Unit Settings;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, JvExComCtrls, JvComCtrls, Contnrs, DB,
  JvMemoryDataset, JvComponentBase, inifiles, JvSimpleXml, JvStringHolder,
  JvDataEmbedded, JvCipher, JvGenetic;

Type
  TfrmSettings = Class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Pages: TJvPageControl;
    TabSheetProject: TTabSheet;
    TabSheet2: TTabSheet;
    GroupBox2: TGroupBox;
    Label5: TLabel;
    Label6: TLabel;
    Label9: TLabel;
    _tunnelpassword: TEdit;
    _tunnelupload: TEdit;
    _tunnelusername: TEdit;
    GroupBoxMySQL: TGroupBox;
    Label3: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    Label1: TLabel;
    _password: TEdit;
    _server: TEdit;
    _database: TEdit;
    _port: TEdit;
    _username: TEdit;
    _base_image: TEdit;
    Label8: TLabel;
    _base_preview: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    _base_files: TEdit;
    Label13: TLabel;
    _foldersview: TComboBox;
    TabSheet3: TTabSheet;
    GroupBox3: TGroupBox;
    Label16: TLabel;
    Label21: TLabel;
    _language: TComboBox;
    _charset: TComboBox;
    _unicode: TCheckBox;
    Label14: TLabel;
    _valuta: TComboBox;
    Label15: TLabel;
    _codepage: TComboBox;
    PanelBtn: TPanel;
    btnCancel: TButton;
    btnOk: TButton;
    TabSheet4: TTabSheet;
    Label12: TLabel;
    _ConnectKind: TComboBox;
    GroupBox4: TGroupBox;
    _tunnelmysql: TEdit;
    Label7: TLabel;
    GroupBox6: TGroupBox;
    Label18: TLabel;
    Label19: TLabel;
    Label22: TLabel;
    _ssh_password: TEdit;
    _ssh_server: TEdit;
    _ssh_port: TEdit;
    _ssh_username: TEdit;
    Edit1: TEdit;
    Label17: TLabel;
    Label23: TLabel;
    Edit8: TEdit;
    TabSheet5: TTabSheet;
    GroupBox5: TGroupBox;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    _ftp_server: TEdit;
    _ftp_username: TEdit;
    _ftp_password: TEdit;
    _projectname: TEdit;
    Label27: TLabel;
    _projecturl: TEdit;
    Label28: TLabel;
    GroupBoxPassword: TGroupBox;
    Label30: TLabel;
    _projectpassword: TEdit;
    Coder: TJvVigenereCipher;
    Procedure FormShow(Sender: TObject);
    Procedure btnOkClick(Sender: TObject);
    Procedure btnCancelClick(Sender: TObject);
    Procedure FormCreate(Sender: TObject);
    Procedure FormActivate(Sender: TObject);
  Private
    Procedure CorrectDetect;
    Function ReadEncString(section, ident: String): String;
    Procedure WriteEncString(section, ident, value: String);
    { Private declarations }
  Public
    ProjectPassword: String;
    Server: String;
    Port: integer;
    Database, Username, Password: String;
    Project_correct: boolean;
    Project_active: boolean;
    Projectname: String;
    ProjectUrl: String;
    TunnelMysql, TunnelUpload: String;
    TunnelUsername, TunnelPassword: String;
    Base_image, Base_preview, Base_files: String;
    ConnectKind: integer;
    FoldersView: integer;

    ftp_server: String;
    ftp_username: String;
    ftp_password: String;
    ssh_server: String;
    ssh_port: integer;
    ssh_username: String;
    ssh_password: String;

    Language, Codepage, Charset, Valuta: String;
    Unicode: boolean;

    // Settings: TIniFile;
    Procedure FormToValue;
    Procedure ValueToForm;
    Procedure ResetValue;
    Procedure WriteToFile(Filename: String);
    Procedure ReadFromFile(Filename: String);
    Procedure ActiveDetect;
    { Public declarations }
  End;

Var
  frmSettings: TfrmSettings;

Var
  ini: TIniFile;

Implementation

Uses Main, ReqPassword;
{$R *.dfm}

Procedure TfrmSettings.ActiveDetect;
Begin
  //     ?
{  Project_active := (length(Projectname) > 1);
  If Project_active Then
    frmMain.StatusBar.Panels[0].Text := Projectname
  Else
    frmMain.StatusBar.Panels[0].Text := '';
    }
End;

Procedure TfrmSettings.CorrectDetect;
Var
  res: boolean;
  purl: String;
Begin
  //     ?
  res := true;
  { if (pos('http://', _projectname.Text) > 0) then
    _projectname.Text := copy(_projectname.Text,
    pos('http://', _projectname.Text) + 7);
    if (pos('/', _projectname.Text) > 0) then
    _projectname.Text := copy(_projectname.Text, 0,
    pos('/', _projectname.Text) - 1);
    if (pos('.', _projectname.Text) < 1) then
    res := false;
  }

  If (pos('http://', _server.Text) > 0) Then
    _server.Text := copy(_server.Text, pos('http://', _server.Text) + 7);

  If (pos('/', _server.Text) > 0) Then
    _server.Text := copy(_server.Text, 0, pos('/', _server.Text) - 1);

  If (length(_database.Text) < 1) Then
    res := false;

  purl := _projecturl.Text;
  If (pos('http://', purl) = 0) Then
    purl := 'http://' + purl;
  While purl[length(purl)] = '/' Do
    delete(purl, length(purl), 1);
  _projecturl.Text := purl;

  Project_correct := res;
End;

Procedure TfrmSettings.btnCancelClick(Sender: TObject);
Begin
  ValueToForm; //   
  modalResult := mrCancel;
End;

Procedure TfrmSettings.btnOkClick(Sender: TObject);
Begin
  CorrectDetect;
  If Project_correct Then
  Begin
    FormToValue; //    
    // ActiveDetect;
    modalResult := mrOk;
  End;
End;

Procedure TfrmSettings.FormActivate(Sender: TObject);
Begin
  Pages.ActivePage := TabSheetProject;
  _projectname.SetFocus;
End;

Procedure TfrmSettings.FormCreate(Sender: TObject);
Begin
  Project_correct := false;
  Project_active := true; //2021
End;

Procedure TfrmSettings.FormShow(Sender: TObject);
Begin
  Pages.ActivePageIndex := 0;
  ValueToForm; //   
  btnOk.SetFocus;
End;

Procedure TfrmSettings.ValueToForm;
Begin
  _projectpassword.Text := ProjectPassword;
  _projectname.Text := Projectname;
  _projecturl.Text := ProjectUrl;

  _ftp_server.Text := ftp_server;
  _ftp_username.Text := ftp_username;
  _ftp_password.Text := ftp_password;
  _ssh_server.Text := ssh_server;
  _ssh_port.Text := IntToStr(ssh_port);
  _ssh_username.Text := ssh_username;
  _ssh_password.Text := ssh_password;

  _tunnelmysql.Text := TunnelMysql;
  _tunnelupload.Text := TunnelUpload;
  _tunnelusername.Text := TunnelUsername;
  _tunnelpassword.Text := TunnelPassword;
  _server.Text := Server;
  _port.Text := IntToStr(Port);
  _database.Text := Database;
  _username.Text := Username;
  _password.Text := Password;
  _base_preview.Text := Base_preview;
  _base_image.Text := Base_image;
  _base_files.Text := Base_files;
  // _NoSavePass.Checked := NoSavePass;
  _ConnectKind.ItemIndex := ConnectKind;
  _foldersview.ItemIndex := FoldersView;
  _unicode.Checked := Unicode;
  _language.Text := Language;
  _codepage.Text := Codepage;
  _charset.Text := Charset;
  _valuta.Text := Valuta;

  _language.ItemIndex := _language.Items.IndexOf(Language);
  _codepage.Text := Codepage;
  _codepage.ItemIndex := _codepage.Items.IndexOf(Codepage);
  _charset.Text := Charset;
  _charset.ItemIndex := _charset.Items.IndexOf(Charset);
  _valuta.ItemIndex := _valuta.Items.IndexOf(Valuta);
  _unicode.Checked := Unicode;
End;

Procedure TfrmSettings.FormToValue;
Begin
  ProjectPassword := _projectpassword.Text;
  Projectname := _projectname.Text;
  ProjectUrl := _projecturl.Text;

  ftp_server := _ftp_server.Text;
  ftp_username := _ftp_username.Text;
  ftp_password := _ftp_password.Text;
  ssh_server := _ssh_server.Text;
  If Not TryStrToInt(_ssh_port.Text, ssh_port) Then
    ssh_port := 22;
  ssh_username := _ssh_username.Text;
  ssh_password := _ssh_password.Text;

  TunnelMysql := _tunnelmysql.Text;
  TunnelUpload := _tunnelupload.Text;
  TunnelUsername := _tunnelusername.Text;
  TunnelPassword := _tunnelpassword.Text;
  Base_image := _base_image.Text;
  Base_preview := _base_preview.Text;
  Base_files := _base_files.Text;
  Server := _server.Text;
  If Not TryStrToInt(_port.Text, Port) Then
    Port := 3306;
  Database := _database.Text;
  Username := _username.Text;
  Password := _password.Text;
  // NoSavePass := _NoSavePass.Checked;
  ConnectKind := _ConnectKind.ItemIndex;

  Language := _language.Text;
  Codepage := _codepage.Text;
  Charset := _charset.Text;
  Valuta := _valuta.Text;
  Unicode := _unicode.Checked;
End;

Procedure TfrmSettings.ResetValue;
Begin
  ProjectPassword := '';
  Server := '';
  Port := 3306;
  Database := '';
  Username := '';
  Password := '';
  Projectname := '';
  ProjectUrl := '';
  ftp_server := '';
  ftp_username := '';
  ftp_password := '';
  ssh_server := '';
  ssh_port := 22;
  ssh_username := '';
  ssh_password := '';

  TunnelMysql := '';
  TunnelUpload := '';
  TunnelUsername := '';
  TunnelPassword := '';
  Base_image := '/content/image/';
  Base_preview := '/content/preview/';
  Base_files := '/content/files/';
  ConnectKind := 0;
  FoldersView := 0;
  Project_active := false;
  Language := 'EN';
  Codepage := 'UTF-8';
  Charset := 'utf8';
  Valuta := 'USD';
  Unicode := true;
End;

Procedure TfrmSettings.WriteToFile(Filename: String);
Begin
  If (Filename <> '') Then
    Try
      ini := TIniFile.Create(Filename);
      WriteEncString('Project', 'projectpassword', ProjectPassword);
      WriteEncString('Project', 'projectname', Projectname);
      WriteEncString('Project', 'projecturl', ProjectUrl);

      WriteEncString('FTP', 'ftp_server', ftp_server);
      WriteEncString('FTP', 'ftp_username', ftp_username);
      WriteEncString('FTP', 'ftp_password', ftp_password);

      WriteEncString('SSH', 'ssh_server', ssh_server);
      WriteEncString('SSH', 'ssh_port', IntToStr(ssh_port));
      WriteEncString('SSH', 'ssh_username', ssh_username);
      WriteEncString('SSH', 'ssh_password', ssh_password);

      WriteEncString('MySQL', 'server', Server);
      WriteEncString('MySQL', 'port', IntToStr(Port));
      WriteEncString('MySQL', 'connectkind', IntToStr(ConnectKind));
      WriteEncString('MySQL', 'foldersview', IntToStr(FoldersView));
      WriteEncString('MySQL', 'database', Database);
      WriteEncString('MySQL', 'username', Username);
      WriteEncString('MySQL', 'password', Password);
      WriteEncString('HTTP', 'tunnelmysql', TunnelMysql);
      WriteEncString('HTTP', 'tunnelupload', TunnelUpload);
      WriteEncString('HTTP', 'tunnelusername', TunnelUsername);
      WriteEncString('HTTP', 'tunnelpassword', TunnelPassword);
      WriteEncString('HTTP', 'base_image', Base_image);
      WriteEncString('HTTP', 'base_preview', Base_preview);
      WriteEncString('HTTP', 'base_files', Base_files);
      WriteEncString('Regional', 'language', Language);
      WriteEncString('Regional', 'codepage', Codepage);
      WriteEncString('Regional', 'charset', Charset);
      WriteEncString('Regional', 'valuta', Valuta);
      WriteEncString('Regional', 'unicode', BoolToStr(Unicode));
      ini.Free;
    Except
    End;
End;

Procedure TfrmSettings.ReadFromFile(Filename: String);
Var
  inp_pass: String;
  kindpass: integer;
Begin
  If (Filename <> '') And (fileexists(Filename)) Then
    Try
      ini := TIniFile.Create(Filename);
      kindpass := 1;
      ProjectPassword := '';
      inp_pass := '';
      If ReadEncString('Project', 'projectpassword') <> '' Then
      Begin
        kindpass := -1;
        If frmReqPassword.ShowModal = mrOk Then
        Begin
          inp_pass := frmReqPassword._projectpassword.Text;
          ProjectPassword := inp_pass;
          If inp_pass = ReadEncString('Project', 'projectpassword') Then
            kindpass := 1
          Else
            kindpass := -2;
        End;
      End;
      //        
      If kindpass = 1 Then
      Begin
        Projectname := ReadEncString('Project', 'projectname');
        ProjectUrl := ReadEncString('Project', 'projecturl');

        ftp_server := ReadEncString('FTP', 'ftp_server');
        ftp_username := ReadEncString('FTP', 'ftp_username');
        ftp_password := ReadEncString('FTP', 'ftp_password');
        ssh_server := ReadEncString('SSH', 'ssh_server');
        If Not TryStrToInt(ReadEncString('SSH', 'ssh_port'), ssh_port) Then
          Port := 22;
        ssh_username := ReadEncString('SSH', 'ssh_username');
        ssh_password := ReadEncString('SSH', 'ssh_password');

        Server := ReadEncString('MySQL', 'server');
        If Not TryStrToInt(ReadEncString('MySQL', 'port'), Port) Then
          Port := 3306;
        Database := ReadEncString('MySQL', 'database');
        Username := ReadEncString('MySQL', 'username');
        Password := ReadEncString('MySQL', 'password');
        TunnelMysql := ReadEncString('HTTP', 'tunnelmysql');
        TunnelUpload := ReadEncString('HTTP', 'tunnelupload');
        TunnelUsername := ReadEncString('HTTP', 'tunnelusername');
        TunnelPassword := ReadEncString('HTTP', 'tunnelpassword');
        Base_image := ReadEncString('HTTP', 'base_image');
        Base_preview := ReadEncString('HTTP', 'base_preview');
        Base_files := ReadEncString('HTTP', 'base_files');
        If Not TryStrToInt(ReadEncString('MySQL', 'connectkind'),
          ConnectKind) Then
          ConnectKind := 0;
        If Not TryStrToInt(ReadEncString('MySQL', 'foldersview'),
          FoldersView) Then
          FoldersView := 0;
        Language := ReadEncString('Regional', 'language');
        Codepage := ReadEncString('Regional', 'codepage');
        Charset := ReadEncString('Regional', 'charset');
        Valuta := ReadEncString('Regional', 'valuta');
        If Not TryStrToBool(ReadEncString('Regional', 'unicode'), Unicode) Then
          Unicode := true;
      End;
      If kindpass = -2 Then
      Begin
        ShowMessage('     ');
      End;
      ini.Free;
    Except
    End;
  ActiveDetect;

End;

Function TfrmSettings.ReadEncString(section, ident: String): String;
Var
  value: String;
Begin
  //   
  value := ini.ReadString(section, ident, '');
  result := String(Coder.DecodeString(ansistring(ProjectPassword),
    ansistring(value)));
End;

Procedure TfrmSettings.WriteEncString(section, ident, value: String);
Var
  envalue: String;
Begin
  //   
  envalue := String(Coder.EncodeString(ansistring(ProjectPassword),
    ansistring(value)));
  ini.WriteString(section, ident, envalue);
End;

End.
