Unit Stage1;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, JvExStdCtrls, JvButton, JvCtrls, JvFooter, ExtCtrls,
  JvExExtCtrls, JvExtComponent, DB, IdBaseComponent,
  IdComponent, IdTCPConnection, IdTCPClient, IdExplicitTLSClientServerBase,
  IdFTP, OleServer, ExcelXP, {XLSFile, XLSFormat, XLSRects, XLSWorkbook,}
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client;

Type
  TfrmStage1 = Class(TForm)
    JvFooter1: TJvFooter;
    btnOk: TJvFooterBtn;
    FTPClient: TIdFTP;
    TimerStart: TTimer;
    Panel1: TPanel;
    LabelInfo: TLabel;
    Panel2: TPanel;
    ListInfo: TListBox;
    TimerEnd: TTimer;
    CloseAtEnd: TCheckBox;
    MyQuery1: TFDQuery;
    MyQuery2: TFDQuery;
    TPrSystems: TFDQuery;
    TPrAtt: TFDQuery;
    JvFooterBtn1: TJvFooterBtn;
    Procedure FormCreate(Sender: TObject);
    Procedure FormDestroy(Sender: TObject);
    Procedure TimerStartTimer(Sender: TObject);
    Procedure FormShow(Sender: TObject);
    Procedure btnOkClick(Sender: TObject);
    Procedure FTPClientWork(ASender: TObject; AWorkMode: TWorkMode; AWorkCount: Int64);
    Procedure TimerEndTimer(Sender: TObject);
    Procedure FormActivate(Sender: TObject);
    procedure JvFooterBtn1Click(Sender: TObject);
  Private
    SplStr: TStrings;
    FileList: TStrings;
    ArrSearch, ArrReplace: TStrings;
    ArrSearchPr, ArrReplacePr: TStrings;
    procedure StartProcessTemplates2;

  type
    TCellStyle = record
      row: integer;
      col: integer;
      Template: string;
      BGBorderColor: integer;
      FGBorderColor: integer;
      FontName: string;
      FontHeight: integer;
      FontColorRGB: integer;
 //     HAlign: TCellHAlignment;
    end;

  procedure XLSSetStyle(row, col, page: integer; Style: TCellStyle);
  Procedure CopyTemplate;
  Function KindToSrcPath(kind: String): String;
  Procedure StartProcess;
  Function FilenameToDesc(fn: String): String;
  Procedure StartProcessTemplates;
  Procedure StartProcessSpecification;
  Procedure FileProcessing(filename: String);
  Procedure ExcelProcessing(filename: String);
  procedure ExcelProcessing2(filename: String);
  Procedure WordProcessing(filename: String);
  Procedure FillArr(sKind: String);
  Procedure FillPrArr;
  procedure StartProcessSpecification2;
  procedure Test;
  procedure XLSFindAndReplace(OldValue, NewValue: string);
  function XLSGetStyle(Value: string): TCellStyle;
  { Private declarations }
  Public
    Project_no: integer;
    System_no: integer;
    autoclose: integer;
    sName, sKind: String;
    sOpts: TStrings;
    EnableSpecification: boolean;
    EnableDocumentation: boolean;
    EnableTemplates: boolean;
  //  xf: TXLSFile;
    { Public declarations }
  End;

Var
  frmStage1: TfrmStage1;

Implementation

Uses Main, WordExcel, DataModule, ReportSelect;

{$R *.dfm}

Procedure TfrmStage1.FileProcessing(filename: String);
Var
  xt: String;
Begin
  ListInfo.Items.Add('      (' + sKind + ')');
  ListInfo.ItemIndex := ListInfo.Items.Count - 1;
  Application.Processmessages;
  FillArr(sKind);
  xt := ExtractFileExt(filename);
  If xt = '.xls' Then
    ExcelProcessing2(filename);
  If xt = '.doc' Then
    WordProcessing(filename);
End;

Procedure TfrmStage1.FormActivate(Sender: TObject);
Begin
  btnOk.SetFocus;
End;

Procedure TfrmStage1.FormCreate(Sender: TObject);
Begin
  FileList := TStringlist.Create;
  ArrSearch := TStringlist.Create;
  ArrReplace := TStringlist.Create;
  ArrSearchPr := TStringlist.Create;
  ArrReplacePr := TStringlist.Create;
  sOpts := TStringlist.Create;
  // xf := TXLSFile.Create;
  SplStr := TStringlist.Create;
End;

Procedure TfrmStage1.FormDestroy(Sender: TObject);
Begin
  FileList.Free;
  ArrSearch.Free;
  ArrReplace.Free;
  ArrSearchPr.Free;
  ArrReplacePr.Free;
  sOpts.Free;
  // xf.Destroy;
  SplStr.Free;
End;

Procedure TfrmStage1.FormShow(Sender: TObject);
Begin
  TimerStart.Enabled := true;
  autoclose := 0;
  btnOk.Caption := '';
End;

Procedure TfrmStage1.FTPClientWork(ASender: TObject; AWorkMode: TWorkMode; AWorkCount: Int64);
Begin
  Application.Processmessages;
End;

procedure TfrmStage1.JvFooterBtn1Click(Sender: TObject);
begin
//
end;

Procedure TfrmStage1.StartProcess;
Begin
  btnOk.Enabled := false;
  ListInfo.Clear;
  Application.Processmessages;
  //
  { FTPClient.Host := frmSettings.ftp_server;
    FTPClient.username := frmSettings.ftp_username;
    FTPClient.password := frmSettings.ftp_password;
  }
  //
  FillPrArr;
  If EnableDocumentation Then
    StartProcessTemplates;
  If EnableSpecification Then
    StartProcessSpecification2;
  If EnableTemplates Then
    StartProcessTemplates2;
  //
  btnOk.Enabled := true;
  If CloseAtEnd.Checked Then
    TimerEnd.Enabled := true;
End;

Procedure TfrmStage1.btnOkClick(Sender: TObject);
Begin
  TimerStart.Enabled := false;
  TimerEnd.Enabled := false;
  ModalResult := mrOk;
End;

Procedure TfrmStage1.CopyTemplate;
Var
  srcfolder, src, tmp, dst: String;
  i: integer;
  nfn: String;
  err: boolean;
Begin
  //  
  srcfolder := KindToSrcPath(sKind);
  If srcfolder = '' Then
  Begin
    ListInfo.Items.Add('    ');
  End
  Else
  Begin
    ListInfo.Items.Add('   : /templates/' + srcfolder + '/ >> /projects/' + IntToStr(Project_no) + '/');
    Try
      FTPClient.Connect;
      FTPClient.ChangeDir('templates');
      FTPClient.ChangeDir(srcfolder);
      FTPClient.List(FileList, '', false);
      For i := 0 To FileList.Count - 1 Do
      Begin
        src := '/templates/' + srcfolder + '/' + FileList[i];
        nfn := IntToStr(System_no) + '_' + FileList[i];
        dst := '/projects/' + IntToStr(Project_no) + '/' + nfn;
        //    FileList[i]
        If TPrAtt.Locate('file', nfn, []) Then
        Begin
          ListInfo.Items.Add('      : ' + nfn);
        End
        Else
        Begin
          // 
          ListInfo.Items.Add('     : /templates/' + srcfolder + '/' + FileList[i] + ' >> ' + dst);
          err := false;
          tmp := frmMain.ComputerInfo.Folders.Temp + '\' + FileList[i];
          Try
            If FileExists(tmp) Then
              DeleteFile(tmp);
            FTPClient.Get(src, tmp, true, true);
            FileProcessing(tmp);
            FTPClient.Put(tmp, dst, false);
          Except
            err := true;
          End;
          If Not err Then
          Begin
            tmp := FilenameToDesc(nfn);
            TPrAtt.Append;
            TPrAtt.FieldByName('name').AsString := sName + ' (' + sKind + ')';
            If tmp <> '' Then
              TPrAtt.FieldByName('name').AsString := tmp + ' - ' + sName;
            // TPrAtt.FieldByName('comment').AsString := sName + ' (' +  sKind + ')';
            TPrAtt.FieldByName('file').AsString := nfn;
            TPrAtt.FieldByName('lastupdate').AsDateTime := Now();
            TPrAtt.FieldByName('project_no').AsInteger := Project_no;
            TPrAtt.FieldByName('system_no').AsInteger := System_no;
            TPrAtt.Post;
          End;
        End;
      End;
    Except
    End;
    If FTPClient.Connected Then
      Try
        FTPClient.Disconnect;
      Except
      End;
  End;
  Application.Processmessages;
  ListInfo.ItemIndex := ListInfo.Items.Count - 1;
End;

Function TfrmStage1.KindToSrcPath(kind: String): String;
Var
  res: String;
Begin
  If kind = '' Then
    res := 'au';
  If kind = '' Then
    res := 'grh';
  If kind = '' Then
    res := 'hk';
  If kind = '' Then
    res := 'hr';
  If kind = '' Then
    res := 'ho';
  If kind = '' Then
    res := 'hre';
  If kind = '' Then
    res := 'vru';
  result := res;
End;

Function TfrmStage1.FilenameToDesc(fn: String): String;
Var
  res: String;
Begin
  res := '';
  If pos('passport', fn) > 0 Then
    res := '';
  If pos('manual', fn) > 0 Then
    res := ' ';
  If pos('protocol', fn) > 0 Then
    res := ' ';
  result := res;
End;

Procedure TfrmStage1.TimerEndTimer(Sender: TObject);
Begin
  ListInfo.ItemIndex := ListInfo.Items.Count - 1;
  Application.Processmessages;
  If CloseAtEnd.Checked Then
  Begin
    Inc(autoclose);
    If autoclose > 10 Then
      btnOk.Click
    Else
      btnOk.Caption := '[' + IntToStr(11 - autoclose) + '] ';
  End
  Else
    btnOk.Caption := '';
End;

Procedure TfrmStage1.TimerStartTimer(Sender: TObject);
Begin
  TimerStart.Enabled := false;
  StartProcess;
End;

Procedure TfrmStage1.StartProcessTemplates;
Begin
  //
  TPrSystems.Active := false;
  TPrAtt.Active := false;
  // uni_projectsystems
  try
    TPrSystems.SQL.Text := 'SELECT * FROM uni_projectsystems WHERE project_no=' + IntToStr(Project_no) +
      ' AND `active` ORDER BY `orderby`;';
    TPrSystems.Active := true;

    TPrAtt.SQL.Text := 'SELECT * FROM uni_projectatt WHERE project_no=' + IntToStr(Project_no) + ';';
    TPrAtt.Active := true;
    TPrSystems.First;
    //
    While Not TPrSystems.Eof Do
      Try
        System_no := TPrSystems.FieldByName('rec_no').AsInteger;
        sName := TPrSystems.FieldByName('name').AsString;
        sKind := TPrSystems.FieldByName('kind').AsString;
        sOpts.Text := TPrSystems.FieldByName('opts').AsString;
        If length(sName) < 1 Then
        Begin
          ListInfo.Items.Add('.    ');
        End
        Else If length(sKind) < 1 Then
        Begin
          ListInfo.Items.Add('.    : ' + sName);
        End
        Else
        Begin
          ListInfo.Items.Add('   ' + sName + ' (' + sKind + ')');
          CopyTemplate;
        End;
        //
        Application.Processmessages;
        ListInfo.ItemIndex := ListInfo.Items.Count - 1;
        TPrSystems.Next;
      Except
      End;
  except
    showmessage('err 4342');
  end;
  TPrSystems.Active := false;
End;

Procedure TfrmStage1.StartProcessSpecification;
Var
  spfilename: String;
Var
  fil, SaveChanges: OleVariant;
  LCID, i, cnt: integer;
  What, LookIn, LookAt, SearchOrder, SearchDirection, MathCase, MathByte, SearchFormat: OleVariant;
  c_name, c_kinddesc, c_article, c_count, c_price, c_total, c_comment: OleVariant;
  f_name, f_kinddesc, f_article, f_count, f_price, f_total, f_comment: ExcelRange;
  System_count: integer;
  total_system, total_project: real;
  Found: ExcelRange;
  num: integer;
Type
  TWordReplaceFlags = Set Of (wrfReplaceAll, wrfMatchCase, wrfMatchWildcards);
Begin
  //
  ListInfo.Items.Add('   ');
  // GetSpecification
  Try
    FTPClient.Connect;
    FTPClient.ChangeDir('templates');
    spfilename := frmMain.ComputerInfo.Folders.Temp + '\specification.xls';
    If FileExists(spfilename) Then
      DeleteFile(spfilename);
    FTPClient.Get('specification.xls', spfilename, true);
    If FTPClient.Connected Then
      Try
        FTPClient.Quit;
      Except
      End;
  Except
  End;

  If FileExists(spfilename) Then
  Begin
    ListInfo.Items.Add(' ');
    frmWordExcel.ExcelLoad(spfilename);
    cnt := frmWordExcel.ExcelWorkbook1.Worksheets.Count;
    For i := 1 To cnt Do
      Try
        frmWordExcel.ExcelWorksheet1.ConnectTo(frmWordExcel.ExcelWorkbook1.Worksheets.Get_Item(i) As _WorkSheet);
        c_name := '#name#';
        c_article := '#article#';
        c_count := '#count#';
        c_price := '#price#';
        c_total := '#total#';
        c_comment := '#comment#';
        c_kinddesc := '#kinddesc#';
        LookIn := xlFormulas;
        LookAt := xlPart;
        SearchOrder := xlByRows;
        SearchDirection := xlNext;
        MathCase := EmptyParam;
        MathByte := EmptyParam;
        SearchFormat := EmptyParam;
        f_name := frmWordExcel.ExcelWorksheet1.UsedRange[0].Find(c_name, EmptyParam, integer(xlValues), xlPart,
          xlByRows, xlNext, EmptyParam, EmptyParam, EmptyParam);
        f_kinddesc := frmWordExcel.ExcelWorksheet1.UsedRange[0].Find(c_kinddesc, EmptyParam, integer(xlValues), xlPart,
          xlByRows, xlNext, EmptyParam, EmptyParam, EmptyParam);
        f_article := frmWordExcel.ExcelWorksheet1.UsedRange[0].Find(c_article, EmptyParam, integer(xlValues), xlPart,
          xlByRows, xlNext, EmptyParam, EmptyParam, EmptyParam);
        f_count := frmWordExcel.ExcelWorksheet1.UsedRange[0].Find(c_count, EmptyParam, integer(xlValues), xlPart,
          xlByRows, xlNext, EmptyParam, EmptyParam, EmptyParam);
        f_price := frmWordExcel.ExcelWorksheet1.UsedRange[0].Find(c_price, EmptyParam, integer(xlValues), xlPart,
          xlByRows, xlNext, EmptyParam, EmptyParam, EmptyParam);
        f_total := frmWordExcel.ExcelWorksheet1.UsedRange[0].Find(c_total, EmptyParam, integer(xlValues), xlPart,
          xlByRows, xlNext, EmptyParam, EmptyParam, EmptyParam);
        f_comment := frmWordExcel.ExcelWorksheet1.UsedRange[0].Find(c_comment, EmptyParam, integer(xlValues), xlPart,
          xlByRows, xlNext, EmptyParam, EmptyParam, EmptyParam);
        ///
        ///  ,    
        ///
        try
          MyQuery2.SQL.Text := 'SELECT * FROM `uni_projectsystems` WHERE `project_no`=' + IntToStr(Project_no) +
            ' AND `active` ORDER BY `orderby`;';
          MyQuery2.Active := true;
        except
          showmessage('err 9853');
        end;
        total_project := 0;
        While Not MyQuery2.Eof Do
          try
            System_no := MyQuery2.FieldByName('rec_no').AsInteger;
            System_count := MyQuery2.FieldByName('count').AsInteger;
            MyQuery1.SQL.Text := 'SELECT * FROM `uni_projecthardware` WHERE `project_no`=' + IntToStr(Project_no) +
              ' AND `system_no`=' + IntToStr(System_no) + ' ORDER BY `orderby`;';
            MyQuery1.Active := true;
            total_system := 0;

            //    
            f_name.EntireRow.Insert(xlShiftDown, EmptyParam);
            f_kinddesc.Offset[-1, 0].EntireRow.Font.Bold := true;
            f_kinddesc.Offset[-1, 0].Value2 := MyQuery2.FieldByName('name').AsString;
            f_kinddesc.Offset[-1, 0].HorizontalAlignment := 2;
            f_count.Offset[-1, 0].Value2 := MyQuery2.FieldByName('count').AsInteger;
            // f_name.EntireRow.Insert(xlShiftDown, EmptyParam);
            //  ,  
            While Not MyQuery1.Eof Do
              try
                //   
                f_name.EntireRow.Insert(xlShiftDown, EmptyParam);

                If (f_name <> Nil) Then
                Begin
                  f_name.Offset[-1, 0].Value2 := MyQuery1.FieldByName('name').AsString;
                  f_name.Offset[-1, 0].Font.Bold := false;
                  f_name.Offset[-1, 0].NumberFormat := '@';
                  f_name.Offset[-1, 0].HorizontalAlignment := 2;
                  f_name.Offset[-1, 0].Interior.Color := clWhite;
                End;
                If (f_kinddesc <> Nil) Then
                Begin
                  f_kinddesc.Offset[-1, 0].Value2 := MyQuery1.FieldByName('kinddesc').AsString;
                  f_kinddesc.Offset[-1, 0].Font.Bold := false;
                  f_kinddesc.Offset[-1, 0].NumberFormat := '@';
                  f_kinddesc.Offset[-1, 0].HorizontalAlignment := 2;
                  f_kinddesc.Offset[-1, 0].Interior.Color := clWhite;
                End;
                If (f_article <> Nil) Then
                Begin
                  f_article.Offset[-1, 0].Value2 := MyQuery1.FieldByName('article').AsString;
                  f_article.Offset[-1, 0].Font.Bold := false;
                  f_article.Offset[-1, 0].NumberFormat := '@';
                  f_article.Offset[-1, 0].HorizontalAlignment := 2;
                  f_article.Offset[-1, 0].Interior.Color := clWhite;
                End;
                If (f_comment <> Nil) Then
                Begin
                  f_comment.Offset[-1, 0].Value2 := MyQuery1.FieldByName('comment').AsString;
                  f_comment.Offset[-1, 0].Font.Bold := false;
                  f_comment.Offset[-1, 0].NumberFormat := '@';
                  f_comment.Offset[-1, 0].HorizontalAlignment := 2;
                  f_comment.Offset[-1, 0].Interior.Color := clWhite;
                End;
                If (f_count <> Nil) Then
                Begin
                  f_count.Offset[-1, 0].Value2 := MyQuery1.FieldByName('count').AsInteger;
                  f_count.Offset[-1, 0].Font.Bold := false;
                  f_count.Offset[-1, 0].Interior.Color := clWhite;
                End;
                If (f_price <> Nil) Then
                Begin
                  f_price.Offset[-1, 0].Value2 := MyQuery1.FieldByName('price').AsFloat;
                  f_price.Offset[-1, 0].Font.Bold := false;
                  f_price.Offset[-1, 0].NumberFormat := '0,00';
                  f_price.Offset[-1, 0].Interior.Color := clWhite;
                End;
                If (f_total <> Nil) Then
                Begin
                  f_total.Offset[-1, 0].Value2 := MyQuery1.FieldByName('count').AsInteger *
                    MyQuery1.FieldByName('price').AsFloat;
                  f_total.Offset[-1, 0].NumberFormat := '0,00';
                  f_total.Offset[-1, 0].Font.Bold := false;
                  f_total.Offset[-1, 0].Interior.Color := clWhite;

                  total_system := total_system + MyQuery1.FieldByName('count').AsInteger *
                    MyQuery1.FieldByName('price').AsFloat;
                End;

                MyQuery1.Next;
              except
                //     
              End;

            // 
            f_kinddesc.EntireRow.Insert(xlShiftDown, EmptyParam);
            total_project := total_project + (total_system * MyQuery2.FieldByName('count').AsInteger);
            f_kinddesc.Offset[-1, 0].EntireRow.Font.Bold := true;
            f_kinddesc.Offset[-1, 0].Value2 := '';
            f_total.Offset[-1, 0].Value2 := total_system;
            f_total.Offset[-1, 0].NumberFormat := '0,00';

            //    
            MyQuery2.Next;
          except
          End;
        f_kinddesc.EntireRow.Insert(xlShiftDown, EmptyParam);
        f_kinddesc.Offset[-1, 0].EntireRow.Font.Bold := true;
        f_kinddesc.Offset[-1, 0].EntireRow.Font.Color := clRed;
        f_kinddesc.Offset[-1, 0].Value2 := '  ';
        f_total.Offset[-1, 0].Value2 := total_project;
        f_total.Offset[-1, 0].NumberFormat := '0,00';

        f_name.EntireRow.Clear;
      Except
        showmessage('err fill excel');
      End;

    /// ///////////////
    ///   
    For num := 0 To ArrSearchPr.Count - 1 Do
      Try
        What := ArrSearchPr[num];
        Found := frmWordExcel.ExcelWorksheet1.UsedRange[0].Find(What, EmptyParam, integer(xlValues), xlPart, xlByRows,
          xlNext, EmptyParam, EmptyParam, EmptyParam);
        If (Found <> Nil) Then
        Begin
          Found.Value2 := ArrReplacePr[num]; // 
        End;
      Except
        showmessage('err replace');
      End;

    // 
    Try
      frmWordExcel.ExcelWorkbook1.Save;
    Except
      showmessage('err save excel');
    End;
    frmWordExcel.ExcelClose;
  End;

  If FileExists(spfilename) Then
    Try
      ListInfo.Items.Add('   ');
      ListInfo.ItemIndex := ListInfo.Items.Count - 1;
      Application.Processmessages;
      FTPClient.Connect;
      FTPClient.ChangeDir('projects');
      Try
        FTPClient.ChangeDir(IntToStr(Project_no));
      Except
        FTPClient.MakeDir(IntToStr(Project_no));
        FTPClient.ChangeDir(IntToStr(Project_no));
      End;
      FTPClient.Put(spfilename, 'specification.xls', false);

      //   
      try
        TPrAtt.SQL.Text := 'SELECT * FROM `uni_projectatt` WHERE `project_no`=' + IntToStr(Project_no);
        TPrAtt.Active := true;

        If TPrAtt.Locate('file', 'specification.xls', []) Then
          TPrAtt.Delete;
        TPrAtt.Append;
        TPrAtt.FieldByName('name').AsString := '';
        TPrAtt.FieldByName('file').AsString := 'specification.xls';
        TPrAtt.FieldByName('lastupdate').AsDateTime := Now();
        TPrAtt.FieldByName('project_no').AsInteger := Project_no;
        TPrAtt.Post;
      except
        showmessage(' 86234');
      end;
    Except
      showmessage('  =   =');
    End;
  If FTPClient.Connected Then
    Try
      FTPClient.Disconnect;
    Except
    End;
End;

Procedure TfrmStage1.ExcelProcessing(filename: String);
Var
  fil: OleVariant;
  icid, cnt, num, page: integer;
  What, LookIn, LookAt, SearchOrder, SearchDirection, MathCase, MathByte, SearchFormat: OleVariant;
  Found: ExcelRange;
Type
  TWordReplaceFlags = Set Of (wrfReplaceAll, wrfMatchCase, wrfMatchWildcards);
Const
  wdFindContinue = 1;
  wdReplaceOne = 1;
  wdReplaceAll = 2;
  wdDoNotSaveChanges = 0;
Begin
  ListInfo.Items.Add('      MS Excel ');
  ListInfo.ItemIndex := ListInfo.Items.Count - 1;
  Application.Processmessages;
  // open
  If FileExists(filename) Then
  Begin
    frmWordExcel.ExcelLoad(filename);
    cnt := frmWordExcel.ExcelWorkbook1.Worksheets.Count;
    For page := 1 To cnt Do
    Begin
      frmWordExcel.ExcelWorksheet1.ConnectTo(frmWordExcel.ExcelWorkbook1.Worksheets.Get_Item(page) As _WorkSheet);
      LookIn := xlFormulas;
      LookAt := xlPart;
      SearchOrder := xlByRows;
      SearchDirection := xlNext;
      MathCase := EmptyParam;
      MathByte := EmptyParam;
      SearchFormat := EmptyParam;

      For num := 0 To ArrSearch.Count - 1 Do
        Try
          What := ArrSearch[num];
          Found := frmWordExcel.ExcelWorksheet1.UsedRange[0].Find(What, EmptyParam, integer(xlValues), xlPart, xlByRows,
            xlNext, EmptyParam, EmptyParam, EmptyParam);
          If (Found <> Nil) Then
          Begin
            Found.Value2 := ArrReplace[num]; // 
          End;
        Except
        End;

      For num := 0 To ArrSearchPr.Count - 1 Do
        Try
          What := ArrSearchPr[num];
          Found := frmWordExcel.ExcelWorksheet1.UsedRange[0].Find(What, EmptyParam, integer(xlValues), xlPart, xlByRows,
            xlNext, EmptyParam, EmptyParam, EmptyParam);
          If (Found <> Nil) Then
          Begin
            Found.Value2 := ArrReplacePr[num]; // 
          End;
        Except
        End;
    End;

    Try
      frmWordExcel.ExcelWorkbook1.Save;
    Except
      showmessage('err save excel');
    End;
    frmWordExcel.ExcelClose;
  End;
End;

Procedure TfrmStage1.WordProcessing(filename: String);
Var
  fil, SaveChanges, Replace: OleVariant;
  Text1, Text2: OleVariant;
  num: integer;
Type
  TWordReplaceFlags = Set Of (wrfReplaceAll, wrfMatchCase, wrfMatchWildcards);
Const
  wdFindContinue = 1;
  wdReplaceOne = 1;
  wdReplaceAll = 2;
  wdDoNotSaveChanges = 0;
Begin
  ListInfo.Items.Add('      MS Word ');
  ListInfo.ItemIndex := ListInfo.Items.Count - 1;
  Application.Processmessages;
  // open
  fil := filename;
  frmWordExcel.WordApplication1.Documents.OpenOld(fil, EmptyParam, EmptyParam, EmptyParam, EmptyParam, EmptyParam,
    EmptyParam, EmptyParam, EmptyParam, EmptyParam);
  frmWordExcel.WordApplication1.Visible := false;
  frmWordExcel.WordDocument1.ConnectTo(frmWordExcel.WordApplication1.ActiveDocument);

  // replace
  Replace := wdReplaceAll;
  // ArrSearch, ArrReplace: TStrings;
  For num := 0 To ArrSearch.Count - 1 Do
    Try
      Text1 := ArrSearch[num];
      Text2 := ArrReplace[num];
      frmWordExcel.WordDocument1.Range.Find.ExecuteOld(Text1, EmptyParam, EmptyParam, EmptyParam, EmptyParam,
        EmptyParam, EmptyParam, EmptyParam, EmptyParam, Text2, Replace);
    Except
    End;

  For num := 0 To ArrSearchPr.Count - 1 Do
    Try
      Text1 := ArrSearchPr[num];
      Text2 := ArrReplacePr[num];
      frmWordExcel.WordDocument1.Range.Find.ExecuteOld(Text1, EmptyParam, EmptyParam, EmptyParam, EmptyParam,
        EmptyParam, EmptyParam, EmptyParam, EmptyParam, Text2, Replace);
    Except
    End;

  // close
  SaveChanges := true;
  frmWordExcel.WordApplication1.ActiveDocument.Close(SaveChanges, EmptyParam, EmptyParam);
End;

Procedure TfrmStage1.FillArr(sKind: String);
Var
  i: integer;
  tmpname, tmpvalue, temlate_id: String;
Begin
  //
  ArrSearch.Clear;
  ArrReplace.Clear;
  // sOpts = 
  For i := 0 To sOpts.Count - 1 Do
  Begin
    If pos('=', sOpts[i]) > 0 Then
    Begin
      tmpname := copy(sOpts[i], 0, pos('=', sOpts[i]) - 1);
      tmpvalue := copy(sOpts[i], pos('=', sOpts[i]) + 1);

      MyQuery1.SQL.Text := 'SELECT * FROM uni_systemsopts WHERE kind=' + QuotedStr(sKind) + ' AND name=' +
        QuotedStr(tmpname) + ';';
      MyQuery1.Active := true;
      If MyQuery1.RecordCount > 0 Then
      Begin
        temlate_id := MyQuery1.FieldByName('temlate_id').AsString;
        ArrSearch.Add(temlate_id);
        ArrReplace.Add(tmpvalue);
      End;
      MyQuery1.Active := false;
    End;
  End;

  For i := 0 To TPrSystems.Fields.Count - 1 Do
  Begin
    temlate_id := '#Systems.' + TPrSystems.Fields[i].FullName + '#';
    tmpvalue := TPrSystems.Fields[i].AsString;
    ArrSearch.Add(temlate_id);
    ArrReplace.Add(tmpvalue);
  End;
End;

Procedure TfrmStage1.FillPrArr;
Var
  i: integer;
  tmpname, tmpvalue, temlate_id: String;
Begin
  // uni_projects
  //
  ArrSearchPr.Clear;
  ArrReplacePr.Clear;
  // sOpts = 

  MyQuery1.SQL.Text := 'SELECT * FROM uni_projects WHERE rec_no=' + IntToStr(Project_no) + ';';
  MyQuery1.Active := true;

  If MyQuery1.RecordCount > 0 Then
    For i := 0 To MyQuery1.Fields.Count - 1 Do
    Begin
      temlate_id := '#Projects.' + MyQuery1.Fields[i].FullName + '#';
      tmpvalue := MyQuery1.Fields[i].AsString;
      ArrSearchPr.Add(temlate_id);
      ArrReplacePr.Add(tmpvalue);
    End;
End;

Procedure TfrmStage1.Test;
var
  i: integer;
begin
  { apply all built-in formats }
  for i := 0 to 36 - 1 do
  begin
    xf.Workbook.Sheets[0].Cells[i, 0].Value := 12345.123456789;
    xf.Workbook.Sheets[0].Cells[i, 0].FormatStringIndex := i;
  end;
  xf.SaveAs('c:\test.xls');
end;

Procedure TfrmStage1.XLSFindAndReplace(OldValue, NewValue: string);
var
  rr: TRangeRect;
  row, col, cp, i, tlng: integer;
  val: variant;
  R: TRange;
  StIndent: byte;
begin
  // showmessage(OldValue + ' > ' + NewValue);
  OldValue := LowerCase(OldValue);
  for cp := 0 to (xf.Workbook.Sheets.Count - 1) do
  begin
    xf.Workbook.Sheets[cp].GetUsedRect(rr);
    for row := rr.RowFrom to rr.RowTo do
    begin
      for col := rr.ColumnFrom to rr.ColumnTo do
      begin
        val := xf.Workbook.Sheets[cp].Cells[row, col].Value;
        if pos(OldValue, LowerCase(val)) > 0 then
        begin
          val := StringReplace(val, OldValue, NewValue, [rfReplaceAll, rfIgnoreCase]);
          xf.Workbook.Sheets[cp].Cells[row, col].Value := val;
          //
          if OldValue = '#projects.info#' then
          begin
            SplStr.Text := NewValue;
            StIndent := xf.Workbook.Sheets[cp].Cells[row, col].Indent;

            { tlng := 0;
              for i := 0 to SplStr.Count - 1 do
              begin
              tlng := tlng + (length(SplStr[i]) div 62) + 1;
              end;
              xf.Workbook.Sheets[cp].Rows[row].Height := tlng * xf.Workbook.Sheets
              [cp].Rows[row].Height; }

            tlng := row;
            for i := 0 to SplStr.Count - 1 do
            begin
              with xf.Workbook.Sheets[cp] do
              begin
                Cells[tlng, col].Value := SplStr[i];
                Cells[tlng, col].Merged := false;
                if length(SplStr[i]) > 62 then
                  Rows[tlng].Height := ((length(SplStr[i]) div 62)) * Rows[tlng].Height;
                // Rows[tlng].AutoFit;
                R := Ranges.Add;
                R.AddRect(tlng, tlng, col, col + 5);
                R.MergeCells;
                R.Value := SplStr[i];
                R.Wrap := true;
                R.VAlign := xlVAlignTop;
                R.Indent := StIndent;
                R.HAlign := xlHAlignLeft;
                Rows.InsertRows(tlng, 1);
                tlng := tlng + 1;
              end;
            end;
          end;
        end;
      end;
    end;
  end;
end;

function TfrmStage1.XLSGetStyle(Value: string): TCellStyle;
var
  rr: TRangeRect;
  row, col, cp: integer;
  val: variant;
begin
  result.row := -1;
  result.col := -1;
  result.Template := Value;

  for cp := 0 to (xf.Workbook.Sheets.Count - 1) do
  begin
    xf.Workbook.Sheets[cp].GetUsedRect(rr);
    for row := rr.RowFrom to rr.RowTo do
    begin
      for col := rr.ColumnFrom to rr.ColumnTo do
      begin
        val := xf.Workbook.Sheets[cp].Cells[row, col].Value;
        if pos(Value, val) > 0 then
        begin
          result.row := row;
          result.col := col;
          result.BGBorderColor := xf.Workbook.Sheets[cp].Cells[row, col].FillPatternBGColorRGB;
          result.FGBorderColor := xf.Workbook.Sheets[cp].Cells[row, col].FillPatternFGColorRGB;
          result.FontName := xf.Workbook.Sheets[cp].Cells[row, col].FontName;
          result.FontHeight := xf.Workbook.Sheets[cp].Cells[row, col].FontHeight;
          result.HAlign := xf.Workbook.Sheets[cp].Cells[row, col].HAlign;
          result.FontColorRGB := xf.Workbook.Sheets[cp].Cells[row, col].FontColorRGB;
        end;
      end;
    end;
  end;

end;

procedure TfrmStage1.XLSSetStyle(row, col: integer; page: integer; Style: TCellStyle);
begin
  //
  xf.Workbook.Sheets[page].Cells[row, col].FillPatternBGColorRGB := Style.BGBorderColor;
  xf.Workbook.Sheets[page].Cells[row, col].FillPatternFGColorRGB := Style.FGBorderColor;
  xf.Workbook.Sheets[page].Cells[row, col].FontName := Style.FontName;
  xf.Workbook.Sheets[page].Cells[row, col].FontHeight := Style.FontHeight;
  xf.Workbook.Sheets[page].Cells[row, col].HAlign := Style.HAlign;
  // test
  xf.Workbook.Sheets[page].Cells[row, col].FontColorRGB := Style.FontColorRGB;
  // always
  xf.Workbook.Sheets[page].Cells[row, col].BorderStyle[xlBorderAll] := bsThin;
  xf.Workbook.Sheets[page].Cells[row, col].BorderColorIndex[xlBorderAll] := xlColorBlack;
  {
    Cells[curLine, f_name.col].HAlign := xlHAlignLeft;
    Cells[curLine, f_name.col].FontBold := false;
    Cells[curLine, f_name.col].BorderStyle[xlBorderAll] := bsThin;
    Cells[curLine, f_name.col].BorderColorIndex[xlBorderAll] :=
    xlColorBlack;
  }
end;

Procedure TfrmStage1.ExcelProcessing2(filename: String);
Var
  icid, cnt, num, curPage: integer;
Begin
  ListInfo.Items.Add('      .xls');
  ListInfo.ItemIndex := ListInfo.Items.Count - 1;
  Application.Processmessages;
  // open

  If FileExists(filename) Then
  Begin
    xf.OpenFile(filename);
    cnt := xf.Workbook.Sheets.Count;
    For curPage := 0 To cnt - 1 Do
    Begin
      ///   
      { ArrSearch.SaveToFile('c:\ArrSearch.txt');
        ArrSearchPr.SaveToFile('c:\ArrSearchPr.txt');
        ArrReplace.SaveToFile('c:\Replace.txt');
        ArrReplacePr.SaveToFile('c:\ReplacePr.txt');
      }
      For num := 0 To ArrSearch.Count - 1 Do
      begin
        XLSFindAndReplace(ArrSearch[num], ArrReplace[num]);
      end;
      For num := 0 To ArrSearchPr.Count - 1 Do
      begin
        XLSFindAndReplace(ArrSearchPr[num], ArrReplacePr[num]);
      end;
    End;

    if FileExists(filename) then
      DeleteFile(filename);
    Try
      xf.SaveAs(filename);
    Except
      showmessage('err save excel');
    End;
  End;
End;

Procedure TfrmStage1.StartProcessSpecification2;
Var
  filename: String;
  filenameindex: integer;
  //
  i, cnt: integer;
  f_name, f_kinddesc, f_article, f_count, f_price, f_total, f_comment: TCellStyle;
  System_count: integer;
  total_system, total_project: real;
  num: integer;
  curPage, curLine: integer;
Begin
  // Test;
  //
  ListInfo.Items.Add('   ');
  filename := frmMain.ComputerInfo.Folders.Temp + '\specification.xls';
  if FileExists(filename) then
    DeleteFile(filename);
  while FileExists(filename) do
  begin
    Inc(filenameindex);
    filename := frmMain.ComputerInfo.Folders.Temp + '\specification' + IntToStr(filenameindex) + '.xls';
    DeleteFile(filename);
  end;

  // GetSpecification
  Try
    FTPClient.Connect;
    FTPClient.ChangeDir('templates');
    If FileExists(filename) Then
      DeleteFile(filename);
    FTPClient.Get('specification.xls', filename, true);
    If FTPClient.Connected Then
      Try
        FTPClient.Quit;
      Except
      End;
  Except
  End;

  If FileExists(filename) Then
  Begin
    ListInfo.Items.Add(' ');
    xf.OpenFile(filename);
    cnt := xf.Workbook.Sheets.Count;
    For curPage := 0 To cnt - 1 Do
      Try
        //     
        //  
        f_name := XLSGetStyle('#name#');
        f_kinddesc := XLSGetStyle('#kinddesc#');
        f_article := XLSGetStyle('#article#');
        f_count := XLSGetStyle('#count#');
        f_price := XLSGetStyle('#price#');
        f_total := XLSGetStyle('#total#');
        f_comment := XLSGetStyle('#comment#');
        ///  ,    
        try
          MyQuery2.SQL.Text := 'SELECT * FROM `uni_projectsystems` WHERE `project_no`=' + IntToStr(Project_no) +
            ' AND `active` ORDER BY `orderby`;';
          MyQuery2.Active := true;
        except
          showmessage('err 9853');
        end;
        total_project := 0;
        curLine := 3;
        While Not MyQuery2.Eof Do
          try
            System_no := MyQuery2.FieldByName('rec_no').AsInteger;
            System_count := MyQuery2.FieldByName('count').AsInteger;
            MyQuery1.SQL.Text := 'SELECT * FROM `uni_projecthardware` WHERE `project_no`=' + IntToStr(Project_no) +
              ' AND `system_no`=' + IntToStr(System_no) + ' ORDER BY `orderby`;';
            MyQuery1.Active := true;
            total_system := 0;

            //    
            with xf.Workbook.Sheets[curPage] do
            begin
              Inc(curLine);
              Rows.InsertRows(curLine, 1);

              Cells[curLine, f_kinddesc.col].Value := MyQuery2.FieldByName('name').AsString;
              XLSSetStyle(curLine, f_kinddesc.col, curPage, f_kinddesc);
              Cells[curLine, f_kinddesc.col].FontBold := true;

              Cells[curLine, f_count.col].Value := MyQuery2.FieldByName('count').AsInteger;
              XLSSetStyle(curLine, f_count.col, curPage, f_count);
              Cells[curLine, f_price.col].FormatStringIndex := 2;
              Cells[curLine, f_count.col].FontBold := true;
              // 
              Cells[curLine, f_name.col].Value := '';
              XLSSetStyle(curLine, f_name.col, curPage, f_name);
              Cells[curLine, f_article.col].Value := '';
              XLSSetStyle(curLine, f_article.col, curPage, f_article);
              Cells[curLine, f_price.col].Value := '';
              XLSSetStyle(curLine, f_price.col, curPage, f_price);
              Cells[curLine, f_total.col].Value := '';
              XLSSetStyle(curLine, f_total.col, curPage, f_total);
              // Cells[curLine, f_comment.col].Value := '';
            end;

            //  ,  
            While Not MyQuery1.Eof Do
              with xf.Workbook.Sheets[curPage] do
              begin
                //   
                Inc(curLine);
                Rows.InsertRows(curLine, 1);

                If (f_name.col > -1) Then
                Begin
                  Cells[curLine, f_name.col].Value := MyQuery1.FieldByName('name').AsString;
                  Cells[curLine, f_name.col].FontBold := false;
                  XLSSetStyle(curLine, f_name.col, curPage, f_name);
                End;
                If (f_kinddesc.col > -1) Then
                Begin
                  Cells[curLine, f_kinddesc.col].Value := MyQuery1.FieldByName('kinddesc').AsString;
                  Cells[curLine, f_kinddesc.col].HAlign := xlHAlignLeft;
                  Cells[curLine, f_kinddesc.col].FontBold := false;
                  XLSSetStyle(curLine, f_kinddesc.col, curPage, f_kinddesc);
                End;
                If (f_article.col > -1) Then
                Begin
                  Cells[curLine, f_article.col].Value := MyQuery1.FieldByName('article').AsString;
                  Cells[curLine, f_article.col].HAlign := xlHAlignLeft;
                  Cells[curLine, f_article.col].FontBold := false;
                  Cells[curLine, f_article.col].FormatStringIndex := 35;
                  XLSSetStyle(curLine, f_article.col, curPage, f_article);
                End;
                If (f_comment.col > -1) Then
                Begin
                  Cells[curLine, f_comment.col].Value := MyQuery1.FieldByName('comment').AsString;
                  Cells[curLine, f_comment.col].HAlign := xlHAlignLeft;
                  Cells[curLine, f_comment.col].FontBold := false;
                  XLSSetStyle(curLine, f_comment.col, curPage, f_comment);
                End;
                If (f_count.col > -1) Then
                Begin
                  Cells[curLine, f_count.col].Value := MyQuery1.FieldByName('count').AsInteger;
                  Cells[curLine, f_count.col].HAlign := xlHAlignCenter;
                  Cells[curLine, f_count.col].FontBold := false;
                  XLSSetStyle(curLine, f_count.col, curPage, f_count);
                End;
                If (f_price.col > -1) Then
                Begin
                  // f_price.col.Offset[-1, 0].NumberFormat := '0,00';
                  Cells[curLine, f_price.col].Value := MyQuery1.FieldByName('price').AsFloat;
                  Cells[curLine, f_price.col].HAlign := xlHAlignRight;
                  Cells[curLine, f_price.col].FontBold := false;
                  Cells[curLine, f_price.col].FormatStringIndex := 2;
                  XLSSetStyle(curLine, f_price.col, curPage, f_price);
                End;
                If (f_total.col > -1) Then
                Begin
                  Cells[curLine, f_total.col].Value := MyQuery1.FieldByName('count').AsInteger *
                    MyQuery1.FieldByName('price').AsFloat;
                  Cells[curLine, f_total.col].FontBold := false;
                  Cells[curLine, f_total.col].FormatStringIndex := 2;
                  total_system := total_system + MyQuery1.FieldByName('count').AsInteger *
                    MyQuery1.FieldByName('price').AsFloat;
                  XLSSetStyle(curLine, f_total.col, curPage, f_total);
                End;

                MyQuery1.Next;
              End;

            // 

            total_project := total_project + (total_system * MyQuery2.FieldByName('count').AsInteger);

            with xf.Workbook.Sheets[curPage] do
            begin
              Inc(curLine);
              Rows.InsertRows(curLine, 1);
              Cells[curLine, f_kinddesc.col].Value := '';
              XLSSetStyle(curLine, f_kinddesc.col, curPage, f_kinddesc);
              Cells[curLine, f_kinddesc.col].FontBold := true;

              Cells[curLine, f_total.col].Value := total_system;
              XLSSetStyle(curLine, f_total.col, curPage, f_total);
              Cells[curLine, f_total.col].FontBold := true;
              Cells[curLine, f_total.col].FormatStringIndex := 2;
              //  
              XLSSetStyle(curLine, f_name.col, curPage, f_name);
              XLSSetStyle(curLine, f_article.col, curPage, f_article);
              XLSSetStyle(curLine, f_price.col, curPage, f_price);
              XLSSetStyle(curLine, f_count.col, curPage, f_count);
            end;

            //    
            MyQuery2.Next;
          except
          End;

        //   
        with xf.Workbook.Sheets[curPage] do
        begin
          Rows.InsertRows(curLine, 1);
          Inc(curLine);
          Cells[curLine, f_kinddesc.col].Value := '  ';
          Cells[curLine, f_kinddesc.col].FontBold := true;
          Cells[curLine, f_kinddesc.col].FontColorRGB := clRed;
          XLSSetStyle(curLine, f_kinddesc.col, curPage, f_kinddesc);

          Cells[curLine, f_total.col].Value := total_project;
          XLSSetStyle(curLine, f_total.col, curPage, f_total);
          Cells[curLine, f_total.col].FontBold := true;
          Cells[curLine, f_total.col].FontColorRGB := clRed;
          Cells[curLine, f_total.col].FormatStringIndex := 2;

          //  
          XLSSetStyle(curLine, f_name.col, curPage, f_name);
          XLSSetStyle(curLine, f_article.col, curPage, f_article);
          XLSSetStyle(curLine, f_price.col, curPage, f_price);
          XLSSetStyle(curLine, f_count.col, curPage, f_count);
        end;

      Except
        showmessage('err fill excel');
      End;

    /// ///////////////
    ///   
    For num := 0 To ArrSearchPr.Count - 1 Do
    begin
      XLSFindAndReplace(ArrSearchPr[num], ArrReplacePr[num]);
    end;

    // 
    if FileExists(filename) then
      DeleteFile(filename);

    Try
      xf.SaveAs(filename);
    Except
      showmessage('err save excel');
    End;
  End;

  If FileExists(filename) Then
    Try
      ListInfo.Items.Add('   ');
      ListInfo.ItemIndex := ListInfo.Items.Count - 1;
      Application.Processmessages;
      FTPClient.Connect;
      FTPClient.ChangeDir('projects');
      Try
        FTPClient.ChangeDir(IntToStr(Project_no));
      Except
        FTPClient.MakeDir(IntToStr(Project_no));
        FTPClient.ChangeDir(IntToStr(Project_no));
      End;
      FTPClient.Put(filename, 'specification.xls', false);

      //   
      try
        TPrAtt.SQL.Text := 'SELECT * FROM `uni_projectatt` WHERE `project_no`=' + IntToStr(Project_no);
        TPrAtt.Active := true;

        If TPrAtt.Locate('file', 'specification.xls', []) Then
          TPrAtt.Delete;
        TPrAtt.Append;
        TPrAtt.FieldByName('name').AsString := '';
        TPrAtt.FieldByName('file').AsString := 'specification.xls';
        TPrAtt.FieldByName('lastupdate').AsDateTime := Now();
        TPrAtt.FieldByName('project_no').AsInteger := Project_no;
        TPrAtt.Post;
      except
        showmessage(' 86234');
      end;
    Except
      showmessage('  =   =');
    End;
  If FTPClient.Connected Then
    Try
      FTPClient.Disconnect;
    Except
    End;
End;

Procedure TfrmStage1.StartProcessTemplates2;
Var
  filename: String;
  filenameindex: integer;
  //
  i, cnt: integer;
  f_name, f_kinddesc, f_article, f_count, f_price, f_total, f_comment: TCellStyle;
  System_count: integer;
  total_system, total_project: real;
  num: integer;
  curPage, curLine: integer;
  System_name, System_kind: string;
  tName, Text: string;
Begin
  // Test;
  //
  ListInfo.Items.Add('   ');
  try
    MyQuery1.SQL.Text := 'SELECT * FROM `uni_docparts` WHERE `project_no`=0 AND (`kind`="") OR (`kind` IS NULL);';
    MyQuery1.Active := true;
    //
    if MyQuery1.RecordCount > 0 then
    begin
      While Not MyQuery1.Eof Do
      begin
        tName := MyQuery1.FieldByName('name').AsString;
        Text := MyQuery1.FieldByName('defaultext').AsString;
        ListInfo.Items.Add('    [' + tName + ']');
        //
        Data.reportkind := '';
        Data.reportname := tName;
        Data.reportext := Text;
        Data.Project_no := Project_no;
        Data.System_no := System_no;
        Data.DoReportSave;
        //
        MyQuery1.Next;
      end;
    end;
  except
    showmessage('err 9550');
  end;

  MyQuery2.SQL.Text := 'SELECT * FROM `uni_projectsystems` WHERE `project_no`=' + IntToStr(Project_no) +
    ' AND `active` ORDER BY `orderby`;';
  MyQuery2.Active := true;

  While Not MyQuery2.Eof Do
    try
      System_no := MyQuery2.FieldByName('rec_no').AsInteger;
      System_count := MyQuery2.FieldByName('count').AsInteger;
      System_name := MyQuery2.FieldByName('name').AsString;
      System_kind := MyQuery2.FieldByName('kind').AsString;
      ListInfo.Items.Add('    : ' + System_name + '');
      ListInfo.Items.Add('    : ' + System_kind + '');

      MyQuery1.SQL.Text := 'SELECT * FROM `uni_docparts` WHERE `project_no`=0 AND `kind`=' +
        QuotedStr(System_kind) + ';';
      MyQuery1.Active := true;
      //
      if MyQuery1.RecordCount > 0 then
      begin
        While Not MyQuery1.Eof Do
        begin
          tName := MyQuery1.FieldByName('name').AsString;
          Text := MyQuery1.FieldByName('defaultext').AsString;
          ListInfo.Items.Add('     [' + tName + ']');
          //
          Data.reportkind := System_kind;
          Data.reportname := tName;
          Data.reportext := Text;
          Data.Project_no := Project_no;
          Data.System_no := System_no;
          Data.DoReportSave;
          //
          MyQuery1.Next;
        end;
      end;

      MyQuery2.Next;
    except
    end;

  { filename := frmMain.ComputerInfo.Folders.Temp + '\specification.xls';
    if FileExists(filename) then
    DeleteFile(filename);
    while FileExists(filename) do
    begin
    Inc(filenameindex);
    filename := frmMain.ComputerInfo.Folders.Temp + '\specification' +
    IntToStr(filenameindex) + '.xls';
    DeleteFile(filename);
    end; }

  // GetSpecification
  { Try
    FTPClient.Connect;
    FTPClient.ChangeDir('templates');
    If FileExists(filename) Then
    DeleteFile(filename);
    FTPClient.Get('specification.xls', filename, true);
    If FTPClient.Connected Then
    Try
    FTPClient.Quit;
    Except
    End;
    Except
    End;
  }
  {
    If FileExists(filename) Then
    Begin
    ListInfo.Items.Add(' ');
    xf.OpenFile(filename);
    cnt := xf.Workbook.Sheets.Count;
    For curPage := 0 To cnt - 1 Do
    Try
    //     
    //  
    f_name := XLSGetStyle('#name#');
    f_kinddesc := XLSGetStyle('#kinddesc#');
    f_article := XLSGetStyle('#article#');
    f_count := XLSGetStyle('#count#');
    f_price := XLSGetStyle('#price#');
    f_total := XLSGetStyle('#total#');
    f_comment := XLSGetStyle('#comment#');
    ///  ,    
    try
    MyQuery2.SQL.Text :=
    'SELECT * FROM `uni_projectsystems` WHERE `project_no`=' +
    IntToStr(Project_no) + ' AND `active` ORDER BY `orderby`;';
    MyQuery2.Active := true;
    except
    showmessage('err 9853');
    end;
    total_project := 0;
    curLine := 3;
    While Not MyQuery2.Eof Do
    try
    System_no := MyQuery2.FieldByName('rec_no').AsInteger;
    System_count := MyQuery2.FieldByName('count').AsInteger;
    MyQuery1.SQL.Text :=
    'SELECT * FROM `uni_projecthardware` WHERE `project_no`=' +
    IntToStr(Project_no) + ' AND `system_no`=' + IntToStr(System_no) +
    ' ORDER BY `orderby`;';
    MyQuery1.Active := true;
    total_system := 0;

    //    
    with xf.Workbook.Sheets[curPage] do
    begin
    Inc(curLine);
    Rows.InsertRows(curLine, 1);

    Cells[curLine, f_kinddesc.col].Value :=
    MyQuery2.FieldByName('name').AsString;
    XLSSetStyle(curLine, f_kinddesc.col, curPage, f_kinddesc);
    Cells[curLine, f_kinddesc.col].FontBold := true;

    Cells[curLine, f_count.col].Value := MyQuery2.FieldByName('count')
    .AsInteger;
    XLSSetStyle(curLine, f_count.col, curPage, f_count);
    Cells[curLine, f_price.col].FormatStringIndex := 2;
    Cells[curLine, f_count.col].FontBold := true;
    // 
    Cells[curLine, f_name.col].Value := '';
    XLSSetStyle(curLine, f_name.col, curPage, f_name);
    Cells[curLine, f_article.col].Value := '';
    XLSSetStyle(curLine, f_article.col, curPage, f_article);
    Cells[curLine, f_price.col].Value := '';
    XLSSetStyle(curLine, f_price.col, curPage, f_price);
    Cells[curLine, f_total.col].Value := '';
    XLSSetStyle(curLine, f_total.col, curPage, f_total);
    // Cells[curLine, f_comment.col].Value := '';
    end;

    //  ,  
    While Not MyQuery1.Eof Do
    with xf.Workbook.Sheets[curPage] do
    begin
    //   
    Inc(curLine);
    Rows.InsertRows(curLine, 1);

    If (f_name.col > -1) Then
    Begin
    Cells[curLine, f_name.col].Value :=
    MyQuery1.FieldByName('name').AsString;
    Cells[curLine, f_name.col].FontBold := false;
    XLSSetStyle(curLine, f_name.col, curPage, f_name);
    End;
    If (f_kinddesc.col > -1) Then
    Begin
    Cells[curLine, f_kinddesc.col].Value :=
    MyQuery1.FieldByName('kinddesc').AsString;
    Cells[curLine, f_kinddesc.col].HAlign := xlHAlignLeft;
    Cells[curLine, f_kinddesc.col].FontBold := false;
    XLSSetStyle(curLine, f_kinddesc.col, curPage, f_kinddesc);
    End;
    If (f_article.col > -1) Then
    Begin
    Cells[curLine, f_article.col].Value :=
    MyQuery1.FieldByName('article').AsString;
    Cells[curLine, f_article.col].HAlign := xlHAlignLeft;
    Cells[curLine, f_article.col].FontBold := false;
    Cells[curLine, f_article.col].FormatStringIndex := 35;
    XLSSetStyle(curLine, f_article.col, curPage, f_article);
    End;
    If (f_comment.col > -1) Then
    Begin
    Cells[curLine, f_comment.col].Value :=
    MyQuery1.FieldByName('comment').AsString;
    Cells[curLine, f_comment.col].HAlign := xlHAlignLeft;
    Cells[curLine, f_comment.col].FontBold := false;
    XLSSetStyle(curLine, f_comment.col, curPage, f_comment);
    End;
    If (f_count.col > -1) Then
    Begin
    Cells[curLine, f_count.col].Value :=
    MyQuery1.FieldByName('count').AsInteger;
    Cells[curLine, f_count.col].HAlign := xlHAlignCenter;
    Cells[curLine, f_count.col].FontBold := false;
    XLSSetStyle(curLine, f_count.col, curPage, f_count);
    End;
    If (f_price.col > -1) Then
    Begin
    // f_price.col.Offset[-1, 0].NumberFormat := '0,00';
    Cells[curLine, f_price.col].Value :=
    MyQuery1.FieldByName('price').AsFloat;
    Cells[curLine, f_price.col].HAlign := xlHAlignRight;
    Cells[curLine, f_price.col].FontBold := false;
    Cells[curLine, f_price.col].FormatStringIndex := 2;
    XLSSetStyle(curLine, f_price.col, curPage, f_price);
    End;
    If (f_total.col > -1) Then
    Begin
    Cells[curLine, f_total.col].Value :=
    MyQuery1.FieldByName('count').AsInteger *
    MyQuery1.FieldByName('price').AsFloat;
    Cells[curLine, f_total.col].FontBold := false;
    Cells[curLine, f_total.col].FormatStringIndex := 2;
    total_system := total_system + MyQuery1.FieldByName('count')
    .AsInteger * MyQuery1.FieldByName('price').AsFloat;
    XLSSetStyle(curLine, f_total.col, curPage, f_total);
    End;

    MyQuery1.Next;
    End;

    // 

    total_project := total_project +
    (total_system * MyQuery2.FieldByName('count').AsInteger);

    with xf.Workbook.Sheets[curPage] do
    begin
    Inc(curLine);
    Rows.InsertRows(curLine, 1);
    Cells[curLine, f_kinddesc.col].Value := '';
    XLSSetStyle(curLine, f_kinddesc.col, curPage, f_kinddesc);
    Cells[curLine, f_kinddesc.col].FontBold := true;

    Cells[curLine, f_total.col].Value := total_system;
    XLSSetStyle(curLine, f_total.col, curPage, f_total);
    Cells[curLine, f_total.col].FontBold := true;
    Cells[curLine, f_total.col].FormatStringIndex := 2;
    //  
    XLSSetStyle(curLine, f_name.col, curPage, f_name);
    XLSSetStyle(curLine, f_article.col, curPage, f_article);
    XLSSetStyle(curLine, f_price.col, curPage, f_price);
    XLSSetStyle(curLine, f_count.col, curPage, f_count);
    end;

    //    
    MyQuery2.Next;
    except
    End;

    //   
    with xf.Workbook.Sheets[curPage] do
    begin
    Rows.InsertRows(curLine, 1);
    Inc(curLine);
    Cells[curLine, f_kinddesc.col].Value := '  ';
    Cells[curLine, f_kinddesc.col].FontBold := true;
    Cells[curLine, f_kinddesc.col].FontColorRGB := clRed;
    XLSSetStyle(curLine, f_kinddesc.col, curPage, f_kinddesc);

    Cells[curLine, f_total.col].Value := total_project;
    XLSSetStyle(curLine, f_total.col, curPage, f_total);
    Cells[curLine, f_total.col].FontBold := true;
    Cells[curLine, f_total.col].FontColorRGB := clRed;
    Cells[curLine, f_total.col].FormatStringIndex := 2;

    //  
    XLSSetStyle(curLine, f_name.col, curPage, f_name);
    XLSSetStyle(curLine, f_article.col, curPage, f_article);
    XLSSetStyle(curLine, f_price.col, curPage, f_price);
    XLSSetStyle(curLine, f_count.col, curPage, f_count);
    end;

    Except
    showmessage('err fill excel');
    End;

    /// ///////////////
    ///   
    For num := 0 To ArrSearchPr.Count - 1 Do
    begin
    XLSFindAndReplace(ArrSearchPr[num], ArrReplacePr[num]);
    end;

    // 
    if FileExists(filename) then
    DeleteFile(filename);

    Try
    xf.SaveAs(filename);
    Except
    showmessage('err save excel');
    End;
    End;
  }
  {
    If FileExists(filename) Then
    Try
    ListInfo.Items.Add('   ');
    ListInfo.ItemIndex := ListInfo.Items.Count - 1;
    Application.Processmessages;
    FTPClient.Connect;
    FTPClient.ChangeDir('projects');
    Try
    FTPClient.ChangeDir(IntToStr(Project_no));
    Except
    FTPClient.MakeDir(IntToStr(Project_no));
    FTPClient.ChangeDir(IntToStr(Project_no));
    End;
    FTPClient.Put(filename, 'specification.xls', false);

    //   
    try
    TPrAtt.SQL.Text := 'SELECT * FROM `uni_projectatt` WHERE `project_no`='
    + IntToStr(Project_no);
    TPrAtt.Active := true;

    If TPrAtt.Locate('file', 'specification.xls', []) Then
    TPrAtt.Delete;
    TPrAtt.Append;
    TPrAtt.FieldByName('name').AsString := '';
    TPrAtt.FieldByName('file').AsString := 'specification.xls';
    TPrAtt.FieldByName('lastupdate').AsDateTime := Now();
    TPrAtt.FieldByName('project_no').AsInteger := Project_no;
    TPrAtt.Post;
    except
    showmessage(' 86234');
    end;
    Except
    showmessage('  =   =');
    End;
    If FTPClient.Connected Then
    Try
    FTPClient.Disconnect;
    Except
    End;
  }
End;

End.
