unit Valuta;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, DBGrids, JvExDBGrids, JvDBGrid, DB,
  Menus, JvMenus, ActnList, System.Actions, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf,
  FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.Client,
  FireDAC.Comp.DataSet;

type
  TfrmValuta = class(TForm)
    MainMenu: TMainMenu;
    N12: TMenuItem;
    N15: TMenuItem;
    N14: TMenuItem;
    N13: TMenuItem;
    Actions: TActionList;
    actAdd: TAction;
    actEdit: TAction;
    actDelete: TAction;
    PopupMenu: TPopupMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    TValuta: TFDTable;
    DSUsers: TDataSource;
    TemplateGrid: TJvDBGrid;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure actAddExecute(Sender: TObject);
    procedure actEditExecute(Sender: TObject);
    procedure actDeleteExecute(Sender: TObject);
    procedure TemplateGridDblClick(Sender: TObject);
    procedure actEditUpdate(Sender: TObject);
    procedure actDeleteUpdate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    tunnelupload: string;
    { Public declarations }
  end;

var
  frmValuta: TfrmValuta;

implementation

uses Main, ValutaAdd, ValutaDelete, Universal;

{$R *.dfm}

procedure TfrmValuta.actAddExecute(Sender: TObject);
begin
  frmValutaAdd.ClearData;
  if frmValutaAdd.ShowModal = mrOk then
  begin
    TValuta.Append;
    TValuta.FieldByName('valuta_code').AsString := frmValutaAdd.valuta_code.Text;
    TValuta.FieldByName('valuta_html').AsString := frmValutaAdd.valuta_html.Text;
    TValuta.FieldByName('valuta_buy').AsFloat := frmValutaAdd.valuta_buy.value;
    TValuta.FieldByName('valuta_sale').AsFloat := frmValutaAdd.valuta_sale.value;
    TValuta.Post;
  end;
end;

procedure TfrmValuta.actDeleteExecute(Sender: TObject);
begin
  if frmValutaDelete.ShowModal = mrOk then
  begin
    TValuta.Delete;
  end;
end;

procedure TfrmValuta.actDeleteUpdate(Sender: TObject);
begin
  actDelete.Enabled := (TValuta.RecordCount > 0);
end;

procedure TfrmValuta.actEditExecute(Sender: TObject);
begin
  frmValutaAdd.ClearData;
  if (TValuta.RecordCount > 0) then
    try
      frmValutaAdd.valuta_code.ItemIndex := frmValutaAdd.valuta_code.Items.IndexOf
        (TValuta.FieldByName('valuta_code').AsString);

      frmValutaAdd.valuta_buy.value := TValuta.FieldByName('valuta_buy').AsFloat;

      frmValutaAdd.valuta_html.Text := TValuta.FieldByName('valuta_html').AsString;

      frmValutaAdd.valuta_sale.value := TValuta.FieldByName('valuta_sale').AsFloat;
      if frmValutaAdd.ShowModal = mrOk then
      begin
        TValuta.Edit;
        TValuta.FieldByName('valuta_code').AsString := frmValutaAdd.valuta_code.Text;
        TValuta.FieldByName('valuta_html').AsString := frmValutaAdd.valuta_html.Text;
        TValuta.FieldByName('valuta_buy').AsFloat := frmValutaAdd.valuta_buy.value;
        TValuta.FieldByName('valuta_sale').AsFloat := frmValutaAdd.valuta_sale.value;
        TValuta.Post;
      end;
    except
    end;
end;

procedure TfrmValuta.actEditUpdate(Sender: TObject);
begin
  actEdit.Enabled := (TValuta.RecordCount > 0);
end;

procedure TfrmValuta.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TfrmValuta.FormCreate(Sender: TObject);
begin
  WindowState := frmMain.ws;
end;

procedure TfrmValuta.FormShow(Sender: TObject);
begin
  if not frmUniversal.DBConnected then
    close;

  try
    TValuta.Active := true;
  except
    showmessage('    ');
    close;
  end;
end;

procedure TfrmValuta.TemplateGridDblClick(Sender: TObject);
begin
  actEdit.Execute;
end;

end.
