unit Tracker;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ComCtrls, Vcl.ExtCtrls,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, Data.DB, FireDAC.Comp.DataSet,
  FireDAC.Comp.Client;

type
  TfrmTracker = class(TForm)
    GroupBox1: TGroupBox;
    Panel1: TPanel;
    editDate: TDateTimePicker;
    editTime: TDateTimePicker;
    Label1: TLabel;
    Label2: TLabel;
    ListUsers: TComboBox;
    ListTables: TComboBox;
    ListLogs: TListBox;
    TimerGetLogs: TTimer;
    QueryLog: TFDQuery;
    ListOrders: TEdit;
    ListSystems: TEdit;
    fOrders: TCheckBox;
    fSystems: TCheckBox;
    fTables: TCheckBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure TimerGetLogsTimer(Sender: TObject);
    procedure AnyChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    function OperationToString(operation: integer): string;
    procedure FillUserList;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmTracker: TfrmTracker;

implementation

{$R *.dfm}

uses Universal;

procedure TfrmTracker.AnyChange(Sender: TObject);
begin
  TimerGetLogs.Enabled := false;
  TimerGetLogs.Enabled := true;
end;

procedure TfrmTracker.FillUserList;
begin
  try
    ListUsers.items.clear;
    ListUsers.items.Add('[ ]');
    QueryLog.SQL.text := 'SELECT `username` FROM `uni_users` GROUP BY `username` ORDER BY `username`;';
    QueryLog.Active := true;
    If QueryLog.Active Then
      While Not QueryLog.eof Do
      Begin
        If QueryLog.FieldByName('username').AsString <> '' Then
          ListUsers.items.Add(QueryLog.FieldByName('username').AsString);
        QueryLog.next;
      End;
  except
  end;
end;

procedure TfrmTracker.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TfrmTracker.FormCreate(Sender: TObject);
begin
  editDate.DateTime := now;
  editTime.DateTime := now;
  editTime.Time := 0;
end;

procedure TfrmTracker.FormShow(Sender: TObject);
begin
  if not frmUniversal.DBConnected then
    exit;
  FillUserList;
  ListUsers.ItemIndex := 0;
end;

procedure TfrmTracker.TimerGetLogsTimer(Sender: TObject);
var
  username, text: string;
  operation: integer;
  table_name, project_name, system_name: string;
  dt: tdatetime;
  log: string;
  filter: string;
begin
  if not frmUniversal.DBConnected then
    exit;

  TimerGetLogs.Enabled := false;
  editDate.Time := editTime.Time;

  filter := 'timestamp>:dt';

  if ListUsers.text <> '[ ]' then
  begin
    filter := filter + ' AND username=' + QuotedStr(ListUsers.items[ListUsers.ItemIndex]);
  end;

  if fTables.Checked and (ListTables.text <> '[ ]') then
  begin
    if ListTables.text = '' then
      filter := filter + ' AND table_name=' + QuotedStr('uni_projects');

    if ListTables.text = ' ' then
      filter := filter + ' AND table_name=' + QuotedStr('uni_projectsystems');

    if ListTables.text = ' ' then
      filter := filter + ' AND table_name=' + QuotedStr('uni_projecthardware');

    if ListTables.text = ' ' then
      filter := filter + ' AND table_name=' + QuotedStr('uni_hardware');

    if ListTables.text = ' ' then
      filter := filter + ' AND table_name=' + QuotedStr('uni_systems');
  end;

  if fOrders.Checked and (ListOrders.text <> '') then
  begin
    filter := filter + ' AND project_name=' + QuotedStr(ListOrders.text);
  end;

  if fSystems.Checked and (ListSystems.text <> '') then
  begin
    filter := filter + ' AND system_name=' + QuotedStr(ListSystems.text);
  end;

  QueryLog.SQL.text := 'SELECT * FROM uni_log WHERE ' + filter + ' ORDER BY `rec_no` DESC LIMIT 100;';
  QueryLog.ParamByName('dt').AsDateTime := editDate.DateTime;
  try
    QueryLog.Active := true;
  except
    exit;
  end;

  ListLogs.items.clear;
  while not QueryLog.eof do
  begin
    username := QueryLog.FieldByName('username').AsString;
    text := QueryLog.FieldByName('text').AsString;
    table_name := QueryLog.FieldByName('table_name').AsString;
    project_name := QueryLog.FieldByName('project_name').AsString;
    system_name := QueryLog.FieldByName('system_name').AsString;
    operation := QueryLog.FieldByName('operation').AsInteger;
    dt := QueryLog.FieldByName('timestamp').AsDateTime;

    log := FormatDateTime('dd.mm.yy hh:nn', dt);
    log := log + ' ' + username;
    log := log + ' ' + OperationToString(operation);
    log := log + ' "' + text + '"';

    if table_name <> '' then
    begin
      if table_name = 'uni_hardware' then
        log := log + '   ';

      if table_name = 'uni_projectsystems' then
      begin
        log := log + '  ';
        if project_name <> '' then
          log := log + ' ' + project_name;
        if system_name <> '' then
          log := log + ' / ' + system_name;
      end;
      if table_name = 'uni_projecthardware' then
      begin
        log := log + '  ';
        if project_name <> '' then
          log := log + ' ' + project_name;
        if system_name <> '' then
          log := log + ' / ' + system_name;
      end;
      if table_name = 'uni_systems' then
        log := log + '   ';
    end;

    ListLogs.items.Insert(0, log);
    QueryLog.next;
  end;

  QueryLog.Close;
  if ListLogs.items.Count > 0 then
    ListLogs.ItemIndex := ListLogs.items.Count - 1;
end;

function TfrmTracker.OperationToString(operation: integer): string;
begin
  result := '-';
  case operation of
    1:
      result := '';
    2:
      result := '';
    3:
      result := '';
  end;
end;

end.
