Unit TemplatesFR;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, Grids, DBGrids, JvExDBGrids, JvDBGrid, DB,
  Menus, JvMenus, ActnList, JvDialogs, frxClass,
  JvMemoryDataset, frxDBSet, System.Actions, Vcl.ExtCtrls, JvBaseDlg,
  JvSelectDirectory, JvComponentBase, JvSearchFiles, FireDAC.Stan.Intf,
  FireDAC.Stan.Option, FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS,
  FireDAC.Phys.Intf, FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt,
  FireDAC.Comp.DataSet, FireDAC.Comp.Client, Vcl.StdCtrls, JvFormPlacement;

Type
  TfrmTemplatesFR = Class(TForm)
    TemplateGrid: TJvDBGrid;
    StatusBar: TStatusBar;
    DSTemplate: TDataSource;
    PopupMenu: TJvPopupMenu;
    N1: TMenuItem;
    Actions: TActionList;
    actDeleteRecord: TAction;
    N2: TMenuItem;
    N3: TMenuItem;
    actEditContent: TAction;
    N4: TMenuItem;
    N5: TMenuItem;
    actAdd: TAction;
    actLoad: TAction;
    actSave: TAction;
    N6: TMenuItem;
    N7: TMenuItem;
    N8: TMenuItem;
    actRename: TAction;
    N9: TMenuItem;
    dlgSave: TSaveDialog;
    dlgOpen: TJvOpenDialog;
    actAddFolder: TAction;
    actAddFolder1: TMenuItem;
    N10: TMenuItem;
    SF: TJvSearchFiles;
    dlgSelectDirectory: TJvSelectDirectory;
    TTemplate: TFDQuery;
    PanelHeader: TPanel;
    Label2: TLabel;
    FormStorage: TJvFormStorage;
    actCreateReport: TAction;
    N11: TMenuItem;
    FDQuery1: TFDQuery;
    Procedure FormShow(Sender: TObject);
    Procedure N1Click(Sender: TObject);
    Procedure actDeleteRecordExecute(Sender: TObject);
    Procedure actDeleteRecordUpdate(Sender: TObject);
    Procedure FormClose(Sender: TObject; Var Action: TCloseAction);
    procedure TemplateGridDblClick(Sender: TObject);
    procedure actEditContentUpdate(Sender: TObject);
    procedure actEditContentExecute(Sender: TObject);
    procedure actAddExecute(Sender: TObject);
    procedure actRenameExecute(Sender: TObject);
    procedure actLoadExecute(Sender: TObject);
    procedure actSaveExecute(Sender: TObject);
    procedure actRenameUpdate(Sender: TObject);
    procedure actSaveUpdate(Sender: TObject);
    procedure actLoadUpdate(Sender: TObject);
    procedure actAddUpdate(Sender: TObject);
    function frxDesignerSaveReport(Report: TfrxReport; SaveAs: Boolean): Boolean;
    procedure actAddFolderExecute(Sender: TObject);
    procedure SFFindFile(Sender: TObject; const AName: string);
    procedure actCreateReportExecute(Sender: TObject);
    procedure actCreateReportUpdate(Sender: TObject);
  Private
    { Private declarations }
  Public
    { Public declarations }
  End;

Var
  frmTemplatesFR: TfrmTemplatesFR;

Implementation

Uses Main, TemplatesFRAdd, DataModule, Universal;
{$R *.dfm}

procedure TfrmTemplatesFR.actAddExecute(Sender: TObject);
var
  BlobField1, BlobField2: TField;
  BS1, BS2: TStream;
begin
  frmTemplatesFRAdd.editName.Text := '';
  frmTemplatesFRAdd.editKind.Text := '';
  frmTemplatesFRAdd.ext.Text := 'PDF';
  if frmTemplatesFRAdd.ShowModal = mrOk then
    try
      frmUniversal.FilebaseQuery1.Active := false;
      frmUniversal.FilebaseQuery1.SQL.Text :=
        'INSERT INTO `uni_docparts` (`store`,`kind`,`name`,`defaultext`,`project_no`) VALUES(:store,:kind,:name,:defaultext,0);';
      frmUniversal.FilebaseQuery1.ParamByName('store').LoadFromStream(Data.EmptyTemplate.Data, ftBlob);
      frmUniversal.FilebaseQuery1.ParamByName('kind').AsString := frmTemplatesFRAdd.editKind.Text;
      frmUniversal.FilebaseQuery1.ParamByName('name').AsString := frmTemplatesFRAdd.editName.Text;
      frmUniversal.FilebaseQuery1.ParamByName('defaultext').AsString := frmTemplatesFRAdd.ext.Text;
      frmUniversal.FilebaseQuery1.ExecSQL;
      frmUniversal.FilebaseQuery1.close;
    except
    end;
  TTemplate.Refresh;
end;

procedure TfrmTemplatesFR.actAddUpdate(Sender: TObject);
begin
  actEditContent.Enabled := TTemplate.Active;
end;

procedure TfrmTemplatesFR.actCreateReportExecute(Sender: TObject);
var
  reporname, reportext, reportfile: string;
  BlobField2: TField;
  edit_stream: TStream;
  res_stream: TMemoryStream;
  errcnt: integer;
begin
  reporname := TTemplate.FieldByName('name').AsString;
  reportext := uppercase(TTemplate.FieldByName('defaultext').AsString);
  // open
  FDQuery1.SQL.Text := 'SELECT * FROM `uni_docparts` WHERE `project_no`=0 AND `name`=:name LIMIT 5;';
  FDQuery1.ParamByName('name').AsString := reporname;
  FDQuery1.Active := true;
  //
  if FDQuery1.Recordcount > 0 then
    While Not FDQuery1.eof Do
      try
        FDQuery1.Next;

        Data.Project_no := frmMain.current_projectno;
        Data.DoReportPreset;

        //   
        BlobField2 := FDQuery1.FieldByName('store');
        edit_stream := FDQuery1.CreateBlobStream(BlobField2, bmRead);
        Data.frxReport.FileName := 'template.fr3';
        Data.frxReport.LoadFromStream(edit_stream);

        try
          if not Data.frxReport.PrepareReport(true) then
          begin
            for errcnt := 0 to Data.frxReport.Errors.Count - 1 do
            begin
              showmessage(Data.frxReport.Errors[errcnt]);
            end;
            exit;
          end;
        except
          showmessage(' frmTemplatesFR.actCreateReportExecute');
          exit;
        end;

        reportfile := reporname + '_' + Data.Project_no.ToString + '.' + lowercase(reportext);
        dlgSave.DefaultExt := lowercase(reportext);
        dlgSave.FileName := reportfile;
        if dlgSave.Execute then
          try
            reportfile := dlgSave.FileName;

            res_stream := TMemoryStream.Create;
            Data.DoReportSaveFormat(res_stream, '.' + reportext); //       
            res_stream.Seek(0, soFromBeginning);
            res_stream.SaveToFile(reportfile);
            res_stream.Free;

            frmMain.OpenFile(reportfile);
          except
          end;

        edit_stream.Free;
      except
      end;
end;

procedure TfrmTemplatesFR.actCreateReportUpdate(Sender: TObject);
begin
  actCreateReport.Enabled := TTemplate.Active And (TTemplate.RecNo > 0);
end;

Procedure TfrmTemplatesFR.actDeleteRecordExecute(Sender: TObject);
Begin
  if (MessageDlg('    ?', mtCustom, [mbYes, mbCancel], 0) = mrYes) then
    TTemplate.Delete;
End;

Procedure TfrmTemplatesFR.actDeleteRecordUpdate(Sender: TObject);
Begin
  actDeleteRecord.Enabled := TTemplate.Active And (TTemplate.RecNo > 0);
End;

procedure TfrmTemplatesFR.actEditContentUpdate(Sender: TObject);
begin
  actEditContent.Enabled := TTemplate.Active And (TTemplate.RecNo > 0);
end;

procedure TfrmTemplatesFR.actLoadExecute(Sender: TObject);
var
  rec_no: integer;
begin
  if (TTemplate.Recordcount = 0) or (rec_no < 0) then
    exit;
  rec_no := TTemplate.FieldByName('rec_no').AsInteger;

  if (rec_no > -1) and dlgOpen.Execute and FileExists(dlgOpen.FileName) then
    try
      frmUniversal.FilebaseQuery1.Active := false;
      frmUniversal.FilebaseQuery1.SQL.Text := 'UPDATE `uni_docparts` SET `store`=:store WHERE rec_no=:rec_no;';
      frmUniversal.FilebaseQuery1.ParamByName('store').LoadFromFile(dlgOpen.FileName, ftBlob);
      frmUniversal.FilebaseQuery1.ParamByName('rec_no').AsInteger := rec_no;
      frmUniversal.FilebaseQuery1.ExecSQL;
      frmUniversal.FilebaseQuery1.close;
      TTemplate.Refresh;
    except
    end;
end;

procedure TfrmTemplatesFR.actLoadUpdate(Sender: TObject);
begin
  actLoad.Enabled := TTemplate.Active And (TTemplate.RecNo > 0);
end;

procedure TfrmTemplatesFR.actRenameExecute(Sender: TObject);
begin
  frmTemplatesFRAdd.editKind.Text := TTemplate.FieldByName('kind').AsString;
  frmTemplatesFRAdd.editName.Text := TTemplate.FieldByName('name').AsString;
  frmTemplatesFRAdd.ext.Text := TTemplate.FieldByName('defaultext').AsString;
  if frmTemplatesFRAdd.ShowModal = mrOk then
    try
      TTemplate.Edit;
      TTemplate.FieldByName('project_no').AsInteger := 0;
      TTemplate.FieldByName('kind').AsString := frmTemplatesFRAdd.editKind.Text;
      TTemplate.FieldByName('name').AsString := frmTemplatesFRAdd.editName.Text;
      TTemplate.FieldByName('defaultext').AsString := frmTemplatesFRAdd.ext.Text;
      TTemplate.Post;
    except
    end;
end;

procedure TfrmTemplatesFR.actRenameUpdate(Sender: TObject);
begin
  actRename.Enabled := TTemplate.Active And (TTemplate.RecNo > 0);
end;

procedure TfrmTemplatesFR.actSaveExecute(Sender: TObject);
var
  BlobField1, BlobField2: TField;
  FS: TMemoryStream;
  BlobStream: TStream;
begin
  TTemplate.Refresh;

  dlgSave.FileName := TTemplate.FieldByName('name').AsString;
  Data.report_recno := TTemplate.FieldByName('rec_no').AsInteger;

  if (TTemplate.RecNo > 0) and dlgSave.Execute then
    try
      FS := TMemoryStream.Create;
      frmUniversal.DatabaseQuery1.Active := false;
      frmUniversal.DatabaseQuery1.SQL.Text := 'SELECT `store` FROM `uni_docparts` WHERE rec_no=:rec_no;';
      frmUniversal.DatabaseQuery1.ParamByName('rec_no').AsInteger := Data.report_recno;
      frmUniversal.DatabaseQuery1.Active := true;
      if (frmUniversal.DatabaseQuery1.Recordcount > 0) then
      begin
        BlobStream := frmUniversal.DatabaseQuery1.CreateBlobStream(frmUniversal.DatabaseQuery1.FieldByName('store'),
          TBlobStreamMode.bmRead);
        if (BlobStream.Size > 0) then
        begin
          FS.CopyFrom(BlobStream, 0);
          FS.SaveToFile(dlgSave.FileName);
        end;
        BlobStream.Free;
      end;
      frmUniversal.DatabaseQuery1.close;
      FS.Free;
    except
    end;
end;

procedure TfrmTemplatesFR.actSaveUpdate(Sender: TObject);
begin
  actSave.Enabled := TTemplate.Active And (TTemplate.RecNo > 0);
end;

Procedure TfrmTemplatesFR.FormClose(Sender: TObject; Var Action: TCloseAction);
Begin
  // frmMain.UpdateMDIPanel(0, Caption);
  TTemplate.Active := false;
  Action := caFree;
End;

Procedure TfrmTemplatesFR.FormShow(Sender: TObject);
Begin
  // frmMain.UpdateMDIPanel(1, Caption);
  try
    TTemplate.Active := true;
  except
    close;
  end;
End;

function TfrmTemplatesFR.frxDesignerSaveReport(Report: TfrxReport; SaveAs: Boolean): Boolean;
var
  FS: TMemoryStream;
begin
  FS := TMemoryStream.Create;
  try
    Report.SaveToStream(FS);
    FS.Seek(0, soFromBeginning);

    if SaveAs then
    begin
      if dlgSave.Execute then
        FS.SaveToFile(dlgSave.FileName);
    end
    else
    begin
      frmUniversal.FilebaseQuery1.SQL.Text := 'UPDATE `uni_docparts` SET `store`=:store WHERE rec_no=:rec_no;';
      frmUniversal.FilebaseQuery1.ParamByName('store').LoadFromStream(FS, ftBlob);
      frmUniversal.FilebaseQuery1.ParamByName('rec_no').AsInteger := Report.Tag;
      frmUniversal.FilebaseQuery1.ExecSQL;
      frmUniversal.FilebaseQuery1.close;
    end;
  finally
    FS.Free;
  end;
end;

Procedure TfrmTemplatesFR.N1Click(Sender: TObject);
Begin
  TTemplate.Active := false;
  TTemplate.Active := true;
  // TTemplate.Refresh;
End;

procedure TfrmTemplatesFR.TemplateGridDblClick(Sender: TObject);
begin
  actEditContent.Execute;
end;

procedure TfrmTemplatesFR.actEditContentExecute(Sender: TObject);
var
  BlobStream: TStream;
begin
  if (TTemplate.Recordcount = 0) then
    exit;

  Data.frxReport.Clear;
  Data.frxReport.FileName := TTemplate.FieldByName('name').AsString;
  Data.report_recno := TTemplate.FieldByName('rec_no').AsInteger;

  //  
  try
    frmUniversal.DatabaseQuery1.Active := false;
    frmUniversal.DatabaseQuery1.SQL.Text := 'SELECT `store` FROM `uni_docparts` WHERE rec_no=:rec_no;';
    frmUniversal.DatabaseQuery1.ParamByName('rec_no').AsInteger := Data.report_recno;
    frmUniversal.DatabaseQuery1.Active := true;
    if (frmUniversal.DatabaseQuery1.Recordcount > 0) then
    begin
      BlobStream := frmUniversal.DatabaseQuery1.CreateBlobStream(frmUniversal.DatabaseQuery1.FieldByName('store'),
        TBlobStreamMode.bmRead);
      if (BlobStream.Size > 0) then
      begin
        Data.frxReport.LoadFromStream(BlobStream);
        Data.DesignReport;
      end;
      BlobStream.Free;
    end;
    frmUniversal.DatabaseQuery1.close;
    TTemplate.Refresh;
  except
    showmessage(' frmTemplatesFR.actEditContentExecute');
  end;

end;

procedure TfrmTemplatesFR.actAddFolderExecute(Sender: TObject);
begin
  dlgSelectDirectory.InitialDir := ExtractFilePath(application.ExeName);
  if dlgSelectDirectory.Execute then
  begin
    SF.RootDirectory := dlgSelectDirectory.Directory;
    SF.FileParams.FileMask := '*.fr3';
    SF.Search;
  end;
  TTemplate.Refresh;
end;

procedure TfrmTemplatesFR.SFFindFile(Sender: TObject; const AName: string);
var
  fn, n: string;
begin
  try
    fn := ExtractFileName(AName);
    n := Copy(fn, 0, pos('.', fn) - 1);

    frmUniversal.FilebaseQuery1.SQL.Text :=
      'INSERT INTO `uni_docparts` (`store`,`kind`,`name`,`defaultext`,`project_no`) VALUES(:store,:kind,:name,:defaultext,0);';
    frmUniversal.FilebaseQuery1.ParamByName('store').LoadFromFile(AName, ftBlob);
    frmUniversal.FilebaseQuery1.ParamByName('kind').AsString := '';
    frmUniversal.FilebaseQuery1.ParamByName('name').AsString := n;
    frmUniversal.FilebaseQuery1.ParamByName('defaultext').AsString := 'PDF';
    frmUniversal.FilebaseQuery1.ExecSQL;
    frmUniversal.FilebaseQuery1.close;
  except
  end;
end;

End.
