Unit Templates;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, JvExGrids, JvStringGrid, ExtCtrls, FMTBcd, SqlExpr, DB, Menus,
  StdActns, ActnList, JvMenus, DBGrids, JvExDBGrids, JvDBGrid, DBClient,
  Provider, ComCtrls, StdCtrls, JvExControls, JvDBLookup, JvComponentBase,
  JvDBGridExport, JvDialogs,
  JvExStdCtrls, JvRichEdit, JvDBRichEdit, JvExComCtrls,
  JvComCtrls, Mask, JvExMask, JvSpin, JvDBSpinEdit, IniFiles,
  DBCtrls,
  JvDBTreeView, ToolWin, System.Actions, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf,
  FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.Client,
  FireDAC.Comp.DataSet;

Type
  TfrmTemplates = Class(TForm)
    pmTree: TPopupMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    Actions: TActionList;
    actTemplateAdd: TAction;
    actTemplateEdit: TAction;
    actTemplateDelete: TAction;
    MainMenu: TMainMenu;
    mTemplates: TMenuItem;
    mTemplateAdd: TMenuItem;
    mTemplateEdit: TMenuItem;
    mTemplateDelete: TMenuItem;
    StatusBar: TStatusBar;
    PanelRight: TPanel;
    SaveDialog: TJvSaveDialog;
    DSTemplate: TDataSource;
    actTemplateCopy: TAction;
    actTemplateSave: TAction;
    actTemplateLoad: TAction;
    PanelLeft: TPanel;
    CatalogTree: TJvDBTreeView;
    Splitter3: TSplitter;
    DSDefFields: TDataSource;
    pmDefFields: TPopupMenu;
    actFieldsAdd: TAction;
    N5: TMenuItem;
    N10: TMenuItem;
    N12: TMenuItem;
    actFieldsEdit: TAction;
    actFieldsDelete: TAction;
    N13: TMenuItem;
    N14: TMenuItem;
    N15: TMenuItem;
    N16: TMenuItem;
    actAllowMove: TAction;
    ToolBarTree: TToolBar;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    DefFields: TJvDBGrid;
    N4: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    TTemplate: TFDQuery;
    TDefFields: TFDQuery;
    Procedure FormClose(Sender: TObject; Var Action: TCloseAction);
    Procedure FormCreate(Sender: TObject);
    Procedure FormDestroy(Sender: TObject);
    Procedure actTemplateAddExecute(Sender: TObject);
    Procedure actTemplateDeleteExecute(Sender: TObject);
    Procedure actTemplateEditExecute(Sender: TObject);
    Procedure TTemplateAfterScroll(DataSet: TDataSet);
    Procedure FormShow(Sender: TObject);
    Procedure FormActivate(Sender: TObject);
    Procedure actTemplateSaveExecute(Sender: TObject);
    Procedure actFieldsAddExecute(Sender: TObject);
    Procedure actFieldsEditUpdate(Sender: TObject);
    Procedure actFieldsDeleteUpdate(Sender: TObject);
    Procedure CatalogTreeChange(Sender: TObject; Node: TTreeNode);
    Procedure actFieldsEditExecute(Sender: TObject);
    Procedure DefFieldsDblClick(Sender: TObject);
    Procedure actFieldsDeleteExecute(Sender: TObject);
    Procedure actFieldsAddUpdate(Sender: TObject);
    Procedure actAllowMoveExecute(Sender: TObject);
    Procedure CatalogTreeDblClick(Sender: TObject);
    Procedure actTemplateCopyExecute(Sender: TObject);
    Procedure actTemplateDeleteUpdate(Sender: TObject);
    Procedure actTemplateEditUpdate(Sender: TObject);
    Procedure actTemplateCopyUpdate(Sender: TObject);
    procedure actTemplateAddUpdate(Sender: TObject);
    procedure actAllowMoveUpdate(Sender: TObject);
  Private
    { Private declarations }
  Public
    f_captions, f_visible, f_width: TStringList;
    tunnelupload: String;
    Procedure ExportToExcel;
    Procedure ReTranslate;
    { Public declarations }
  End;

Var
  frmTemplates: TfrmTemplates;

Implementation

Uses Main, TemplateAdd, EffectDelete, EffectEdit, LanguageSelect,
  DefFieldsAdd, TemplateCopy, Universal;
{$R *.dfm}

Procedure TfrmTemplates.FormActivate(Sender: TObject);
Begin
  DefFields.SetFocus;
End;

Procedure TfrmTemplates.FormClose(Sender: TObject; Var Action: TCloseAction);
Begin
  Action := caFree;
End;

Procedure TfrmTemplates.FormCreate(Sender: TObject);
Begin
  WindowState := frmMain.ws;
  { f_captions := TStringList.Create;
    f_visible := TStringList.Create;
    f_width := TStringList.Create;
  }
End;

Procedure TfrmTemplates.FormDestroy(Sender: TObject);
Begin
  { f_captions.Free;
    f_visible.Free;
    f_width.Free;
  }
End;

Procedure TfrmTemplates.FormShow(Sender: TObject);
Begin
  // ReTranslate;

  if not frmUniversal.DBConnected then
    close;

  Try
    PanelLeft.Visible := true;
    PanelRight.Visible := true;
    TTemplate.Active := true;
    CatalogTree.Selected := CatalogTree.TopItem;
  Except
    showmessage('      ');
    close;
  End;
End;

Procedure TfrmTemplates.TTemplateAfterScroll(DataSet: TDataSet);
Var
  rec_no: integer;
Begin
  If TTemplate.Active Then
  Begin
    rec_no := TTemplate.FieldByName('rec_no').AsInteger;
    StatusBar.Panels[0].Text := inttostr(rec_no);
  End;
End;

Procedure TfrmTemplates.actAllowMoveExecute(Sender: TObject);
Begin
  CatalogTree.DragMode := dmManual;
  If actAllowMove.Checked Then
  Begin
    CatalogTree.DragMode := dmAutomatic;
    CatalogTree.ReadOnly := false;
  End
  Else
  Begin
    CatalogTree.DragMode := dmManual;
    CatalogTree.ReadOnly := true;
  End;
End;

procedure TfrmTemplates.actAllowMoveUpdate(Sender: TObject);
begin
  actAllowMove.Enabled := (frmMain.usergroup.Length > 1);
end;

Procedure TfrmTemplates.actFieldsAddExecute(Sender: TObject);
Begin
  frmDefFieldsAdd.Clear;
  If frmDefFieldsAdd.ShowModal = mrOk Then
  Begin
    //  
    TDefFields.Append;
    TDefFields.FieldByName('parent').AsInteger := TTemplate.FieldByName('rec_no').AsInteger;

    TDefFields.FieldByName('name').AsString := frmDefFieldsAdd.Name.Text;
    TDefFields.FieldByName('kind').AsString := 'TEXT';
    TDefFields.FieldByName('description').AsString := frmDefFieldsAdd.Description.Text;
    TDefFields.FieldByName('defaultvalues').AsString := frmDefFieldsAdd.Values.Text;
    TDefFields.FieldByName('defaultvalue').AsString := frmDefFieldsAdd.Default.Text;
    TDefFields.Post;
  End;
End;

Procedure TfrmTemplates.actFieldsAddUpdate(Sender: TObject);
Begin
  actFieldsAdd.Enabled := (frmMain.usergroup.Length > 1);
End;

Procedure TfrmTemplates.actFieldsDeleteExecute(Sender: TObject);
Begin
  If frmEffectDelete.ShowModal = mrOk Then
  Begin
    TDefFields.Delete;
  End;
End;

Procedure TfrmTemplates.actFieldsDeleteUpdate(Sender: TObject);
Begin
  actFieldsDelete.Enabled := TDefFields.Active and (TDefFields.RecordCount > 0) and (TDefFields.RecNo > 0) and
    (frmMain.usergroup.Length > 1);
End;

Procedure TfrmTemplates.actFieldsEditExecute(Sender: TObject);
Begin
  frmDefFieldsAdd.Clear;

  frmDefFieldsAdd.Name.Text := TDefFields.FieldByName('name').AsString;

  frmDefFieldsAdd.Description.Text := TDefFields.FieldByName('description').AsString;
  frmDefFieldsAdd.Values.Text := TDefFields.FieldByName('defaultvalues').AsString;
  frmDefFieldsAdd.Default.Text := TDefFields.FieldByName('defaultvalue').AsString;

  If frmDefFieldsAdd.ShowModal = mrOk Then
  Begin
    //  
    TDefFields.Edit;
    TDefFields.FieldByName('parent').AsInteger := TTemplate.FieldByName('rec_no').AsInteger;

    TDefFields.FieldByName('name').AsString := frmDefFieldsAdd.Name.Text;
    TDefFields.FieldByName('kind').AsString := 'TEXT';
    TDefFields.FieldByName('description').AsString := frmDefFieldsAdd.Description.Text;
    TDefFields.FieldByName('defaultvalues').AsString := frmDefFieldsAdd.Values.Text;
    TDefFields.FieldByName('defaultvalue').AsString := frmDefFieldsAdd.Default.Text;
    TDefFields.Post;
  End;

End;

Procedure TfrmTemplates.actFieldsEditUpdate(Sender: TObject);
Begin
  actFieldsEdit.Enabled := TDefFields.Active and (TDefFields.RecordCount > 0) and (TDefFields.RecNo > 0) and
    (frmMain.usergroup.Length > 1);
End;

Procedure TfrmTemplates.actTemplateAddExecute(Sender: TObject);
Var
  Description: String;
  parent_no: integer;
Begin
  If TTemplate.RecNo > 0 Then
    parent_no := TTemplate.FieldByName('parent').AsInteger
  Else
    parent_no := 0;
  If parent_no < 0 Then
    parent_no := 0;
  If frmTemplateAdd.ShowModal = mrOk Then
  Begin
    Description := frmTemplateAdd.Description.Text;
    TTemplate.Append;
    TTemplate.FieldByName('name').AsString := Description;
    TTemplate.FieldByName('parent').AsInteger := parent_no;
    TTemplate.Post;
    TTemplate.Refresh;
  End;
End;

procedure TfrmTemplates.actTemplateAddUpdate(Sender: TObject);
begin
  actTemplateAdd.Enabled := (frmMain.usergroup.Length > 1);
end;

Procedure TfrmTemplates.actTemplateDeleteExecute(Sender: TObject);
Begin
  If frmEffectDelete.ShowModal = mrOk Then
  Begin
    CatalogTree.DeleteNode(CatalogTree.Selected);
  End;
End;

Procedure TfrmTemplates.actTemplateDeleteUpdate(Sender: TObject);
Begin
  actTemplateDelete.Enabled := (TTemplate.FieldByName('rec_no').AsInteger > 0) and (frmMain.usergroup.Length > 1);
End;

Procedure TfrmTemplates.actTemplateCopyExecute(Sender: TObject);
Begin
  If TTemplate.FieldByName('rec_no').AsInteger > 0 Then
  Begin
    frmTemplateCopy.src_id := TTemplate.FieldByName('rec_no').AsInteger;
    frmTemplateCopy.ShowModal;
  End;
End;

Procedure TfrmTemplates.actTemplateCopyUpdate(Sender: TObject);
Begin
  actTemplateCopy.Enabled := (TTemplate.FieldByName('rec_no').AsInteger > 0) and (frmMain.usergroup.Length > 1);
End;

Procedure TfrmTemplates.actTemplateEditExecute(Sender: TObject);
Begin
  frmEffectEdit.Description.Text := TTemplate.FieldByName('name').AsString;
  If frmEffectEdit.ShowModal = mrOk Then
  Begin
    TTemplate.Edit;
    TTemplate.FieldByName('name').AsString := frmEffectEdit.Description.Text;
    TTemplate.Post;
  End;
End;

Procedure TfrmTemplates.actTemplateEditUpdate(Sender: TObject);
Begin
  actTemplateEdit.Enabled := (TTemplate.FieldByName('rec_no').AsInteger > 0) and (frmMain.usergroup.Length > 1);
End;

Procedure TfrmTemplates.actTemplateSaveExecute(Sender: TObject);
Var
  i, z: integer;
  fn: String;
  f_exp: TIniFile;
  f_name: String;
  f_str: TstringStream;
Begin
  If SaveDialog.Execute Then
  Begin
    fn := SaveDialog.FileName;
    f_exp := TIniFile.Create(fn);
  End;
End;

Procedure TfrmTemplates.CatalogTreeChange(Sender: TObject; Node: TTreeNode);
Var
  rec_no: integer;
Begin
  rec_no := TTemplate.FieldByName('rec_no').AsInteger;
  TDefFields.Active := false;
  TDefFields.SQL.Text := 'SELECT * FROM `uni_templatesfields` WHERE `parent`=' + inttostr(rec_no) + ';';
  caption:=TDefFields.SQL.Text;
  Try
    TDefFields.Active := true;
  Except
  End;
End;

Procedure TfrmTemplates.CatalogTreeDblClick(Sender: TObject);
Begin
  If actTemplateEdit.Enabled Then
    actTemplateEdit.Execute;
End;

Procedure TfrmTemplates.DefFieldsDblClick(Sender: TObject);
Begin
  actFieldsEdit.Execute;
End;

Procedure TfrmTemplates.ExportToExcel;
Begin
  If TTemplate.Active Then
  Begin
    If SaveDialog.Execute() Then
      Try
        { JvDBGridExcelExport1.FileName := SaveDialog.FileName;
          JvDBGridExcelExport1.ExportGrid; }
      Except
      End;
  End
  Else
    showmessage('   ');
End;

Procedure TfrmTemplates.ReTranslate;
Var
  i: integer;
Begin
  Caption := frmLanguageSelect.TranslateString('frmTemplates', '');
  frmLanguageSelect.TranslateForm(self);

  { // Tables
    for i := 0 to CatalogUnits.Columns.Count - 1 do
    CatalogUnits.Columns[i].Title.Caption := frmLanguageSelect.TranslateString
    ('CatalogUnits_' + inttostr(i), CatalogUnits.Columns[i].Title.Caption);
  }
End;

End.
