unit TableSets;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, JvExStdCtrls, JvButton,
  JvCtrls, JvFooter, Vcl.ExtCtrls, JvExExtCtrls, JvExtComponent, Vcl.CheckLst,
  Vcl.Grids, Vcl.DBGrids, JvExDBGrids, JvDBGrid, Vcl.Mask, JvExMask, JvSpin;

type
  TfrmTableSets = class(TForm)
    ColumnsList: TCheckListBox;
    TitleWidth: TJvSpinEdit;
    : TLabel;
    lblTitleName: TLabel;
    TitleName: TEdit;
    procedure FormShow(Sender: TObject);
    procedure ColumnsListClickCheck(Sender: TObject);
    procedure ColumnsListClick(Sender: TObject);
    procedure TitleNameKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure TitleWidthChange(Sender: TObject);
  private
  var
    ii: integer;
    { Private declarations }
  public
    WhereTable: TJvDBGrid;
    { Public declarations }
  end;

var
  frmTableSets: TfrmTableSets;

implementation

{$R *.dfm}

procedure TfrmTableSets.ColumnsListClick(Sender: TObject);
begin
  ii := ColumnsList.ItemIndex;
  TitleName.Text := WhereTable.Columns[ii].Title.Caption;
  TitleWidth.Value := WhereTable.Columns[ii].Width;
end;

procedure TfrmTableSets.ColumnsListClickCheck(Sender: TObject);
begin
  ii := ColumnsList.ItemIndex;
  WhereTable.Columns[ii].Visible := ColumnsList.Checked[ii];
end;

procedure TfrmTableSets.FormShow(Sender: TObject);
var
  i: integer;
begin
  ColumnsList.Clear;
  if WhereTable <> nil then
  begin
    for i := 0 to WhereTable.Columns.Count - 1 do
    begin
      ColumnsList.Items.Add(WhereTable.Columns[i].Title.Caption);
      ColumnsList.Checked[i] := WhereTable.Columns[i].Visible;
    end;
  end;
  try
    ColumnsList.ItemIndex := 0;
    ColumnsList.OnClick(self);
  except
  end;
end;

procedure TfrmTableSets.TitleNameKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  ii := ColumnsList.ItemIndex;
  WhereTable.Columns[ii].Title.Caption := TitleName.Text;
  ColumnsList.Items[ii] := TitleName.Text;
end;

procedure TfrmTableSets.TitleWidthChange(Sender: TObject);
begin
  ii := ColumnsList.ItemIndex;
  WhereTable.Columns[ii].Width := TitleWidth.AsInteger;
end;

end.
