Unit SystemsOptEdit;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, JvExStdCtrls, JvButton, JvCtrls, JvFooter, ExtCtrls,
  JvExExtCtrls, JvExtComponent, Grids, DBGrids, JvExDBGrids, JvDBGrid, DB,
    JvMemoryDataset, FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client;

Type
  TfrmSystemsOptEdit = Class(TForm)
    JvFooter1: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    btnOk: TJvFooterBtn;
    Panel1: TPanel;
    Panel2: TPanel;
    LabelInfo: TLabel;
    TTemplate: TFDTable;
    DSData: TDataSource;
    TemplateGrid: TJvDBGrid;
    TData: TJvMemoryData;
    TDataname: TStringField;
    TDatatmpvalue: TStringField;
    TDataautofill: TStringField;
    UseAutoCalc: TCheckBox;
    UseReset: TCheckBox;
    Procedure FormShow(Sender: TObject);
    Procedure FormClose(Sender: TObject; Var Action: TCloseAction);
    Procedure FormCreate(Sender: TObject);
    Procedure FormDestroy(Sender: TObject);
    Procedure btnOkClick(Sender: TObject);
  Private
    { Private declarations }
  Public
    Kind: String;
    Opts: TStrings;

    { Public declarations }
  End;

Var
  frmSystemsOptEdit: TfrmSystemsOptEdit;

Implementation

{$R *.dfm}

Procedure TfrmSystemsOptEdit.FormClose(Sender: TObject;
  Var Action: TCloseAction);
Begin
  If TTemplate.Active Then
    TTemplate.Close;
End;

Procedure TfrmSystemsOptEdit.FormCreate(Sender: TObject);
Begin
  Opts := TStringList.Create;
End;

Procedure TfrmSystemsOptEdit.FormDestroy(Sender: TObject);
Begin
  Opts.Free;
End;

Procedure TfrmSystemsOptEdit.FormShow(Sender: TObject);
Var
  i: integer;
  s: String;
  f_name, f_temlate_id, f_autofill: string;
Begin
  LabelInfo.Caption := ' : ' + Kind;
  TTemplate.Filter := 'kind=' + QuotedStr(Kind);
  TTemplate.IndexFieldNames := 'name';
  TTemplate.Filtered := true;
  TTemplate.Active := true;
  TData.Filtered := false;
  TData.DisableControls;
  TData.Active := true;

  TData.EmptyTable;
  TTemplate.First;
  While Not TTemplate.Eof Do
  Begin
    f_name := TTemplate.FieldByName('name').AsString;
    f_temlate_id := TTemplate.FieldByName('temlate_id').AsString;
    f_autofill := TTemplate.FieldByName('autofill').AsString;
    If ((f_name <> '') And (f_temlate_id <> '')) Then
    Begin
      //   
      TData.Append;
      TData.FieldByName('name').AsString := f_name;
      TData.FieldByName('tmpvalue').AsString := '';
      TData.FieldByName('autofill').AsString := f_autofill;
      For i := 0 To Opts.Count - 1 Do
      Begin
        s := TData.FieldByName('name').AsString;
        If pos(s + '=', Opts[i]) > 0 Then
        Begin
          TData.FieldByName('tmpvalue').AsString :=
            copy(Opts[i], length(s) + 2);
        End;
      End;
      TData.Post;
    End;
    TTemplate.Next;
  End;
  TData.First;
  TData.EnableControls;
End;

Procedure TfrmSystemsOptEdit.btnOkClick(Sender: TObject);
Var
  vn, vv: String;
Begin
  // save opts
  Opts.Clear;
  TData.DisableControls;
  TData.First;
  While Not TData.Eof Do
  Begin
    vn := TData.FieldByName('name').AsString;
    vv := TData.FieldByName('tmpvalue').AsString;
    Opts.Add(vn + '=' + vv);
    TData.Next;
  End;
  // Memo1.Lines.Text:=Opts.Text;
  TTemplate.Active := false;
  TData.EnableControls;
  ModalResult := mrOk;
End;

End.
