Unit SystemsImport;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, JvExStdCtrls, JvButton, JvCtrls, JvFooter, ExtCtrls,
  JvExExtCtrls, JvExtComponent, JvExControls, JvSpeedButton, Grids, DBGrids,
  JvExDBGrids, JvDBGrid, DB,   ActnList, Menus,
  JvComponentBase, JvFormPlacement, System.Actions, FireDAC.Stan.Intf,
  FireDAC.Stan.Option, FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS,
  FireDAC.Phys.Intf, FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt,
  FireDAC.Comp.Client, FireDAC.Comp.DataSet;

Type
  TfrmSystemsImport = Class(TForm)
    JvFooter1: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    JvFooterBtn2: TJvFooterBtn;
    PanelTop: TPanel;
    optAddToOld: TRadioButton;
    optSaveWithName: TRadioButton;
    editNewName: TEdit;
    PanelCenter: TPanel;
    Panel6: TPanel;
    Label12: TLabel;
    PanelBottom: TPanel;
    gridSystemsDetail: TJvDBGrid;
    Panel3: TPanel;
    Label1: TLabel;
    gridSystems: TJvDBGrid;
    pmSystems: TPopupMenu;
    N1: TMenuItem;
    pmHardware: TPopupMenu;
    actHardwareRemove1: TMenuItem;
    MyQuery1: TFDQuery;
    Actions: TActionList;
    actOk: TAction;
    actHardwareRemove: TAction;
    actSystemDelete: TAction;
    TSystems: TFDTable;
    DSTSystems: TDataSource;
    DSSystemsDetail: TDataSource;
    LabelCurrentSystem: TLabel;
    FormStorage: TJvFormStorage;
    N2: TMenuItem;
    N3: TMenuItem;
    TSystemsDetail: TFDQuery;
    Procedure TSystemsAfterScroll(DataSet: TDataSet);
    Procedure optSaveWithNameClick(Sender: TObject);
    Procedure FormShow(Sender: TObject);
    Procedure actHardwareRemoveExecute(Sender: TObject);
    Procedure actHardwareRemoveUpdate(Sender: TObject);
    Procedure actSystemDeleteUpdate(Sender: TObject);
    Procedure actSystemDeleteExecute(Sender: TObject);
    Procedure actOkUpdate(Sender: TObject);
    Procedure actOkExecute(Sender: TObject);
    Procedure gridSystemsDetailDrawColumnCell(Sender: TObject;
      Const Rect: TRect; DataCol: Integer; Column: TColumn;
      State: TGridDrawState);
    Procedure FormActivate(Sender: TObject);
    procedure N2Click(Sender: TObject);
    procedure editNewNameChange(Sender: TObject);
  Private
    Procedure CopyHardware;
    procedure NameChange;
    { Private declarations }
  Public
    SystemsList: TStrings;
    Source_system_no: Integer;
    DST_project_no: Integer;
    DST_system_no: Integer;
    { Public declarations }
  End;

Var
  frmSystemsImport: TfrmSystemsImport;

Implementation

Uses Main, PriceUpdate;

{$R *.dfm}

Procedure TfrmSystemsImport.actHardwareRemoveExecute(Sender: TObject);
Begin
  TSystemsDetail.Delete;
End;

Procedure TfrmSystemsImport.actHardwareRemoveUpdate(Sender: TObject);
Begin
  actHardwareRemove.Enabled := (TSystemsDetail.RecordCount > 0);
End;

Procedure TfrmSystemsImport.actOkExecute(Sender: TObject);
Var
  SystemName: String;
  flds: String;
Begin
  Source_system_no := TSystems.FieldByName('rec_no').AsInteger;
  If Source_system_no > 0 Then
    If optSaveWithName.Checked And (editNewName.Text <> '') Then
    Begin
      //          
      SystemName := editNewName.Text;
      flds := 'construction,kind,voltage,current,protection,entries,voltage_secondary,strength';

      MyQuery1.SQL.Text :=
        'INSERT INTO `uni_projectsystems` (`project_no`,`name`,' + flds +
        ') SELECT ' + IntToStr(DST_project_no) + ',' + QuotedStr(SystemName) +
        ',' + flds + ' FROM `uni_systems` WHERE `rec_no`=' +
        IntToStr(TSystems.FieldByName('rec_no').AsInteger) + ';';
      MyQuery1.Execute;

      MyQuery1.SQL.Text :=
        'SELECT `rec_no` FROM `uni_projectsystems` WHERE `project_no`=' +
        IntToStr(DST_project_no) + ' AND `name`=' + QuotedStr(SystemName) +
        ' ORDER BY `orderby` DESC LIMIT 1';
      MyQuery1.Active := true;
      If MyQuery1.RecordCount = 1 Then
      Begin
        DST_system_no := MyQuery1.FieldByName('rec_no').AsInteger;
        //      (Source_system_no)
        CopyHardware;
        TSystems.Active := false;
        TSystemsDetail.Active := false;
        ModalResult := mrOk;
      End;
    End;
  If Not optSaveWithName.Checked And (DST_system_no > 0) Then
  Begin
    //      
    CopyHardware;
    TSystems.Active := false;
    TSystemsDetail.Active := false;
    ModalResult := mrOk;
  End;
End;

Procedure TfrmSystemsImport.actOkUpdate(Sender: TObject);
Begin
  if editNewName.Color = clRed then
  begin
    actOk.Enabled := false;
  end
  else If optSaveWithName.Checked Then
  Begin
    actOk.Enabled := (Length(editNewName.Text) > 0)
  End
  Else
  Begin
    actOk.Enabled := true;
  End;
End;

Procedure TfrmSystemsImport.actSystemDeleteExecute(Sender: TObject);
Var
  system_no: Integer;
Begin
  system_no := TSystems.FieldByName('rec_no').AsInteger;
  If (system_no > 0) Then
  Begin
    TSystems.Delete;
    MyQuery1.SQL.Text := 'DELETE FROM `uni_systemsdetail` WHERE `system_no`=' +
      IntToStr(system_no) + ';';
    MyQuery1.Execute;
  End;
End;

Procedure TfrmSystemsImport.actSystemDeleteUpdate(Sender: TObject);
Begin
  actSystemDelete.Enabled := (TSystems.RecordCount > 0);
End;

Procedure TfrmSystemsImport.FormActivate(Sender: TObject);
Begin
  If editNewName.Enabled Then
    editNewName.SetFocus;
End;

Procedure TfrmSystemsImport.FormShow(Sender: TObject);
Begin
  optSaveWithNameClick(self);
  TSystems.Active := true;
  optAddToOld.Enabled := (DST_system_no > 0);
  NameChange;
  // TSystemsDetail.Active := true;
End;

Procedure TfrmSystemsImport.gridSystemsDetailDrawColumnCell(Sender: TObject;
  Const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
Begin
  If Column.FieldName = 'file' Then
    With gridSystemsDetail.Canvas Do
    Begin
      Brush.Color := clWhite;
      FillRect(Rect);
      If TSystemsDetail.FieldByName('file').AsString <> '' Then
      Begin
        gridSystemsDetail.Canvas.Brush.Color := clGrayText;
        Draw(round((Rect.Left + Rect.Right - frmMain.IconAttachment.Width) / 2),
          Rect.Top, frmMain.IconAttachment);
      End;
    End
  Else
    gridSystemsDetail.DefaultDrawColumnCell(Rect, DataCol, Column, State);
End;

procedure TfrmSystemsImport.N2Click(Sender: TObject);
var
  SQL: string;
begin
  //     
  if frmPriceUpdate.ShowModal = mrOk then
  begin
    TSystemsDetail.DisableControls;
    try
      SQL := 'UPDATE uni_systemsdetail SET uni_systemsdetail.price=' +
        '(SELECT price FROM uni_hardware WHERE uni_hardware.article=uni_systemsdetail.article LIMIT 1);';
      // Clipboard.SetTextBuf(pchar(SQL));
      MyQuery1.SQL.Text := SQL;
      MyQuery1.Execute;
    except
    end;
    TSystemsDetail.Refresh;
    TSystemsDetail.EnableControls;
  end;
  // SumRecalc;
end;

Procedure TfrmSystemsImport.optSaveWithNameClick(Sender: TObject);
Begin
  If optSaveWithName.Checked Then
  Begin
    editNewName.Enabled := true;
    editNewName.Color := clWindow;
    NameChange;
  End
  Else
  Begin
    editNewName.Enabled := false;
    editNewName.Color := clBtnFace;
  End;
End;

Procedure TfrmSystemsImport.TSystemsAfterScroll(DataSet: TDataSet);
Var
  cur_no: Integer;
Begin
  cur_no := TSystems.FieldByName('rec_no').AsInteger;
  If cur_no > 0 Then
  Begin
    TSystemsDetail.SQL.Text :=
      'SELECT * FROM `uni_systemsdetail` WHERE system_no=' +
      IntToStr(cur_no) + ' ORDER BY `orderby`;';
    TSystemsDetail.Active := true;
  End;
  gridSystemsDetail.Enabled := (TSystemsDetail.RecordCount > 0);
End;

Procedure TfrmSystemsImport.CopyHardware;
Var
  SQL, flds: String;
Begin
  //
  // ShowMessage(': ' + IntToStr(Source_system_no) + ' ' +    IntToStr(DST_system_no));
  try
    flds := 'name,kinddesc,article,comment,developer,file,price,valuta,count,modules';
    SQL := 'INSERT INTO uni_projecthardware (project_no,system_no,' + flds +
      ') ' + 'SELECT ' + IntToStr(DST_project_no) + ',' +
      IntToStr(DST_system_no) + ',' + flds +
      ' FROM `uni_systemsdetail` WHERE `system_no`=' +
      IntToStr(Source_system_no) + ' ORDER BY `rec_no`;';
    MyQuery1.SQL.Text := SQL;
    MyQuery1.Execute;
    SQL := 'UPDATE uni_projecthardware SET `orderby`=`rec_no` WHERE `project_no`='
      + IntToStr(DST_project_no) + ' AND `system_no`=' +
      IntToStr(DST_system_no) + ';';
    MyQuery1.SQL.Text := SQL;
    MyQuery1.Execute;
  except
    ShowMessage(' frmSystemsImport.CopyHardware');
  end;
End;

procedure TfrmSystemsImport.editNewNameChange(Sender: TObject);
begin
  NameChange;
end;

procedure TfrmSystemsImport.NameChange;
var
  i: Integer;
  fnd: boolean;
begin
  fnd := false;
  for i := 0 to SystemsList.Count - 1 do
  begin
    if Trim(editNewName.Text) = (SystemsList[i]) then
      fnd := true;
  end;
  if fnd or (Trim(editNewName.Text) = '') then
  begin
    editNewName.Color := clRed;
  end
  else
  begin
    editNewName.Color := clWindow;
  end;
end;

End.
