Unit SystemsExport;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, DBGrids, JvExDBGrids, JvDBGrid, StdCtrls, JvExStdCtrls,
  JvButton, JvCtrls, JvFooter, ExtCtrls, JvExExtCtrls, JvExtComponent, DB,
    ActnList, Project, Menus, JvComponentBase,
  JvFormPlacement, System.Actions, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf,
  FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.Client,
  FireDAC.Comp.DataSet;

Type
  TfrmSystemsExport = Class(TForm)
    JvFooter1: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    JvFooterBtn2: TJvFooterBtn;
    TSystems: TFDTable;
    DSSystemsDetail: TDataSource;
    PanelCenter: TPanel;
    gridSystems: TJvDBGrid;
    Panel6: TPanel;
    Label12: TLabel;
    PanelBottom: TPanel;
    gridSystemsDetail: TJvDBGrid;
    Panel3: TPanel;
    Label1: TLabel;
    PanelTop: TPanel;
    optAddToOld: TRadioButton;
    optSaveWithName: TRadioButton;
    editNewName: TEdit;
    DSTSystems: TDataSource;
    TSystemsDetail: TFDTable;
    Actions: TActionList;
    actOk: TAction;
    MyQuery1: TFDQuery;
    pmSystems: TPopupMenu;
    pmHardware: TPopupMenu;
    actHardwareRemove: TAction;
    actHardwareRemove1: TMenuItem;
    actSystemDelete: TAction;
    N1: TMenuItem;
    FormStorage: TJvFormStorage;
    Procedure optSaveWithNameClick(Sender: TObject);
    Procedure FormShow(Sender: TObject);
    Procedure actOkUpdate(Sender: TObject);
    Procedure actOkExecute(Sender: TObject);
    Procedure TSystemsAfterScroll(DataSet: TDataSet);
    Procedure actHardwareRemoveUpdate(Sender: TObject);
    Procedure actHardwareRemoveExecute(Sender: TObject);
    Procedure actSystemDeleteUpdate(Sender: TObject);
    Procedure actSystemDeleteExecute(Sender: TObject);
    Procedure gridSystemsDetailDrawColumnCell(Sender: TObject;
      Const Rect: TRect; DataCol: Integer; Column: TColumn;
      State: TGridDrawState);
    Procedure FormActivate(Sender: TObject);
  Private
    Procedure CopyHardware;
    { Private declarations }
  Public
    Source_system_no: Integer;
    DST_system_no: Integer;
    { Public declarations }
  End;

Var
  frmSystemsExport: TfrmSystemsExport;

Implementation

Uses Main;

{$R *.dfm}

Procedure TfrmSystemsExport.actOkUpdate(Sender: TObject);
Begin
  If optSaveWithName.Checked Then
  Begin
    actOk.Enabled := (Length(editNewName.Text) > 0)
  End
  Else
  Begin
    actOk.Enabled := true;
  End;
End;

Procedure TfrmSystemsExport.actSystemDeleteExecute(Sender: TObject);
Var
  system_no: Integer;
Begin
  system_no := TSystems.FieldByName('rec_no').AsInteger;
  If (system_no > 0) Then
  Begin
    TSystems.Delete;
    MyQuery1.SQL.Text := 'DELETE FROM `uni_systemsdetail` WHERE `system_no`=' +
      IntToStr(system_no) + ';';
    MyQuery1.Execute;
  End;
End;

Procedure TfrmSystemsExport.actSystemDeleteUpdate(Sender: TObject);
Begin
  actSystemDelete.Enabled := (TSystems.RecordCount > 0);
End;

Procedure TfrmSystemsExport.FormActivate(Sender: TObject);
Begin
  If editNewName.Enabled Then
    editNewName.SetFocus;
End;

Procedure TfrmSystemsExport.FormShow(Sender: TObject);
Begin
  optSaveWithNameClick(self);
  TSystems.Active := true;
  optAddToOld.Enabled := (TSystems.RecordCount > 0);
End;

Procedure TfrmSystemsExport.gridSystemsDetailDrawColumnCell(Sender: TObject;
  Const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
Begin
  If Column.FieldName = 'file' Then
    With gridSystemsDetail.Canvas Do
    Begin
      Brush.Color := clWhite;
      FillRect(Rect);
      If TSystemsDetail.FieldByName('file').AsString <> '' Then
      Begin
        gridSystemsDetail.Canvas.Brush.Color := clGrayText;
        Draw(round((Rect.Left + Rect.Right - frmMain.IconAttachment.Width) / 2),
          Rect.Top, frmMain.IconAttachment);
      End;
    End
  Else
    gridSystemsDetail.DefaultDrawColumnCell(Rect, DataCol, Column, State);
End;

Procedure TfrmSystemsExport.optSaveWithNameClick(Sender: TObject);
Begin
  If optSaveWithName.Checked Then
  Begin
    editNewName.Enabled := true;
    editNewName.Color := clWindow;
    gridSystems.Enabled := false;
    gridSystemsDetail.Enabled := false;
    gridSystems.Color := clBtnFace;
    gridSystemsDetail.Color := clBtnFace;
  End
  Else
  Begin
    editNewName.Enabled := false;
    editNewName.Color := clBtnFace;
    gridSystems.Enabled := true;
    gridSystemsDetail.Enabled := true;
    gridSystems.Color := clWindow;
    gridSystemsDetail.Color := clWindow;
  End;
End;

Procedure TfrmSystemsExport.TSystemsAfterScroll(DataSet: TDataSet);
Var
  cur_no: Integer;
Begin
  cur_no := TSystems.FieldByName('rec_no').AsInteger;
  If cur_no > 0 Then
  Begin
    TSystemsDetail.SQL.Text :=
      'SELECT * FROM `uni_systemsdetail` WHERE system_no=' + IntToStr(cur_no) +
      ' ORDER BY `rec_no`;';
    TSystemsDetail.Active := true;
  End;
  gridSystemsDetail.Enabled := (TSystemsDetail.RecordCount > 0);
End;

Procedure TfrmSystemsExport.actHardwareRemoveExecute(Sender: TObject);
Begin
  TSystemsDetail.Delete;
End;

Procedure TfrmSystemsExport.actHardwareRemoveUpdate(Sender: TObject);
Begin
  actHardwareRemove.Enabled := (TSystemsDetail.RecordCount > 0);
End;

Procedure TfrmSystemsExport.actOkExecute(Sender: TObject);
Var
  SystemName: String;
  SQL: String;
Begin
  DST_system_no := 0;
  //   
  If optSaveWithName.Checked Then
  Begin
    SystemName := editNewName.Text;
    If SystemName <> '' Then
    Begin
      If TSystems.Locate('name', SystemName, []) Then
        ShowMessage('  ')
      Else
      Begin
        //  ,  

        TSystems.Append;
        TSystems.FieldByName('name').AsString := SystemName;
        //    
        Try
          SQL := 'SELECT * FROM `uni_projecthardware` WHERE `system_no`=' +
            IntToStr(Source_system_no) + ' ORDER BY `orderby`;';
          MyQuery1.SQL.Text := SQL;
          MyQuery1.Active := true;
          If MyQuery1.RecordCount = 1 Then
          Begin
            TSystems.FieldByName('construction').AsString :=
              MyQuery1.FieldByName('construction').AsString;
            TSystems.FieldByName('kind').AsString :=
              MyQuery1.FieldByName('kind').AsString;
            TSystems.FieldByName('voltage').AsString :=
              MyQuery1.FieldByName('voltage').AsString;
            TSystems.FieldByName('current').AsString :=
              MyQuery1.FieldByName('current').AsString;
            TSystems.FieldByName('protection').AsString :=
              MyQuery1.FieldByName('protection').AsString;
            TSystems.FieldByName('entries').AsString :=
              MyQuery1.FieldByName('entries').AsString;
            TSystems.FieldByName('voltage_secondary').AsString :=
              MyQuery1.FieldByName('voltage_secondary').AsString;
            TSystems.FieldByName('strength').AsString :=
              MyQuery1.FieldByName('strength').AsString;
            TSystems.FieldByName('opts').AsString :=
              MyQuery1.FieldByName('opts').AsString;
          End;
        Except
        End;
        TSystems.Post;
        TSystems.Refresh;
        Application.ProcessMessages;
        If TSystems.Locate('name', SystemName, []) Then
        Begin
          DST_system_no := TSystems.FieldByName('rec_no').AsInteger;
          //      (Source_system_no)
          CopyHardware;
          IntToStr(DST_system_no);
        End;
        ModalResult := mrOk;
      End;
    End;
  End
  Else
  Begin
    If TSystems.RecNo > 0 Then
    Begin
      DST_system_no := TSystems.FieldByName('rec_no').AsInteger;
      //      
      CopyHardware;
      ModalResult := mrOk;
    End;
  End;
End;

Procedure TfrmSystemsExport.CopyHardware;
Var
  SQL, flds: String;
Begin
  //
  // ShowMessage(': ' + IntToStr(Source_system_no) + ' ' +    IntToStr(DST_system_no));
  flds := 'name,kinddesc,article,comment,developer,file,price,valuta,count,modules';
  SQL := 'INSERT INTO uni_systemsdetail (system_no,' + flds + ') ' + 'SELECT ' +
    IntToStr(DST_system_no) + ',' + flds +
    ' FROM `uni_projecthardware` WHERE `system_no`=' +
    IntToStr(Source_system_no) + ' ORDER BY `orderby`;';
  MyQuery1.SQL.Text := SQL;
  MyQuery1.Execute;
  TSystemsDetail.Refresh;
End;

End.
