Unit Systems;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, Menus, ActnList, DB, StdCtrls, Grids,
  DBGrids, JvExDBGrids, JvDBGrid, ExtCtrls, JvComponentBase,
  JvFormPlacement, JvMenus, System.Actions, FireDAC.Stan.Intf,
  FireDAC.Stan.Option, FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS,
  FireDAC.Phys.Intf, FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt,
  FireDAC.Comp.Client, FireDAC.Comp.DataSet, Vcl.ToolWin, Vcl.Buttons;

Type
  TfrmSystems = Class(TForm)
    PanelBottom: TPanel;
    gridSystemsDetail: TJvDBGrid;
    Panel3: TPanel;
    Label1: TLabel;
    DSSystemsDetail: TDataSource;
    DSTSystems: TDataSource;
    Actions: TActionList;
    actHardwareRemove: TAction;
    actSystemDelete: TAction;
    MyQuery1: TFDQuery;
    PanelCenter: TPanel;
    gridSystems: TJvDBGrid;
    Panel6: TPanel;
    Label12: TLabel;
    FormStorage: TJvFormStorage;
    actSystemsEdit: TAction;
    pmSystems: TPopupMenu;
    pmHardware: TPopupMenu;
    actPriceUpdate: TAction;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    TSystemsDetail: TFDQuery;
    actHardwareUp: TAction;
    actHardwareDown: TAction;
    ToolBar2: TToolBar;
    btnHardwareUp: TToolButton;
    btnHardwareDown: TToolButton;
    N7: TMenuItem;
    N8: TMenuItem;
    N9: TMenuItem;
    PanelSearch: TPanel;
    Label2: TLabel;
    _Search: TEdit;
    TimerSearchUpdate: TTimer;
    TSystems: TFDQuery;
    N10: TMenuItem;
    miSystemsAdd: TMenuItem;
    N12: TMenuItem;
    N13: TMenuItem;
    miSystemsEdit: TMenuItem;
    miProjectSystemsImport: TMenuItem;
    N17: TMenuItem;
    N5: TMenuItem;
    MicrosoftExcel1: TMenuItem;
    MicrosoftExcel2: TMenuItem;
    N4: TMenuItem;
    TimerDetailsUpdate: TTimer;
    Procedure FormClose(Sender: TObject; Var Action: TCloseAction);
    Procedure FormShow(Sender: TObject);
    Procedure TSystemsAfterScroll(DataSet: TDataSet);
    Procedure actHardwareRemoveExecute(Sender: TObject);
    Procedure actHardwareRemoveUpdate(Sender: TObject);
    Procedure actSystemDeleteUpdate(Sender: TObject);
    Procedure actSystemDeleteExecute(Sender: TObject);
    Procedure gridSystemsDetailDrawColumnCell(Sender: TObject; Const Rect: TRect; DataCol: Integer; Column: TColumn;
      State: TGridDrawState);
    Procedure TSystemsDetailCalcFields(DataSet: TDataSet);
    Procedure actSystemsEditUpdate(Sender: TObject);
    Procedure actSystemsEditExecute(Sender: TObject);
    procedure actPriceUpdateExecute(Sender: TObject);
    procedure _SearchChange(Sender: TObject);
    procedure TimerSearchUpdateTimer(Sender: TObject);
    procedure PanelSearchResize(Sender: TObject);
    procedure actHardwareUpExecute(Sender: TObject);
    procedure actHardwareDownExecute(Sender: TObject);
    procedure actHardwareDownUpdate(Sender: TObject);
    procedure actHardwareUpUpdate(Sender: TObject);
    procedure gridSystemsDblClick(Sender: TObject);
    procedure gridSystemsDetailEnter(Sender: TObject);
    procedure gridSystemsDetailExit(Sender: TObject);
    procedure MouseWheelByOne(Sender: TObject; Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
      var Handled: Boolean);
    procedure FormActivate(Sender: TObject);
    procedure TimerDetailsUpdateTimer(Sender: TObject);
  Private
    Procedure SumRecalc;
    procedure UpdateData;
    procedure UpdateDetails;
    { Private declarations }
  Public
    { Public declarations }
  End;

Var
  frmSystems: TfrmSystems;

Implementation

Uses Main, SystemsAdd, PriceUpdate, Universal, Sequence;

{$R *.dfm}

procedure TfrmSystems.actHardwareDownExecute(Sender: TObject);
var
  tmp1, tmp2: Integer;
begin
  // down hardware
  if TSystemsDetail.RecNo = TSystemsDetail.Recordcount then
    exit;

  // down
  TSystemsDetail.DisableControls;
  Try
    tmp1 := TSystemsDetail.FieldByName('orderby').AsInteger;
    TSystemsDetail.Next;
    tmp2 := TSystemsDetail.FieldByName('orderby').AsInteger;
    if tmp1 = tmp2 then
      Inc(tmp2);
    TSystemsDetail.Edit;
    TSystemsDetail.FieldByName('orderby').AsInteger := tmp1;
    TSystemsDetail.Post;
    TSystemsDetail.Prior;
    TSystemsDetail.Edit;
    TSystemsDetail.FieldByName('orderby').AsInteger := tmp2;
    TSystemsDetail.Post;
  Except
  End;

  TSystemsDetail.Refresh;
  TSystemsDetail.EnableControls;
end;

procedure TfrmSystems.actHardwareUpExecute(Sender: TObject);
var
  tmp1, tmp2: Integer;
begin
  // up hardware
  if TSystemsDetail.RecNo < 2 then
    exit;

  TSystemsDetail.DisableControls;

  Try
    tmp1 := TSystemsDetail.FieldByName('orderby').AsInteger;
    TSystemsDetail.Prior;
    tmp2 := TSystemsDetail.FieldByName('orderby').AsInteger;
    if tmp1 = tmp2 then
      Inc(tmp2);
    TSystemsDetail.Edit;
    TSystemsDetail.FieldByName('orderby').AsInteger := tmp1;
    TSystemsDetail.Post;
    TSystemsDetail.Next;
    TSystemsDetail.Edit;
    TSystemsDetail.FieldByName('orderby').AsInteger := tmp2;
    TSystemsDetail.Post;
  Except
  End;

  TSystemsDetail.Refresh;
  TSystemsDetail.EnableControls;
end;

procedure TfrmSystems.actHardwareUpUpdate(Sender: TObject);
begin
  actHardwareUp.Enabled := (TSystemsDetail.RecNo > 1) and (frmMain.usergroup.length > 1);
  // if not actHardwareUp.Enabled then    TimerRepUp.Enabled := false;
end;

procedure TfrmSystems.actHardwareDownUpdate(Sender: TObject);
begin
  actHardwareDown.Enabled := ((TSystemsDetail.RecNo < TSystemsDetail.Recordcount) And (TSystemsDetail.Recordcount > 1))
    and (frmMain.usergroup.length > 1);
  // if not actHardwareDown.Enabled then    TimerRepDown.Enabled := false;
end;

Procedure TfrmSystems.actHardwareRemoveExecute(Sender: TObject);
Begin
  TSystemsDetail.Delete;
End;

Procedure TfrmSystems.actHardwareRemoveUpdate(Sender: TObject);
Begin
  actHardwareRemove.Enabled := (TSystemsDetail.RecNo > 0) and (frmMain.usergroup.length > 1);
End;

Procedure TfrmSystems.actSystemDeleteExecute(Sender: TObject);
Var
  system_no: Integer;
Begin
  system_no := TSystems.FieldByName('rec_no').AsInteger;
  If (system_no > 0) Then
    Try
      TSystems.Delete;
      MyQuery1.SQL.Text := 'DELETE FROM `uni_systemsdetail` WHERE `system_no`=' + IntToStr(system_no) + ';';
      MyQuery1.Execute;
    Except
    End;
End;

Procedure TfrmSystems.actSystemDeleteUpdate(Sender: TObject);
Begin
  actSystemDelete.Enabled := (TSystems.RecNo > 0) and (frmMain.usergroup.length > 1);
End;

Procedure TfrmSystems.actSystemsEditExecute(Sender: TObject);
Begin
  frmSystemsAdd.Caption := '  ';
  frmSystemsAdd.Clear;
  frmSystemsAdd.editName.Text := TSystems.FieldByName('name').AsString;
  frmSystemsAdd.Counter.value := 1;
  frmSystemsAdd.construction.Text := TSystems.FieldByName('construction').AsString;
  frmSystemsAdd.kind.Text := TSystems.FieldByName('kind').AsString;
  frmSystemsAdd.voltage.Text := TSystems.FieldByName('voltage').AsString;
  frmSystemsAdd.current.Text := TSystems.FieldByName('current').AsString;
  frmSystemsAdd.protection.Text := TSystems.FieldByName('protection').AsString;
  frmSystemsAdd.entries.Text := TSystems.FieldByName('entries').AsString;
  frmSystemsAdd.voltage_secondary.Text := TSystems.FieldByName('voltage_secondary').AsString;
  frmSystemsAdd.strength.Text := TSystems.FieldByName('strength').AsString;

  If frmSystemsAdd.ShowModal = mrOk Then
  Begin
    TSystems.Edit;
    TSystems.FieldByName('name').AsString := frmSystemsAdd.editName.Text;
    TSystems.FieldByName('construction').AsString := frmSystemsAdd.construction.Text;
    TSystems.FieldByName('kind').AsString := frmSystemsAdd.kind.Text;
    TSystems.FieldByName('voltage').AsString := frmSystemsAdd.voltage.Text;
    TSystems.FieldByName('current').AsString := frmSystemsAdd.current.Text;
    TSystems.FieldByName('protection').AsString := frmSystemsAdd.protection.Text;
    TSystems.FieldByName('entries').AsString := frmSystemsAdd.entries.Text;
    TSystems.FieldByName('voltage_secondary').AsString := frmSystemsAdd.voltage_secondary.Text;
    TSystems.FieldByName('strength').AsString := frmSystemsAdd.strength.Text;
    // TSystems.FieldByName('count').AsInteger := frmSystemsAdd.Count.AsInteger;
    TSystems.Post;
  End;
End;

Procedure TfrmSystems.actSystemsEditUpdate(Sender: TObject);
Begin
  actSystemsEdit.Enabled := (TSystems.RecNo > 0) and (frmMain.usergroup.length > 1);
End;

procedure TfrmSystems.FormActivate(Sender: TObject);
begin
  // update view
  TSystemsDetail.Refresh;
end;

Procedure TfrmSystems.FormClose(Sender: TObject; Var Action: TCloseAction);
Begin
  MyQuery1.Active := false;
  Action := caFree;
End;

Procedure TfrmSystems.FormShow(Sender: TObject);
Begin
  if not frmUniversal.DBConnected then
    close;
  try
    TSystems.Active := true;
  except
  end;
End;

procedure TfrmSystems.gridSystemsDblClick(Sender: TObject);
begin
  frmMain.actProjectSystemsImport.Execute;
end;

Procedure TfrmSystems.gridSystemsDetailDrawColumnCell(Sender: TObject; Const Rect: TRect; DataCol: Integer;
  Column: TColumn; State: TGridDrawState);
Begin
  If Column.FieldName = 'file' Then
    With gridSystemsDetail.Canvas Do
    Begin
      Brush.Color := clWhite;
      FillRect(Rect);
      If TSystemsDetail.FieldByName('file').AsString <> '' Then
      Begin
        gridSystemsDetail.Canvas.Brush.Color := clGrayText;
        Draw(round((Rect.Left + Rect.Right - frmMain.IconAttachment.Width) / 2), Rect.Top, frmMain.IconAttachment);
      End;
    End
  Else
    gridSystemsDetail.DefaultDrawColumnCell(Rect, DataCol, Column, State);
End;

procedure TfrmSystems.gridSystemsDetailEnter(Sender: TObject);
begin
  frmSequence.TQuerySRC.SQL.Text := 'SELECT rec_no,name,tag,orderby FROM `uni_systemsdetail` WHERE `system_no`=' +
    IntToStr(frmMain.current_systemno) + ' ORDER BY `orderby`;'
end;

procedure TfrmSystems.gridSystemsDetailExit(Sender: TObject);
begin
  frmSequence.TQuerySRC.SQL.Text := '';
end;

procedure TfrmSystems.MouseWheelByOne(Sender: TObject; Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
  var Handled: Boolean);
var
  Direction: Shortint;
begin
  Direction := 1;
  if WheelDelta = 0 then
    exit
  else if WheelDelta > 0 then
    Direction := -1;

  Handled := true;
  with TJvDBGrid(Sender) do
  begin
    if Assigned(DataSource) and Assigned(DataSource.DataSet) then
      DataSource.DataSet.MoveBy(Direction);
    Invalidate;
  end;
end;

procedure TfrmSystems.PanelSearchResize(Sender: TObject);
Var
  ns: Integer;
Begin
  ns := 100;
  If PanelSearch.Width > 180 Then
    ns := (PanelSearch.Width - 120);
  _Search.Width := ns;
end;

procedure TfrmSystems.TimerDetailsUpdateTimer(Sender: TObject);
begin
  TimerDetailsUpdate.Enabled:=false;
  UpdateDetails;
end;

procedure TfrmSystems.TimerSearchUpdateTimer(Sender: TObject);
begin
  TimerSearchUpdate.Enabled := false;
  UpdateData;
end;

Procedure TfrmSystems.TSystemsAfterScroll(DataSet: TDataSet);
Begin
  TimerDetailsUpdate.Enabled := false;
  TimerDetailsUpdate.Enabled := true;
End;

Procedure TfrmSystems.UpdateDetails;
Begin
  frmMain.current_systemno := TSystems.FieldByName('rec_no').AsInteger;
  If frmMain.current_systemno > 0 Then
  Begin
    TSystemsDetail.Active := false;
    TSystemsDetail.SQL.Text := 'SELECT * FROM `uni_systemsdetail` WHERE system_no=' + IntToStr(frmMain.current_systemno)
      + ' ORDER BY `orderby`;';
    TSystemsDetail.Active := true;
    SumRecalc;
  End;
  gridSystemsDetail.Enabled := (TSystemsDetail.Recordcount > 0);
End;

Procedure TfrmSystems.TSystemsDetailCalcFields(DataSet: TDataSet);
Begin
  TSystemsDetail.FieldByName('total').value := TSystemsDetail.FieldByName('price').value *
    TSystemsDetail.FieldByName('count').value;
End;

procedure TfrmSystems._SearchChange(Sender: TObject);
begin
  TimerSearchUpdate.Enabled := true;

end;

Procedure TfrmSystems.SumRecalc;
Var
  FilterSQL: String;
  system_no: Integer;
  cur_no: Integer;
Begin
  cur_no := TSystems.FieldByName('rec_no').AsInteger;
  {
    If (TSystemsDetail.RecordCount > 0) Then
    Try
    MyQuery1.SQL.Text :=
    'SELECT SUM(price*count),SUM(modules*count) FROM `uni_systemsdetail` WHERE `system_no`='
    + IntToStr(cur_no);
    MyQuery1.Active := true;
    StatusBar.Panels[0].Text := ': ' +
    IntToStr(TSystemsDetail.RecordCount);
    StatusBar.Panels[1].Text := ', : ' +
    FloatToStr((MyQuery1.Fields[0].AsFloat));
    StatusBar.Panels[2].Text := ', : ' +
    FloatToStr((MyQuery1.Fields[1].AsInteger));
    Except
    End
    Else
    Begin
    StatusBar.Panels[0].Text := ': 0';
    StatusBar.Panels[1].Text := ', : 0';
    StatusBar.Panels[2].Text := ', : 0 ';
    End;
  }
End;

procedure TfrmSystems.actPriceUpdateExecute(Sender: TObject);
var
  SQL: string;
begin
  //     
  if frmPriceUpdate.ShowModal = mrOk then
  begin
    TSystemsDetail.DisableControls;
    try
      SQL := 'UPDATE uni_systemsdetail SET uni_systemsdetail.price=' +
        '(SELECT price FROM uni_hardware WHERE uni_hardware.article=uni_systemsdetail.article LIMIT 1);';
      // Clipboard.SetTextBuf(pchar(SQL));
      MyQuery1.SQL.Text := SQL;
      MyQuery1.Execute;
    except
    end;
    TSystemsDetail.Refresh;
    TSystemsDetail.EnableControls;
  end;
  SumRecalc;
end;

Procedure TfrmSystems.UpdateData;
Var
  filter: String;
  search_RU, search_EN: string;
  developer_RU, developer_EN: string;
  i: Integer;
  bm: TBookmark;
Begin

  try
    TSystems.DisableControls;
    bm := TSystems.GetBookmark;
  except
  end;
  TSystems.Active := false;

  filter := '';
  If _Search.Text <> '' Then
  Begin
    search_EN := frmMain.TransformToEN(_Search.Text);
    search_RU := frmMain.TransformToRU(_Search.Text);
    filter := '(`name` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `name` LIKE ' + QuotedStr('%' + search_RU + '%');
    filter := filter + ' OR `name` LIKE ' + QuotedStr('%' + search_EN + '%');
    filter := filter + ')';
  End;

  if filter <> '' then
    TSystems.SQL.Text := 'SELECT * FROM `uni_systems` WHERE ' + filter
  else
    TSystems.SQL.Text := 'SELECT * FROM `uni_systems`';

  if gridSystems.SortedField <> '' then
  begin
    TSystems.SQL.Text := TSystems.SQL.Text + ' ORDER BY ' + gridSystems.SortedField;
    If gridSystems.SortMarker = smDown Then
      TSystems.SQL.Text := TSystems.SQL.Text + ' DESC';
  end;

  try
    TSystems.Active := true;
  except
  end;

  //     
  if TSystems.Active and (TSystems.Recordcount > 0) then
    try
      TSystems.GotoBookmark(bm);
      TSystems.FreeBookmark(bm);
    except
    end;
  TSystems.EnableControls;

  // ShowScrollBar(TemplateGrid.Handle, SB_VERT, true);

  { if TSystems.Active then
    StatusBar.Panels[0].Text := ': ' + IntToStr(THardware.RecordCount)
    else
    StatusBar.Panels[0].Text := '';
  }
End;

End.
