unit Sequence;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, JvExStdCtrls, JvButton,
  JvCtrls, JvFooter, JvExExtCtrls, JvExtComponent, Vcl.Grids, Vcl.DBGrids,
  JvExDBGrids, JvDBGrid, Vcl.ExtCtrls, Vcl.ComCtrls, Vcl.ToolWin, Data.DB,
  JvDataSource, JvMemoryDataset, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client,
  Vcl.ActnList, Vcl.Buttons, JvDBUltimGrid, System.Actions;

type
  TfrmSequence = class(TForm)
    Footer: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    btnOk: TJvFooterBtn;
    TSource: TJvMemoryData;
    DSSource: TJvDataSource;
    TQuerySRC: TFDQuery;
    Actions: TActionList;
    actUp: TAction;
    actDown: TAction;
    SrcLabel: TLabel;
    DstLabel: TLabel;
    GridSource: TJvDBGrid;
    GridDest: TJvDBGrid;
    TDest: TJvMemoryData;
    DSDest: TJvDataSource;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    actAdd: TAction;
    actAddAll: TAction;
    actRemove: TAction;
    actRemoveAll: TAction;
    actOk: TAction;
    procedure actUpExecute(Sender: TObject);
    procedure actDownExecute(Sender: TObject);
    procedure actDownUpdate(Sender: TObject);
    procedure actUpUpdate(Sender: TObject);
    procedure GridSourceDblClick(Sender: TObject);
    procedure actAddExecute(Sender: TObject);
    procedure actAddUpdate(Sender: TObject);
    procedure actRemoveUpdate(Sender: TObject);
    procedure actRemoveAllUpdate(Sender: TObject);
    procedure actAddAllUpdate(Sender: TObject);
    procedure actAddAllExecute(Sender: TObject);
    procedure actRemoveAllExecute(Sender: TObject);
    procedure actRemoveExecute(Sender: TObject);
    procedure GridDestDblClick(Sender: TObject);
    procedure actOkUpdate(Sender: TObject);
    procedure actOkExecute(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    function GetFirstSelection(List: TCustomListBox): Integer;
    procedure MoveSelected(List: TCustomListBox; Items: TStrings);
    procedure Init;
    { Private declarations }
  public
    Project_no: Integer;
    { Public declarations }
  end;

var
  frmSequence: TfrmSequence;

implementation

{$R *.dfm}

uses Main, Universal, Systems, Hardware;

var

  SGC: TGridCoord;

procedure TfrmSequence.actAddAllExecute(Sender: TObject);
begin
  GridSource.SelectAll;
  actAdd.Execute;
end;

procedure TfrmSequence.actAddAllUpdate(Sender: TObject);
begin
  actAddAll.Enabled := (TSource.Active and (TSource.RecordCount > 0));
end;

procedure TfrmSequence.actAddExecute(Sender: TObject);
var
  i: Integer;
begin
  if GridSource.SelectedRows.Count > 0 then
  begin
    with GridSource.DataSource.DataSet do
      for i := 0 to GridSource.SelectedRows.Count - 1 do
      begin
        GotoBookmark(TBookmark(pointer(GridSource.SelectedRows.Items[i])));
        TDest.Append;
        TDest.FieldByName('rec_no').AsInteger := FieldByName('rec_no').AsInteger;
        TDest.FieldByName('name').AsString := FieldByName('name').AsString;
        TDest.FieldByName('tag').AsString := FieldByName('tag').AsString;
        TDest.Post;
      end;
    GridSource.SelectedRows.Delete;
  end
  else
  begin
    if (GridSource.SelectedIndex > -1) then
    begin
      TDest.Append;
      TDest.FieldByName('rec_no').AsInteger := TSource.FieldByName('rec_no').AsInteger;
      TDest.FieldByName('name').AsString := TSource.FieldByName('name').AsString;
      TDest.FieldByName('tag').AsString := TSource.FieldByName('tag').AsString;
      TDest.Post;
      TSource.Delete;
    end;
  end;
end;

procedure TfrmSequence.actAddUpdate(Sender: TObject);
begin
  actAdd.Enabled := (TSource.Active and (TSource.RecordCount > 0));
end;

procedure TfrmSequence.actDownExecute(Sender: TObject);
Var
  tmp1, tmp2: Integer;
  name1, name2: string;
  tag1, tag2: string;
Begin
  // down
  TSource.DisableControls;
  Try
    tmp1 := TSource.FieldByName('rec_no').AsInteger;
    name1 := TSource.FieldByName('name').AsString;
    tag1 := TSource.FieldByName('tag').AsString;
    TSource.Next;
    tmp2 := TSource.FieldByName('rec_no').AsInteger;
    name2 := TSource.FieldByName('name').AsString;
    tag2 := TSource.FieldByName('tag').AsString;
    if tmp1 = tmp2 then
      Inc(tmp2);
    TSource.Edit;
    TSource.FieldByName('rec_no').AsInteger := tmp1;
    TSource.FieldByName('name').AsString := name1;
    TSource.FieldByName('tag').AsString := tag1;
    TSource.Post;
    TSource.Prior;
    TSource.Edit;
    TSource.FieldByName('rec_no').AsInteger := tmp2;
    TSource.FieldByName('name').AsString := name2;
    TSource.FieldByName('tag').AsString := tag2;
    TSource.Post;
    TSource.Next;
  Except
  End;
  TSource.Refresh;
  TSource.EnableControls;
end;

procedure TfrmSequence.actDownUpdate(Sender: TObject);
begin
  actDown.Enabled := ((TSource.RecNo < TSource.RecordCount) And (TSource.RecordCount > 1)) and
    (frmMain.usergroup.Length > 1);
end;

procedure TfrmSequence.actOkExecute(Sender: TObject);
var
  rec_no, neworder: Integer;
begin
  //    
  try
    TQuerySRC.First;
    while not TQuerySRC.Eof do
    begin
      rec_no := TQuerySRC.FieldByName('rec_no').AsInteger;
      if TDest.Locate('rec_no', rec_no, []) then
        try
          neworder := TDest.RecNo + 1;
          TQuerySRC.Edit;
          TQuerySRC.FieldByName('orderby').AsInteger := neworder;
          TQuerySRC.Post;
        except
        end;
      TQuerySRC.Next;
    end;
    TQuerySRC.Close;
  except

  end;

  Application.ProcessMessages;

  ModalResult := mrOk;
end;

procedure TfrmSequence.actOkUpdate(Sender: TObject);
begin
  actOk.Enabled := ((TSource.RecordCount = 0) and (TDest.RecordCount > 0) and TQuerySRC.Active);
end;

procedure TfrmSequence.actRemoveAllExecute(Sender: TObject);
begin
  GridDest.SelectAll;
  actRemove.Execute;
end;

procedure TfrmSequence.actRemoveAllUpdate(Sender: TObject);
begin
  actRemoveAll.Enabled := (TDest.Active and (TDest.RecordCount > 0));
end;

procedure TfrmSequence.actRemoveExecute(Sender: TObject);
var
  i: Integer;
begin
  if GridDest.SelectedRows.Count > 0 then
  begin
    with GridDest.DataSource.DataSet do
      for i := 0 to GridDest.SelectedRows.Count - 1 do
      begin
        GotoBookmark(TBookmark(pointer(GridDest.SelectedRows.Items[i])));
        TSource.Append;
        TSource.FieldByName('name').AsString := FieldByName('name').AsString;
        TSource.FieldByName('tag').AsString := FieldByName('tag').AsString;
        TSource.FieldByName('rec_no').AsInteger := FieldByName('rec_no').AsInteger;
        TSource.Post;
      end;
    GridDest.SelectedRows.Delete;
  end
  else
  begin
    if (GridDest.SelectedIndex > -1) then
    begin
      TSource.Append;
      TSource.FieldByName('name').AsString := TDest.FieldByName('name').AsString;
      TSource.FieldByName('tag').AsString := TDest.FieldByName('tag').AsString;
      TSource.FieldByName('rec_no').AsInteger := TDest.FieldByName('rec_no').AsInteger;
      TSource.Post;
      TDest.Delete;
    end;
  end;
end;

procedure TfrmSequence.actRemoveUpdate(Sender: TObject);
begin
  actRemove.Enabled := (TDest.Active and (TDest.RecordCount > 0));
end;

procedure TfrmSequence.actUpExecute(Sender: TObject);
Var
  tmp1, tmp2: Integer;
  name1, name2: string;
  tag1, tag2: string;
Begin
  // up
  TSource.DisableControls;
  Try
    tmp1 := TSource.FieldByName('rec_no').AsInteger;
    name1 := TSource.FieldByName('name').AsString;
    tag1 := TSource.FieldByName('tag').AsString;
    TSource.Prior;
    tmp2 := TSource.FieldByName('rec_no').AsInteger;
    name2 := TSource.FieldByName('name').AsString;
    tag2 := TSource.FieldByName('tag').AsString;
    if tmp1 = tmp2 then
      Inc(tmp2);
    TSource.Edit;
    TSource.FieldByName('rec_no').AsInteger := tmp1;
    TSource.FieldByName('name').AsString := name1;
    TSource.FieldByName('tag').AsString := tag1;
    TSource.Post;
    TSource.Next;
    TSource.Edit;
    TSource.FieldByName('rec_no').AsInteger := tmp2;
    TSource.FieldByName('name').AsString := name2;
    TSource.FieldByName('tag').AsString := tag2;
    TSource.Post;
    TSource.Prior;
  Except
  End;
  TSource.Refresh;
  TSource.EnableControls;
end;

procedure TfrmSequence.actUpUpdate(Sender: TObject);
begin
  actUp.Enabled := (TSource.RecNo > 1) and (frmMain.usergroup.Length > 1);
end;

procedure TfrmSequence.FormActivate(Sender: TObject);
begin
  Init;
end;

procedure TfrmSequence.Init;
begin
  if not frmUniversal.DBConnected then
    Close;

  try
    TSource.Active := false;
    TDest.Active := false;

    TSource.Active := true;
    TDest.Active := true;

    TSource.EmptyTable;
    TDest.EmptyTable;
  except
  end;

  try
    TQuerySRC.Active := true;
    TQuerySRC.Refresh;
    TQuerySRC.First;

    while not TQuerySRC.Eof do
    begin
      TSource.Append;
      TSource.FieldByName('name').AsString := TQuerySRC.FieldByName('name').AsString;
      TSource.FieldByName('tag').AsString := TQuerySRC.FieldByName('tag').AsString;
      TSource.FieldByName('rec_no').AsInteger := TQuerySRC.FieldByName('rec_no').AsInteger;
      TSource.Post;

      TQuerySRC.Next;
    end;
    TSource.First;
  except

  end;

end;

function TfrmSequence.GetFirstSelection(List: TCustomListBox): Integer;
begin
  for Result := 0 to List.Items.Count - 1 do
    if List.Selected[Result] then
      Exit;
  Result := LB_ERR;
end;

procedure TfrmSequence.GridDestDblClick(Sender: TObject);
begin
  actRemove.Execute;
end;

procedure TfrmSequence.GridSourceDblClick(Sender: TObject);
begin
  actAdd.Execute;
end;

procedure TfrmSequence.MoveSelected(List: TCustomListBox; Items: TStrings);
var
  i: Integer;
begin
  for i := List.Items.Count - 1 downto 0 do
    if List.Selected[i] then
    begin
      Items.AddObject(List.Items[i], List.Items.Objects[i]);
      List.Items.Delete(i);
    end;
end;

end.
