Unit SelectKindHardware;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB,   StdCtrls, JvExStdCtrls, JvButton,
  JvCtrls, JvFooter, ExtCtrls, JvExExtCtrls, JvExtComponent, ComCtrls,
  JvExComCtrls, JvDBTreeView, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf,
  FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet,
  FireDAC.Comp.Client;

Type
  TfrmSelectKindHardware = Class(TForm)
    CatalogTree: TJvDBTreeView;
    TTemplate: TFDQuery;
    DSTemplate: TDataSource;
    JvFooter1: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    btnOk: TJvFooterBtn;
    MyQuery1: TFDQuery;
    Procedure CatalogTreeDblClick(Sender: TObject);
    Procedure FormShow(Sender: TObject);
    Procedure btnOkClick(Sender: TObject);
    Procedure FormActivate(Sender: TObject);
  Private
    Function getParent(rec_no: String): String;
    Procedure getChild(myparent: String);
    { Private declarations }
  Public
    template_name: String;
    template_no: integer;
    template_list: String;
    { Public declarations }
  End;

Var
  frmSelectKindHardware: TfrmSelectKindHardware;

Implementation

Uses Main;

{$R *.dfm}

Procedure TfrmSelectKindHardware.btnOkClick(Sender: TObject);
Var
  template_str: String;
Begin
  template_no := TTemplate.FieldByName('rec_no').AsInteger;
  template_name := TTemplate.FieldByName('name').AsString;
  template_str := IntToStr(template_no);
  template_list := template_str;
  getChild(template_str); // create template_list;
  ModalResult := mrOk;
End;

Function TfrmSelectKindHardware.getParent(rec_no: String): String;
Var
  res: String;
Begin
  res := '';
  Try
    MyQuery1.Sql.Text := 'SELECT `parent` FROM `uni_templates` WHERE `rec_no`='
      + rec_no + ';';
    MyQuery1.Active := true;
    If MyQuery1.RecordCount > 0 Then
      res := MyQuery1.FieldByName('parent').AsString;
  Except
  End;
  result := res;
End;

Procedure TfrmSelectKindHardware.getChild(myparent: String);
Var
  i: integer;
  childs: TStrings;
  rn: String;
Begin
  childs := TStringList.Create;
  childs.Clear;
  Try
    MyQuery1.Sql.Text := 'SELECT `rec_no` FROM `uni_templates` WHERE `parent`='
      + myparent + ';';
    MyQuery1.Active := true;
    While Not MyQuery1.eof Do
    Begin
      rn := MyQuery1.FieldByName('rec_no').AsString;
      childs.Add(rn);
      template_list := template_list + ',' + rn;
      MyQuery1.Next;
    End;
  Except
  End;
  For i := 0 To childs.Count - 1 Do
  Begin
    getChild(childs[i]);
  End;
  childs.Free;
End;

Procedure TfrmSelectKindHardware.CatalogTreeDblClick(Sender: TObject);
Begin
  btnOk.Click;
End;

Procedure TfrmSelectKindHardware.FormActivate(Sender: TObject);
Begin
  btnOk.SetFocus;
End;

Procedure TfrmSelectKindHardware.FormShow(Sender: TObject);
Begin
  TTemplate.Active := true;
End;

End.
