Unit Project;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, JvExComCtrls, JvDBTreeView, ExtCtrls,
  JvComCtrls, JvExExtCtrls, JvSplitter, JvDateTimePicker,
  StdCtrls, JvComponentBase, JvCaptionButton, ActnList, Menus, JvExControls,
  JvSpeedButton, Grids, DBGrids, JvExDBGrids, JvDBGrid, JvExStdCtrls,
  JvCheckBox, Clipbrd, ShellAPI, Math, DateUtils,
  JvScrollMax, JvExtComponent, ToolWin, JvMenus, JvDBLookupTreeView, JvCombobox,
  ButtonGroup, JvDBGridFooter, JvLabel, JvDBControls, JvAutoComplete, ImgList,
  JvFormPlacement, JvDialogs, IdBaseComponent, IdComponent, IdTCPConnection,
  IdTCPClient, IdExplicitTLSClientServerBase, JvDBGridExport, JvButton,
  JvCtrls, JvFooter, Vcl.DBCtrls, System.Actions, FireDAC.Stan.Intf,
  FireDAC.Stan.Option, FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS,
  FireDAC.Phys.Intf, FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt,
  FireDAC.Comp.Client, FireDAC.Comp.DataSet, Vcl.Buttons,
  System.IOUtils, W7Classes,
  W7ListViewItems, W7Panels, JvEditorCommon, JvEditor, JvHLEditor, AdvMemo,
  AdvLabelEdit, JvMemo, JvDotNetControls, JvListBox, JvComboListBox, BtnListB,
  AdvListBox, HTMListB, AdvDBListBox, AdvSmoothListBox, DB, Vcl.Tabs;

Type
  TfrmProject = Class(TForm)
    DSPrSystems: TDataSource;
    Panel2: TPanel;
    Pages: TJvPageControl;
    TabSheetInfo: TTabSheet;
    TabSheetHardware: TTabSheet;
    TabSheetDocuments: TTabSheet;
    MainMenu: TMainMenu;
    mCategory: TMenuItem;
    mStructureAddSub: TMenuItem;
    mStructureEdit: TMenuItem;
    miSystemDelete: TMenuItem;
    N29: TMenuItem;
    mStructureMove: TMenuItem;
    N28: TMenuItem;
    mStructureUpdate: TMenuItem;
    Actions: TActionList;
    actUnitsAdd: TAction;
    actUnitsEdit: TAction;
    actUnitsDelete: TAction;
    actUnitsUpdate: TAction;
    actStructureUpdate: TAction;
    actUnitsMove: TAction;
    N1: TMenuItem;
    N2: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    actOrderChange: TAction;
    actOrderRename: TAction;
    actOrderDelete: TAction;
    pmPrSystems: TPopupMenu;
    N12: TMenuItem;
    DSHardware: TDataSource;
    Panel4: TPanel;
    JvSpeedButton2: TJvSpeedButton;
    JvSpeedButton1: TJvSpeedButton;
    PanelLeft: TPanel;
    SplitterVertical: TJvSplitter;
    Panel7: TPanel;
    GridPrSystems: TJvDBGrid;
    Panel8: TPanel;
    GridPrHardware: TJvDBGrid;
    Panel6: TPanel;
    Panel9: TPanel;
    Label7: TLabel;
    THardware: TFDTable;
    pmPrHardware: TPopupMenu;
    MyQuerySRC: TFDQuery;
    TimerUpdateList: TTimer;
    N15: TMenuItem;
    TAtt: TFDQuery;
    DSAtt: TDataSource;
    TimerUpdateHardwareInfo: TTimer;
    DSPrAtt: TDataSource;
    pmPrAtt: TPopupMenu;
    MenuItem6: TMenuItem;
    actPrAttAdd: TAction;
    N16: TMenuItem;
    Panel14: TPanel;
    GridPrAtt: TJvDBGrid;
    Panel15: TPanel;
    Label20: TLabel;
    Panel16: TPanel;
    FormStorage: TJvFormStorage;
    N20: TMenuItem;
    DSPrCertificates: TDataSource;
    pmGridPrCertificates: TPopupMenu;
    MenuItem12: TMenuItem;
    dlgOpen: TJvOpenDialog;
    actPrAttDelete: TAction;
    N21: TMenuItem;
    N22: TMenuItem;
    TPrCertificates: TFDQuery;
    actPrAttSaveToFile: TAction;
    dlgSave: TSaveDialog;
    N23: TMenuItem;
    actPrCertificatesSaveToFile: TAction;
    N24: TMenuItem;
    actPrAttOpen: TAction;
    actPrCertificateOpen: TAction;
    actPrAttName: TAction;
    N25: TMenuItem;
    Panel17: TPanel;
    GridPrCertificates: TJvDBGrid;
    Panel18: TPanel;
    Label22: TLabel;
    Panel19: TPanel;
    actSystemsOpts: TAction;
    N26: TMenuItem;
    actJoinArticle: TAction;
    N27: TMenuItem;
    actStage1: TAction;
    actStage2: TAction;
    pmHardware: TPopupMenu;
    actActiveToPrinter: TAction;
    LabelOrderInfo: TLabel;
    N17: TMenuItem;
    N18: TMenuItem;
    SaveHTMLDialog: TSaveDialog;
    TPrHardware: TFDQuery;
    actHardwareUp: TAction;
    actHardwareDown: TAction;
    DSPrHardware: TDataSource;
    PanelCommon: TPanel;
    GroupBoxContragents: TGroupBox;
    Label10: TLabel;
    Label9: TLabel;
    Label1: TLabel;
    lblCustomer: TLabel;
    lblEngineer: TLabel;
    lblManager: TLabel;
    GroupBoxPeriod: TGroupBox;
    Label3: TLabel;
    Label6: TLabel;
    lblDateStart: TLabel;
    lblDateEnd: TLabel;
    GroupBoxOptions: TGroupBox;
    Label23: TLabel;
    Label24: TLabel;
    lblShema: TLabel;
    lblSpecification: TLabel;
    Label27: TLabel;
    lblAllForProject: TLabel;
    lblOsobo: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    lblFastProject: TLabel;
    GroupBoxCustomer: TGroupBox;
    Label5: TLabel;
    Label11: TLabel;
    lblCustomer2: TLabel;
    lblUser_Job: TLabel;
    Label14: TLabel;
    lblPhone1: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    lblPhone2: TLabel;
    Label19: TLabel;
    lblEMail: TLabel;
    Label21: TLabel;
    lblComment: TLabel;
    lblUserFio: TLabel;
    PanelPrComments: TPanel;
    lblProjectInfo: TMemo;
    Label15: TLabel;
    actCommentSave: TAction;
    actCommentLoad: TAction;
    JvFooter1: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    JvFooterBtn2: TJvFooterBtn;
    actSystemUp: TAction;
    actSystemDown: TAction;
    ToolBar1: TToolBar;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolBar2: TToolBar;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    TPrSystems: TFDQuery;
    actPriceUpdate: TAction;
    N19: TMenuItem;
    N32: TMenuItem;
    MyQuery2: TFDQuery;
    actSummary: TAction;
    actSummary1: TMenuItem;
    actImportToProject: TAction;
    Excel1: TMenuItem;
    TimerSumRecalc: TTimer;
    N34: TMenuItem;
    N35: TMenuItem;
    actSystemsSelectAll: TAction;
    actSystemsSelectNone: TAction;
    actSystemsSelectNone1: TMenuItem;
    actJoinName: TAction;
    N36: TMenuItem;
    Label18: TLabel;
    Label25: TLabel;
    lblName: TLabel;
    lblDescription: TLabel;
    HTMLExport: TJvDBGridHTMLExport;
    N37: TMenuItem;
    TPrAtt: TFDQuery;
    actUnitReplace: TAction;
    N38: TMenuItem;
    actSystemsSequence: TAction;
    N40: TMenuItem;
    N41: TMenuItem;
    N42: TMenuItem;
    actReportCreate: TAction;
    N45: TMenuItem;
    Label26: TLabel;
    N46: TMenuItem;
    N47: TMenuItem;
    N48: TMenuItem;
    N49: TMenuItem;
    N50: TMenuItem;
    N39: TMenuItem;
    TabSheetTasks: TTabSheet;
    Panel1: TPanel;
    TasksScrolls: TScrollBox;
    btnTasksRead: TButton;
    TasksHolder0: TPanel;
    QTasks: TFDQuery;
    TimerUpdateChat: TTimer;
    N53: TMenuItem;
    N54: TMenuItem;
    N55: TMenuItem;
    N7: TMenuItem;
    PanelTotals: TGridPanel;
    TotalModules: TLabel;
    TotalSystem: TLabel;
    TotalProject: TLabel;
    TotalActive: TLabel;
    actTasksCancel: TAction;
    actTasksAdd: TAction;
    actTasksCopyToLib: TAction;
    actTasksCopyFromLib: TAction;
    actTasksDelete: TAction;
    actTasksDeleteFromLib: TAction;
    TMessageLib: TFDQuery;
    DSMessageLib: TDataSource;
    MyQueryDST: TFDQuery;
    actDeleteFromLib: TAction;
    ListTaskLib: TJvComboListBox;
    pmLib: TPopupMenu;
    N3: TMenuItem;
    N8: TMenuItem;
    pmTasks: TPopupMenu;
    N9: TMenuItem;
    N10: TMenuItem;
    N11: TMenuItem;
    miCancel: TMenuItem;
    N30: TMenuItem;
    actTasksRefresh: TAction;
    N33: TMenuItem;
    Tabs: TTabSet;
    Panel3: TPanel;
    btnSaveToFile: TButton;
    btnSaveToDB: TButton;
    TemplateList: TComboBox;
    TTemplate: TFDQuery;
    LibFilter: TEdit;
    TotalNeModules: TLabel;
    N31: TMenuItem;
    setNumberToActive: TMenuItem;
    setActiveToNumber: TMenuItem;
    actTasksAssignFast: TAction;
    actTasksAssignFast1: TMenuItem;
    actTasksSave: TAction;
    N43: TMenuItem;
    ToolBar3: TToolBar;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    Panel5: TPanel;
    TimerAutoEdit: TTimer;
    TasksHolder2: TPanel;
    TasksHolder1: TPanel;
    N13: TMenuItem;
    N14: TMenuItem;
    actJoin: TAction;
    N44: TMenuItem;
    actSystemsCertificate: TAction;
    N51: TMenuItem;
    btnSaveComments: TButton;
    TimerClose: TTimer;
    N52: TMenuItem;
    N56: TMenuItem;
    N57: TMenuItem;
    N58: TMenuItem;
    miSetGabarites: TMenuItem;
    miAutoPassport: TMenuItem;
    Procedure FormClose(Sender: TObject; Var Action: TCloseAction);
    Procedure FormShow(Sender: TObject);
    Procedure FormActivate(Sender: TObject);
    Procedure SearchCatalogClick(Sender: TObject);
    Procedure _SearchChange(Sender: TObject);
    Procedure TPrSystemsAfterScroll(DataSet: TDataSet);
    Procedure GridHardwareTitleBtnClick(Sender: TObject; ACol: Integer; Field: TField);
    Procedure GridPrSystemsDblClick(Sender: TObject);
    Procedure GridPrHardwareDblClick(Sender: TObject);
    Procedure GridPrHardwareTitleBtnClick(Sender: TObject; ACol: Integer; Field: TField);
    Procedure actUnitsAddUpdate(Sender: TObject);
    Procedure actUnitsAddExecute(Sender: TObject);
    Procedure GridHardwareDblClick(Sender: TObject);
    Procedure GridPrHardwareDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; Var Accept: Boolean);
    Procedure GridPrHardwareDragDrop(Sender, Source: TObject; X, Y: Integer);
    Procedure GridHardwareMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    Procedure GridPrHardwareMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    Procedure GridHardwareDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; Var Accept: Boolean);
    Procedure GridHardwareDragDrop(Sender, Source: TObject; X, Y: Integer);
    Procedure actUnitsDeleteUpdate(Sender: TObject);
    Procedure actUnitsDeleteExecute(Sender: TObject);
    Procedure actOrderChangeExecute(Sender: TObject);
    Procedure actOrderDeleteExecute(Sender: TObject);
    Procedure TotalSystemClick(Sender: TObject);
    Procedure TPrHardwareAfterDelete(DataSet: TDataSet);
    Procedure TimerUpdateListT(Sender: TObject);
    Procedure OnlyArticulClick(Sender: TObject);
    Procedure OrderChange(Sender: TObject);
    Procedure THardwareAfterScroll(DataSet: TDataSet);
    Procedure TimerUpdateHardwareInfoTimer(Sender: TObject);
    Procedure GridPrHardwareDrawColumnCell(Sender: TObject; Const Rect: TRect; DataCol: Integer; Column: TColumn;
      State: TGridDrawState);
    Procedure TPrHardwareCalcFields(DataSet: TDataSet);
    Procedure actPrAttAddExecute(Sender: TObject);
    Procedure actPrAttAddUpdate(Sender: TObject);
    Procedure actPrAttDeleteUpdate(Sender: TObject);
    Procedure actPrAttDeleteExecute(Sender: TObject);
    Procedure lblShemaClick(Sender: TObject);
    Procedure actPrAttSaveToFileUpdate(Sender: TObject);
    Procedure actPrAttSaveToFileExecute(Sender: TObject);
    Procedure actPrCertificatesSaveToFileUpdate(Sender: TObject);
    Procedure actPrCertificatesSaveToFileExecute(Sender: TObject);
    Procedure actPrCertificateOpenUpdate(Sender: TObject);
    Procedure actPrAttOpenUpdate(Sender: TObject);
    Procedure actPrAttOpenExecute(Sender: TObject);
    Procedure actPrCertificateOpenExecute(Sender: TObject);
    Procedure GridPrCertificatesDblClick(Sender: TObject);
    Procedure GridPrAttDblClick(Sender: TObject);
    Procedure actPrAttNameUpdate(Sender: TObject);
    Procedure actPrAttNameExecute(Sender: TObject);
    Procedure actSystemsOptsUpdate(Sender: TObject);
    Procedure actSystemsOptsExecute(Sender: TObject);
    Procedure actUnitsEditUpdate(Sender: TObject);
    Procedure actJoinArticleUpdate(Sender: TObject);
    Procedure actJoinArticleExecute(Sender: TObject);
    Procedure TPrHardwareAfterOpen(DataSet: TDataSet);
    Procedure THardwareAfterOpen(DataSet: TDataSet);
    Procedure actActiveToPrinterExecute(Sender: TObject);
    Procedure PrHardwareAsShowedChange(Sender: TObject);
    Procedure actHardwareUpExecute(Sender: TObject);
    Procedure actHardwareDownExecute(Sender: TObject);
    Procedure actHardwareUpUpdate(Sender: TObject);
    Procedure actHardwareDownUpdate(Sender: TObject);
    Procedure TPrSystemsAfterPost(DataSet: TDataSet);
    procedure actCommentSaveExecute(Sender: TObject);
    procedure actCommentLoadExecute(Sender: TObject);
    procedure actCommentSaveUpdate(Sender: TObject);
    procedure actCommentLoadUpdate(Sender: TObject);
    procedure actOrderDeleteUpdate(Sender: TObject);
    procedure actOrderRenameUpdate(Sender: TObject);
    procedure TimerRepUpTimer(Sender: TObject);
    procedure TimerRepDownTimer(Sender: TObject);
    procedure actSystemUpUpdate(Sender: TObject);
    procedure actSystemDownUpdate(Sender: TObject);
    procedure actSystemUpExecute(Sender: TObject);
    procedure actSystemDownExecute(Sender: TObject);
    procedure ToolButton6MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ToolButton6MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ToolButton7MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ToolButton7MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure actPriceUpdateExecute(Sender: TObject);
    procedure actSummaryExecute(Sender: TObject);
    procedure actImportToProjectExecute(Sender: TObject);
    procedure TPrHardwareAfterInsert(DataSet: TDataSet);
    procedure TPrHardwareAfterPost(DataSet: TDataSet);
    procedure TimerSumRecalcTimer(Sender: TObject);
    procedure actImportToProjectUpdate(Sender: TObject);
    procedure actPriceUpdateUpdate(Sender: TObject);
    procedure actSystemsSelectAllExecute(Sender: TObject);
    procedure actSystemsSelectNoneExecute(Sender: TObject);
    procedure GridPrCertificatesDrawDataCell(Sender: TObject; const Rect: TRect; Field: TField; State: TGridDrawState);
    procedure actJoinNameExecute(Sender: TObject);
    procedure actJoinNameUpdate(Sender: TObject);
    procedure lblProjectInfoChange(Sender: TObject);
    procedure TimerRepSystemUpTimer(Sender: TObject);
    procedure TimerRepSystemDownTimer(Sender: TObject);
    procedure ToolButton2MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ToolButton3MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ToolButton2MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ToolButton3MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure GridPrSystemsExit(Sender: TObject);
    procedure PagesChange(Sender: TObject);
    procedure N37Click(Sender: TObject);
    procedure actUnitReplaceUpdate(Sender: TObject);
    procedure actUnitReplaceExecute(Sender: TObject);
    procedure TPrAttAfterOpen(DataSet: TDataSet);
    procedure TPrCertificatesAfterOpen(DataSet: TDataSet);
    procedure TPrSystemsAfterOpen(DataSet: TDataSet);
    procedure GridPrSystemsEnter(Sender: TObject);
    procedure N40Click(Sender: TObject);
    procedure N41Click(Sender: TObject);
    procedure N42Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure actReportCreateExecute(Sender: TObject);
    procedure GridPrHardwareEnter(Sender: TObject);
    procedure GridPrHardwareExit(Sender: TObject);
    procedure MouseWheelByOne(Sender: TObject; Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
      var Handled: Boolean);
    procedure MemoEditorChange(Sender: TObject);
    procedure TasksScrollsResize(Sender: TObject);
    procedure btnTasksSaveClick(Sender: TObject);
    procedure TimerUpdateChatTimer(Sender: TObject);
    procedure MemoEditorEnter(Sender: TObject);
    procedure TasksScrollsMouseWheel(Sender: TObject; Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
      var Handled: Boolean);
    procedure TPrHardwareAfterScroll(DataSet: TDataSet);
    procedure GridPrHardwareCellClick(Column: TColumn);
    procedure actTasksCancelExecute(Sender: TObject);
    procedure actTasksAddExecute(Sender: TObject);
    procedure actTasksDeleteExecute(Sender: TObject);
    procedure actTasksCopyToLibExecute(Sender: TObject);
    procedure actTasksDeleteFromLibExecute(Sender: TObject);
    procedure actTasksCopyFromLibExecute(Sender: TObject);
    procedure actTasksRefreshExecute(Sender: TObject);
    procedure TabsClick(Sender: TObject);
    procedure actTasksCopyToLibUpdate(Sender: TObject);
    procedure actTasksDeleteUpdate(Sender: TObject);
    procedure btnSaveToFileClick(Sender: TObject);
    procedure dlgSaveTypeChange(Sender: TObject);
    procedure btnSaveToDBClick(Sender: TObject);
    procedure LibFilterChange(Sender: TObject);
    procedure TPrHardwareAfterRefresh(DataSet: TDataSet);
    procedure TPrHardwareBeforeDelete(DataSet: TDataSet);
    procedure setNumberToActiveClick(Sender: TObject);
    procedure setActiveToNumberClick(Sender: TObject);
    procedure actTasksAssignFastExecute(Sender: TObject);
    procedure actTasksAssignFastUpdate(Sender: TObject);
    procedure actTasksDeleteFromLibUpdate(Sender: TObject);
    procedure ListTaskLibDrawText(Sender: TObject; Index: Integer; const AText: string; R: TRect;
      var DefaultDraw: Boolean);
    procedure actTasksSaveExecute(Sender: TObject);
    procedure ListTaskLibMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ListTaskLibClick(Sender: TObject);
    procedure TimerAutoEditTimer(Sender: TObject);
    procedure actJoinExecute(Sender: TObject);
    procedure actJoinUpdate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure actSystemsCertificateExecute(Sender: TObject);
    procedure actSystemsCertificateUpdate(Sender: TObject);
    procedure TimerCloseTimer(Sender: TObject);
    procedure N57Click(Sender: TObject);
    procedure N56Click(Sender: TObject);
    procedure N58Click(Sender: TObject);
    procedure miSetGabaritesClick(Sender: TObject);
    procedure miAutoPassportClick(Sender: TObject);
  Private
    template_no: Integer;
    template_list: String;
    lastMemo: TMemo;
    // maxorderby: Integer;
    Procedure UpdateHardwareList;
    Procedure SumRecalc;
    Procedure UpdateAtt;
    Procedure ShowMarks;
    procedure SystemOptAutoCalc;
    function GetEmptyTemplate(kind: string): string;
    function SystemsCheckOk: Boolean;
    procedure SumRecalc2;
    procedure FixCommentSize;
    procedure RenewPrSystems;
    procedure RenewPrAtt;
    procedure RenewProjectInfo;
    procedure RenewPrHardware;
    procedure RenewPrCertificates;
    procedure SystemsListRebuild;
    procedure UpdateTasks;
    procedure ShowInfo;
    procedure MemoEditorExit(Sender: TObject);
    procedure UpdateTaskLib;
    procedure TasksHolderRecalcHeight;
    procedure SaveTasks;
    procedure TemplateListFill;
    procedure ReportToFile;
    procedure ReportToDB;
    function DetectSize(input: string; var h, w, d: double): Boolean;
    procedure SetGlobal;
    function GetPriceListID(pricename: string): Integer;
    { Private declarations }
  Public
    Project_no: Integer;
    Project_name: String;
    Project_customer: String;
    Project_engineer: String;
    Project_manager: String;
    Project_datestart: tdatetime;
    Project_dateend: tdatetime;
    Project_options: String;
    Project_description: String;
    Project_info: String;
    system_no: Integer;
    System_name: String;
    System_tag: String;
    //
    SystemsList: TStrings;
    ListTaskLibRecno: TStrings;
    ListTaskLibShort: TStrings;
    //
    LastSystemRecNo: Integer;
    //
    updated_chat, updated_lib, updated_info, updated_hardware: tdatetime;
    selectedMemo: TMemo;
    maxorder: Integer;
    TasksHolder: array [0 .. 2] of TPanel;
    procedure MakeCountFocused(article: string);
    { Public declarations }
  End;

Var
  frmProject: TfrmProject;

Implementation

Uses SystemsAdd, SystemsImport, SystemsDelete, SystemsExport,
  SelectKindHardware, Main, OrderChange, OrderDelete, ProjectMarks,
  PrAttName, SystemsOptEdit, DoCopyHardware, PriceUpdate,
  ProjectSummary, HardwareReplace, TableSets,
  ReportSelect, DataModule, Universal, Sequence, Tracker, NumEdit, DescEdit,
  TotalUpdate, AutoPassport;

{$R *.dfm}

Procedure TfrmProject.actPrAttSaveToFileExecute(Sender: TObject);
Var
  fn, d: String;
Begin
  //  
  If (TPrAtt.RecNo > 0) Then
  Begin
    fn := TPrAtt.FieldByName('file').AsString;
    dlgSave.FileName := fn;
    dlgSave.DefaultExt := ExtractFileExt(fn);
    If (fn <> '') And dlgSave.Execute Then
    Begin
      frmUniversal.FileGetByNameToFile(fn, dlgSave.FileName);
    End;
  End;
End;

Procedure TfrmProject.actPrAttSaveToFileUpdate(Sender: TObject);
Var
  res: Boolean;
Begin
  If (TPrAtt.RecNo < 1) Then
    res := false
  Else
    res := (length(TPrAtt.FieldByName('file').AsString) > 10);
  actPrAttSaveToFile.Enabled := res;
End;

Procedure TfrmProject.actPrCertificateOpenExecute(Sender: TObject);
Var
  fn, d, sfn: String;
Begin
  //  
  If (TPrCertificates.RecNo > 0) Then
  Begin
    fn := TPrCertificates.FieldByName('file').AsString;
    sfn := frmMain.ComputerInfo.Folders.Temp + '\' + fn;
    If (fn <> '') Then
    Begin
      frmUniversal.FileGetByNameToFile(fn, sfn);
    End;

    frmMain.OpenFile(sfn);
  End;
End;

Procedure TfrmProject.actPrCertificateOpenUpdate(Sender: TObject);
Var
  res: Boolean;
Begin
  If (TPrCertificates.RecNo < 1) Then
    res := false
  Else
    res := (length(TPrCertificates.FieldByName('file').AsString) > 10);
  actPrCertificateOpen.Enabled := res;
End;

Procedure TfrmProject.actPrCertificatesSaveToFileExecute(Sender: TObject);
Var
  fn, d: String;
Begin
  //  
  If (TPrCertificates.RecNo > 0) Then
  Begin
    fn := TPrCertificates.FieldByName('file').AsString;
    dlgSave.FileName := fn;
    dlgSave.DefaultExt := ExtractFileExt(fn);
    If (fn <> '') And dlgSave.Execute Then
    Begin
      frmUniversal.FileGetByNameToFile(fn, dlgSave.FileName);
    End;
  End;
End;

Procedure TfrmProject.actPrCertificatesSaveToFileUpdate(Sender: TObject);
Var
  res: Boolean;
Begin
  If (TPrCertificates.RecNo < 1) Then
    res := false
  Else
    res := (length(TPrCertificates.FieldByName('file').AsString) > 10);
  actPrCertificatesSaveToFile.Enabled := res;
End;

Procedure TfrmProject.actActiveToPrinterExecute(Sender: TObject);
Begin
  SaveHTMLDialog.FileName := Project_name + '.html';
  If SaveHTMLDialog.Execute Then
  Begin
    HTMLExport.Caption := ': ' + Project_name;
    HTMLExport.DocTitle := ': ' + Project_name;
    HTMLExport.FileName := SaveHTMLDialog.FileName;
    HTMLExport.ExportGrid;
    If FileExists(HTMLExport.FileName) Then
      frmMain.OpenFile(HTMLExport.FileName);
  End;
End;

{
  Procedure TfrmProject.actExportExecute(Sender: TObject);
  Begin
  frmSystemsExport.Source_system_no := TPrSystems.FieldByName('rec_no').AsInteger;
  frmSystemsExport.ShowModal;
  End;
}

{
  Procedure TfrmProject.actImportExecute(Sender: TObject);
  Var
  lname: String;
  Begin
  SystemsListRebuild;
  frmSystemsImport.SystemsList := SystemsList;
  frmSystemsImport.DST_project_no := Project_no;
  If TPrSystems.RecNo > 0 Then
  Begin
  lname := TPrSystems.FieldByName('name').AsString;
  frmSystemsImport.DST_system_no := TPrSystems.FieldByName('rec_no').AsInteger;
  frmSystemsImport.LabelCurrentSystem.Caption := lname;
  End
  Else
  Begin
  frmSystemsImport.DST_system_no := -1;
  frmSystemsImport.LabelCurrentSystem.Caption := '';
  End;

  If frmSystemsImport.ShowModal = mrOk Then
  Begin
  TPrSystems.Refresh;
  If lname <> '' Then
  TPrSystems.Locate('name', lname, []);
  End;
  RenewPrHardware;
  End; }

procedure TfrmProject.actImportToProjectExecute(Sender: TObject);
var
  system_no: Integer;
begin
  { frmImportToProject.Project_no := Project_no;
    system_no := TPrSystems.FieldByName('rec_no').AsInteger;
    frmImportToProject.system_no := system_no;
    if (system_no > 0) and (Project_no > 0) then
    frmImportToProject.ShowModal;
    RenewPrHardware;
  }
end;

procedure TfrmProject.actImportToProjectUpdate(Sender: TObject);
begin
  actImportToProject.Enabled := (frmMain.usergroup.length > 1);
end;

procedure TfrmProject.actTasksSaveExecute(Sender: TObject);
begin
  SaveTasks;
end;

Procedure TfrmProject.actJoinArticleUpdate(Sender: TObject);
Begin
  actJoinArticle.Enabled := (TPrHardware.RecNo > 0) and (frmMain.usergroup.length > 1);
End;

procedure TfrmProject.actJoinExecute(Sender: TObject);
Var
  system_no: Integer;
  article, name: String;
  Count: Integer;
  bm: TBookmark;
  i, RecNo: Integer;
Begin
  TPrHardware.DisableControls;
  Try
    bm := THardware.GetBookmark;
  Except
  End;
  system_no := TPrHardware.FieldByName('system_no').AsInteger;
  For RecNo := TPrHardware.Recordcount Downto 1 Do
  Begin
    TPrHardware.RecNo := RecNo;
    article := TPrHardware.FieldByName('article').AsString;
    name := TPrHardware.FieldByName('name').AsString;
    Count := TPrHardware.FieldByName('count').AsInteger;
    TPrHardware.Locate('article;name', VarArrayOf([article, name]), []);
    If TPrHardware.RecNo <> RecNo Then
    Begin
      //  `count`
      TPrHardware.Edit;
      TPrHardware.FieldByName('count').AsInteger := TPrHardware.FieldByName('count').AsInteger + Count;
      TPrHardware.Post;
      TPrHardware.RecNo := RecNo;
      TPrHardware.Delete;
    End;
  End;
  Try
    THardware.GotoBookmark(bm);
    THardware.FreeBookmark(bm);
  Except
  End;
  TPrHardware.EnableControls;
end;

procedure TfrmProject.actJoinNameExecute(Sender: TObject);
Var
  system_no: Integer;
  article: String;
  Count: Integer;
  bm: TBookmark;
  i, RecNo: Integer;
Begin
  {
    TPrHardware.DisableControls;
    Try
    bm := THardware.GetBookmark;
    Except
    End;
    System_no := TPrHardware.FieldByName('system_no').AsInteger;
    For RecNo := TPrHardware.Recordcount Downto 1 Do
    Begin
    TPrHardware.RecNo := RecNo;
    article := TPrHardware.FieldByName('name').AsString;
    Count := TPrHardware.FieldByName('count').AsInteger;
    TPrHardware.Locate('name', article, []);
    If TPrHardware.RecNo <> RecNo Then
    Begin
    //  `count`
    TPrHardware.Edit;
    TPrHardware.FieldByName('count').AsInteger := TPrHardware.FieldByName('count').AsInteger + Count;
    TPrHardware.Post;
    TPrHardware.RecNo := RecNo;
    TPrHardware.Delete;
    End;
    End;
    Try
    THardware.GotoBookmark(bm);
    THardware.FreeBookmark(bm);
    Except
    End;
    TPrHardware.EnableControls;
  }
end;

procedure TfrmProject.actJoinNameUpdate(Sender: TObject);
begin
  actJoinName.Enabled := (TPrHardware.RecNo > 0) and (frmMain.usergroup.length > 1);
end;

procedure TfrmProject.actJoinUpdate(Sender: TObject);
begin
  actJoin.Enabled := (TPrHardware.RecNo > 0) and (frmMain.usergroup.length > 1);
end;

Procedure TfrmProject.actOrderChangeExecute(Sender: TObject);
Begin
  frmOrderChange.Project_no := Project_no;
  frmOrderChange.Project_name := Project_name;
  frmOrderChange.Project_description := Project_description;
  frmOrderChange.Project_customer := Project_customer;
  frmOrderChange.Project_engineer := Project_engineer;
  frmOrderChange.Project_manager := Project_manager;
  frmOrderChange.Project_datestart := Project_datestart;
  frmOrderChange.Project_dateend := Project_dateend;
  If frmOrderChange.ShowModal = mrOk Then
  Begin
    // save to database
    Try
      If Project_name <> frmOrderChange.Project_name Then
      Begin
        MyQuerySRC.SQL.Text := 'UPDATE `uni_projects` SET `name`=' + QuotedStr(frmOrderChange.Project_name) +
          ' WHERE rec_no=' + IntToStr(Project_no);
        MyQuerySRC.Execute;
      End;
      If Project_description <> frmOrderChange.Project_description Then
      Begin
        MyQuerySRC.SQL.Text := 'UPDATE `uni_projects` SET `description`=' +
          QuotedStr(frmOrderChange.Project_description) + ' WHERE rec_no=' + IntToStr(Project_no);
        MyQuerySRC.Execute;
      End;
      If Project_customer <> frmOrderChange.Project_customer Then
      Begin
        MyQuerySRC.SQL.Text := 'UPDATE `uni_projects` SET `owner_customer`=' +
          QuotedStr(frmOrderChange.Project_customer) + ' WHERE rec_no=' + IntToStr(Project_no);
        MyQuerySRC.Execute;
      End;
      If Project_engineer <> frmOrderChange.Project_engineer Then
      Begin
        MyQuerySRC.SQL.Text := 'UPDATE `uni_projects` SET `owner_engineer`=' +
          QuotedStr(frmOrderChange.Project_engineer) + ' WHERE rec_no=' + IntToStr(Project_no);
        MyQuerySRC.Execute;
      End;
      If Project_manager <> frmOrderChange.Project_manager Then
      Begin
        MyQuerySRC.SQL.Text := 'UPDATE `uni_projects` SET `owner_manager`=' + QuotedStr(frmOrderChange.Project_manager)
          + ' WHERE rec_no=' + IntToStr(Project_no);
        MyQuerySRC.Execute;
      End;
      If Project_datestart <> frmOrderChange.Project_datestart Then
      Begin
        MyQuerySRC.SQL.Text := 'UPDATE `uni_projects` SET `datestart`="' +
          frmMain.DateTimeForSQL(frmOrderChange.Project_datestart) + '" WHERE rec_no=' + IntToStr(Project_no);
        MyQuerySRC.Execute;
      End;
      If Project_dateend <> frmOrderChange.Project_dateend Then
      Begin
        MyQuerySRC.SQL.Text := 'UPDATE `uni_projects` SET `dateend`="' +
          frmMain.DateTimeForSQL(frmOrderChange.Project_dateend) + '" WHERE rec_no=' + IntToStr(Project_no);
        MyQuerySRC.Execute;
      End;
    Except
    End;
    // save to current
    // Project_no := frmOrderChange.Project_no;
    Project_name := frmOrderChange.Project_name;
    Project_description := frmOrderChange.Project_description;
    Project_customer := frmOrderChange.Project_customer;
    Project_engineer := frmOrderChange.Project_engineer;
    Project_manager := frmOrderChange.Project_manager;
    Project_datestart := frmOrderChange.Project_datestart;
    Project_dateend := frmOrderChange.Project_dateend;
    FormActivate(self);
  End;
End;

Procedure TfrmProject.actOrderDeleteExecute(Sender: TObject);
Var
  FilterSQL: String;
Begin
  If frmOrderDelete.ShowModal = mrOk Then
  begin
    //  
    TimerUpdateChat.Enabled := false;
    Enabled := false;

    //    
    Try
      frmMain.Log(3, 'uni_projects', '', '', trim(Project_name));

      MyQuerySRC.SQL.Text := 'DELETE FROM `uni_projecthardware` WHERE `project_no`=:project_no';
      MyQuerySRC.ParamByName('project_no').AsInteger := Project_no;
      MyQuerySRC.Execute;

      MyQuerySRC.SQL.Text := 'DELETE FROM `uni_projectsystems` WHERE `project_no`=:project_no';
      MyQuerySRC.ParamByName('project_no').AsInteger := Project_no;
      MyQuerySRC.Execute;

      MyQuerySRC.SQL.Text := 'DELETE FROM `uni_projects` WHERE `rec_no`=:project_no';
      MyQuerySRC.ParamByName('project_no').AsInteger := Project_no;
      MyQuerySRC.Execute;

      Application.ProcessMessages;
    Except
    End;
    //   
    TimerClose.Enabled := true;
  end;
End;

procedure TfrmProject.actOrderDeleteUpdate(Sender: TObject);
begin
  actOrderDelete.Enabled := (frmMain.usergroup.length > 1);
end;

procedure TfrmProject.actOrderRenameUpdate(Sender: TObject);
begin
  actOrderRename.Enabled := (frmMain.usergroup.length > 1);
end;

Procedure TfrmProject.actPrAttAddUpdate(Sender: TObject);
Begin
  actPrAttAdd.Enabled := (frmMain.usergroup.length > 1);
End;

Procedure TfrmProject.actPrAttDeleteExecute(Sender: TObject);
var
  fn: string;
Begin
  fn := TPrAtt.FieldByName('file').AsString;
  TPrAtt.Delete;
  //     
  frmMain.StatusBar.Panels[3].Text := fn + ' -  ...';
  Application.ProcessMessages;
  frmUniversal.RemoveUnusedFile(fn);
  frmMain.StatusBar.Panels[3].Text := '';
End;

Procedure TfrmProject.actPrAttDeleteUpdate(Sender: TObject);
Begin
  actPrAttDelete.Enabled := (TPrAtt.RecNo > 0) and (frmMain.usergroup.length > 1);;
End;

Procedure TfrmProject.actPrAttNameExecute(Sender: TObject);
Begin
  frmPrAttName.Desc.Text := TPrAtt.FieldByName('name').AsString;
  frmPrAttName.comment.Text := TPrAtt.FieldByName('comment').AsString;
  If frmPrAttName.ShowModal = mrOk Then
  Begin
    TPrAtt.Edit;
    TPrAtt.FieldByName('name').AsString := frmPrAttName.Desc.Text;
    TPrAtt.FieldByName('comment').AsString := frmPrAttName.comment.Text;
    TPrAtt.Post;
  End;
End;

Procedure TfrmProject.actPrAttNameUpdate(Sender: TObject);
Begin
  actPrAttName.Enabled := (TPrAtt.RecNo > 0) and (frmMain.usergroup.length > 1);
End;

Procedure TfrmProject.actPrAttOpenExecute(Sender: TObject);
Var
  fn, d, spfilename: String;
  spfilenameindex: Integer;
Begin
  //  
  spfilenameindex := 0;
  If (TPrAtt.RecNo > 0) Then
  Begin
    fn := TPrAtt.FieldByName('file').AsString;
    spfilename := frmMain.ComputerInfo.Folders.Temp + '\' + fn;
    if FileExists(spfilename) then
      DeleteFile(spfilename);
    while FileExists(spfilename) do
    begin
      Inc(spfilenameindex);
      spfilename := frmMain.ComputerInfo.Folders.Temp + '\' + IntToStr(spfilenameindex) + '_' + fn;
      DeleteFile(spfilename);
    end;

    If (fn <> '') Then
    begin
      frmUniversal.FileGetByNameToFile(fn, spfilename);
    End;

    frmMain.OpenFile(spfilename);

  End;
End;

Procedure TfrmProject.actPrAttOpenUpdate(Sender: TObject);
Var
  res: Boolean;
Begin
  If (TPrAtt.RecNo < 1) Then
    res := false
  Else
    res := (length(TPrAtt.FieldByName('file').AsString) > 10);
  actPrAttOpen.Enabled := res;
End;

procedure TfrmProject.actSystemDownExecute(Sender: TObject);
Var
  orderby1, orderby2: Integer;
  rec_no1, rec_no2: Integer;
Begin
  // up
  TPrSystems.DisableControls;
  Try
    orderby2 := TPrSystems.FieldByName('orderby').AsInteger;
    rec_no2 := TPrSystems.FieldByName('rec_no').AsInteger;
    TPrSystems.Next;
    orderby1 := TPrSystems.FieldByName('orderby').AsInteger;
    rec_no1 := TPrSystems.FieldByName('rec_no').AsInteger;
    if orderby1 = orderby2 then
      Inc(orderby2);

    MyQuery2.SQL.Text := 'UPDATE `uni_projectsystems` SET orderby=:orderby WHERE rec_no=:rec_no';
    MyQuery2.ParamByName('orderby').AsInteger := orderby1;
    MyQuery2.ParamByName('rec_no').AsInteger := rec_no2;
    MyQuery2.ExecSQL;
    MyQuery2.SQL.Text := 'UPDATE `uni_projectsystems` SET orderby=:orderby WHERE rec_no=:rec_no';
    MyQuery2.ParamByName('orderby').AsInteger := orderby2;
    MyQuery2.ParamByName('rec_no').AsInteger := rec_no1;
    MyQuery2.ExecSQL;
    MyQuery2.Close;

    TPrSystems.Refresh;
  Except
    showmessage('err');
  End;

  TPrSystems.EnableControls;
  TPrSystems.Next;
end;

procedure TfrmProject.actSystemDownUpdate(Sender: TObject);
begin
  actSystemDown.Enabled := ((TPrSystems.RecNo < TPrSystems.Recordcount) And (TPrSystems.Recordcount > 1)) and
    (frmMain.usergroup.length > 1);
end;

{
  Procedure TfrmProject.actSystemsAddExecute(Sender: TObject);
  Var
  newName: String;
  tnod: TTreeNode;
  flds, SQL: String;
  Source_system_no, DST_system_no: Integer;
  max_orderby: Integer;
  Begin

  showmessage('moved');
  exit;

  SystemsListRebuild;
  frmSystemsAdd.SystemsList := SystemsList;
  frmSystemsAdd.CurrentName := '';
  Source_system_no := -1;
  If TPrSystems.RecNo > 0 Then
  Begin
  Source_system_no := TPrSystems.FieldByName('rec_no').AsInteger;
  End;
  //
  try
  MyQuerySRC.SQL.Text := 'SELECT max(`orderby`) as mx FROM uni_projectsystems WHERE `project_no`=' +
  IntToStr(Project_no) + ' ORDER BY `orderby`';
  MyQuerySRC.Active := true;
  max_orderby := MyQuerySRC.FieldByName('mx').AsInteger;
  MyQuerySRC.Active := false;
  except
  end;

  frmSystemsAdd.Caption := '  ';
  frmSystemsAdd.Clear;
  If (TPrSystems.Recordcount > 0) And (TPrSystems.RecNo > 0) Then
  Begin
  frmSystemsAdd.editName.Text := TPrSystems.FieldByName('name').AsString;
  frmSystemsAdd.Count.value := TPrSystems.FieldByName('count').AsInteger;
  frmSystemsAdd.construction.Text := TPrSystems.FieldByName('construction').AsString;
  frmSystemsAdd.kind.Text := TPrSystems.FieldByName('kind').AsString;
  frmSystemsAdd.voltage.Text := TPrSystems.FieldByName('voltage').AsString;
  frmSystemsAdd.current.Text := TPrSystems.FieldByName('current').AsString;
  frmSystemsAdd.protection.Text := TPrSystems.FieldByName('protection').AsString;
  frmSystemsAdd.entries.Text := TPrSystems.FieldByName('entries').AsString;
  frmSystemsAdd.voltage_secondary.Text := TPrSystems.FieldByName('voltage_secondary').AsString;
  frmSystemsAdd.strength.Text := TPrSystems.FieldByName('strength').AsString;
  frmSystemsAdd.UseActive.Checked := TPrSystems.FieldByName('active').AsBoolean;
  End;

  If frmSystemsAdd.ShowModal = mrOk Then
  Begin
  newName := frmSystemsAdd.editName.Text;
  TPrSystems.Append;
  TPrSystems.FieldByName('project_no').AsInteger := Project_no;
  TPrSystems.FieldByName('name').AsString := newName;
  TPrSystems.FieldByName('construction').AsString := frmSystemsAdd.construction.Text;
  TPrSystems.FieldByName('kind').AsString := frmSystemsAdd.kind.Text;
  TPrSystems.FieldByName('voltage').AsString := frmSystemsAdd.voltage.Text;
  TPrSystems.FieldByName('current').AsString := frmSystemsAdd.current.Text;
  TPrSystems.FieldByName('protection').AsString := frmSystemsAdd.protection.Text;
  TPrSystems.FieldByName('entries').AsString := frmSystemsAdd.entries.Text;
  TPrSystems.FieldByName('voltage_secondary').AsString := frmSystemsAdd.voltage_secondary.Text;
  TPrSystems.FieldByName('strength').AsString := frmSystemsAdd.strength.Text;
  TPrSystems.FieldByName('count').AsInteger := frmSystemsAdd.Count.value;
  TPrSystems.FieldByName('active').AsBoolean := frmSystemsAdd.UseActive.Checked;
  TPrSystems.FieldByName('orderby').AsInteger := max_orderby + 1;
  TPrSystems.Post;
  TPrSystems.Refresh;
  TPrSystems.Locate('project_no;name', VarArrayOf([Project_no, newName]), []);
  //
  DST_system_no := TPrSystems.FieldByName('rec_no').AsInteger;

  If Source_system_no > 0 Then
  If frmDoCopyHardware.ShowModal = mrOk Then
  try
  flds := 'name,kinddesc,article,comment,developer,file,price,valuta,count,modules';
  SQL := 'INSERT INTO uni_projecthardware (project_no,system_no,' + flds + ') ' + 'SELECT ' +
  IntToStr(Project_no) + ',' + IntToStr(DST_system_no) + ',' + flds +
  ' FROM `uni_projecthardware` WHERE `system_no`=' + IntToStr(Source_system_no) + ' ORDER BY `orderby`';
  MyQuerySRC.SQL.Text := SQL;
  MyQuerySRC.Execute;
  SQL := 'UPDATE uni_projecthardware SET `orderby`=`rec_no` WHERE `project_no`=' + IntToStr(Project_no) +
  ' AND `system_no`=' + IntToStr(DST_system_no);
  MyQuerySRC.SQL.Text := SQL;
  MyQuerySRC.Execute;
  except
  End;

  RenewPrHardware;
  End;
  End; }

procedure TfrmProject.actSystemsOptsUpdate(Sender: TObject);
Begin
  actSystemsOpts.Enabled := ((TPrSystems.Active) And (TPrSystems.RecNo > 0) And
    (length(TPrSystems.FieldByName('kind').AsString) > 1)) and (frmMain.usergroup.length > 1);;
End;

procedure TfrmProject.actSystemsSelectAllExecute(Sender: TObject);
var
  SQL: string;
begin
  //  
  TPrSystems.DisableControls;
  try
    SQL := 'UPDATE `uni_projectsystems`' + ' SET `active`= true ' + ' WHERE `project_no` = ' + IntToStr(Project_no);
    // Clipboard.SetTextBuf(pchar(SQL));
    MyQuerySRC.SQL.Text := SQL;
    MyQuerySRC.Execute;
  except
  end;
  TPrSystems.Refresh;
  TPrSystems.EnableControls;
end;

procedure TfrmProject.actSystemsSelectNoneExecute(Sender: TObject);
var
  SQL: string;
begin
  //  
  TPrSystems.DisableControls;
  try
    SQL := 'UPDATE `uni_projectsystems`' + ' SET `active`= false ' + ' WHERE `project_no` = ' + IntToStr(Project_no);
    // Clipboard.SetTextBuf(pchar(SQL));
    MyQuerySRC.SQL.Text := SQL;
    MyQuerySRC.Execute;
  except
  end;
  TPrSystems.Refresh;
  TPrSystems.EnableControls;
end;

procedure TfrmProject.actSystemUpExecute(Sender: TObject);
Var
  orderby1, orderby2: Integer;
  rec_no1, rec_no2: Integer;
Begin
  // up
  TPrSystems.DisableControls;
  Try
    orderby2 := TPrSystems.FieldByName('orderby').AsInteger;
    rec_no2 := TPrSystems.FieldByName('rec_no').AsInteger;
    TPrSystems.Prior;
    orderby1 := TPrSystems.FieldByName('orderby').AsInteger;
    rec_no1 := TPrSystems.FieldByName('rec_no').AsInteger;
    if orderby1 = orderby2 then
      Inc(orderby2);

    MyQuery2.SQL.Text := 'UPDATE `uni_projectsystems` SET orderby=:orderby WHERE rec_no=:rec_no';
    MyQuery2.ParamByName('orderby').AsInteger := orderby1;
    MyQuery2.ParamByName('rec_no').AsInteger := rec_no2;
    MyQuery2.ExecSQL;
    MyQuery2.SQL.Text := 'UPDATE `uni_projectsystems` SET orderby=:orderby WHERE rec_no=:rec_no';
    MyQuery2.ParamByName('orderby').AsInteger := orderby2;
    MyQuery2.ParamByName('rec_no').AsInteger := rec_no1;
    MyQuery2.ExecSQL;
    MyQuery2.Close;

    TPrSystems.Refresh;
  Except
    showmessage('err');
  End;

  TPrSystems.EnableControls;
  TPrSystems.Prior;
end;

procedure TfrmProject.actSystemUpUpdate(Sender: TObject);
begin
  actSystemUp.Enabled := (TPrSystems.RecNo > 1) and (frmMain.usergroup.length > 1);
end;

procedure TfrmProject.actTasksAddExecute(Sender: TObject);
begin
  // add
  Inc(maxorder);
  MyQuerySRC.SQL.Text :=
    'INSERT INTO `uni_messages` (project_no,kind,dt,username,comment,orderby) VALUES(:project_no,:kind,now(),:username,:comment,:maxorder)';
  MyQuerySRC.ParamByName('project_no').AsInteger := Project_no;
  MyQuerySRC.ParamByName('username').AsString := frmMain.username;
  MyQuerySRC.ParamByName('comment').AsString := '';
  MyQuerySRC.ParamByName('kind').AsInteger := Tabs.TabIndex;
  MyQuerySRC.ParamByName('maxorder').AsInteger := maxorder;
  MyQuerySRC.ExecSQL;
  MyQuerySRC.Close;
  Application.ProcessMessages;

  UpdateTasks;

  TasksScrolls.VertScrollBar.Position := TasksHolder[Tabs.TabIndex].Height - TasksScrolls.Height;
  if lastMemo <> nil then
    lastMemo.SetFocus;
end;

procedure TfrmProject.actTasksCancelExecute(Sender: TObject);
begin
  // full update
  selectedMemo := nil;
  updated_chat := 0;
  TasksHolder[Tabs.TabIndex].DestroyComponents;
  UpdateTasks;
end;

procedure TfrmProject.actTasksCopyFromLibExecute(Sender: TObject);
var
  ta: string;
begin
  Inc(maxorder);
  ta := '';
  if ListTaskLib.ItemIndex > -1 then
    ta := ListTaskLib.Items[ListTaskLib.ItemIndex];
  if trim(ta) = '' then
    exit;

  // add
  MyQueryDST.SQL.Text :=
    'INSERT INTO `uni_messages` (project_no,kind,dt,username,comment,orderby) VALUES(:project_no,:kind,now(),:username,:comment,:maxorder)';
  MyQueryDST.ParamByName('project_no').AsInteger := Project_no;
  MyQueryDST.ParamByName('kind').AsInteger := Tabs.TabIndex;
  MyQueryDST.ParamByName('username').AsString := frmMain.username;
  MyQueryDST.ParamByName('comment').AsString := ta;
  MyQueryDST.ParamByName('maxorder').AsInteger := maxorder;
  MyQueryDST.ExecSQL;
  MyQueryDST.Close;

  UpdateTasks;

  TasksScrolls.VertScrollBar.Position := TasksHolder[Tabs.TabIndex].Height - TasksScrolls.Height;
  if lastMemo <> nil then
    lastMemo.SetFocus;
end;

procedure TfrmProject.actTasksCopyToLibExecute(Sender: TObject);
begin
  { MyQuerySRC.SQL.Text := 'SELECT * FROM `uni_messages` WHERE project_no=:project_no AND rec_no=:rec_no';
    MyQuerySRC.ParamByName('rec_no').AsInteger := selectedMemo.Tag;
    MyQuerySRC.ParamByName('project_no').AsInteger := Project_no; //   
    MyQuerySRC.Active := true;
  }
  if selectedMemo = nil then
    exit;

  MyQueryDST.SQL.Text :=
    'INSERT INTO `uni_messageslib` (kind,dt,username,comment) VALUES(:kind,now(),:username,:comment)';
  MyQueryDST.ParamByName('kind').AsInteger := Tabs.TabIndex;
  MyQueryDST.ParamByName('username').AsString := frmMain.username;
  MyQueryDST.ParamByName('comment').AsString := selectedMemo.Text;
  MyQueryDST.ExecSQL;
  MyQueryDST.Close;

  UpdateTaskLib;
end;

procedure TfrmProject.actTasksCopyToLibUpdate(Sender: TObject);
begin
  actTasksCopyToLib.Enabled := (selectedMemo <> nil);
end;

procedure TfrmProject.actTasksDeleteExecute(Sender: TObject);
begin
  if (selectedMemo <> nil) and (MessageDlg('?', mtCustom, [mbYes, mbCancel], 0) = mrYes) then
  begin
    MyQuerySRC.SQL.Text := 'DELETE FROM `uni_messages` WHERE project_no=:project_no AND rec_no=:rec_no';
    MyQuerySRC.ParamByName('rec_no').AsInteger := selectedMemo.Tag;
    MyQuerySRC.ParamByName('project_no').AsInteger := Project_no; //   
    MyQuerySRC.ExecSQL;

    selectedMemo.HelpContext := -1;
    selectedMemo.Visible := false;

    Tabs.SetFocus;
    selectedMemo := nil;
  end;
end;

procedure TfrmProject.actTasksDeleteFromLibExecute(Sender: TObject);
var
  ta: string;
begin
  ta := '';
  if ListTaskLib.ItemIndex > -1 then
    ta := ListTaskLib.Items[ListTaskLib.ItemIndex];
  // delete
  MyQuery2.SQL.Text := 'DELETE FROM `uni_messageslib` WHERE `comment`=:comment;';
  MyQuery2.ParamByName('comment').AsString := ta;
  MyQuery2.ExecSQL;
  MyQuery2.Close;

  UpdateTaskLib;
end;

procedure TfrmProject.actTasksDeleteFromLibUpdate(Sender: TObject);
begin
  actTasksDeleteFromLib.Enabled := ListTaskLib.ItemIndex > -1;
end;

procedure TfrmProject.actTasksDeleteUpdate(Sender: TObject);
begin
  actTasksDelete.Enabled := (selectedMemo <> nil);
end;

procedure TfrmProject.actTasksRefreshExecute(Sender: TObject);
begin
  // full update
  selectedMemo := nil;
  updated_chat := 0;
  TasksHolder[Tabs.TabIndex].DestroyComponents;
  UpdateTasks;
end;

Procedure TfrmProject.actUnitsAddUpdate(Sender: TObject);
Begin
  actUnitsAdd.Enabled := (THardware.RecNo > 0) And TPrHardware.Active and (frmMain.usergroup.length > 1);;
End;

Procedure TfrmProject.actUnitsDeleteExecute(Sender: TObject);
Begin
  TPrHardware.Delete;
End;

Procedure TfrmProject.actUnitsDeleteUpdate(Sender: TObject);
Begin
  actUnitsDelete.Enabled := (TPrHardware.RecNo > 0) and (frmMain.usergroup.length > 1);
End;

Procedure TfrmProject.actUnitsEditUpdate(Sender: TObject);
Begin
  actUnitsEdit.Enabled := (TPrHardware.RecNo > 0);
End;

procedure TfrmProject.btnTasksSaveClick(Sender: TObject);
begin
  SaveTasks;
end;

procedure TfrmProject.SaveTasks;
var
  z, i: Integer;
  newMemo: TMemo;
  category_no: Integer;
begin
  //        
  for z := 0 to 2 do
    for i := 0 to TasksHolder[z].ComponentCount - 1 do
    begin
      newMemo := TMemo(TasksHolder[z].Components[i]);
      if (newMemo.Font.Color <> clWindowText) then
        try
          //   c 

          category_no := newMemo.HelpContext; // 0..2

          MyQuery2.SQL.Text :=
            'UPDATE `uni_messages` SET `comment`=:comment,`dt`=:dt,`username`=:username,`kind`=:kind WHERE `rec_no`=:rec_no';
          MyQuery2.ParamByName('rec_no').AsInteger := newMemo.Tag;
          MyQuery2.ParamByName('comment').AsString := newMemo.Lines.Text;
          MyQuery2.ParamByName('dt').AsDateTime := now;
          MyQuery2.ParamByName('username').AsString := frmMain.username;
          // MyQuery2.ParamByName('name').AsString := Tabs.Tabs[z];
          MyQuery2.ParamByName('kind').AsInteger := newMemo.HelpContext;
          MyQuery2.ExecSQL;

          newMemo.Font.Color := clWindowText;
        except
        end;
    end;

  MyQuery2.Close;
end;

procedure TfrmProject.UpdateTaskLib;
var
  comment, short: string;
  rec_no, no: Integer;
begin
  //   
  updated_lib := now;

  TMessageLib.SQL.Text :=
    'SELECT * FROM `uni_messageslib` WHERE kind=:kind AND (`comment` LIKE :f OR `short` LIKE :f) ORDER BY `orderby` LIMIT 200;';
  TMessageLib.ParamByName('kind').AsInteger := Tabs.TabIndex;
  TMessageLib.ParamByName('f').AsString := '%' + LibFilter.Text + '%';
  try
    if TMessageLib.Active then
      TMessageLib.Refresh
    else
      TMessageLib.Active := true;
  except
    showmessage('err');
  end;
  TMessageLib.first;
  ListTaskLib.Items.Clear;
  ListTaskLibRecno.Clear;
  ListTaskLibShort.Clear;
  while not TMessageLib.eof do
  begin
    // with ListTaskLib.Items.Add do
    begin
      comment := TMessageLib.FieldByName('comment').AsString;
      short := TMessageLib.FieldByName('short').AsString;
      rec_no := TMessageLib.FieldByName('rec_no').AsInteger;
      //
      ListTaskLib.Items.Add(comment);
      ListTaskLibRecno.Add(rec_no.ToString);
      ListTaskLibShort.Add(short);
    end;
    TMessageLib.Next;
  end;
end;

procedure TfrmProject.UpdateTasks;
var
  i, z, ftag: Integer;
  changeDT: string;
  newMemo: TMemo;
  category_no: Integer;
  fnd: Boolean;
begin
  if Project_no < 0 then
    exit;

  // caption:=random(10000000).ToString;

  TasksHolder[Tabs.TabIndex].Locked := true; //      
  //  
  QTasks.Active := false;
  QTasks.SQL.Text := 'SELECT * FROM `uni_messages` WHERE project_no=:project_no AND dt>:dt ORDER BY `orderby`';
  //
  // QTasks.ParamByName('name').AsString := Tabs.Tabs[Tabs.TabIndex];
  QTasks.ParamByName('project_no').AsInteger := Project_no;
  QTasks.ParamByName('dt').AsDateTime := updated_chat;
  QTasks.Active := true;

  //  Caption := QTasks.Recordcount.ToString + ' - ' + TasksHolder.ComponentCount.ToString;

  //    
  if QTasks.Recordcount > 0 then
    while not QTasks.eof do
      try
        frmMain.StatusBar.Panels[0].Text := TimeToStr(now) + ' : ' + TimeToStr(updated_chat);

        newMemo := nil;
        changeDT := ' ' + QTasks.FieldByName('username').AsString + ': ' +
          DateTimeToStr(QTasks.FieldByName('dt').AsDateTime);

        //   
        if updated_chat < QTasks.FieldByName('dt').AsDateTime then
          updated_chat := QTasks.FieldByName('dt').AsDateTime;

        for z := 0 to 2 do
          for i := 0 to TasksHolder[z].ComponentCount - 1 do
          begin
            if TMemo(TasksHolder[z].Components[i]).Tag = QTasks.FieldByName('rec_no').AsInteger then
            begin
              //  
              newMemo := TMemo(TasksHolder[z].Components[i]);
            end;
          end;

        if (newMemo <> nil) and (changeDT <> newMemo.HelpKeyword) and (newMemo.Font.Color = clWindowText) then
        begin
          //   
          //     
          newMemo.HelpKeyword := changeDT;
          newMemo.Lines.Text := QTasks.FieldByName('comment').AsString;
          newMemo.Hint := changeDT;
          newMemo.Font.Color := clWindowText;
          // newMemo
        end;

        category_no := QTasks.FieldByName('kind').AsInteger; // 0..2

        if newMemo = nil then
        begin
          maxorder := max(maxorder, QTasks.FieldByName('orderby').AsInteger);
          //   ,     
          newMemo := TMemo.Create(TasksHolder[category_no]);
          newMemo.Parent := TasksHolder[category_no];
          newMemo.Top := TasksHolder[category_no].Height; // tpos;
          newMemo.Height := 20;
          newMemo.AlignWithMargins := false;
          newMemo.Align := alTop;
          newMemo.Font.Color := clWindowText;
          newMemo.Tag := QTasks.FieldByName('rec_no').AsInteger;
          newMemo.Hint := changeDT;
          newMemo.OnChange := MemoEditorChange;
          newMemo.OnEnter := MemoEditorEnter;
          newMemo.OnExit := MemoEditorExit;
          newMemo.Lines.Text := QTasks.FieldByName('comment').AsString;
          // + ' s=' + QTasks.FieldByName('orderby').AsString;
          newMemo.StyleElements := [seFont, seBorder];
          newMemo.BorderStyle := bsSingle;
          newMemo.Color := clBtnFace;
          newMemo.PopupMenu := pmTasks;
          newMemo.HelpContext := category_no;
          newMemo.Visible := true;
          TasksHolder[category_no].Height := TasksHolder[category_no].Height + newMemo.Height;
          lastMemo := newMemo;
        end;

        QTasks.Next;
      except
        showmessage('err');
      end;

  TasksHolder[Tabs.TabIndex].Repaint;

  TasksHolderRecalcHeight;

  TasksHolder[Tabs.TabIndex].Locked := false;
end;

procedure TfrmProject.TabsClick(Sender: TObject);
var
  i: Integer;
begin
  Tabs.SetFocus;
  selectedMemo := nil;
  lastMemo := nil;

  TasksHolder[0].Visible := Tabs.TabIndex = 0;
  TasksHolder[1].Visible := Tabs.TabIndex = 1;
  TasksHolder[2].Visible := Tabs.TabIndex = 2;

  UpdateTaskLib;

  // TasksScrolls.Align:=alNone;
  // TasksScrolls.Align:=alClient;
  TasksScrolls.Width := TabSheetTasks.Width;
end;

Procedure TfrmProject.TasksHolderRecalcHeight;
var
  nh, i, z: Integer;
begin
  nh := 0;

  for z := 0 to 2 do
    try
      for i := 0 to TasksHolder[z].ComponentCount - 1 do
      begin
        if nh < TMemo(TasksHolder[z].Components[i]).BoundsRect.Bottom then
          nh := TMemo(TasksHolder[z].Components[i]).BoundsRect.Bottom;
      end;
      TasksHolder[z].Height := nh;
    except
      showmessage('error frmProject.TasksHolderRecalcHeight');
    end;
end;

Procedure TfrmProject.TotalSystemClick(Sender: TObject);
Begin
  // copy to buffer
  if Sender is TLabel then
    Clipboard.SetTextBuf(Pchar(TLabel(Sender).Caption));
End;

{
  Procedure TfrmProject.actSystemsDeleteExecute(Sender: TObject);
  Var
  System_no: Integer;
  FilterSQL: String;
  Begin
  showmessage('moved');
  exit;

  System_no := TPrSystems.FieldByName('rec_no').AsInteger;
  If (System_no > 0) And (Project_no > 0) Then
  Begin
  If frmSystemsDelete.ShowModal = mrOk Then
  Begin
  TPrSystems.Delete;
  Try
  FilterSQL := '`project_no`=' + IntToStr(Project_no) + ' AND `system_no`=' + IntToStr(System_no);
  MyQuerySRC.SQL.Text := 'DELETE FROM `uni_projecthardware` WHERE ' + FilterSQL;
  MyQuerySRC.Execute;
  Except
  End;
  RenewPrHardware;
  End;
  End;
  End; }

Procedure TfrmProject.RenewPrSystems;
var
  syspos: Integer;
begin
  updated_hardware := now; //   

  If not TPrSystems.Active and (Project_no > 0) Then
  begin
    TPrSystems.SQL.Text := 'SELECT * FROM uni_projectsystems WHERE `project_no`=' + IntToStr(Project_no) +
      ' ORDER BY `orderby`';
    TPrSystems.Active := true;
  end;
  // if TPrSystems.Active then    syspos := TPrSystems.FieldByName('rec_no').AsInteger;

  If TPrSystems.Active and (TPrSystems.State <> dsEdit) Then
  begin
    TPrSystems.Refresh;
    If TPrHardware.Active and (TPrHardware.State <> dsEdit) Then
      TPrHardware.Refresh;
  end;

  // ShowScrollBar(GridPrSystems.Handle, SB_VERT, false);
  // ShowScrollBar(GridPrSystems.Handle, SB_VERT, true);
end;

Procedure TfrmProject.RenewPrAtt;
var
  attpos: Integer;
begin
  if TPrAtt.Active then
    attpos := TPrAtt.FieldByName('rec_no').AsInteger;
  If Project_no > 0 Then
  begin
    TPrAtt.SQL.Text := 'SELECT * FROM uni_projectatt WHERE `project_no`=' + IntToStr(Project_no) +
      ' ORDER BY `lastupdate`,`name`';
    TPrAtt.Active := true;
  end;
  if attpos > 0 then
    TPrAtt.Locate('rec_no', attpos, []);

  // ShowScrollBar(GridPrAtt.Handle, SB_VERT, false);
  // ShowScrollBar(GridPrAtt.Handle, SB_VERT, true);
end;

Procedure TfrmProject.FormActivate(Sender: TObject);
Begin
  RenewProjectInfo;
  PagesChange(self);

  UpdateTasks;
  UpdateTaskLib;

  if frmTracker <> nil then
  begin
    frmTracker.ListOrders.Text := Project_name;
    frmTracker.ListSystems.Text := System_name;
  end;
End;

Procedure TfrmProject.RenewProjectInfo;
Var
  tmp: String;
begin
  If Project_no < 0 Then
    exit;

  updated_info := now; //   

  frmMain.StatusBar.Panels[1].Text := frmMain.current_projectname;
  if frmMain.current_projectsystemname <> '' then
    frmMain.StatusBar.Panels[1].Text := frmMain.current_projectname + ' / ' + frmMain.current_projectsystemname;

  If Project_no > 0 Then
  begin
    MyQuery2.SQL.Text := 'SELECT * FROM `uni_projects` WHERE rec_no=:rec_no;';
    MyQuery2.ParamByName('rec_no').AsInteger := Project_no;
    MyQuery2.Active := true;
    if MyQuery2.Recordcount > 0 then
    begin
      Project_name := MyQuery2.FieldByName('name').AsString;
      Project_description := MyQuery2.FieldByName('description').AsString;
      Project_customer := MyQuery2.FieldByName('owner_customer').AsString;
      Project_engineer := MyQuery2.FieldByName('owner_engineer').AsString;
      Project_manager := MyQuery2.FieldByName('owner_manager').AsString;
      Project_datestart := MyQuery2.FieldByName('datestart').AsDateTime;
      Project_dateend := MyQuery2.FieldByName('dateend').AsDateTime;
      Project_options := MyQuery2.FieldByName('options').AsString;
      Project_info := MyQuery2.FieldByName('info').AsString;
      Caption := ' ' + Project_name + ' (' + Project_customer + ')';
      // recent projects
      if frmMain.recent_projects.IndexOf(Caption) > -1 then
        frmMain.recent_projects.Delete(frmMain.recent_projects.IndexOf(Caption));
      frmMain.recent_projects.Insert(0, Caption);
    end
    else
      Close;
  end;

  If Project_no > 0 Then
    Try
      //  
      MyQuerySRC.SQL.Text := 'SELECT * FROM `uni_customers` WHERE `name`=' + QuotedStr(Project_customer) + ' LIMIT 1';
      MyQuerySRC.Active := true;
      If (MyQuerySRC.Recordcount > 0) Then
      Begin
        lblCustomer2.Caption := Project_customer;
        lblUserFio.Caption := MyQuerySRC.FieldByName('user_fio').AsString;
        If MyQuerySRC.FieldByName('kind').AsString <> '' Then
          lblCustomer2.Caption := MyQuerySRC.FieldByName('kind').AsString + ' ' + lblCustomer2.Caption;
        lblUser_Job.Caption := MyQuerySRC.FieldByName('user_job').AsString;
        lblPhone1.Caption := MyQuerySRC.FieldByName('phone_1').AsString;
        lblPhone2.Caption := MyQuerySRC.FieldByName('phone_2').AsString;
        lblEMail.Caption := MyQuerySRC.FieldByName('email').AsString;
        lblComment.Caption := MyQuerySRC.FieldByName('comment').AsString;
        //
      End;
    Except
    End;

  If Project_no > 0 Then
  begin
    lblName.Caption := Project_name;
    LabelOrderInfo.Caption := ' ' + Project_name;
    lblDescription.Caption := Project_description;
    lblCustomer.Caption := Project_customer;
    lblEngineer.Caption := Project_engineer;
    lblManager.Caption := Project_manager;
    lblProjectInfo.Text := Project_info;
    lblDateStart.Caption := DateToStr(Project_datestart);
    lblDateEnd.Caption := DateToStr(Project_dateend);
    Caption := ' ' + Project_name + ' (' + Project_customer + ')';
  end;

  { if _SearchDeveloper.Items.Count = 0 then
    Try
    //  
    _SearchDeveloper.Clear;
    MyQuerySRC.SQL.Text := 'SELECT `developer` FROM `uni_hardware` GROUP BY `developer`';
    MyQuerySRC.Active := true;
    While Not MyQuerySRC.eof Do
    Begin
    tmp := Trim(MyQuerySRC.Fields[0].AsString);
    If tmp <> '' Then
    _SearchDeveloper.Items.Add(MyQuerySRC.Fields[0].AsString);
    MyQuerySRC.Next;
    End;
    Except
    End;
  }

  ShowMarks;

  frmMain.current_projectno := Project_no;
  frmMain.current_projectname := Project_name;
  frmMain.current_projectcaption := Caption;
end;

Procedure TfrmProject.FormClose(Sender: TObject; Var Action: TCloseAction);
Begin
  try
    SaveTasks;
    Application.ProcessMessages;

    frmMain.StatusBar.Panels[1].Text := '';
    frmMain.current_projectno := -1;
    frmMain.current_projectname := '';
    frmMain.current_projectsystemno := -1;
    frmMain.current_projectsystemname := '';
    frmMain.current_projectsystemtag := '';

    Try
      If TPrSystems.State = dsEdit Then
        TPrSystems.Post;
      If TPrHardware.State = dsEdit Then
        TPrHardware.Post;
    Except
    End;
    Action := caFree;

    frmProject := nil;
  except
    showmessage('frmProject.FormClose');
  end;
End;

procedure TfrmProject.FormCreate(Sender: TObject);
begin
  try
    WindowState := frmMain.ws;
    Pages.ActivePage := TabSheetTasks;
    SystemsList := TstringList.Create;
    ListTaskLibRecno := TstringList.Create;
    ListTaskLibShort := TstringList.Create;
    updated_chat := IncYear(now, -5);
    updated_chat := 0;
    updated_lib := IncYear(now, -5);
    updated_info := IncYear(now, -5);
    updated_hardware := IncYear(now, -5);
    selectedMemo := nil;
    Project_no := -1;
    maxorder := 0;
    TasksHolder[0] := TasksHolder0;
    TasksHolder[1] := TasksHolder1;
    TasksHolder[2] := TasksHolder2;
  except
    showmessage('frmProject.FormCreate');
  end;
end;

procedure TfrmProject.FormDeactivate(Sender: TObject);
begin
  SetGlobal;
end;

procedure TfrmProject.FormDestroy(Sender: TObject);
begin
  SystemsList.Free;
  ListTaskLibRecno.Free;
  ListTaskLibShort.Free;
end;

Procedure TfrmProject.FormShow(Sender: TObject);
var
  h, w, d: double;
Begin
  if not frmUniversal.DBConnected then
    Close;

  frmNumEdit.Number.value := 1;

  // SearchCatalog.Caption := '';
  template_no := -1;
  //  
  lblProjectInfo.ReadOnly := (frmMain.usergroup.length < 5); //   
  //
  TimerUpdateChat.Enabled := true;
  DetectSize('Test 123 456 789 012', h, w, d);
End;

Procedure TfrmProject.GridPrAttDblClick(Sender: TObject);
Begin
  actPrAttOpen.Execute;
End;

Procedure TfrmProject.GridPrCertificatesDblClick(Sender: TObject);
Begin
  actPrCertificateOpen.Execute;
End;

procedure TfrmProject.GridPrHardwareCellClick(Column: TColumn);
begin
  ShowInfo;
end;

Procedure TfrmProject.GridPrHardwareDblClick(Sender: TObject);
Begin
  actUnitsEdit.Execute;
End;

Procedure TfrmProject.GridPrHardwareDragDrop(Sender, Source: TObject; X, Y: Integer);
Begin
  actUnitsAdd.Execute;
End;

Procedure TfrmProject.GridPrHardwareDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState;
  Var Accept: Boolean);
Begin
  // Accept := (Source = GridHardware);
End;

Procedure TfrmProject.GridPrHardwareDrawColumnCell(Sender: TObject; Const Rect: TRect; DataCol: Integer;
  Column: TColumn; State: TGridDrawState);
Begin
  If Column.FieldName = 'file' Then
    With GridPrHardware.Canvas Do
    Begin
      Brush.Color := clWhite;
      FillRect(Rect);
      If TPrHardware.FieldByName('file').AsString <> '' Then
      Begin
        GridPrHardware.Canvas.Brush.Color := clGrayText;
        Draw(round((Rect.Left + Rect.Right - frmMain.IconAttachment.Width) / 2), Rect.Top, frmMain.IconAttachment);
      End;
    End
  Else
    GridPrHardware.DefaultDrawColumnCell(Rect, DataCol, Column, State);
End;

procedure TfrmProject.GridPrHardwareEnter(Sender: TObject);
begin
  frmSequence.TQuerySRC.SQL.Text :=
    'SELECT rec_no,name,"" as tag,orderby FROM `uni_projecthardware` WHERE `project_no`=' + IntToStr(Project_no) +
    ' AND `system_no`=' + IntToStr(frmMain.current_projectsystemno) + ' ORDER BY `orderby`;'
end;

procedure TfrmProject.GridPrHardwareExit(Sender: TObject);
begin
  frmSequence.TQuerySRC.SQL.Text := '';
end;

Procedure TfrmProject.GridPrHardwareMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
Begin
  If (TPrHardware.RecNo > 0) And (ssCtrl In Shift) Then
    GridPrHardware.BeginDrag(true);
End;

Procedure TfrmProject.GridPrHardwareTitleBtnClick(Sender: TObject; ACol: Integer; Field: TField);
Begin
  { TPrHardware.IndexFieldNames := GridPrHardware.SortedField;
    if GridPrHardware.SortMarker = smDown then
    TPrHardware.IndexFieldNames := TPrHardware.IndexFieldNames + ' DESC';
  }
End;

Procedure TfrmProject.OrderChange(Sender: TObject);
Begin
  actOrderChange.Execute;
End;

procedure TfrmProject.lblProjectInfoChange(Sender: TObject);
begin
  // FixCommentSize;
end;

Procedure TfrmProject.lblShemaClick(Sender: TObject);
Begin
  frmProjectMarks.Project_options := Project_options;
  If frmProjectMarks.ShowModal = mrOk Then
  Begin
    Project_options := frmProjectMarks.Project_options;
  End;
  // save to database
  MyQuerySRC.SQL.Text := 'UPDATE `uni_projects` SET `options`=' + QuotedStr(Project_options) + ' WHERE rec_no=' +
    IntToStr(Project_no);
  MyQuerySRC.Execute;
  ShowMarks;
End;

procedure TfrmProject.N37Click(Sender: TObject);
begin
  RenewPrAtt;
end;

Procedure TfrmProject.ShowMarks;
Begin
  While length(Project_options) < 5 Do
    Project_options := Project_options + '0';
  If Project_options[1] = '1' Then
    lblShema.Caption := ''
  Else
    lblShema.Caption := '';
  If Project_options[2] = '1' Then
    lblSpecification.Caption := ''
  Else
    lblSpecification.Caption := '';
  If Project_options[3] = '1' Then
    lblOsobo.Caption := ''
  Else
    lblOsobo.Caption := '';
  If Project_options[4] = '1' Then
    lblAllForProject.Caption := ''
  Else
    lblAllForProject.Caption := '';
  If Project_options[5] = '1' Then
    lblFastProject.Caption := ''
  Else
    lblFastProject.Caption := '';
End;

Procedure TfrmProject.GridPrSystemsDblClick(Sender: TObject);
Begin
  SetGlobal;
  frmMain.actProjectSystemsEdit.Execute;
End;

procedure TfrmProject.GridPrSystemsEnter(Sender: TObject);
begin
  frmSequence.TQuerySRC.SQL.Text := 'SELECT rec_no,name,tag,orderby FROM `uni_projectsystems` WHERE `project_no`=' +
    IntToStr(Project_no) + ' ORDER BY `orderby`;'
end;

procedure TfrmProject.GridPrSystemsExit(Sender: TObject);
begin
  frmSequence.TQuerySRC.SQL.Text := '';
  If TPrSystems.State = dsEdit Then
    try
      TPrSystems.Post;
    except
    end;
end;

procedure TfrmProject.MemoEditorChange(Sender: TObject);
var
  LineHeight: Integer;
  DC: HDC;
  SaveFont: HFont;
  Metrics: TTextMetric;
  Increase: Integer;
  LC: Integer;
begin

  try
    DC := GetDC(TMemo(Sender).Handle);
    SaveFont := SelectObject(DC, TMemo(Sender).Font.Handle);
    GetTextMetrics(DC, Metrics);
    SelectObject(DC, SaveFont);
    ReleaseDC(TMemo(Sender).Handle, DC);

    LineHeight := Metrics.tmHeight;
    Increase := TMemo(Sender).Height;
    LC := TMemo(Sender).Lines.Count + 1;
    if LC < 1 then
      LC := 1;
    TMemo(Sender).Height := LC * LineHeight + 8;
    Increase := TMemo(Sender).Height - Increase;
    TMemo(Sender).Parent.Height := TMemo(Sender).Parent.Height + Increase;

    if not TasksHolder[Tabs.TabIndex].Locked then
    begin

      //  ,   
      TMemo(Sender).Font.Color := clBlue;
    end;
  except
    showmessage('MemoEditorChange');
  end;

end;

procedure TfrmProject.MemoEditorEnter(Sender: TObject);
begin
  try
    selectedMemo := TMemo(Sender);
    TMemo(Sender).Color := clWhite;
  except
    showmessage('MemoEditorEnter');

  end;
end;

procedure TfrmProject.MemoEditorExit(Sender: TObject);
begin
  try
    TMemo(Sender).Color := clBtnFace;
  except
    showmessage('MemoEditorExit');

  end;
end;

procedure TfrmProject.MouseWheelByOne(Sender: TObject; Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
  var Handled: Boolean);
var
  Direction: Shortint;
begin
  Direction := 1;
  if WheelDelta = 0 then
    exit
  else if WheelDelta > 0 then
    Direction := -1;

  Handled := true;
  with TJvDBGrid(Sender) do
  begin
    if Assigned(DataSource) and Assigned(DataSource.DataSet) then
      DataSource.DataSet.MoveBy(Direction);
    Invalidate;
  end;
end;

Procedure TfrmProject.OnlyArticulClick(Sender: TObject);
Begin
  TimerUpdateList.Enabled := true;
End;

procedure TfrmProject.TasksScrollsMouseWheel(Sender: TObject; Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
  var Handled: Boolean);
var
  ScrollBox: TScrollBox;
  NewPos: Integer;
begin
  ScrollBox := TScrollBox(Sender);

  NewPos := ScrollBox.VertScrollBar.Position - WheelDelta div 10; // sensitivity
  NewPos := max(NewPos, 0);
  NewPos := Min(NewPos, ScrollBox.VertScrollBar.Range);

  ScrollBox.VertScrollBar.Position := NewPos;
  Handled := true;
end;

procedure TfrmProject.TasksScrollsResize(Sender: TObject);
begin
  TasksHolder[Tabs.TabIndex].Top := 0;
  TasksHolder[Tabs.TabIndex].Left := 0;
  TasksHolder[Tabs.TabIndex].Width := TasksScrolls.Width - 20;
end;

Procedure TfrmProject.SearchCatalogClick(Sender: TObject);
Begin
  { If frmSelectKindHardware.ShowModal = mrOk Then
    Begin
    SearchCatalog.Caption := frmSelectKindHardware.template_name;
    template_no := frmSelectKindHardware.template_no;
    template_list := frmSelectKindHardware.template_list;
    End;
    If (template_no < 0) Then
    OnlyCategory.Checked := false;
    TimerUpdateList.Enabled := true;
  }
End;

Procedure TfrmProject.GridHardwareDblClick(Sender: TObject);
Var
  AMousePos: TPoint;
  ARow: Integer;
Begin
  //     
  { AMousePos := GridHardware.ScreenToClient(Mouse.CursorPos);
    ARow := GridHardware.MouseCoord(AMousePos.X, AMousePos.Y).Y;
    If ARow > 0 Then
    Begin
    actUnitsAdd.Execute;
    End;
  }
End;

Procedure TfrmProject.GridHardwareDragDrop(Sender, Source: TObject; X, Y: Integer);
Begin
  actUnitsDelete.Execute;
End;

Procedure TfrmProject.GridHardwareDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState;
  Var Accept: Boolean);
Begin
  Accept := (Source = GridPrHardware);
End;

Procedure TfrmProject.GridHardwareMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
Begin
  // If (THardware.RecNo > 0) And (ssCtrl In Shift) Then    GridHardware.BeginDrag(true);
End;

Procedure TfrmProject.GridHardwareTitleBtnClick(Sender: TObject; ACol: Integer; Field: TField);
Begin
  { THardware.IndexFieldNames := GridHardware.SortedField;
    If GridHardware.SortMarker = smDown Then
    THardware.IndexFieldNames := THardware.IndexFieldNames + ' DESC';
  }
End;

procedure TfrmProject.GridPrCertificatesDrawDataCell(Sender: TObject; const Rect: TRect; Field: TField;
  State: TGridDrawState);
begin
  try
    If TPrCertificates.FieldByName('expire').IsNull Then
    Begin
      GridPrCertificates.Canvas.Brush.Color := $00F08080;
    End
    else If TPrCertificates.FieldByName('expire').AsDateTime > (now() - 1) Then
    Begin
      GridPrCertificates.Canvas.Brush.Color := $00008000;
    End
    else
    begin
      GridPrCertificates.Canvas.Brush.Color := clRed; // $00000080;
    end;
  except
  end;

  GridPrCertificates.DefaultDrawDataCell(Rect, Field, State);
end;

procedure TfrmProject.PagesChange(Sender: TObject);
begin
  if not frmUniversal.DBConnected then
  begin
    showmessage('   ');
    Close;
    exit;
  end;
  //  
  if Pages.ActivePage = TabSheetInfo then
    RenewProjectInfo;
  if Pages.ActivePage = TabSheetHardware then
  begin
    RenewPrSystems;
  end;
  if Pages.ActivePage = TabSheetDocuments then
  begin
    TemplateListFill;
    RenewPrAtt;
    RenewPrCertificates;
  end;
  if Pages.ActivePage = TabSheetTasks then
  begin
    TabsClick(self);
    UpdateTasks;
  end;
end;

Procedure TfrmProject.PrHardwareAsShowedChange(Sender: TObject);
Begin
  RenewPrHardware;
End;

procedure TfrmProject.TPrSystemsAfterOpen(DataSet: TDataSet);
begin
  (TPrSystems.FieldByName('price') As TFloatField).DisplayFormat := ',0.00';
  (TPrSystems.FieldByName('total') As TFloatField).DisplayFormat := ',0.00';
  /// / ShowScrollBar(GridPrSystems.Handle, SB_VERT, false);
  /// / ShowScrollBar(GridPrSystems.Handle, SB_VERT, true);
end;

Procedure TfrmProject.TPrSystemsAfterPost(DataSet: TDataSet);
Begin
  frmUniversal.UpdateTotalQuery(TPrSystems.FieldByName('rec_no').AsInteger);
  RenewPrHardware;
End;

Procedure TfrmProject.SetGlobal;
begin
  if not TPrSystems.Active then
    exit;

  if TPrSystems.RecNo > 0 then
  begin
    system_no := TPrSystems.FieldByName('rec_no').AsInteger;
    System_name := TPrSystems.FieldByName('name').AsString;
    System_tag := TPrSystems.FieldByName('tag').AsString;
    frmMain.current_projectsystemno := system_no;
    frmMain.current_projectsystemname := System_name;
    frmMain.current_projectsystemtag := System_tag;

    frmMain.StatusBar.Panels[3].Text := frmMain.current_projectno.ToString + '/' +
      frmMain.current_projectsystemno.ToString;
  end
  else
  begin
    frmMain.current_projectsystemno := -1;
    frmMain.current_projectsystemname := '';
    frmMain.current_projectsystemtag := '';
  end;

  frmMain.StatusBar.Panels[1].Text := frmMain.current_projectname + ' / ' + frmMain.current_projectsystemname;
end;

Procedure TfrmProject.TPrSystemsAfterScroll(DataSet: TDataSet);
Begin
  SetGlobal;
  RenewPrHardware;

  if frmTracker <> nil then
  begin
    frmTracker.ListOrders.Text := Project_name;
    frmTracker.ListSystems.Text := System_name;
  end;

End;

Procedure TfrmProject._SearchChange(Sender: TObject);
Begin
  TimerUpdateList.Enabled := true;
End;

Procedure TfrmProject.UpdateHardwareList;
Var
  filter: String;
  searchkey: String;
  RU, EN: string;
Begin
  { searchkey := Trim(_Search.Text);
    If searchkey <> '' Then
    Begin
    EN := frmMain.TransformToEN(searchkey);
    RU := frmMain.TransformToRU(searchkey);
    filter := '(`article` LIKE ' + QuotedStr('%' + searchkey + '%');
    filter := filter + ' OR `name` LIKE ' + QuotedStr('%' + searchkey + '%');
    filter := filter + ' OR `name` LIKE ' + QuotedStr('%' + EN + '%');
    filter := filter + ' OR `name` LIKE ' + QuotedStr('%' + RU + '%');
    filter := filter + ' OR `comment` LIKE ' + QuotedStr('%' + searchkey + '%');
    filter := filter + ')';
    End;
    If OnlyCategory.Checked Then
    Begin
    If filter <> '' Then
    filter := filter + ' AND ';
    filter := filter + '`kind` IN (' + template_list + ')';
    End;
    If (_SearchDeveloper.Text <> '') Then
    Begin
    If filter <> '' Then
    filter := filter + ' AND ';
    filter := filter + '`developer`=' + QuotedStr(_SearchDeveloper.Text);
    End;

    THardware.filter := filter;
    THardware.IndexFieldNames := GridHardware.SortedField;
    If GridHardware.SortMarker = smDown Then
    THardware.IndexFieldNames := THardware.IndexFieldNames + ' DESC';
    THardware.Active := true;

    // (THardware.FieldByName('price') As TFloatField).DisplayFormat := ',0.00.00';
    TimerUpdateHardwareInfo.Enabled := true;
  }
End;

procedure TfrmProject.actUnitReplaceUpdate(Sender: TObject);
begin
  actUnitReplace.Enabled := (TPrHardware.RecNo > 0) and (frmMain.usergroup.length > 1);
end;

Procedure TfrmProject.actUnitsAddExecute(Sender: TObject);
Var
  system_no: Integer;
Begin
  // THardware > TPrHardware
  TPrHardware.DisableControls;
  Try
    system_no := TPrSystems.FieldByName('rec_no').AsInteger;
    TPrHardware.Append;
    TPrHardware.FieldByName('project_no').AsInteger := Project_no;
    TPrHardware.FieldByName('system_no').AsInteger := system_no;
    TPrHardware.FieldByName('article').AsString := THardware.FieldByName('article').AsString;
    TPrHardware.FieldByName('kinddesc').AsString := THardware.FieldByName('kinddesc').AsString;
    TPrHardware.FieldByName('name').AsString := THardware.FieldByName('name').AsString;
    TPrHardware.FieldByName('comment').AsString := THardware.FieldByName('comment').AsString;
    TPrHardware.FieldByName('price').AsFloat := THardware.FieldByName('price').AsFloat;
    TPrHardware.FieldByName('count').AsInteger := 1;
    TPrHardware.FieldByName('valuta').AsString := THardware.FieldByName('valuta').AsString;
    TPrHardware.FieldByName('file').AsString := THardware.FieldByName('file').AsString;
    TPrHardware.FieldByName('developer').AsString := THardware.FieldByName('developer').AsString;
    TPrHardware.FieldByName('modules').AsString := THardware.FieldByName('modules').AsString;
    TPrHardware.FieldByName('expire').AsDateTime := THardware.FieldByName('expire').AsDateTime;
    // inc(maxorderby);
    // TPrHardware.FieldByName('orderby').AsInteger := maxorderby;
    TPrHardware.Post;
    TPrHardware.Edit;
    TPrHardware.FieldByName('orderby').AsInteger := TPrHardware.FieldByName('rec_no').AsInteger;
    TPrHardware.Post;
  Except
  End;
  TPrHardware.Refresh;
  TPrHardware.last;
  { TPrHardware.Locate('article;price',
    VarArrayOf([THardware.FieldByName('article').AsString,
    THardware.FieldByName('price').AsFloat]), []);
  }
  //
  TPrHardware.EnableControls;
End;

Procedure TfrmProject.THardwareAfterOpen(DataSet: TDataSet);
Begin
  (THardware.FieldByName('price') As TFloatField).DisplayFormat := ',0.00';
  (THardware.FieldByName('total') As TFloatField).DisplayFormat := ',0.00';
  // ShowScrollBar(GridHardware.Handle, SB_VERT, false);
  // ShowScrollBar(GridHardware.Handle, SB_VERT, true);
End;

Procedure TfrmProject.THardwareAfterScroll(DataSet: TDataSet);
Begin
  // UpdateAtt;
  TimerUpdateHardwareInfo.Enabled := false;
  TimerUpdateHardwareInfo.Enabled := true;
End;

procedure TfrmProject.TimerRepDownTimer(Sender: TObject);
begin
  // Caption := random(100000).ToString + '-4';
  actHardwareDown.Execute;
end;

procedure TfrmProject.TimerRepSystemDownTimer(Sender: TObject);
begin
  { if ((TPrSystems.RecNo < TPrSystems.Recordcount) And (TPrSystems.Recordcount > 1)) and (frmMain.usergroup.length > 1)
    then
    actSystemDown.Execute
    else
    TimerRepSystemDown.Enabled := false; }
end;

procedure TfrmProject.TimerRepSystemUpTimer(Sender: TObject);
begin
  {
    if (TPrSystems.RecNo > 1) and (frmMain.usergroup.length > 1) then
    actSystemUp.Execute
    else
    TimerRepSystemUp.Enabled := false; }
end;

procedure TfrmProject.TimerRepUpTimer(Sender: TObject);
begin
  // Caption := random(100000).ToString + '-3';
  actHardwareUp.Execute;
end;

procedure TfrmProject.TimerSumRecalcTimer(Sender: TObject);
begin
  TimerSumRecalc.Enabled := false;
  SumRecalc2;
end;

procedure TfrmProject.TimerUpdateChatTimer(Sender: TObject);
begin
  //     
  if not frmUniversal.DBConnected then
    exit;

  if self <> frmMain.ActiveMDIChild then
    exit;

  if (Pages.ActivePage = TabSheetTasks) { and (SecondsBetween(updated_chat, now) > 60) } then
    UpdateTasks;

  // if (Pages.ActivePage = TabSheetTasks) { and (SecondsBetween(updated_lib, now) > 360) } then    UpdateTaskLib;

  if (Pages.ActivePage = TabSheetHardware) { and (SecondsBetween(updated_hardware, now) > 60) } then
  begin
    if not(GridPrSystems.Focused or GridPrHardware.Focused) then
      exit;
    // application.Title := IntToStr(Random(1000000));
    RenewPrSystems;
  end;

end;

Procedure TfrmProject.TimerUpdateHardwareInfoTimer(Sender: TObject);
Begin
  TimerUpdateHardwareInfo.Enabled := false;
  UpdateAtt;
End;

Procedure TfrmProject.UpdateAtt;
Begin
  TAtt.Active := false;
  If THardware.Active And (THardware.RecNo > 0) Then
  Begin
    // TAtt.SQL.Text := 'SELECT * FROM `uni_attachment` WHERE parent=:rec_no';
    TAtt.ParamByName('rec_no').AsInteger := THardware.FieldByName('rec_no').AsInteger;
    TAtt.Active := true;
  End;
End;

Procedure TfrmProject.TimerUpdateListT(Sender: TObject);
Begin
  TimerUpdateList.Enabled := false;
  UpdateHardwareList;
End;

procedure TfrmProject.ToolButton2MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  // run autorepeat
  // TimerRepSystemUp.Enabled := true;
end;

procedure TfrmProject.ToolButton2MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  // TimerRepSystemUp.Enabled := false;
end;

procedure TfrmProject.ToolButton3MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  // TimerRepSystemDown.Enabled := true;
end;

procedure TfrmProject.ToolButton3MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  // TimerRepSystemDown.Enabled := false;
end;

procedure TfrmProject.ToolButton6MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  // run autorepeat
  // TimerRepUp.Enabled := true;
end;

procedure TfrmProject.ToolButton6MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  // TimerRepUp.Enabled := false;
end;

procedure TfrmProject.ToolButton7MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  // TimerRepDown.Enabled := true;
end;

procedure TfrmProject.ToolButton7MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  // TimerRepDown.Enabled := false;
end;

procedure TfrmProject.TPrAttAfterOpen(DataSet: TDataSet);
begin
  // ShowScrollBar(GridPrAtt.Handle, SB_VERT, false);
  // ShowScrollBar(GridPrAtt.Handle, SB_VERT, true);
end;

procedure TfrmProject.TPrCertificatesAfterOpen(DataSet: TDataSet);
begin
  // ShowScrollBar(GridPrCertificates.Handle, SB_VERT, false);
  // ShowScrollBar(GridPrCertificates.Handle, SB_VERT, true);
end;

Procedure TfrmProject.TPrHardwareAfterDelete(DataSet: TDataSet);
Begin
  SumRecalc;
End;

procedure TfrmProject.TPrHardwareAfterInsert(DataSet: TDataSet);
begin
  SumRecalc;
end;

Procedure TfrmProject.TPrHardwareAfterOpen(DataSet: TDataSet);
Begin
  (TPrHardware.FieldByName('price') As TFloatField).DisplayFormat := ',0.00';
  (TPrHardware.FieldByName('total') As TFloatField).DisplayFormat := ',0.00';
  // ShowScrollBar(GridPrHardware.Handle, SB_VERT, false);
  // ShowScrollBar(GridPrHardware.Handle, SB_VERT, true);
End;

procedure TfrmProject.TPrHardwareAfterPost(DataSet: TDataSet);
begin
  frmUniversal.UpdateTotalQuery(TPrSystems.FieldByName('rec_no').AsInteger);
  SumRecalc;
  frmMain.Log(2, 'uni_projecthardware', Project_name, System_name, TPrHardware.FieldByName('article').AsString);
  TPrHardware.Refresh;
end;

procedure TfrmProject.TPrHardwareAfterRefresh(DataSet: TDataSet);
begin
  SumRecalc;
end;

procedure TfrmProject.ShowInfo;
var
  info: string;
begin
  If TPrHardware.RecNo > 0 Then
  begin
    info := ' : ' + TPrHardware.FieldByName('username').AsString + ' / ' +
      DateTimeToStr(TPrHardware.FieldByName('lastupdate').AsDateTime);
    if (TPrHardware.FieldByName('lastupdate').AsDateTime = 0) then
      info := '';
  end
  else
  begin
    // frmMain.current_projecthardwareno := -1;
    info := '';
  end;
  frmMain.StatusBar.Panels[2].Text := info;
end;

procedure TfrmProject.TPrHardwareAfterScroll(DataSet: TDataSet);
begin
  ShowInfo;
end;

procedure TfrmProject.TPrHardwareBeforeDelete(DataSet: TDataSet);
begin
  frmMain.Log(3, 'uni_projecthardware', Project_name, System_name, TPrHardware.FieldByName('article').AsString);
end;

Procedure TfrmProject.TPrHardwareCalcFields(DataSet: TDataSet);
Begin
  TPrHardware.FieldByName('total').value := TPrHardware.FieldByName('price').value *
    TPrHardware.FieldByName('count').value;
  TPrHardware.FieldByName('lastupdate').AsDateTime := now();
  TPrHardware.FieldByName('username').AsString := frmMain.username;
End;

Procedure TfrmProject.actPrAttAddExecute(Sender: TObject);
Var
  fn, newfilename: String;
  cnt, i: Integer;
  bm: TBookmark;
  d: String;
Begin
  dlgOpen.Title := '   ';

  //  
  If dlgOpen.Execute Then
  Begin
    fn := dlgOpen.FileName;
    If FileExists(fn) Then
    Begin
      newfilename := frmUniversal.FileSaveToFB(fn);
    End;
  End;

  //   
  If pos(' ', newfilename) < 1 Then
  Begin
    //
    TPrAtt.Append;
    TPrAtt.FieldByName('project_no').AsInteger := Project_no;
    TPrAtt.FieldByName('file').AsString := newfilename;
    TPrAtt.FieldByName('lastupdate').AsDateTime := now();
    TPrAtt.FieldByName('name').AsString := ExtractFileName(fn);
    TPrAtt.Post;
  End;

End;

Procedure TfrmProject.actJoinArticleExecute(Sender: TObject);
Var
  system_no: Integer;
  article: String;
  Count: Integer;
  bm: TBookmark;
  i, RecNo: Integer;
Begin
  TPrHardware.DisableControls;
  Try
    bm := THardware.GetBookmark;
  Except
  End;
  system_no := TPrHardware.FieldByName('system_no').AsInteger;
  For RecNo := TPrHardware.Recordcount Downto 1 Do
  Begin
    TPrHardware.RecNo := RecNo;
    article := TPrHardware.FieldByName('article').AsString;
    Count := TPrHardware.FieldByName('count').AsInteger;
    TPrHardware.Locate('article', article, []);
    If TPrHardware.RecNo <> RecNo Then
    Begin
      //  `count`
      TPrHardware.Edit;
      TPrHardware.FieldByName('count').AsInteger := TPrHardware.FieldByName('count').AsInteger + Count;
      TPrHardware.Post;
      TPrHardware.RecNo := RecNo;
      TPrHardware.Delete;
    End;
  End;
  Try
    THardware.GotoBookmark(bm);
    THardware.FreeBookmark(bm);
  Except
  End;
  TPrHardware.EnableControls;
End;

{
  Procedure TfrmProject.actStage1Execute(Sender: TObject);
  Var
  _kind, _name, _opts: String;
  _act: Boolean;
  msg: String;
  Begin
  msg := '';
  If frmStage2.ShowModal = mrOk Then
  Begin
  RenewPrSystems;
  TPrSystems.first;
  If frmStage2.EnableDocumentation.Checked or frmStage2.EnableTemplates.Checked Then
  //   
  While Not TPrSystems.eof And (msg = '') Do
  Begin
  _kind := TPrSystems.FieldByName('kind').AsString;
  _name := TPrSystems.FieldByName('name').AsString;
  _opts := TPrSystems.FieldByName('opts').AsString;
  _act := TPrSystems.FieldByName('active').AsBoolean;
  if _act then
  begin
  If length(_kind) < 2 Then
  Begin
  msg := '.    ';
  If Name <> '' Then
  Begin
  msg := msg + ' (' + _name + ')';
  showmessage(msg);
  frmMain.actProjectSystemsEdit.Execute;
  End;
  End
  Else If length(_opts) < 2 Then
  Begin
  msg := '.      ';
  If Name <> '' Then
  Begin
  msg := msg + ' (' + _name + ')';
  showmessage(msg);
  actSystemsOpts.Execute;
  End;
  End;
  end;
  TPrSystems.Next;
  End;
  If msg = '' Then
  Begin
  //   
  frmStage1.EnableSpecification := frmStage2.EnableSpecification.Checked;
  frmStage1.EnableDocumentation := frmStage2.EnableDocumentation.Checked;
  frmStage1.EnableTemplates := frmStage2.EnableTemplates.Checked;
  frmStage1.Project_no := Project_no;
  frmStage1.ListInfo.Clear;
  frmStage1.ShowModal;
  RenewPrAtt;
  End;
  End;
  End;

  procedure TfrmProject.actStage1Update(Sender: TObject);
  begin
  actStage1.Enabled := (frmMain.usergroup.length > 1);
  end;
}

procedure TfrmProject.actSummaryExecute(Sender: TObject);
var
  NewCaption: string;
begin
  //   
  NewCaption := ' ' + Project_name + ' (' + Project_customer + ') - ';
  If Not frmMain.MDIExists(NewCaption) Then
    With TfrmProjectSummary.Create(Application) Do
    Begin
      Caption := NewCaption;
      _Project_no := Project_no;
      _Project_name := Project_name;
      FormActivate(self);
    End;
end;

Procedure TfrmProject.actHardwareUpUpdate(Sender: TObject);
Begin
  actHardwareUp.Enabled := (TPrHardware.RecNo > 1) and (frmMain.usergroup.length > 1);
  // if not actHardwareUp.Enabled then    TimerRepUp.Enabled := false;
End;

procedure TfrmProject.actCommentLoadExecute(Sender: TObject);
begin
  lblProjectInfo.Text := Project_info;
end;

procedure TfrmProject.actCommentLoadUpdate(Sender: TObject);
begin
  actCommentLoad.Enabled := (lblProjectInfo.Text <> Project_info);
end;

procedure TfrmProject.actCommentSaveExecute(Sender: TObject);
begin
  // FixCommentSize;
  Project_info := lblProjectInfo.Text;
  // save to database
  Try
    MyQuerySRC.SQL.Text := 'UPDATE `uni_projects` SET `info`=' + QuotedStr(Project_info) + ' WHERE rec_no=' +
      IntToStr(Project_no);
    MyQuerySRC.Execute;
  Except
  End;
end;

procedure TfrmProject.actCommentSaveUpdate(Sender: TObject);
begin
  actCommentSave.Enabled := (lblProjectInfo.Text <> Project_info);
end;

Procedure TfrmProject.actHardwareDownUpdate(Sender: TObject);
Begin
  actHardwareDown.Enabled := ((TPrHardware.RecNo < TPrHardware.Recordcount) And (TPrHardware.Recordcount > 1)) and
    (frmMain.usergroup.length > 1);
  // if not actHardwareDown.Enabled then    TimerRepDown.Enabled := false;
End;

procedure TfrmProject.actPriceUpdateUpdate(Sender: TObject);
begin
  actPriceUpdate.Enabled := (frmMain.usergroup.length > 1);
end;

procedure TfrmProject.actSystemsCertificateUpdate(Sender: TObject);
begin
  actSystemsCertificate.Enabled := (TPrSystems.Recordcount > 1) and (frmMain.usergroup.length > 1);
end;

Procedure TfrmProject.actSystemsOptsExecute(Sender: TObject);
Begin
  //       
  if SystemsCheckOk then
  begin
    frmSystemsOptEdit.kind := uppercase(TPrSystems.FieldByName('kind').AsString);
    frmSystemsOptEdit.Opts.Text := TPrSystems.FieldByName('opts').AsString;
    If frmSystemsOptEdit.ShowModal = mrOk Then
    begin
      try
        TPrSystems.Edit;
        TPrSystems.FieldByName('opts').AsString := frmSystemsOptEdit.Opts.Text;
        TPrSystems.Post;
      except
      End;
      if frmSystemsOptEdit.UseAutoCalc.Checked then
        SystemOptAutoCalc;
    end;
  end
  else
    showmessage('     ');
End;

function TfrmProject.SystemsCheckOk: Boolean;
var
  lpos: Integer;
  res: Boolean;
begin
  res := true;
  lpos := TPrSystems.FieldByName('rec_no').AsInteger;
  try
    TPrSystems.DisableControls;
    TPrSystems.first;
    while not TPrSystems.eof do
    begin
      if TPrSystems.FieldByName('kind').AsString = '' then
        res := false;
      TPrSystems.Next;
    end;
    TPrSystems.Locate('rec_no', lpos, []);
  except
  end;
  TPrSystems.EnableControls;
  result := res;
end;

function TfrmProject.GetEmptyTemplate(kind: string): string;
var
  res: TStrings;
begin
  res := TstringList.Create;
  res.Clear;
  //     
  try
    MyQuerySRC.SQL.Text := 'SELECT `name` FROM uni_systemsopts WHERE kind=' + QuotedStr(kind) + ' ORDER BY name';
    MyQuerySRC.Active := true;
    while not MyQuerySRC.eof do
    begin
      res.Add(MyQuerySRC.FieldByName('name').AsString + '=');
      MyQuerySRC.Next;
    end;
    MyQuerySRC.Active := false;
  except
  end;
  result := res.Text;
  // ShowMessage(res.Text);
  res.Free;
end;

Procedure TfrmProject.FixCommentSize;
var
  i: Integer;
  cline, nline: string;
  X, Y: Integer;
begin
  for i := 0 to lblProjectInfo.Lines.Count - 1 do
  begin
    if length(lblProjectInfo.Lines[i]) > 62 then
    begin
      X := lblProjectInfo.SelStart;
      Y := lblProjectInfo.SelLength;
      cline := copy(lblProjectInfo.Lines[i], 0, 62);
      nline := copy(lblProjectInfo.Lines[i], 63);
      lblProjectInfo.Lines[i] := cline;
      if i = lblProjectInfo.Lines.Count - 1 then
      begin
        lblProjectInfo.Lines.Add(nline);
      end
      else
      begin
        lblProjectInfo.Lines[i + 1] := nline + lblProjectInfo.Lines[i + 1];
      end;
      lblProjectInfo.SelStart := X;
      lblProjectInfo.SelLength := Y;
    end;
  end;
end;

Procedure TfrmProject.RenewPrHardware;
var
  hardpos: Integer;
  system_no: Integer;
  SQL: string;
begin
  LastSystemRecNo := TPrSystems.RecNo;
  If (Project_no > 0) Then
  Begin
    //   
    If TPrSystems.RecNo > 0 Then
    Begin
      system_no := TPrSystems.FieldByName('rec_no').AsInteger;
    End
    Else
    begin
      system_no := -1;
      TPrHardware.Active := false;
    end;
  end
  Else
  Begin
    TPrHardware.Active := false;
  End;

  If (Project_no > 0) and (system_no > 0) Then
  Begin
    if TPrHardware.Tag <> system_no then
    begin
      TPrHardware.Tag := system_no;
      TPrHardware.SQL.Text := 'SELECT *, `price`*`count` as `total` FROM uni_projecthardware WHERE `project_no`=' +
        IntToStr(Project_no) + ' AND `system_no`=' + IntToStr(system_no) + ' ORDER BY `orderby`;';
      TPrHardware.Active := true;
    end
    else
      TPrHardware.Refresh;
  End
  Else
  Begin
    TPrHardware.Active := false;
  End;

  SumRecalc;
end;

procedure TfrmProject.actUnitReplaceExecute(Sender: TObject);
begin
  frmHardwareReplace.WhatId := TPrHardware.FieldByName('rec_no').AsInteger;
  frmHardwareReplace.WhatByName.Text := TPrHardware.FieldByName('name').AsString;
  frmHardwareReplace.WhatByArticle.Text := TPrHardware.FieldByName('article').AsString;
  frmHardwareReplace.Project_no := Project_no;
  frmHardwareReplace.system_no := TPrSystems.FieldByName('rec_no').AsInteger;
  frmHardwareReplace.ShowModal;
  RenewPrHardware;
end;

Procedure TfrmProject.SystemOptAutoCalc;
var
  CurOpt: TStrings;
  lpos, rpos: Integer;
  i: Integer;
  t_name, t_tmpvalue, t_autofill: string;
  changed: Boolean;
  n_value: string;
Begin
  //  
  CurOpt := TstringList.Create;
  lpos := TPrSystems.FieldByName('rec_no').AsInteger;
  //      
  //       
  // *****
  MyQuery2.SQL.Text := TPrSystems.SQL.Text;
  MyQuery2.Active := true;
  while not MyQuery2.eof do
    try
      changed := false;
      CurOpt.Text := MyQuery2.FieldByName('opts').AsString;
      if CurOpt.Count = 0 then
        CurOpt.Text := GetEmptyTemplate(MyQuery2.FieldByName('kind').AsString);
      //      
      if frmSystemsOptEdit.UseReset.Checked then
      begin
        frmSystemsOptEdit.TData.first;
        While Not frmSystemsOptEdit.TData.eof Do
        begin
          t_autofill := frmSystemsOptEdit.TData.FieldByName('autofill').AsString;
          t_tmpvalue := frmSystemsOptEdit.TData.FieldByName('tmpvalue').AsString;
          t_name := frmSystemsOptEdit.TData.FieldByName('name').AsString;
          if (t_autofill = 'COPY') or (t_autofill = 'AUTOINC') then
          begin
            for i := 0 to CurOpt.Count - 1 do
            begin
              if pos(t_name + '=', CurOpt[i]) > 0 then
                CurOpt[i] := t_name + '=';
            end;
          end;
          frmSystemsOptEdit.TData.Next;
        end;
      end;
      //   
      frmSystemsOptEdit.TData.first;
      While Not frmSystemsOptEdit.TData.eof Do
      begin
        t_autofill := frmSystemsOptEdit.TData.FieldByName('autofill').AsString;
        t_tmpvalue := frmSystemsOptEdit.TData.FieldByName('tmpvalue').AsString;
        t_name := frmSystemsOptEdit.TData.FieldByName('name').AsString;
        if (t_autofill = 'COPY') or (t_autofill = 'AUTOINC') then
        begin
          if (t_tmpvalue <> '') then
          begin
            changed := true;
            rpos := CurOpt.IndexOf(t_name + '=');
            for i := 0 to CurOpt.Count - 1 do
            begin
              // if copy(CurOpt[i], 0, length(t_name) + 1) = t_name + '=' then
              if CurOpt[i] = t_name + '=' then
              begin
                //       
                // ShowMessage('found: ' + t_name);
                if (t_autofill = 'COPY') then
                  CurOpt[i] := t_name + '=' + t_tmpvalue;
                if (t_autofill = 'AUTOINC') then
                begin
                  n_value := frmMain.GetNextValue(t_tmpvalue);
                  CurOpt[i] := t_name + '=' + n_value;
                  try
                    frmSystemsOptEdit.TData.Edit;
                    frmSystemsOptEdit.TData.FieldByName('tmpvalue').AsString := n_value;
                    frmSystemsOptEdit.TData.Post;
                  except
                    //    
                  end;
                end;
              end
              else
              begin
                //        
                //
              end;
            end;
          end;
        end;
        frmSystemsOptEdit.TData.Next;
      end;
      // 
      if changed then //  
        try
          MyQuery2.Edit;
          MyQuery2.FieldByName('opts').AsString := CurOpt.Text;
          MyQuery2.Post;
        except
        end;

      MyQuery2.Next;
    except
    end;
  try
    TPrSystems.DisableControls;
    TPrSystems.Refresh;
    // TPrSystems.Locate('rec_no', lpos, []);
    TPrSystems.EnableControls;
  except
  end;
  CurOpt.Free;
end;

{
  if TDBGrid(Sender).DataSource.DataSet.RecNo = LastSystemRecNo then
  begin
  TDBGrid(Sender).Canvas.Brush.Color := clSilver;
  TDBGrid(Sender).Canvas.Font.Color := clBlack;
  end;
  if (gdSelected in State) then
  begin
  TDBGrid(Sender).Canvas.Brush.Color := clGray;
  TDBGrid(Sender).Canvas.Font.Color := clBlack;
  end;
  if (gdFocused in State) then
  begin
  TDBGrid(Sender).Canvas.Brush.Color := clHighlight;
  TDBGrid(Sender).Canvas.Font.Color := clHighlightText;
  end;

  // TDBGrid(Sender).DefaultDrawDataCell(Rect, Field, State);
  TDBGrid(Sender).DefaultDrawColumnCell(Rect, DataCol, Column, State);

}

procedure TfrmProject.N40Click(Sender: TObject);
begin
  frmTableSets.WhereTable := GridPrSystems;
  frmTableSets.ShowModal;
end;

procedure TfrmProject.N41Click(Sender: TObject);
begin
  frmTableSets.WhereTable := GridPrHardware;
  frmTableSets.ShowModal;
end;

procedure TfrmProject.N42Click(Sender: TObject);
begin
  // frmTableSets.WhereTable := GridHardware;
  frmTableSets.ShowModal;
end;

procedure TfrmProject.N56Click(Sender: TObject);
begin
  frmUniversal.RecalcOverpriceForProject(Project_no, false);
end;

procedure TfrmProject.N57Click(Sender: TObject);
begin
  frmUniversal.RecalcOverpriceForProject(Project_no, true);
end;

procedure TfrmProject.N58Click(Sender: TObject);
begin
  frmUniversal.UpdateTotalQuery(TPrSystems.FieldByName('rec_no').AsInteger);
end;

procedure TfrmProject.miAutoPassportClick(Sender: TObject);
begin
  frmAutoPassport.ShowModal;
end;

procedure TfrmProject.SystemsListRebuild;
begin
  SystemsList.Clear;
  try
    MyQuerySRC.SQL.Text := 'SELECT `name` FROM `uni_projectsystems` WHERE `project_no`=' + IntToStr(Project_no) +
      ' ORDER BY `orderby`;';
    MyQuerySRC.Active := true;
    while not MyQuerySRC.eof do
    begin
      SystemsList.Add(MyQuerySRC.FieldByName('name').AsString);
      MyQuerySRC.Next;
    end;
  except
  end;
end;

procedure TfrmProject.actReportCreateExecute(Sender: TObject);
var
  system_no: Integer;
begin
  try
    system_no := TPrSystems.FieldByName('rec_no').AsInteger;
  except
    exit;
  end;
  //  
  if TPrSystems.RecNo > 0 then
  begin
    frmReportSelect.reportkind := TPrSystems.FieldByName('kind').AsString;
    if frmReportSelect.ShowModal = mrOk then
    begin
      Data.reportkind := frmReportSelect.reportkind;
      Data.reportname := frmReportSelect.reportname;
      Data.Project_no := Project_no;
      Data.system_no := system_no;
      Data.DoReport;
    end;
  end;
end;

Procedure TfrmProject.SumRecalc;
Begin
  //    
  TimerSumRecalc.Enabled := false;
  TimerSumRecalc.Enabled := true;
End;

Procedure TfrmProject.SumRecalc2;
Var
  FilterSQL: String;
Begin
  if (TPrSystems.State = dsEdit) then
    exit;
  If (Project_no < 0) or (frmMain.current_projectsystemno < 0) Then
  begin
    TotalModules.Caption := '  : 0';
    TotalSystem.Caption := '  : 0';
    TotalProject.Caption := '  : 0';
    TotalActive.Caption := '   : 0';
    exit;
  end;

  // update overprice

  try // TotalModules.Caption := '  : 0';
    MyQuerySRC.SQL.Text :=
      'SELECT SUM(modules*count) FROM `uni_projecthardware` WHERE `project_no`=:project_no AND `system_no`=:system_no';
    MyQuerySRC.ParamByName('project_no').AsInteger := Project_no;
    MyQuerySRC.ParamByName('system_no').AsInteger := frmMain.current_projectsystemno;
    MyQuerySRC.Active := true;
    TotalModules.Caption := '  : ' + FloatToStrF(MyQuerySRC.Fields[0].AsFloat, ffGeneral, 4, 0);

    // TotalNeModules.Caption := ' DIN : 0';
    MyQuerySRC.SQL.Text :=
      'SELECT COUNT(rec_no) FROM `uni_projecthardware` WHERE `project_no`=:project_no AND `system_no`=:system_no AND `din`=2';
    MyQuerySRC.ParamByName('project_no').AsInteger := Project_no;
    MyQuerySRC.ParamByName('system_no').AsInteger := frmMain.current_projectsystemno;
    MyQuerySRC.Active := true;
    TotalNeModules.Caption := ' DIN : ' + FloatToStrF(MyQuerySRC.Fields[0].AsFloat,
      ffGeneral, 4, 0);

  except
    TotalModules.Caption := '  : ?';
    TotalNeModules.Caption := ' DIN : ?';
  end;

  try
    MyQuerySRC.SQL.Text := 'SELECT `price` FROM `uni_projectsystems` WHERE `rec_no`=:system_no';
    MyQuerySRC.ParamByName('system_no').AsInteger := frmMain.current_projectsystemno;
    MyQuerySRC.Active := true;
    TotalSystem.Caption := '  : ' + FloatToStrF(MyQuerySRC.Fields[0].AsFloat, ffCurrency, 12, 2);
  except
    TotalProject.Caption := '  : ?';
  end;

  try
    MyQuerySRC.SQL.Text := 'SELECT SUM(`price`*`count`) FROM `uni_projectsystems` WHERE `project_no`=:project_no';
    MyQuerySRC.ParamByName('project_no').AsInteger := Project_no;
    MyQuerySRC.Active := true;
    TotalProject.Caption := '  : ' + FloatToStrF(MyQuerySRC.Fields[0].AsFloat, ffCurrency, 12, 2);
  except
    TotalProject.Caption := '  : ?';
  end;

  try
    MyQuerySRC.SQL.Text :=
      'SELECT SUM(`price`*`count`) FROM `uni_projectsystems` WHERE `project_no`=:project_no AND `active`=1';
    MyQuerySRC.ParamByName('project_no').AsInteger := Project_no;
    MyQuerySRC.Active := true;
    TotalActive.Caption := '   : ' + FloatToStrF(MyQuerySRC.Fields[0].AsFloat,
      ffCurrency, 12, 2);
  except
    TotalActive.Caption := '   : ?';
  end;

  MyQuerySRC.Close;

  TPrSystems.Refresh;
End;

Procedure TfrmProject.TemplateListFill;
Begin
  TemplateList.Items.Clear;
  TTemplate.SQL.Text := 'SELECT * FROM `uni_docparts` WHERE `project_no`=0 LIMIT 100;';
  TTemplate.Active := true;
  while not TTemplate.eof do
  begin
    TemplateList.Items.Add(TTemplate.FieldByName('name').AsString);
    TTemplate.Next;
  end;
  if (TemplateList.ItemIndex < 0) and (TemplateList.Items.Count > 0) then
    TemplateList.ItemIndex := 0;
  //    
  if TemplateList.Items.IndexOf(frmMain.lastreportname) > 0 then
    TemplateList.ItemIndex := TemplateList.Items.IndexOf(frmMain.lastreportname)

End;

procedure TfrmProject.btnSaveToFileClick(Sender: TObject);
begin
  ReportToFile;
end;

procedure TfrmProject.btnSaveToDBClick(Sender: TObject);
begin
  ReportToDB;
end;

procedure TfrmProject.ReportToFile;
var
  reportext, reportfile: string;
  BlobField2: TField;
  edit_stream: TStream;
  res_stream: TMemoryStream;
  errcnt: Integer;
begin
  if TemplateList.ItemIndex < 0 then
    exit;
  frmMain.lastreportname := TemplateList.Items[TemplateList.ItemIndex];

  // open
  TTemplate.SQL.Text := 'SELECT * FROM `uni_docparts` WHERE `project_no`=0 AND `name`=:name LIMIT 5;';
  TTemplate.ParamByName('name').AsString := TemplateList.Items[TemplateList.ItemIndex];
  TTemplate.Active := true;
  //
  if TTemplate.Recordcount > 0 then
    While Not TTemplate.eof Do
      try
        reportext := uppercase(TTemplate.FieldByName('defaultext').AsString);
        TTemplate.Next;

        Data.Project_no := Project_no;
        Data.DoReportPreset;

        //   
        BlobField2 := TTemplate.FieldByName('store');
        edit_stream := TTemplate.CreateBlobStream(BlobField2, bmRead);
        Data.frxReport.FileName := 'template.fr3';
        Data.frxReport.LoadFromStream(edit_stream);

        //  
        try
          if pos('_', TemplateList.Items[TemplateList.ItemIndex]) > 0 then
          begin
            Data.frxReport.DataSet := Data.PrSystems;
          end
          else
          begin
            Data.frxReport.DataSet := nil;
          end;

          if not Data.frxReport.PrepareReport(true) then
          begin
            for errcnt := 0 to Data.frxReport.Errors.Count - 1 do
            begin
              showmessage(Data.frxReport.Errors[errcnt]);
            end;
            exit;
          end;
        except
          showmessage(' frmProject.ReportToFile');
          exit;
        end;

        reportfile := TemplateList.Items[TemplateList.ItemIndex] + '_' + Project_name + '.' + lowercase(reportext);
        dlgSave.DefaultExt := lowercase(reportext);
        dlgSave.FileName := reportfile;
        if dlgSave.Execute then
        begin
          reportfile := dlgSave.FileName;
          if FileExists(reportfile) then
            DeleteFile(reportfile);
          Application.ProcessMessages;

          try
            res_stream := TMemoryStream.Create;
            Data.DoReportSaveFormat(res_stream, '.' + reportext); //       
            res_stream.Seek(0, soFromBeginning);
            res_stream.SaveToFile(reportfile);
          finally
            res_stream.Free;
          end;

          frmMain.OpenFile(reportfile);
        end;

        edit_stream.Free;
      except
      end;
end;

procedure TfrmProject.ReportToDB;
var
  reportext, reportfile: string;
  BlobField2: TField;
  edit_stream: TStream;
  res_stream: TMemoryStream;
  size_mb: double;
  errcnt: Integer;
begin
  if TemplateList.ItemIndex < 0 then
    exit;
  frmMain.lastreportname := TemplateList.Items[TemplateList.ItemIndex];

  // open
  TTemplate.SQL.Text := 'SELECT * FROM `uni_docparts` WHERE `project_no`=0 AND `name`=:name LIMIT 5;';
  TTemplate.ParamByName('name').AsString := TemplateList.Items[TemplateList.ItemIndex];
  TTemplate.Active := true;
  //
  if TTemplate.Recordcount > 0 then
    While Not TTemplate.eof Do
      try
        reportext := uppercase(TTemplate.FieldByName('defaultext').AsString);
        TTemplate.Next;

        Data.Project_no := Project_no;
        Data.DoReportPreset;

        //   
        BlobField2 := TTemplate.FieldByName('store');
        edit_stream := TTemplate.CreateBlobStream(BlobField2, bmRead);
        Data.frxReport.FileName := 'template.fr3';
        Data.frxReport.LoadFromStream(edit_stream);
        edit_stream.Free;

        reportfile := TemplateList.Items[TemplateList.ItemIndex] + '_' + Project_name + '.' + lowercase(reportext);

        //  
        try
          if pos('_', TemplateList.Items[TemplateList.ItemIndex]) > 0 then
          begin
            Data.frxReport.DataSet := Data.PrSystems;
          end
          else
          begin
            Data.frxReport.DataSet := nil;
          end;

          if not Data.frxReport.PrepareReport(true) then
          begin
            for errcnt := 0 to Data.frxReport.Errors.Count - 1 do
            begin
              showmessage(Data.frxReport.Errors[errcnt]);
            end;
            exit;
          end;
        except
          showmessage(' frmProject.ReportToDB');
          exit;
        end;

        //   
        res_stream := TMemoryStream.Create;
        Data.DoReportSaveFormat(res_stream, '.' + reportext); //       
        res_stream.Seek(0, soFromBeginning);
        reportfile := frmUniversal.FileSaveToFB(res_stream, reportext);
        size_mb := res_stream.Size / 1048576;

        If pos(' ', reportfile) < 1 Then
        Begin
          //
          TPrAtt.Append;
          TPrAtt.FieldByName('project_no').AsInteger := Project_no;
          TPrAtt.FieldByName('file').AsString := reportfile;
          TPrAtt.FieldByName('lastupdate').AsDateTime := now();
          TPrAtt.FieldByName('name').AsString := TemplateList.Items[TemplateList.ItemIndex];
          TPrAtt.FieldByName('comment').AsString := Format('%f ', [size_mb]);
          TPrAtt.Post;
        End
        else
          showmessage(reportfile);

        res_stream.Free;

      except
        showmessage(' frmProject.ReportToDB');
      end;
end;

procedure TfrmProject.dlgSaveTypeChange(Sender: TObject);
begin
  case dlgSave.FilterIndex of
    1:
      dlgSave.FileName := TPath.ChangeExtension(dlgSave.FileName, '.pdf');
    2:
      dlgSave.FileName := TPath.ChangeExtension(dlgSave.FileName, '.pdf');
    3:
      dlgSave.FileName := TPath.ChangeExtension(dlgSave.FileName, '.html');
    4:
      dlgSave.FileName := TPath.ChangeExtension(dlgSave.FileName, '.rtf');
    5:
      dlgSave.FileName := TPath.ChangeExtension(dlgSave.FileName, '.ods');
    6:
      dlgSave.FileName := TPath.ChangeExtension(dlgSave.FileName, '.odt');
    7:
      dlgSave.FileName := TPath.ChangeExtension(dlgSave.FileName, '.xls');
    8:
      dlgSave.FileName := TPath.ChangeExtension(dlgSave.FileName, '.xlsx');
    9:
      dlgSave.FileName := TPath.ChangeExtension(dlgSave.FileName, '.docx');
    10:
      dlgSave.FileName := TPath.ChangeExtension(dlgSave.FileName, '.tiff');
    11:
      dlgSave.FileName := TPath.ChangeExtension(dlgSave.FileName, '.png');
  end;
end;

procedure TfrmProject.LibFilterChange(Sender: TObject);
begin
  UpdateTaskLib;
end;

procedure TfrmProject.actPriceUpdateExecute(Sender: TObject);
var
  Fields: string;
  priceid: Integer;
  R: Integer;
begin
  //     
  R := 0;
  if frmPriceUpdate.ShowModal = mrOk then
  begin
    Fields := 'kind';
    priceid := GetPriceListID(trim(frmPriceUpdate.ListPrices.Text));

    if frmPriceUpdate.UpdatePrice.Checked then
      Fields := Fields + ',price,valuta';

    //   
    if frmPriceUpdate.UpdatePrice.Checked and (priceid > -1) then
      Fields := 'price';

    if frmPriceUpdate.UpdateCertificates.Checked and (priceid < 0) then
      Fields := Fields + ',file,expire';

    if frmPriceUpdate.UpdateTech.Checked and (priceid < 0) then
      Fields := Fields + ',kinddesc,name,comment,developer,modules,modules2,din';

    if frmPriceUpdate.UpdateActive.Checked then
      R := frmUniversal.UpdateProjectFromBase(Project_no, 0, Fields, priceid);

    if frmPriceUpdate.UpdateAll.Checked then
      R := frmUniversal.UpdateProjectFromBase(Project_no, -1, Fields, priceid);

    if frmPriceUpdate.UpdateCurrent.Checked and (TPrSystems.Recordcount > 0) then
      R := frmUniversal.UpdateProjectFromBase(Project_no, TPrSystems.FieldByName('rec_no').AsInteger, Fields, priceid);

    SumRecalc;
    if TPrHardware.Active then
      TPrHardware.Refresh;
    if TPrCertificates.Active then
      TPrCertificates.Refresh;

    showmessage(' :' + R.ToString);
  end;

end;

function TfrmProject.GetPriceListID(pricename: string): Integer;
begin
  //      ,    rec_no
  result := -1;
  try
    MyQuery2.SQL.Text := 'SELECT `rec_no` FROM `uni_pricelist` WHERE `name`=:name;';
    MyQuery2.ParamByName('name').AsString := pricename;
    MyQuery2.Active := true;
    if MyQuery2.Recordcount > 0 then
      result := MyQuery2.FieldByName('rec_no').AsInteger;
  except
  end;
end;

procedure TfrmProject.setNumberToActiveClick(Sender: TObject);
begin
  frmNumEdit.Caption := '     ';
  if frmNumEdit.ShowModal = mrOk then
  begin
    MyQuery2.SQL.Text := 'UPDATE uni_projectsystems SET `query`=:val WHERE `project_no`=' + IntToStr(Project_no) +
      ' AND `active`=1 ';
    MyQuery2.ParamByName('val').AsInteger := frmNumEdit.Number.value;
    MyQuery2.ExecSQL;
    MyQuery2.Close;

    TPrSystems.Refresh;
  end;
end;

procedure TfrmProject.setActiveToNumberClick(Sender: TObject);
begin
  frmNumEdit.Caption := '      ';
  if frmNumEdit.ShowModal = mrOk then
  begin
    MyQuery2.SQL.Text := 'UPDATE uni_projectsystems set `active`=1 WHERE `project_no`=' + IntToStr(Project_no) +
      ' AND `query`=:val';
    MyQuery2.ParamByName('val').AsInteger := frmNumEdit.Number.value;
    MyQuery2.ExecSQL;
    MyQuery2.SQL.Text := 'UPDATE uni_projectsystems set `active`=0 WHERE `project_no`=' + IntToStr(Project_no) +
      ' AND `query`<>:val';
    MyQuery2.ParamByName('val').AsInteger := frmNumEdit.Number.value;
    MyQuery2.ExecSQL;
    MyQuery2.Close;

    TPrSystems.Refresh;
  end;

end;

procedure TfrmProject.actTasksAssignFastExecute(Sender: TObject);
var
  rec_no: string;
begin
  //
  frmDescEdit.description.Text := ListTaskLibShort[ListTaskLib.ItemIndex];
  if frmDescEdit.ShowModal = mrOk then
  begin
    ListTaskLibShort[ListTaskLib.ItemIndex] := frmDescEdit.description.Text;
    rec_no := ListTaskLibRecno[ListTaskLib.ItemIndex];

    MyQueryDST.SQL.Text := 'UPDATE `uni_messageslib` SET `short`=:short WHERE `rec_no`=:rec_no';
    MyQueryDST.ParamByName('rec_no').AsString := rec_no;
    MyQueryDST.ParamByName('short').AsString := frmDescEdit.description.Text;
    MyQueryDST.ExecSQL;
    MyQueryDST.Close;

  end;

end;

procedure TfrmProject.actTasksAssignFastUpdate(Sender: TObject);
begin
  actTasksAssignFast.Enabled := ListTaskLib.ItemIndex > -1;
end;

procedure TfrmProject.ListTaskLibDrawText(Sender: TObject; Index: Integer; const AText: string; R: TRect;
  var DefaultDraw: Boolean);
var
  short: string;
  tr: TRect;
  tw, th: Integer;
  tc, fc: tcolor;
begin
  with (Sender as TJvComboListBox).Canvas do
  begin
    // text
    Windows.DrawTextEx((Sender as TJvComboListBox).Canvas.Handle, Pchar(AText), length(AText), R,
      DT_LEFT or DT_WORDBREAK, nil);
    //    
    short := ListTaskLibShort[Index];
    tc := Brush.Color;
    fc := Font.Color;
    if length(short) > 0 then
    begin
      short := '[' + short + ']';
      Font.Style := [fsBold];
      Font.Color := clBlue;

      Brush.Color := clWhite;

      tw := textwidth(short);
      th := textheight(short);

      tr := R;
      tr.Top := R.Top + 2;
      tr.Height := th;

      tr.Left := R.Left + R.Width - tw - 40;
      tr.Width := tw;
      FillRect(tr);

      TextOut(tr.Left, tr.Top, short);

      Font.Color := clBlack;
      Font.Style := [];
    end;
    Brush.Color := tc;
    Font.Color := fc;

    DefaultDraw := false;
  end;
end;

procedure TfrmProject.ListTaskLibMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  LB: TCustomListbox;
  N: Integer;
begin
  if Button = mbRight then
  begin
    LB := Sender as TCustomListbox;
    N := LB.ItemAtPos(Point(X, Y), true);
    if N >= 0 then
      LB.ItemIndex := N;
  end;
end;

procedure TfrmProject.ListTaskLibClick(Sender: TObject);
begin
  ListTaskLib.Refresh;
end;

procedure TfrmProject.MakeCountFocused(article: string);
begin
  if Pages.ActivePage <> TabSheetHardware then
  begin
    Pages.ActivePage := TabSheetHardware;
    RenewPrSystems;
  end;
  TPrHardware.Refresh;
  TPrHardware.last;
  GridPrHardware.SelectedField := TPrHardware.FieldByName('count');
  GridPrHardware.EditorMode := false;
  //
  TimerAutoEdit.Enabled := true;
end;

procedure TfrmProject.TimerAutoEditTimer(Sender: TObject);
begin
  //           
  TimerAutoEdit.Enabled := false;
  GridPrHardware.SetFocus;
  GridPrHardware.EditorMode := true;
  SendMessage(GetFocus(), EM_SETSEL, 0, 1000); //   
end;

procedure TfrmProject.TimerCloseTimer(Sender: TObject);
begin
  try
    Close;
  except
  end;
end;

function TfrmProject.DetectSize(input: string; var h, w, d: double): Boolean;
var
  i: Integer;
  lst: TStrings;
  v: Integer;
begin
  { uni_projectsystems
    cab_w.Text := QuerySRC.FieldByName('cab_w').AsString;
    cab_h.Text := QuerySRC.FieldByName('cab_h').AsString;
    cab_d.Text := QuerySRC.FieldByName('cab_d').AsString;
  }
  lst := TstringList.Create;
  h := 0;
  w := 0;
  d := 0;

  // 'Test 123 456 789 012'
  for i := 0 to length(input) - 1 do
  begin
    if not(input[i] in ['0' .. '9']) then
      input[i] := ' ';
  end;

  lst.Delimiter := ' ';
  lst.DelimitedText := input;

  for i := 0 to lst.Count - 1 do
  begin
    if TryStrToInt(lst[i], v) then
    begin
      h := w;
      w := d;
      d := v;
    end;
  end;

  result := (h > 0);

  lst.Free;
  //
end;

Procedure TfrmProject.actHardwareUpExecute(Sender: TObject);
Var
  orderby1, orderby2: Integer;
  rec_no1, rec_no2: Integer;
Begin
  // up
  TPrHardware.DisableControls;
  Try
    orderby2 := TPrHardware.FieldByName('orderby').AsInteger;
    rec_no2 := TPrHardware.FieldByName('rec_no').AsInteger;
    TPrHardware.Prior;
    orderby1 := TPrHardware.FieldByName('orderby').AsInteger;
    rec_no1 := TPrHardware.FieldByName('rec_no').AsInteger;
    if orderby1 = orderby2 then
      Inc(orderby2);

    MyQuery2.SQL.Text := 'UPDATE `uni_projecthardware` SET orderby=:orderby WHERE rec_no=:rec_no';
    MyQuery2.ParamByName('orderby').AsInteger := orderby1;
    MyQuery2.ParamByName('rec_no').AsInteger := rec_no2;
    MyQuery2.ExecSQL;
    MyQuery2.SQL.Text := 'UPDATE `uni_projecthardware` SET orderby=:orderby WHERE rec_no=:rec_no';
    MyQuery2.ParamByName('orderby').AsInteger := orderby2;
    MyQuery2.ParamByName('rec_no').AsInteger := rec_no1;
    MyQuery2.ExecSQL;
    MyQuery2.Close;

    TPrHardware.Refresh;
  Except
    showmessage('err');
  End;

  TPrHardware.EnableControls;
  TPrHardware.Prior;
End;

Procedure TfrmProject.actHardwareDownExecute(Sender: TObject);
Var
  orderby1, orderby2: Integer;
  rec_no1, rec_no2: Integer;
Begin
  // up
  TPrHardware.DisableControls;
  Try
    orderby2 := TPrHardware.FieldByName('orderby').AsInteger;
    rec_no2 := TPrHardware.FieldByName('rec_no').AsInteger;
    TPrHardware.Next;
    orderby1 := TPrHardware.FieldByName('orderby').AsInteger;
    rec_no1 := TPrHardware.FieldByName('rec_no').AsInteger;
    if orderby1 = orderby2 then
      Inc(orderby2);

    MyQuery2.SQL.Text := 'UPDATE `uni_projecthardware` SET orderby=:orderby WHERE rec_no=:rec_no';
    MyQuery2.ParamByName('orderby').AsInteger := orderby1;
    MyQuery2.ParamByName('rec_no').AsInteger := rec_no2;
    MyQuery2.ExecSQL;
    MyQuery2.SQL.Text := 'UPDATE `uni_projecthardware` SET orderby=:orderby WHERE rec_no=:rec_no';
    MyQuery2.ParamByName('orderby').AsInteger := orderby2;
    MyQuery2.ParamByName('rec_no').AsInteger := rec_no1;
    MyQuery2.ExecSQL;
    MyQuery2.Close;

    TPrHardware.Refresh;
  Except
    showmessage('err');
  End;

  TPrHardware.EnableControls;
  TPrHardware.Next;
End;

procedure TfrmProject.actSystemsCertificateExecute(Sender: TObject);
var
  fn, kind: string;
begin
  kind := TPrSystems.FieldByName('kind').AsString;
  fn := '';
  try
    MyQuery2.SQL.Text := 'SELECT * FROM uni_systemstemplates WHERE `kind`=:kind';
    MyQuery2.ParamByName('kind').AsString := kind;
    MyQuery2.Active := true;
    if MyQuery2.Recordcount > 0 then
      fn := MyQuery2.FieldByName('file').AsString;
  except
    fn := '';
  end;

  if fn = '' then
  begin
    showmessage('  ')
  end
  else
  begin
    dlgSave.FileName := fn;
    dlgSave.DefaultExt := ExtractFileExt(fn);
    If (fn <> '') And dlgSave.Execute Then
    Begin
      frmUniversal.FileGetByNameToFile(fn, dlgSave.FileName);
      If FileExists(fn) Then
        frmMain.OpenFile(fn);
    End;
  end;

end;

Procedure TfrmProject.RenewPrCertificates;
begin
  if Project_no < 0 then
    exit;

  try
    TPrCertificates.Active := false;
    TPrCertificates.SQL.Text :=
      '(SELECT " " as `name`,`kind` as `article`,"" as `developer`,`file`,`expire` FROM `uni_systemstemplates` WHERE `kind` IN (SELECT `kind` FROM uni_projectsystems WHERE `project_no`=:project_no AND `active`=true GROUP BY `kind`))'
      + ' UNION ' +
      '(SELECT `name`,`article`,`developer`,`file`,`expire` FROM `uni_projecthardware` WHERE `project_no`=:project_no AND length(`file`)>0'
      + ' AND `system_no` IN (SELECT `rec_no` FROM `uni_projectsystems` WHERE `project_no`=:project_no AND `active`=true)'
      + ' GROUP BY `file`)';
    TPrCertificates.ParamByName('project_no').AsInteger := Project_no;
    TPrCertificates.Active := true;
    GridPrCertificates.Enabled := (TPrCertificates.Recordcount > 0);
  except
    showmessage('Error frmProject.RenewPrCertificates');
  end;

end;

procedure TfrmProject.miSetGabaritesClick(Sender: TObject);
var
  h, w, d: Integer;
  s: tdatetime;
begin
  //
  // frmUniversal.DetectGabaritesForSystem(TPrSystems.FieldByName('rec_no').AsInteger);
  // s := now();
  // frmUniversal.DetectGabaritesForProject(Project_no, false);
  // showmessage('  ' + SecondsBetween(s, now).ToString + ' .');

  frmTotalUpdate.ShowModal;
end;

End.
