unit PDFViewer;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls,
  JvExStdCtrls, JvButton, JvCtrls, JvFooter, JvExExtCtrls, JvExtComponent,
  Vcl.Menus, System.Actions, Vcl.ActnList, Vcl.StdActns, cxControls,
  cxLookAndFeels, cxLookAndFeelPainters, dxPDFCore, dxPDFBase, dxPDFText,
  dxPDFRecognizedObject, dxPDFDocument, dxPSGlbl, dxPSUtl, dxPSEngn, dxPrnPg,
  dxBkgnd, dxWrap, dxPrnDev, dxPSCompsProvider, dxPSFillPatterns,
  dxPSEdgePatterns, dxPSPDFExportCore, dxPSPDFExport, cxDrawTextUtils,
  dxPSPrVwStd, dxPSPrVwAdv, dxPSPrVwRibbon, dxPScxPageControlProducer,
  dxPSdxPDFViewerLnk, dxPScxEditorProducers, dxPScxExtEditorProducers, dxPSCore,
  cxClasses, dxCustomPreview, dxPDFDocumentViewer, dxPDFViewer, cxGraphics;

type
  TfrmPDFViewer = class(TForm)
    Viewer: TdxPDFViewer;
    dxComponentPrinter1: TdxComponentPrinter;
    dxComponentPrinter1Link1: TdxPDFViewerReportLink;
    Footer: TJvFooter;
    btnPrintReport: TJvFooterBtn;
    btnOk: TJvFooterBtn;
    PopupMenu1: TPopupMenu;
    ActionList1: TActionList;
    N1: TMenuItem;
    N2: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnOkClick(Sender: TObject);
    procedure btnPrintReportClick(Sender: TObject);
  private
    { Private declarations }
  public
    procedure LoadFile(fn: string);
    { Public declarations }
  end;

var
  frmPDFViewer: TfrmPDFViewer;

implementation

{$R *.dfm}

procedure TfrmPDFViewer.btnOkClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmPDFViewer.btnPrintReportClick(Sender: TObject);
begin
  dxComponentPrinter1Link1.Print(true);
end;

procedure TfrmPDFViewer.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TfrmPDFViewer.LoadFile(fn: string);
begin
  Viewer.Clear;
  if fileexists(fn) then
    Viewer.LoadFromFile(fn);
end;

end.
