Unit OrderSelect;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, JvExComCtrls, JvComCtrls, StdCtrls, JvDateTimePicker,
  JvExStdCtrls, JvButton, JvCtrls, JvFooter, ExtCtrls, JvExExtCtrls,
  JvExtComponent, DB, Grids, DBGrids, JvExDBGrids, DateUtils,
  JvDBGrid, ActnList, Vcl.Menus, System.Actions, FireDAC.Stan.Intf,
  FireDAC.Stan.Option, FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS,
  FireDAC.Phys.Intf, FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt,
  FireDAC.Comp.DataSet, FireDAC.Comp.Client;

Type
  TfrmOrderSelect = Class(TForm)
    JvFooter1: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    JvFooterBtn2: TJvFooterBtn;
    DSProjects: TDataSource;
    TimerUpdateData: TTimer;
    TProjects: TFDQuery;
    Actions: TActionList;
    actOpen: TAction;
    MyQuery: TFDQuery;
    btnOpen: TJvFooterBtn;
    Panel1: TPanel;
    OrderGrid: TJvDBGrid;
    PanelTop: TPanel;
    GroupBoxContragents: TGroupBox;
    Label10: TLabel;
    Label9: TLabel;
    Label1: TLabel;
    _Managers: TComboBox;
    _Engineers: TComboBox;
    _Customers: TComboBox;
    _Name: TComboBox;
    Label8: TLabel;
    actNew: TAction;
    actCopy: TAction;
    rightMenu: TPopupMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    CheckDateFilter: TCheckBox;
    Label4: TLabel;
    _dateStart: TJvDateTimePicker;
    _dateEnd: TJvDateTimePicker;
    Label5: TLabel;
    TimerAutoClose: TTimer;
    Procedure TimerUpdateDataTimer(Sender: TObject);
    Procedure FormShow(Sender: TObject);
    Procedure _NameChange(Sender: TObject);
    Procedure actOpenUpdate(Sender: TObject);
    Procedure actOpenExecute(Sender: TObject);
    Procedure OrderGridDblClick(Sender: TObject);
    Procedure FormClose(Sender: TObject; Var Action: TCloseAction);
    Procedure FormActivate(Sender: TObject);
    procedure actNewExecute(Sender: TObject);
    procedure actCopyExecute(Sender: TObject);
    procedure actCopyUpdate(Sender: TObject);
    procedure actNewUpdate(Sender: TObject);
    procedure CheckDateFilterClick(Sender: TObject);
    procedure TimerAutoCloseTimer(Sender: TObject);
  Private
    Procedure UpdateData;
    procedure chChange;
    { Private declarations }
  Public
    Project_no: integer;
    Project_name: String;
    Project_description: String;
    Project_customer: String;
    Project_engineer: String;
    Project_manager: String;
    Project_datestart: tdatetime;
    Project_dateend: tdatetime;
    Project_options: String;
    Project_info: String;
    //
    NewCaption: string;
    { Public declarations }
  End;

Var
  frmOrderSelect: TfrmOrderSelect;

Implementation

Uses Main, Project, OrderNew;

{$R *.dfm}

procedure TfrmOrderSelect.actCopyExecute(Sender: TObject);
begin
  if ((TProjects.active) And (TProjects.RecNo > 0)) then
  begin
    frmOrderNew.Caption := ' ';
    frmOrderNew.CopyFrom := TProjects.FieldByName('rec_no').AsInteger;
    frmOrderNew._Name.Text := TProjects.FieldByName('name').AsString;
    frmOrderNew.Project_info := TProjects.FieldByName('info').AsString;
    frmOrderNew._description.Text := TProjects.FieldByName('description').AsString;
    frmOrderNew._Customers.Text := TProjects.FieldByName('owner_customer').AsString;
    frmOrderNew._Engineers.Text := TProjects.FieldByName('owner_engineer').AsString;
    frmOrderNew._Managers.Text := TProjects.FieldByName('owner_manager').AsString;
    If frmOrderNew.ShowModal = mrOk Then
    Begin
      NewCaption := ' ' + frmOrderNew._Name.Text + ' / ' + frmOrderNew._Customers.Text;
      If Not frmMain.MDIExists(NewCaption) Then
        With TfrmProject.Create(Application) Do
        Begin
          Project_no := frmOrderNew.Project_no;
          Project_name := frmOrderNew._Name.Text;
          Project_customer := frmOrderNew._Customers.Text;
          Project_engineer := frmOrderNew._Engineers.Text;
          Project_manager := frmOrderNew._Managers.Text;
          Project_datestart := frmOrderNew.Project_datestart;
          Project_dateend := frmOrderNew.Project_dateend;
          Project_info := frmOrderNew.Project_info;
          Project_description := frmOrderNew._description.Text;
          Project_options := '00000';
          Caption := NewCaption;
          FormActivate(self);
        End;
      Close;
    End;
  end;
end;

procedure TfrmOrderSelect.actCopyUpdate(Sender: TObject);
begin
  actCopy.Enabled := (TProjects.active) And (TProjects.RecordCount > 0) and (frmMain.usergroup.Length > 1);
end;

procedure TfrmOrderSelect.actNewExecute(Sender: TObject);
begin
  frmOrderNew.Caption := ' ';
  frmOrderNew.CopyFrom := -1;
  frmOrderNew.Project_info := '';
  If frmOrderNew.ShowModal = mrOk Then
  Begin
    NewCaption := ' ' + frmOrderNew._Name.Text + ' / ' + frmOrderNew._Customers.Text;
    If Not frmMain.MDIExists(NewCaption) Then
      With TfrmProject.Create(Application) Do
      Begin
        Project_no := frmOrderNew.Project_no;
        Project_description := frmOrderNew._description.Text;
        Project_name := frmOrderNew._Name.Text;
        Project_customer := frmOrderNew._Customers.Text;
        Project_engineer := frmOrderNew._Engineers.Text;
        Project_manager := frmOrderNew._Managers.Text;
        Project_datestart := frmOrderNew.Project_datestart;
        Project_dateend := frmOrderNew.Project_dateend;
        Project_info := frmOrderNew.Project_info;
        Project_options := '00000';
        Caption := NewCaption;
        FormActivate(self);
      End;
    Close;
  End;
end;

procedure TfrmOrderSelect.actNewUpdate(Sender: TObject);
begin
  actNew.Enabled := (TProjects.active) and (frmMain.usergroup.Length > 1);
end;

Procedure TfrmOrderSelect.actOpenExecute(Sender: TObject);
Begin
  if not(TProjects.active) then
    exit;
  if not(TProjects.RecordCount > 0) then
    exit;

  Project_no := TProjects.FieldByName('rec_no').AsInteger;
  Project_name := TProjects.FieldByName('name').AsString;
  Project_customer := TProjects.FieldByName('owner_customer').AsString;
  NewCaption := ' ' + frmOrderSelect.Project_name + ' / ' + frmOrderSelect.Project_customer;

  If Not frmMain.MDIExists(NewCaption) Then
    frmMain.OpenProject(Project_no);

  TimerAutoClose.Enabled := true;
End;

Procedure TfrmOrderSelect.actOpenUpdate(Sender: TObject);
Begin
  actOpen.Enabled := (TProjects.active) And (TProjects.RecordCount > 0);
End;

procedure TfrmOrderSelect.CheckDateFilterClick(Sender: TObject);
begin
  chChange;
end;

Procedure TfrmOrderSelect.OrderGridDblClick(Sender: TObject);
Begin
  actOpen.Execute;
End;

procedure TfrmOrderSelect.TimerAutoCloseTimer(Sender: TObject);
begin
  TimerAutoClose.Enabled := false;
  Close;
end;

Procedure TfrmOrderSelect.TimerUpdateDataTimer(Sender: TObject);
Begin
  TimerUpdateData.Enabled := false;
  UpdateData;
End;

procedure TfrmOrderSelect.chChange;
begin
  TimerUpdateData.Enabled := false;
  TimerUpdateData.Enabled := true;
  _dateStart.Enabled := CheckDateFilter.Checked;
  _dateEnd.Enabled := CheckDateFilter.Checked;
end;

Procedure TfrmOrderSelect.UpdateData;
Var
  filter: String;
Begin
  filter := 'WHERE `rec_no`>-1 ';

  if CheckDateFilter.Checked then
  begin
    filter := filter + ' AND `dateupdate`>=' + QuotedStr(frmMain.DateTimeForSQL(_dateStart.Date));
    filter := filter + ' AND `dateupdate`<=' + QuotedStr(frmMain.DateTimeForSQL(_dateEnd.Date));
  end;

  If _Name.Text <> '' Then
    filter := filter + ' AND `name` LIKE ' + QuotedStr('%' + _Name.Text + '%');
  If _Customers.Text <> '' Then
    filter := filter + ' AND `owner_customer` LIKE ' + QuotedStr('%' + _Customers.Text + '%');
  If _Engineers.Text <> '' Then
    filter := filter + ' AND `owner_engineer` LIKE ' + QuotedStr('%' + _Engineers.Text + '%');
  If _Managers.Text <> '' Then
    filter := filter + ' AND `owner_manager` LIKE ' + QuotedStr('%' + _Managers.Text + '%');

  TProjects.SQL.Text := 'SELECT * FROM `uni_projects` ' + filter + ' ORDER BY `dateupdate` desc;';
  // caption := filter;
  TProjects.active := true;
  //     
End;

Procedure TfrmOrderSelect._NameChange(Sender: TObject);
Begin
  TimerUpdateData.Enabled := false;
  TimerUpdateData.Enabled := true;
End;

Procedure TfrmOrderSelect.FormActivate(Sender: TObject);
Begin
  _Name.SetFocus;
  TimerUpdateData.Enabled := true;
End;

Procedure TfrmOrderSelect.FormClose(Sender: TObject; Var Action: TCloseAction);
Begin
  // TProjects.active := false;
End;

Procedure TfrmOrderSelect.FormShow(Sender: TObject);
Begin
  _dateStart.DateTime := IncYear(now(), -5);
  _dateEnd.DateTime := now();
  Try
    // 
    _Name.Items.Clear;
    MyQuery.SQL.Text := 'SELECT `name` FROM `uni_projects` WHERE `dateupdate`>:start ORDER BY `dateupdate` DESC;';
    MyQuery.ParamByName('start').AsDate := IncYear(now(), -1);
    MyQuery.active := true;
    If MyQuery.active Then
      While Not MyQuery.Eof Do
      Begin
        If MyQuery.FieldByName('name').AsString <> '' Then
          _Name.Items.Add(MyQuery.FieldByName('name').AsString);
        MyQuery.Next;
      End;
    // 
    _Customers.Items.Clear;
    MyQuery.SQL.Text := 'SELECT `name` FROM `uni_customers` GROUP BY `name` ORDER BY `name`;';
    MyQuery.active := true;
    If MyQuery.active Then
      While Not MyQuery.Eof Do
      Begin
        If MyQuery.FieldByName('name').AsString <> '' Then
          _Customers.Items.Add(MyQuery.FieldByName('name').AsString);
        MyQuery.Next;
      End;
    // 
    _Engineers.Items.Clear;
    MyQuery.SQL.Text := 'SELECT `user_fio` FROM `uni_users` WHERE `usergroup`=' + QuotedStr('') +
      ' GROUP BY `user_fio` ORDER BY `user_fio`;';
    MyQuery.active := true;
    If MyQuery.active Then
      While Not MyQuery.Eof Do
      Begin
        If MyQuery.FieldByName('user_fio').AsString <> '' Then
          _Engineers.Items.Add(MyQuery.FieldByName('user_fio').AsString);
        MyQuery.Next;
      End;
    // 
    _Managers.Items.Clear;
    MyQuery.SQL.Text := 'SELECT `user_fio` FROM `uni_users` WHERE `usergroup`=' + QuotedStr('') +
      ' GROUP BY `user_fio` ORDER BY `user_fio`;';
    MyQuery.active := true;
    If MyQuery.active Then
      While Not MyQuery.Eof Do
      Begin
        If MyQuery.FieldByName('user_fio').AsString <> '' Then
          _Managers.Items.Add(MyQuery.FieldByName('user_fio').AsString);
        MyQuery.Next;
      End;
  Except

  End;
  TimerUpdateData.Enabled := true;
End;

End.
