Unit OrderNew;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, JvExStdCtrls, JvButton, JvCtrls, JvFooter, ExtCtrls,
  JvExExtCtrls, JvExtComponent, ComCtrls, JvExComCtrls, JvDateTimePicker,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf,
  FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client,
  JvDBDateTimePicker, DB, ActnList, System.Actions;

Type
  TfrmOrderNew = Class(TForm)
    Label8: TLabel;
    GroupBoxPeriod: TGroupBox;
    Label5: TLabel;
    Label4: TLabel;
    _dateEnd: TJvDateTimePicker;
    JvFooter1: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    btnNew: TJvFooterBtn;
    GroupBoxContragents: TGroupBox;
    Label10: TLabel;
    Label9: TLabel;
    Label1: TLabel;
    _dateStart: TJvDateTimePicker;
    TProjects: TFDQuery;
    Actions: TActionList;
    actNew: TAction;
    _Name: TEdit;
    _Customers: TComboBox;
    _Engineers: TComboBox;
    _Managers: TComboBox;
    MyQuery: TFDQuery;
    MyQuery2: TFDQuery;
    Label2: TLabel;
    _Description: TEdit;
    Procedure FormShow(Sender: TObject);
    Procedure actNewUpdate(Sender: TObject);
    Procedure actNewExecute(Sender: TObject);
    Procedure FormActivate(Sender: TObject);
  Private
    { Private declarations }
  Public
    Project_no: integer;
    Project_datestart: tdatetime;
    Project_dateend: tdatetime;
    Project_info: string;
    CopyFrom: integer; //    
    { Public declarations }
  End;

Var
  frmOrderNew: TfrmOrderNew;

Implementation

Uses Main, Universal;

{$R *.dfm}

Procedure TfrmOrderNew.actNewExecute(Sender: TObject);
var
  i: integer;
  fn: string;
  fv: variant;
  flds, SQL: string;
  SRC_system_no, DST_system_no: integer;
  cap: string;
Begin
  cap := caption;
  _Name.Text := trim(_Name.Text);
  _Description.Text := trim(_Description.Text);
  _Customers.Text := trim(_Customers.Text);
  _Engineers.Text := trim(_Engineers.Text);
  _Managers.Text := trim(_Managers.Text);

  TProjects.Active := true;
  If TProjects.Active Then
  Begin
    If TProjects.Locate('name', VarArrayOf([_Name.Text]), []) Then
    Begin
      ShowMessage('    ');
    End
    Else
    Begin
      TProjects.Append;
      TProjects.FieldByName('name').AsString := _Name.Text;
      TProjects.FieldByName('description').AsString := _Description.Text;
      TProjects.FieldByName('owner_customer').AsString := _Customers.Text;
      TProjects.FieldByName('owner_engineer').AsString := _Engineers.Text;
      TProjects.FieldByName('owner_manager').AsString := _Managers.Text;
      TProjects.FieldByName('datestart').AsDateTime := _dateStart.date;
      TProjects.FieldByName('dateend').AsDateTime := _dateEnd.date;
      TProjects.FieldByName('dateupdate').AsDateTime := now;
      TProjects.FieldByName('info').AsString := Project_info;
      TProjects.Post;
      frmUniversal.DatabaseConnection.Commit;
      //
      Project_no := TProjects.FieldByName('rec_no').AsInteger;
      _Name.Text := TProjects.FieldByName('name').AsString;
      _Description.Text := TProjects.FieldByName('description').AsString;
      _Customers.Text := TProjects.FieldByName('owner_customer').AsString;
      _Engineers.Text := TProjects.FieldByName('owner_engineer').AsString;
      _Managers.Text := TProjects.FieldByName('owner_manager').AsString;
      Project_datestart := TProjects.FieldByName('datestart').AsDateTime;
      Project_dateend := TProjects.FieldByName('dateend').AsDateTime;
      if (CopyFrom > -1) then
      begin
        //      
        try
          MyQuery.SQL.Text := 'SELECT * FROM `uni_projectsystems` WHERE `project_no`=:project_no ORDER BY `orderby`';
          MyQuery.ParamByName('project_no').AsInteger := CopyFrom;
          MyQuery.Active := true;
          while not MyQuery.eof do
            try
              caption := '  (' + MyQuery.RecNo.ToString + '/' + MyQuery.RecordCount.ToString+')';
              Application.ProcessMessages;

              SRC_system_no := MyQuery.FieldByName('rec_no').AsInteger;
              MyQuery2.SQL.Text := 'SELECT * FROM `uni_projectsystems` WHERE `project_no`=' + IntTostr(Project_no) +
                ' ORDER BY `orderby`';
              MyQuery2.Active := true;
              MyQuery2.Append;
              MyQuery2.FieldByName('project_no').AsInteger := Project_no;
              for i := 0 to MyQuery.FieldCount - 1 do
              begin
                fn := MyQuery.Fields[i].FullName;
                fv := MyQuery.Fields[i].Value;
                if (fn <> 'rec_no') and (fn <> 'project_no') then
                  MyQuery2.FieldByName(fn).Value := fv;
              end;
              MyQuery2.Post;
              DST_system_no := MyQuery2.FieldByName('rec_no').AsInteger;
              //     
              try
                flds := 'name,kinddesc,article,comment,developer,file,price,valuta,count,modules,orderby,expire';
                SQL := 'INSERT INTO uni_projecthardware (project_no,system_no,' + flds + ') ' + 'SELECT ' +
                  IntTostr(Project_no) + ',' + IntTostr(DST_system_no) + ',' + flds +
                  ' FROM `uni_projecthardware` WHERE `system_no`=' + IntTostr(SRC_system_no) + ' ORDER BY `orderby`;';
                MyQuery2.SQL.Text := SQL;
                MyQuery2.Execute;
              except
              end;

              MyQuery.Next;
            except
              ShowMessage('       ');
            end;
        except
        end;
        //  
        try
          MyQuery.SQL.Text :=
            'SELECT kind,dt,username,comment,orderby FROM `uni_messages` WHERE `project_no`=:project_no';
          MyQuery.ParamByName('project_no').AsInteger := CopyFrom;
          MyQuery.Active := true;
          while not MyQuery.eof do
          begin
            caption := '  (' + MyQuery.RecNo.ToString + '/' + MyQuery.RecordCount.ToString+')';
            Application.ProcessMessages;

            MyQuery2.SQL.Text := 'INSERT INTO uni_messages (project_no,kind,dt,username,comment,orderby) ' +
              'VALUES(:project_no,:kind,:dt,:username,:comment,:orderby)';
            MyQuery2.ParamByName('project_no').AsInteger := Project_no;
            MyQuery2.ParamByName('kind').Value := MyQuery.FieldByName('kind').Value;
            MyQuery2.ParamByName('dt').Value := MyQuery.FieldByName('dt').Value;
            MyQuery2.ParamByName('username').Value := MyQuery.FieldByName('username').Value;
            MyQuery2.ParamByName('comment').Value := MyQuery.FieldByName('comment').Value;
            MyQuery2.ParamByName('orderby').Value := MyQuery.FieldByName('orderby').Value;
            MyQuery2.Execute;

            MyQuery.Next;
          end;
        except
        end;
      end;
      caption := cap;
      modalresult := mrOk;
    End;
  End;
  caption := cap;
End;

Procedure TfrmOrderNew.actNewUpdate(Sender: TObject);
Begin
  actNew.Enabled := (_Name.Text <> '') And (_Customers.Text <> '') And (_Engineers.Text <> '') And
    (_Managers.Text <> '')
End;

Procedure TfrmOrderNew.FormActivate(Sender: TObject);
Begin
  _Name.SetFocus;
End;

Procedure TfrmOrderNew.FormShow(Sender: TObject);
Begin
  if not frmUniversal.DBConnected then
    close;

  _dateStart.DateTime := now();
  _dateEnd.DateTime := now();

  Try
    // 
    _Customers.Items.Clear;
    MyQuery.SQL.Text := 'SELECT `name` FROM `uni_customers` GROUP BY `name` ORDER BY `name`;';
    MyQuery.Active := true;
    If MyQuery.Active Then
      While Not MyQuery.eof Do
      Begin
        If MyQuery.FieldByName('name').AsString <> '' Then
          _Customers.Items.Add(MyQuery.FieldByName('name').AsString);
        MyQuery.Next;
      End;
    // 
    _Engineers.Items.Clear;
    MyQuery.SQL.Text := 'SELECT `user_fio` FROM `uni_users` WHERE `usergroup`=' + QuotedStr('') +
      ' GROUP BY `user_fio` ORDER BY `user_fio`;';
    MyQuery.Active := true;
    If MyQuery.Active Then
      While Not MyQuery.eof Do
      Begin
        If MyQuery.FieldByName('user_fio').AsString <> '' Then
          _Engineers.Items.Add(MyQuery.FieldByName('user_fio').AsString);
        MyQuery.Next;
      End;
    // 
    _Managers.Items.Clear;
    MyQuery.SQL.Text := 'SELECT `user_fio` FROM `uni_users` WHERE `usergroup`=' + QuotedStr('') +
      ' GROUP BY `user_fio` ORDER BY `user_fio`;';
    MyQuery.Active := true;
    If MyQuery.Active Then
      While Not MyQuery.eof Do
      Begin
        If MyQuery.FieldByName('user_fio').AsString <> '' Then
          _Managers.Items.Add(MyQuery.FieldByName('user_fio').AsString);
        MyQuery.Next;
      End;
  Except
  End;
End;

End.
