Unit Main;

Interface

Uses Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  Hardware, Systems, Tracker, System.Variants,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, ComCtrls, StdActns,
  ActnList, ToolWin, ImgList, JvExComCtrls, JvToolBar, JvCoolBar, JvExExtCtrls,
  JvControlBar, Registry, WideStrings, DBXMySql, DB, SqlExpr, JvDataEmbedded,
  AppEvnts, MidasLib, CRTL, JvExForms, JvClipboardViewer,
  JvExButtons, JvBitBtn, JvImageList, JvComponentBase,
  JvAppStorage, JvAppIniStorage, JvFormPlacement, JvComputerInfoEx,
  JvAppRegistryStorage, ShellAPI, System.Actions,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.UI.Intf, FireDAC.Stan.Def,
  FireDAC.Stan.Pool, FireDAC.Phys, FireDAC.VCLUI.Wait, FireDAC.Comp.Client,
  FireDAC.Comp.DataSet, System.ImageList, FireDAC.Phys.MySQL,
  FireDAC.Phys.MySQLDef, FireDAC.Comp.UI, Vcl.PlatformDefaultStyleActnCtrls,
  Vcl.ActnMan, Vcl.ActnMenus, Vcl.ActnCtrls, Vcl.BandActn, Vcl.CustomizeDlg,
  AdvToolBar, Vcl.ActnPopup, JvHotKey, JvExtComponent, JvPanel, Vcl.Tabs,
  Vcl.DockTabSet, AdvSmoothDock, JvSplitter, Vcl.WinXCtrls, JvExStdCtrls,
  JvCombobox, JvDBGridExport, Vcl.Grids, Vcl.DBGrids, JvExDBGrids, JvDBGrid,
  JvStdEditActions, JvActions, JvAppStorageSelectList, JvAppXMLStorage,
  JvAppDBStorage, Vcl.StdStyleActnCtrls, Vcl.XPStyleActnCtrls, tmsAdvGridExcel,
  AdvUtil, AdvObj, BaseGrid, AdvGrid, DBAdvGrid;

Type
  TfrmMain = Class(TForm)
    MainMenu: TMainMenu;
    mProject: TMenuItem;
    mCatalog: TMenuItem;
    mWindowClose: TMenuItem;
    mWindow: TMenuItem;
    mHelp: TMenuItem;
    mExit: TMenuItem;
    mWindowCascade: TMenuItem;
    mWindowHorizontal: TMenuItem;
    mWindowArrangeAll: TMenuItem;
    mAbout: TMenuItem;
    OpenDialog: TOpenDialog;
    mWindowMinimizeAll: TMenuItem;
    StatusBar: TStatusBar;
    mWindowTileVertical: TMenuItem;
    ImageList48: TImageList;
    ImageList24: TImageList;
    mTemplates: TMenuItem;
    mManagement: TMenuItem;
    N11: TMenuItem;
    AppEvents: TApplicationEvents;
    N17: TMenuItem;
    mProjectNew: TMenuItem;
    SaveDialog: TSaveDialog;
    N15: TMenuItem;
    N2: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    N9: TMenuItem;
    Images: TImageList;
    ComputerInfo: TJvComputerInfoEx;
    N7: TMenuItem;
    N10: TMenuItem;
    N12: TMenuItem;
    N3: TMenuItem;
    N13: TMenuItem;
    N18: TMenuItem;
    N19: TMenuItem;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    N20: TMenuItem;
    N21: TMenuItem;
    N22: TMenuItem;
    N23: TMenuItem;
    Actions: TActionManager;
    CustomizeDlg: TCustomizeDlg;
    pmMenu: TPopupMenu;
    N25: TMenuItem;
    miShowCert: TMenuItem;
    N27: TMenuItem;
    N28: TMenuItem;
    actProjectSelect: TAction;
    actProjectCreate: TAction;
    actImportExcel: TAction;
    actWindowCascade: TWindowCascade;
    actWindowTileHorizontal: TWindowTileHorizontal;
    actWindowTileVertical: TWindowTileVertical;
    actWindowMinimizeAll: TWindowMinimizeAll;
    actWindowArrangeAll: TWindowArrange;
    actAbout: TAction;
    actWindowClose: TWindowClose;
    actExit: TAction;
    actUsers: TAction;
    actWindowsMax: TAction;
    actHardwareKinds: TAction;
    actCustomers: TAction;
    actDevelopers: TAction;
    actSystemsOpt: TAction;
    actChangeUser: TAction;
    actTemplateFR: TAction;
    actUpdateTables: TAction;
    actKindSystems: TAction;
    actFilesImportExport: TAction;
    actCustomize: TAction;
    ToolBar: TActionToolBar;
    MicrosoftExcel1: TMenuItem;
    actProgrammWebsite: TAction;
    TrayIcon: TTrayIcon;
    pmTray: TPopupMenu;
    MenuItem1: TMenuItem;
    miAnticlose: TMenuItem;
    actWindowsAntiClose: TAction;
    N24: TMenuItem;
    InstrumentSplitter: TJvSplitter;
    actProjectHardwareAdd: TAction;
    actProjectSystemsExport: TAction;
    actSystemsAdd: TAction;
    actProjectSystemsImport: TAction;
    actProjectSystemsAdd: TAction;
    actProjectHardwareDelete: TAction;
    actHardwareAdd: TAction;
    actHardwareCopy: TAction;
    actHardwareMove: TAction;
    actSystemsEdit: TAction;
    QuerySRC: TFDQuery;
    QueryDST: TFDQuery;
    actHardwareDelete: TAction;
    actSystemsDelete: TAction;
    actProjectSystemsDelete: TAction;
    actProjectSystemsEdit: TAction;
    actProjectHardwareEdit: TAction;
    actHardwareEdit: TAction;
    actSequence: TAction;
    N1: TMenuItem;
    dd1: TMenuItem;
    TimerCheckAll: TTimer;
    miLang: TMenuItem;
    miLangAlways: TMenuItem;
    miLangMixed: TMenuItem;
    miLangNever: TMenuItem;
    ExportHTML: TJvDBGridHTMLExport;
    actExportExcel: TAction;
    ExportWord: TJvDBGridWordExport;
    ExportExcel: TJvDBGridExcelExport;
    ExportCSV: TJvDBGridCSVExport;
    ExportXML: TJvDBGridXMLExport;
    ExportFileDialog: TSaveDialog;
    MicrosoftExcel2: TMenuItem;
    actCopyToClipboard: TAction;
    actGenerator: TAction;
    N14: TMenuItem;
    QueryTimer: TFDQuery;
    actInstumentsAlign: TAction;
    N26: TMenuItem;
    actMail: TAction;
    N16: TMenuItem;
    N29: TMenuItem;
    miExternal: TMenuItem;
    miXLS: TMenuItem;
    xls1: TMenuItem;
    xls2: TMenuItem;
    xls3: TMenuItem;
    jpg1: TMenuItem;
    jpg2: TMenuItem;
    jpg3: TMenuItem;
    InstrumentPanel: TPageControl;
    ToolsHardware: TTabSheet;
    ToolsSystems: TTabSheet;
    ToolsTracker: TTabSheet;
    actCertificates: TAction;
    N30: TMenuItem;
    miRecent: TMenuItem;
    PDF1: TMenuItem;
    miInternalPDF: TMenuItem;
    AppUserSettings: TJvAppIniFileStorage;
    QueryLog: TFDQuery;
    actClearFileStore: TAction;
    ImageList24b: TImageList;
    actProjectSystemsCopy: TAction;
    actSystemsCopy: TAction;
    AdvGridExcelIO1: TAdvGridExcelIO;
    miMaxWindows: TMenuItem;
    miLangNow: TMenuItem;
    N32: TMenuItem;
    Procedure actProjectSelectExecute(Sender: TObject);
    Procedure actAboutExecute(Sender: TObject);
    Procedure actExitExecute(Sender: TObject);
    Procedure actHardwareKindsExecute(Sender: TObject);
    Procedure actObjectsFilterEditExecute(Sender: TObject);
    Procedure FormCreate(Sender: TObject);
    Procedure FormDestroy(Sender: TObject);
    Procedure AppEventsHint(Sender: TObject);
    Procedure actExportExcelExecute(Sender: TObject);
    Procedure actExportExcelUpdate(Sender: TObject);
    Procedure actImportExcelExecute(Sender: TObject);
    Procedure actImportExcelUpdate(Sender: TObject);
    Procedure actPrintExecute(Sender: TObject);
    Procedure actImportDataExecute(Sender: TObject);
    Procedure actProjectSelectUpdate(Sender: TObject);
    Procedure actHardwareKindsUpdate(Sender: TObject);
    Procedure FormShow(Sender: TObject);
    Procedure actUsersExecute(Sender: TObject);
    Procedure actUnitsExecute(Sender: TObject);
    Procedure actUsersUpdate(Sender: TObject);
    Procedure actUnitsUpdate(Sender: TObject);
    Procedure actProjectCreateExecute(Sender: TObject);
    Procedure actProjectCreateUpdate(Sender: TObject);
    Procedure actCustomersExecute(Sender: TObject);
    Procedure actSystemsExecute(Sender: TObject);
    Procedure actSystemsUpdate(Sender: TObject);
    Procedure actDevelopersExecute(Sender: TObject);
    Procedure actSystemsOptExecute(Sender: TObject);
    procedure actChangeUserExecute(Sender: TObject);
    procedure actSystemsOptUpdate(Sender: TObject);
    procedure actUpdateTablesExecute(Sender: TObject);
    procedure actUpdateTablesUpdate(Sender: TObject);
    procedure actOperationsExecute(Sender: TObject);
    procedure N18Click(Sender: TObject);
    procedure N19Click(Sender: TObject);
    procedure actTemplateFRUpdate(Sender: TObject);
    procedure actTemplateFRExecute(Sender: TObject);
    procedure actKindSystemsExecute(Sender: TObject);
    procedure actCustomizeExecute(Sender: TObject);
    procedure actFilesImportExportExecute(Sender: TObject);
    procedure actFilesImportExportUpdate(Sender: TObject);
    procedure ToolBarDblClick(Sender: TObject);
    procedure actProgrammWebsiteExecute(Sender: TObject);
    procedure actChangeUserUpdate(Sender: TObject);
    procedure actCustomersUpdate(Sender: TObject);
    procedure actDevelopersUpdate(Sender: TObject);
    procedure actKindSystemsUpdate(Sender: TObject);
    procedure actCustomizeUpdate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure actWindowsMaxExecute(Sender: TObject);
    procedure actWindowsAntiCloseExecute(Sender: TObject);
    procedure actWindowsMaxUpdate(Sender: TObject);
    procedure actWindowsAntiCloseUpdate(Sender: TObject);
    procedure ss1Click(Sender: TObject);
    procedure DockLeftUnDock(Sender: TObject; Client: TControl; NewTarget: TWinControl; var Allow: Boolean);
    procedure DockLeftResize(Sender: TObject);
    procedure InstrumentSplitterCanResize(Sender: TObject; var NewSize: Integer; var Accept: Boolean);
    procedure CategoryHardwareExpand;
    procedure CategorySystemsExpand;
    procedure CategoryTrackerExpand;
    procedure actProjectHardwareAddExecute(Sender: TObject);
    procedure actProjectHardwareDeleteExecute(Sender: TObject);
    procedure actProjectHardwareAddUpdate(Sender: TObject);
    procedure actProjectSystemsImportExecute(Sender: TObject);
    procedure actProjectSystemsImportUpdate(Sender: TObject);
    procedure actHardwareAddExecute(Sender: TObject);
    procedure actHardwareCopyExecute(Sender: TObject);
    procedure actHardwareEditExecute(Sender: TObject);
    procedure actHardwareMoveExecute(Sender: TObject);
    procedure actHardwareDeleteExecute(Sender: TObject);
    procedure actHardwareAddUpdate(Sender: TObject);
    procedure actProjectHardwareEditUpdate(Sender: TObject);
    procedure actProjectHardwareDeleteUpdate(Sender: TObject);
    procedure actHardwareDeleteUpdate(Sender: TObject);
    procedure actHardwareMoveUpdate(Sender: TObject);
    procedure actHardwareEditUpdate(Sender: TObject);
    procedure actHardwareCopyUpdate(Sender: TObject);
    procedure actSystemsEditExecute(Sender: TObject);
    procedure actSystemsAddExecute(Sender: TObject);
    procedure actSystemsDeleteExecute(Sender: TObject);
    procedure actSystemsDeleteUpdate(Sender: TObject);
    procedure actSequenceUpdate(Sender: TObject);
    procedure actSequenceExecute(Sender: TObject);
    procedure actProjectSystemsAddExecute(Sender: TObject);
    procedure actProjectSystemsEditExecute(Sender: TObject);
    procedure actProjectSystemsDeleteExecute(Sender: TObject);
    procedure TimerCheckAllTimer(Sender: TObject);
    procedure miLangNeverClick(Sender: TObject);
    procedure actCopyToClipboardExecute(Sender: TObject);
    procedure actCopyToClipboardUpdate(Sender: TObject);
    procedure actGeneratorExecute(Sender: TObject);
    procedure actSystemsEditUpdate(Sender: TObject);
    procedure actInstumentsAlignExecute(Sender: TObject);
    procedure actMailExecute(Sender: TObject);
    procedure miSetExtension(Sender: TObject);
    procedure InstrumentPanelChange(Sender: TObject);
    procedure actCertificatesExecute(Sender: TObject);
    procedure OpenRecent(Sender: TObject);
    procedure CustomizeDlgClose(Sender: TObject);
    procedure actProjectHardwareEditExecute(Sender: TObject);
    procedure actCertificatesUpdate(Sender: TObject);
    procedure actGeneratorUpdate(Sender: TObject);
    procedure actMailUpdate(Sender: TObject);
    procedure actSystemsAddUpdate(Sender: TObject);
    procedure actProjectSystemsAddUpdate(Sender: TObject);
    procedure actProjectSystemsExportUpdate(Sender: TObject);
    procedure actProjectSystemsExportExecute(Sender: TObject);
    procedure actProjectSystemsEditUpdate(Sender: TObject);
    procedure actProjectSystemsDeleteUpdate(Sender: TObject);
    procedure actClearFileStoreExecute(Sender: TObject);
    procedure actProjectSystemsCopyExecute(Sender: TObject);
    procedure actSystemsCopyExecute(Sender: TObject);
    procedure actSystemsCopyUpdate(Sender: TObject);
    procedure miInternalPDFClick(Sender: TObject);
    procedure actProjectSystemsCopyUpdate(Sender: TObject);
    procedure miLangNowClick(Sender: TObject);
  Private
    procedure AutoLogon;
    procedure SetUserRights;
    procedure ExecSQL(SQL: string);
    function getpriv(const privilegename: string): Boolean;
    procedure ToolsCreate(FormClass: string; tools: Boolean);
    procedure CheckAllFiles;
    procedure InformAboutUpdate(rec_no: Integer);
    procedure SetInstrumentPanel;
    procedure RecentRecreate;
    procedure SaveMenuSettings;
    procedure LoadMenuSettings;

  Var
    FirstActivate: Boolean;
    NewCaption: String;
    eng, rus: String;
    dockleft_width: Integer;
    // procedure DBConnect;
    // procedure ExtLibrary;
    { Private declarations }
  Public
    extensions: TstringList;
    recent_projects: TstringList;
    ws: TWindowState;
    Reg: TRegistry;
    // projectpath: String;
    // firstwindow: Boolean;
    username: String;
    userpass: String;
    usergroup: String;
    useractive: Integer;

    current_projectname: string;
    current_projectcaption: string;
    current_projectno: Integer;
    current_projectsystemname: string;
    current_projectsystemtag: string;
    current_projectsystemno: Integer;

    current_hardwareno: Integer;

    current_systemno: Integer;

    debug: Boolean; // 1-  ,  
    IconAttachment: TBitmap;

    lastreportname: string;
    Function MDIExists(FormCaption: String): Boolean;
    Function Translit(s: String): String;
    Procedure ReadSettings;
    Procedure SaveSettings;
    Function DateTimeForSQL(Const DateTime: TDateTime): String;
    Function MD5(Const filename: String): String;
    function TransformToEN(s: String): String;
    function TransformToRU(s: String): String;
    function GetNextValue(old: string): string;
    function FloatToMySQL(f: Extended): String;
    function OpenFile(filename: string): Boolean;
    procedure OpenProject(Project_no: Integer);
    procedure Log(operation: Integer; table, project, System, text: string);
    { Public declarations }
  End;

Var
  frmMain: TfrmMain;

Implementation

{$R *.dfm}

Uses ObjectsFiles, about, dialogFilter,
  Templates, ImportData, ImageProcess, ClipBrd, Users,
  Valuta, OrderSelect, OrderNew, project,
  Customers, IdHashMessageDigest, idHash, Developers, SystemsOpts,
  UserLogin, Operations, FindLost, TemplatesFR, KindSystems,
  FilesImportExport, Universal, DescEdit, HardwareAdd,
  HardwareDelete, HardwareMove, SystemsAdd, Sequence, DoCopyHardware,
  SystemsDelete, LangColor, Generator, Mail, ImportPrices, Certificates,
  PDFViewer;

Procedure TfrmMain.actExportExcelExecute(Sender: TObject);
var
  fn, ext: string;
  selectedJvGrid: TJvDBGrid;
  selectedAdvGrid: TDBAdvGrid;
Begin
  fn := current_projectname + '.html';
  ExportFileDialog.filename := fn;
  If FileExists(fn) Then
    DeleteFile(fn);

  if (Screen.ActiveControl is TJvDBGrid) then
  begin
    selectedJvGrid := TJvDBGrid(Screen.ActiveControl);
    If ExportFileDialog.Execute Then
      try
        fn := ExportFileDialog.filename;
        ext := ExtractFileExt(fn);
        if ext = '' then
        begin
          ext := '.xls';
          fn := fn + ext;
        end;

        if ext = '.doc' then
        begin
          ExportWord.Caption := fn;
          ExportWord.Grid := selectedJvGrid;
          ExportWord.filename := fn;
          ExportWord.ExportGrid;
        end;

        if ext = '.xls' then
        begin
          ExportExcel.Caption := fn;
          ExportExcel.Grid := selectedJvGrid;
          ExportExcel.filename := fn;
          ExportExcel.ExportGrid;
        end;

        if ext = '.html' then
        begin
          ExportHTML.Caption := fn;
          ExportHTML.Grid := selectedJvGrid;
          ExportHTML.filename := fn;
          ExportHTML.ExportGrid;
        end;

        if ext = '.csv' then
        begin
          ExportCSV.Caption := fn;
          ExportCSV.Grid := selectedJvGrid;
          ExportCSV.filename := fn;
          ExportCSV.ExportGrid;
        end;

        if ext = '.xml' then
        begin
          ExportXML.Caption := fn;
          ExportXML.Grid := selectedJvGrid;
          ExportXML.filename := fn;
          ExportXML.ExportGrid;
        end;

      except
        ShowMessage(' ');
      End;

  end;

  if (Screen.ActiveControl is TDBAdvGrid) then
  begin
    selectedAdvGrid := TDBAdvGrid(Screen.ActiveControl);
    If ExportFileDialog.Execute Then
      try
        fn := ExportFileDialog.filename;
        ext := ExtractFileExt(fn);
        if ext = '' then
        begin
          ext := '.xls';
          fn := fn + ext;
        end;

        if ext = '.xls' then
        begin
          AdvGridExcelIO1.AdvStringGrid := selectedAdvGrid;
          AdvGridExcelIO1.XLSExport(fn);
        end;

      except
        ShowMessage(' ');
      End;
  end;

  // 

  If FileExists(fn) Then
    frmMain.OpenFile(fn);
End;

Procedure TfrmMain.actExportExcelUpdate(Sender: TObject);
Begin
  actExportExcel.Enabled := frmUniversal.DBConnected and
    ((Screen.ActiveControl is TJvDBGrid) OR (Screen.ActiveControl is TDBAdvGrid));
End;

Procedure TfrmMain.actImportDataExecute(Sender: TObject);
Begin
  TfrmImportData.Create(Application);
End;

Procedure TfrmMain.actImportExcelExecute(Sender: TObject);
Begin
  // frmImportFromXLS.ShowModal;
  NewCaption := '   ';
  If Not MDIExists(NewCaption) Then
    With TfrmImportPrices.Create(Application) Do
      Caption := NewCaption;
End;

Procedure TfrmMain.actImportExcelUpdate(Sender: TObject);
Begin
  actImportExcel.Enabled := frmUniversal.DBConnected and (useractive > 0);
End;

procedure TfrmMain.actInstumentsAlignExecute(Sender: TObject);
begin
  SetInstrumentPanel;
end;

procedure TfrmMain.actSequenceExecute(Sender: TObject);
begin
  frmSequence.ShowModal;
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TfrmProject) then
  begin
    TfrmProject(ActiveMDIChild).TPrSystems.Refresh;
    TfrmProject(ActiveMDIChild).TPrHardware.Refresh;
  end;
  if frmSystems <> nil then
    frmSystems.OnActivate(self);
end;

procedure TfrmMain.actSequenceUpdate(Sender: TObject);
begin
  actSequence.Enabled := frmUniversal.DBConnected and (frmSequence <> nil) and (frmSequence.TQuerySRC.SQL.text <> '');
end;

procedure TfrmMain.ToolBarDblClick(Sender: TObject);
begin
  actCustomize.Execute;
end;

procedure TfrmMain.actCustomizeExecute(Sender: TObject);
begin
  CustomizeDlg.Show;
end;

procedure TfrmMain.actCustomizeUpdate(Sender: TObject);
begin
  actCustomize.Enabled := frmUniversal.DBConnected and (useractive > 0);
end;

procedure TfrmMain.actFilesImportExportExecute(Sender: TObject);
begin
  frmFilesImportExport.ShowModal;
end;

procedure TfrmMain.actFilesImportExportUpdate(Sender: TObject);
begin
  actFilesImportExport.Enabled := frmUniversal.DBConnected and (useractive > 1);
end;

procedure TfrmMain.actGeneratorExecute(Sender: TObject);
begin
  frmGenerator.ShowModal;
end;

procedure TfrmMain.actGeneratorUpdate(Sender: TObject);
begin
  actGenerator.Enabled := frmUniversal.DBConnected;
end;

procedure TfrmMain.actProjectHardwareDeleteExecute(Sender: TObject);
// var
// article: string;
// HardwareNo: Integer;
begin
  if not(ActiveMDIChild is TfrmProject) then
    exit;

  TfrmProject(ActiveMDIChild).TPrHardware.Delete;

  frmUniversal.UpdateTotalQuery(current_projectsystemno);

  // HardwareNo := TfrmProject(ActiveMDIChild).TPrHardware.FieldByName('rec_no').AsInteger;
  // article := TfrmProject(ActiveMDIChild).TPrHardware.FieldByName('article').AsString;

  // if ((MessageDlg(' "'+article+'"?', mtCustom, [mbYes, mbCancel], 0) = mrYes) then
  // begin
  // frmMain.Log(3, 'uni_projecthardware', current_projectname, current_projectsystemname, article);
  // end;
end;

procedure TfrmMain.actProjectHardwareDeleteUpdate(Sender: TObject);
begin
  actProjectHardwareDelete.Enabled := frmUniversal.DBConnected and (ActiveMDIChild is TfrmProject) and
    (current_projectno > -1) and (current_projectsystemno > -1);
end;

procedure TfrmMain.actProjectHardwareEditExecute(Sender: TObject);
Var
  TemplateNo, HardwareNo: Integer;
  article, Project_name, system_name: string;
Begin
  if (ActiveMDIChild = nil) or not(ActiveMDIChild is TfrmProject) then
    exit;

  HardwareNo := TfrmProject(ActiveMDIChild).TPrHardware.FieldByName('rec_no').AsInteger;
  article := TfrmProject(ActiveMDIChild).TPrHardware.FieldByName('article').AsString;
  Project_name := TfrmProject(ActiveMDIChild).Project_name;
  system_name := TfrmProject(ActiveMDIChild).system_name;
  TemplateNo := -1; // TfrmProject(ActiveMDIChild).TPrHardware.FieldByName('kind').AsInteger;

  frmHardwareAdd.HardwareNo := HardwareNo;
  frmHardwareAdd.CategoryNo := TemplateNo;
  frmHardwareAdd.tableSRC := 'uni_projecthardware';

  if frmHardwareAdd.ShowModal = mrOk Then
  Begin
    frmUniversal.UpdateTotalQuery(current_projectsystemno);
    frmMain.Log(2, 'uni_projecthardware', Project_name, system_name, article);
    TfrmProject(ActiveMDIChild).TPrHardware.Refresh;
  End;
end;

procedure TfrmMain.actProjectHardwareEditUpdate(Sender: TObject);
begin
  actProjectHardwareEdit.Enabled := frmUniversal.DBConnected and (current_projectno > -1) and
    (current_projectsystemno > -1);
end;

procedure TfrmMain.actProjectHardwareAddExecute(Sender: TObject);
var
  neworder: Integer;
  article: string;
begin
  if not((current_hardwareno > -1) and (current_projectno > -1) and (current_projectsystemno > -1)) then
  begin
    exit;
  end;

  // current_projectsystemno
  QuerySRC.SQL.text :=
    'SELECT MAX(orderby) FROM `uni_projecthardware` WHERE `project_no`=:project_no AND `system_no`=:system_no;';
  QuerySRC.ParamByName('project_no').AsInteger := current_projectno;
  QuerySRC.ParamByName('system_no').AsInteger := current_projectsystemno;
  QuerySRC.Active := true;
  neworder := QuerySRC.Fields[0].AsInteger + 1;

  QuerySRC.SQL.text := 'SELECT * FROM `uni_hardware` WHERE `rec_no`=:hardwareno;';
  QuerySRC.ParamByName('hardwareno').AsInteger := current_hardwareno;
  QuerySRC.Active := true;

  QueryDST.SQL.text :=
    'INSERT INTO `uni_projecthardware` (`project_no`,`system_no`,`orderby`,`article`,`kinddesc`,`name`,`comment`,`price`,`count`,`valuta`,`file`,`developer`,`modules`,`modules2`,`expire`,`lastupdate`,`username`,`din`)'
    + ' VALUES (:project_no,:system_no,:orderby,:article,:kinddesc,:name,:comment,:price,:count,:valuta,:file,:developer,:modules,:modules2,:expire,:lastupdate,:username,:din);';
  QueryDST.ParamByName('project_no').AsInteger := current_projectno;
  QueryDST.ParamByName('system_no').AsInteger := current_projectsystemno;
  QueryDST.ParamByName('orderby').AsInteger := neworder;
  QueryDST.ParamByName('article').AsString := QuerySRC.FieldByName('article').AsString;
  QueryDST.ParamByName('kinddesc').AsString := QuerySRC.FieldByName('kinddesc').AsString;
  QueryDST.ParamByName('name').AsString := QuerySRC.FieldByName('name').AsString;
  QueryDST.ParamByName('comment').AsString := QuerySRC.FieldByName('comment').AsString;
  QueryDST.ParamByName('price').AsFloat := QuerySRC.FieldByName('price').AsFloat;
  QueryDST.ParamByName('count').AsInteger := 1;
  QueryDST.ParamByName('din').AsInteger := QuerySRC.FieldByName('din').AsInteger;
  QueryDST.ParamByName('valuta').AsString := QuerySRC.FieldByName('valuta').AsString;
  QueryDST.ParamByName('file').AsString := QuerySRC.FieldByName('file').AsString;
  QueryDST.ParamByName('developer').AsString := QuerySRC.FieldByName('developer').AsString;
  QueryDST.ParamByName('modules').AsFloat := QuerySRC.FieldByName('modules').AsFloat;
  QueryDST.ParamByName('modules2').AsFloat := QuerySRC.FieldByName('modules2').AsFloat;
  QueryDST.ParamByName('expire').AsDateTime := QuerySRC.FieldByName('expire').AsDateTime;
  QueryDST.ParamByName('lastupdate').AsDateTime := now();
  QueryDST.ParamByName('username').AsString := username;
  QueryDST.ExecSQL;
  //
  article := QuerySRC.FieldByName('article').AsString;
  //
  frmMain.Log(1, 'uni_projecthardware', current_projectname, current_projectsystemname, article);
  //
  frmUniversal.UpdateTotalQuery(current_projectsystemno);

  if (ActiveMDIChild is TfrmProject) then
    (ActiveMDIChild as TfrmProject).MakeCountFocused(article);

end;

procedure TfrmMain.actProjectHardwareAddUpdate(Sender: TObject);
begin
  actProjectHardwareAdd.Enabled := frmUniversal.DBConnected and (current_hardwareno > -1) and (current_projectno > -1)
    and (current_projectsystemno > -1);
end;

procedure TfrmMain.actKindSystemsExecute(Sender: TObject);
begin
  NewCaption := '  ';
  If Not MDIExists(NewCaption) Then
    With TfrmKindSystems.Create(Application) Do
      Caption := NewCaption;
end;

procedure TfrmMain.actKindSystemsUpdate(Sender: TObject);
begin
  actKindSystems.Enabled := frmUniversal.DBConnected and (useractive > 0);
end;

procedure TfrmMain.actMailExecute(Sender: TObject);
begin
  frmMail.ShowModal;
end;

procedure TfrmMain.actMailUpdate(Sender: TObject);
begin
  actMail.Enabled := frmUniversal.DBConnected;
end;

procedure TfrmMain.actTemplateFRExecute(Sender: TObject);
begin
  NewCaption := '';
  If Not MDIExists(NewCaption) Then
    With TfrmTemplatesFR.Create(Application) Do
      Caption := NewCaption;
end;

procedure TfrmMain.actTemplateFRUpdate(Sender: TObject);
begin
  actTemplateFR.Enabled := frmUniversal.DBConnected and (useractive > 0);
end;

Procedure TfrmMain.actObjectsFilterEditExecute(Sender: TObject);
Begin
  frmDialogFilter.ShowModal;
End;

procedure TfrmMain.actOperationsExecute(Sender: TObject);
begin
  frmOperations.Show;
end;

procedure TfrmMain.actHardwareAddExecute(Sender: TObject);
Var
  TemplateNo, HardwareNo: Integer;
Begin
  if frmHardware = nil then
    exit;

  TemplateNo := frmHardware.TTemplate.FieldByName('rec_no').AsInteger;

  frmHardwareAdd.HardwareNo := -1;
  frmHardwareAdd.HardwareSrc := -1;
  frmHardwareAdd.CategoryNo := TemplateNo;
  frmHardwareAdd.tableSRC := 'uni_hardware';

  if frmHardwareAdd.ShowModal = mrOk Then
  Begin
    if frmHardware <> nil then
      frmHardware.TimerSearchUpdate.Enabled := true;
    frmMain.Log(1, 'uni_hardware', '', '', trim(frmHardwareAdd._article.text));
  End;

end;

procedure TfrmMain.actHardwareAddUpdate(Sender: TObject);
begin
  actHardwareAdd.Enabled := frmUniversal.DBConnected and (frmHardware <> nil) and (current_hardwareno > -1);
end;

procedure TfrmMain.actHardwareCopyExecute(Sender: TObject);
Var
  TemplateNo, HardwareNo: Integer;
  s1, s2: String;
Begin
  if frmHardware = nil then
    exit;

  TemplateNo := frmHardware.TTemplate.FieldByName('rec_no').AsInteger;

  frmHardwareAdd.HardwareNo := -1;
  frmHardwareAdd.HardwareSrc := frmHardware.THardware.FieldByName('rec_no').AsInteger;
  frmHardwareAdd.CategoryNo := TemplateNo;
  // frmHardwareAdd.CategoryNo := frmHardware.THardware.FieldByName('kind').AsInteger; ??
  frmHardwareAdd.tableSRC := 'uni_hardware';

  if frmHardwareAdd.ShowModal = mrOk Then
  begin
    if frmHardware <> nil then
      frmHardware.TimerSearchUpdate.Enabled := true;
    frmMain.Log(1, 'uni_hardware', '', '', trim(frmHardwareAdd._article.text));
  end;
end;

procedure TfrmMain.actHardwareCopyUpdate(Sender: TObject);
begin
  actHardwareCopy.Enabled := frmUniversal.DBConnected and (frmHardware <> nil) and (current_hardwareno > -1);
end;

procedure TfrmMain.actHardwareDeleteExecute(Sender: TObject);
var
  article: string;
begin
  If frmHardwareDelete.ShowModal = mrOk Then
  Begin
    article := frmHardware.THardware.FieldByName('article').AsString;
    { If frmHardware.HardwareGrid.SelCount > 0 Then
      Begin
      frmHardware.HardwareGrid.SelectedRows.Delete;
      End
      Else }
    Begin
      If frmHardware.THardware.RecNo > 0 Then
        frmHardware.THardware.Delete;
    End;
    if frmHardware <> nil then
      frmHardware.TimerSearchUpdate.Enabled := true;

    frmMain.Log(3, 'uni_hardware', '', '', article);
  End;
end;

procedure TfrmMain.actHardwareDeleteUpdate(Sender: TObject);
begin
  actHardwareDelete.Enabled := frmUniversal.DBConnected and (frmHardware <> nil) and (current_hardwareno > -1);
end;

procedure TfrmMain.actHardwareEditExecute(Sender: TObject);
Var
  TemplateNo, HardwareNo: Integer;
Begin
  if frmHardware = nil then
    exit;
  If (frmHardware.THardware.RecordCount < 1) Then
    exit;

  TemplateNo := frmHardware.TTemplate.FieldByName('rec_no').AsInteger;
  HardwareNo := frmHardware.THardware.FieldByName('rec_no').AsInteger;

  frmHardwareAdd.HardwareNo := HardwareNo;
  frmHardwareAdd.CategoryNo := frmHardware.THardware.FieldByName('kind').AsInteger;
  frmHardwareAdd.tableSRC := 'uni_hardware';

  if frmHardwareAdd.ShowModal = mrOk Then
  Begin
    if frmHardware <> nil then
      frmHardware.TimerSearchUpdate.Enabled := true;
    frmMain.Log(2, 'uni_hardware', '', '', trim(frmHardwareAdd._article.text));
  End;

end;

procedure TfrmMain.actHardwareEditUpdate(Sender: TObject);
begin
  actHardwareEdit.Enabled := frmUniversal.DBConnected and (frmHardware <> nil) and (current_hardwareno > -1);
end;

Procedure TfrmMain.actHardwareKindsExecute(Sender: TObject);
Begin
  NewCaption := ' ';
  If Not MDIExists(NewCaption) Then
    With TfrmTemplates.Create(Application) Do
      Caption := NewCaption;
End;

Procedure TfrmMain.actHardwareKindsUpdate(Sender: TObject);
Begin
  actHardwareKinds.Enabled := frmUniversal.DBConnected and (useractive > 0);
End;

procedure TfrmMain.actHardwareMoveExecute(Sender: TObject);
Var
  i: Integer;
  article: string;
Begin
  // 
  If frmHardwareMove.ShowModal = mrOk Then
    with frmHardware do
      Try
        THardware.DisableControls;
        article := frmHardware.THardware.FieldByName('article').AsString;
        If frmHardwareMove.dir > 0 Then
        Begin
          If TTemplate.RecNo > 0 Then
            Try
              THardware.Edit;
              THardware.FieldByName('kind').AsInteger := frmHardwareMove.dir;
              THardware.Post;
            Except
            End;
        End;
        frmHardware.THardware.EnableControls;

        if frmHardware <> nil then
          frmHardware.TimerSearchUpdate.Enabled := true;

        frmUniversal.UpdateTotalQuery(current_projectsystemno);

        frmMain.Log(1, 'uni_hardware', '', '', article);
      Except
      End;
  // frmHardware.HardwareGrid.SelectedRows.Clear;
end;

procedure TfrmMain.actHardwareMoveUpdate(Sender: TObject);
begin
  actHardwareMove.Enabled := (frmHardware <> nil) and (current_hardwareno > -1);
end;

Procedure TfrmMain.actUsersExecute(Sender: TObject);
Begin
  NewCaption := '';
  If Not MDIExists(NewCaption) Then
    With TfrmUsers.Create(Application) Do
      Caption := NewCaption;
End;

Procedure TfrmMain.actUsersUpdate(Sender: TObject);
Begin
  actUsers.Enabled := frmUniversal.DBConnected and (useractive = 2);
End;

procedure TfrmMain.actWindowsAntiCloseExecute(Sender: TObject);
begin
  //
end;

procedure TfrmMain.actWindowsAntiCloseUpdate(Sender: TObject);
begin
  actWindowsAntiClose.Enabled := true;
end;

procedure TfrmMain.actWindowsMaxExecute(Sender: TObject);
begin
  //
end;

procedure TfrmMain.actWindowsMaxUpdate(Sender: TObject);
begin
  actWindowsMax.Enabled := true;
end;

Procedure TfrmMain.actUnitsExecute(Sender: TObject);
Begin
  ToolsCreate('TfrmHardware', true);
End;

Procedure TfrmMain.actUnitsUpdate(Sender: TObject);
Begin
  // actUnits.Enabled := useractive > 0;
End;

procedure TfrmMain.actUpdateTablesExecute(Sender: TObject);
begin
  frmFindLost.ShowModal;
end;

procedure TfrmMain.ExecSQL(SQL: string);
begin
  Try
    frmUniversal.MyQuery1.SQL.text := SQL;
    frmUniversal.MyQuery1.Execute;
  Except
  End;
end;

procedure TfrmMain.actUpdateTablesUpdate(Sender: TObject);
begin
  actUpdateTables.Enabled := frmUniversal.DBConnected and (useractive > 1);
end;

Procedure TfrmMain.actProjectSelectExecute(Sender: TObject);
Begin
  If frmUniversal.DBConnected Then
    frmOrderSelect.Show;
End;

procedure TfrmMain.SetInstrumentPanel;
begin
  if actInstumentsAlign.Checked then
  begin
    InstrumentPanel.Align := alRight;
    InstrumentSplitter.Align := alRight;
  end
  else
  begin
    InstrumentPanel.Align := alLeft;
    InstrumentSplitter.Align := alLeft;
  end;
end;

procedure TfrmMain.N18Click(Sender: TObject);
var
  fn: string;
  Com: string;
begin
  getpriv('SeBackupPrivilege');
  if SaveDialog1.Execute then
  begin
    fn := SaveDialog1.filename;
    DeleteFile(fn);
    Com := '/e ' + fn + ' HKEY_CURRENT_USER\Software\mysoftware\orderbase2';
    Clipboard.SetTextBuf(Pchar(Com));
    ShellExecute(Handle, 'open', 'regedit', Pchar(Com), nil, SW_SHOWNORMAL);
  end;
end;

procedure TfrmMain.N19Click(Sender: TObject);
var
  fn: string;
  Com: string;
begin
  getpriv('SeBackupPrivilege');
  if SaveDialog1.Execute then
  begin
    fn := SaveDialog1.filename;
    DeleteFile(fn);
    Com := '/s ' + fn;
    Clipboard.SetTextBuf(Pchar(Com));
    ShellExecute(Handle, 'open', 'regedit', Pchar(Com), nil, SW_SHOWNORMAL);
  end;
end;

procedure TfrmMain.miLangNowClick(Sender: TObject);
begin
  if frmLangColor.Visible then
    frmLangColor.Hide
  else
    frmLangColor.ShowText(Screen.ActiveControl);
end;

procedure TfrmMain.miInternalPDFClick(Sender: TObject);
begin
  SaveSettings;
end;

procedure TfrmMain.miLangNeverClick(Sender: TObject);
begin
  frmLangColor.show_always := miLangAlways.Checked;
  frmLangColor.show_mixedonly := miLangMixed.Checked;
  frmLangColor.Hide;
end;

procedure TfrmMain.CheckAllFiles;
var
  i: Integer;
  postfix, fn: string;
  cnt_removed: Integer;
begin
  cnt_removed := 0;
  //    
  for i := 0 to 255 do
  begin
    try
      postfix := IntToHex(i, 2);
      StatusBar.Panels[2].text := ': ' + postfix;
      Application.ProcessMessages;
      QuerySRC.SQL.text := 'SELECT `name` FROM `files_' + postfix + '`;'; // ,length(`file`)
      QuerySRC.Active := true;
      while not QuerySRC.eof do
      begin
        fn := QuerySRC.FieldByName('name').AsString;
        if frmUniversal.RemoveUnusedFile(fn) then
        begin
          StatusBar.Panels[3].text := fn + ' - ';
          inc(cnt_removed);
        end
        else
        begin
          StatusBar.Panels[3].text := fn + ' - ';
        end;
        Application.ProcessMessages;
        QuerySRC.Next;
      end;
    except
    end;
  end;

  StatusBar.Panels[2].text := '';
  StatusBar.Panels[3].text := '  . : ' + cnt_removed.ToString;
end;

function TfrmMain.getpriv(const privilegename: string): Boolean;
var
  LUId: tlargeinteger;
  Priv: ttokenprivileges;
  Token: thandle;
  C: cardinal;
begin
  result := openprocesstoken(getcurrentprocess, TOKEN_ADJUST_PRIVILEGES, Token);
  if not result then
    exit;
  result := lookupprivilegevalue(nil, Pchar(privilegename), LUId);
  if not result then
    exit;
  Priv.privilegecount := 1;
  Priv.privileges[0].LUId := LUId;
  Priv.privileges[0].attributes := SE_PRIVILEGE_ENABLED;
  result := adjusttokenprivileges(Token, false, Priv, sizeof(ttokenprivileges), nil, C);
end;

Procedure TfrmMain.actPrintExecute(Sender: TObject);
Begin
  { if (MDIChildCount > 0) and (ActiveMDIChild is TfrmReport1) then
    (ActiveMDIChild as TfrmReport1)
    .Print; }
End;

procedure TfrmMain.actProgrammWebsiteExecute(Sender: TObject);
begin
  ShellExecute(Handle, 'Open', Pchar('http://bast.mysoftware.ru'), Nil, Nil, 1);
end;

Procedure TfrmMain.actProjectCreateExecute(Sender: TObject);
Begin
  frmOrderNew.Caption := ' ';
  frmOrderNew._Description.text := '  ';
  frmOrderNew.CopyFrom := -1;
  If frmUniversal.DBConnected Then
    If frmOrderNew.ShowModal = mrOk Then
    Begin
      NewCaption := ' ' + frmOrderNew._name.text + ' (' + frmOrderNew._customers.text + ')';
      If Not MDIExists(NewCaption) Then
        With TfrmProject.Create(Application) Do
        Begin
          Project_no := frmOrderNew.Project_no;
          Project_description := frmOrderNew._Description.text;
          Project_name := frmOrderNew._name.text;
          Project_customer := frmOrderNew._customers.text;
          Project_engineer := frmOrderNew._engineers.text;
          Project_manager := frmOrderNew._managers.text;
          Project_datestart := frmOrderNew.Project_datestart;
          Project_dateend := frmOrderNew.Project_dateend;
          Project_options := '00000';
          Caption := NewCaption;
          FormActivate(self);
        End;
      frmMain.Log(1, 'uni_projects', '', '', trim(frmOrderNew._name.text));
    End;
End;

Procedure TfrmMain.actProjectCreateUpdate(Sender: TObject);
Begin
  actProjectCreate.Enabled := frmUniversal.DBConnected and (useractive > 0);
End;

procedure TfrmMain.actSystemsAddExecute(Sender: TObject);
begin
  if frmSystems = nil then
    exit;
  frmSystemsAdd.Project_no := -1;
  frmSystemsAdd.SRC_tablename := '';
  frmSystemsAdd.SRC_systemno := -1;
  frmSystemsAdd.DST_tablename := 'uni_systems';
  frmSystemsAdd.DST_systemno := -1;

  if frmSystemsAdd.ShowModal = mrOk then
  begin
    if frmSystems <> nil then
      frmSystems.TSystems.Refresh;
    frmMain.Log(1, 'uni_systems', '', '', trim(frmSystemsAdd.editName.text));
  end;

end;

procedure TfrmMain.actSystemsAddUpdate(Sender: TObject);
begin
  actSystemsAdd.Enabled := frmUniversal.DBConnected;
end;

procedure TfrmMain.actSystemsCopyExecute(Sender: TObject);
begin
  //    
  frmSystemsAdd.Project_no := current_projectno;
  frmSystemsAdd.SRC_tablename := 'uni_systems';
  frmSystemsAdd.SRC_systemno := current_systemno;
  frmSystemsAdd.DST_tablename := 'uni_systems';
  frmSystemsAdd.DST_systemno := -1;

  if frmSystemsAdd.ShowModal = mrOk then
  begin
    if frmSystems <> nil then
      frmSystems.TSystems.Refresh;
    frmMain.Log(1, 'uni_systems', '', '', trim(frmSystemsAdd.editName.text));
  end;
end;

procedure TfrmMain.actSystemsCopyUpdate(Sender: TObject);
begin
  actSystemsCopy.Enabled := frmUniversal.DBConnected;
end;

procedure TfrmMain.actSystemsDeleteExecute(Sender: TObject);
Var
  system_no: Integer;
  system_name: string;
Begin
  if frmSystems = nil then
    exit;

  system_no := frmSystems.TSystems.FieldByName('rec_no').AsInteger;
  system_name := frmSystems.TSystems.FieldByName('name').AsString;
  frmSystemsAdd.SRC_tablename := 'uni_systems';
  frmSystemsAdd.DST_tablename := 'uni_systems';

  frmSystemsDelete.Labelinfo.Caption := '  "' + system_name + '"?';
  if frmSystemsDelete.ShowModal <> mrOk then
    exit;

  If (system_no > 0) Then
    Try
      frmSystems.TSystems.Delete;
      frmSystems.MyQuery1.SQL.text := 'DELETE FROM `uni_systemsdetail` WHERE `system_no`=' + IntToStr(system_no) + ';';
      frmSystems.MyQuery1.Execute;
      frmMain.Log(3, 'uni_systems', '', '', system_name);
    Except
    End;
end;

procedure TfrmMain.actSystemsDeleteUpdate(Sender: TObject);
begin
  actSystemsDelete.Enabled := frmUniversal.DBConnected and (frmSystems <> nil) and (frmSystems.TSystems.RecNo > 0)
end;

procedure TfrmMain.actSystemsEditExecute(Sender: TObject);
begin
  if frmSystems = nil then
    exit;
  if frmSystems.TSystems.RecNo < 0 then
    exit;

  frmSystemsAdd.Project_no := current_projectno;
  frmSystemsAdd.SRC_tablename := 'uni_systems';
  frmSystemsAdd.SRC_systemno := frmSystems.TSystems.FieldByName('rec_no').AsInteger;
  frmSystemsAdd.DST_tablename := 'uni_systems';
  frmSystemsAdd.DST_systemno := frmSystems.TSystems.FieldByName('rec_no').AsInteger;

  if frmSystemsAdd.ShowModal = mrOk then
  begin
    if frmSystems <> nil then
      frmSystems.TSystems.Refresh;
    frmMain.Log(2, 'uni_systems', '', '', trim(frmSystemsAdd.editName.text));
    InformAboutUpdate(2);
  end;
end;

procedure TfrmMain.actSystemsEditUpdate(Sender: TObject);
begin
  actSystemsEdit.Enabled := frmUniversal.DBConnected and (frmSystems <> nil) and (frmSystems.TSystems.RecNo > -1);
end;

Procedure TfrmMain.actSystemsExecute(Sender: TObject);
Begin
  ToolsCreate('TfrmSystems', true);
End;

Procedure TfrmMain.actSystemsOptExecute(Sender: TObject);
Begin
  frmSystemsOpt.ShowModal;
End;

procedure TfrmMain.actSystemsOptUpdate(Sender: TObject);
begin
  actSystemsOpt.Enabled := frmUniversal.DBConnected and (useractive > 0);
end;

Procedure TfrmMain.actSystemsUpdate(Sender: TObject);
Begin
  // actSystems.Enabled := useractive > 0;
End;

Procedure TfrmMain.AppEventsHint(Sender: TObject);
Begin
  StatusBar.Panels[3].text := Application.Hint;
End;

Function TfrmMain.MD5(Const filename: String): String;
Var
  idmd5: TIdHashMessageDigest5;
  fs: TFileStream;
  hash: T4x4LongWordRecord;
Begin
  idmd5 := TIdHashMessageDigest5.Create;
  fs := TFileStream.Create(filename, fmOpenRead OR fmShareDenyWrite);
  Try
    result := idmd5.HashStreamAsHex(fs);
  Finally
    fs.Free;
    idmd5.Free;
  End;
End;

Procedure TfrmMain.ReadSettings;
var
  i: Integer;
  tmp: TstringList;
Begin
  Try
    Reg.RootKey := HKEY_CURRENT_USER;
    If Reg.OpenKey('\Software\mysoftware\orderbase2', true) Then
    Begin
      If Reg.ValueExists('actWindowsAntiClose') Then
        actWindowsAntiClose.Checked := Reg.ReadBool('actWindowsAntiClose');
      If Reg.ValueExists('actWindowsMax') Then
        actWindowsMax.Checked := Reg.ReadBool('actWindowsMax');
      If Reg.ValueExists('miLangAlways') Then
        miLangAlways.Checked := Reg.ReadBool('miLangAlways');
      If Reg.ValueExists('miLangMixed') Then
        miLangMixed.Checked := Reg.ReadBool('miLangMixed');
      If Reg.ValueExists('miLangNever') Then
        miLangNever.Checked := Reg.ReadBool('miLangNever');

      If Reg.ValueExists('miShowCert') Then
        miShowCert.Checked := Reg.ReadBool('miShowCert');

      If Reg.ValueExists('miInternalPDF') Then
        miInternalPDF.Checked := Reg.ReadBool('miInternalPDF');

      If Reg.ValueExists('actInstumentsAlign') Then
        actInstumentsAlign.Checked := Reg.ReadBool('actInstumentsAlign');

      { If Reg.ValueExists('project') Then
        projectpath := Reg.ReadString('project'); }
      { if Reg.ValueExists('debug') then
        debug := Reg.ReadBool('debug');
        mDebug.Visible := debug; }
      // ImportToProject
      { If Reg.ValueExists('ImportToProject._first') Then
        frmImportToProject._first.text := Reg.ReadString('ImportToProject._first');
        If Reg.ValueExists('ImportToProject._last') Then
        frmImportToProject._last.text := Reg.ReadString('ImportToProject._last');
        If Reg.ValueExists('ImportToProject._article') Then
        frmImportToProject._article.text := Reg.ReadString('ImportToProject._article');
        If Reg.ValueExists('ImportToProject._name') Then
        frmImportToProject._name.text := Reg.ReadString('ImportToProject._name');
        If Reg.ValueExists('ImportToProject._price') Then
        frmImportToProject._price.text := Reg.ReadString('ImportToProject._price');
        If Reg.ValueExists('ImportToProject._developer') Then
        frmImportToProject._developer.text := Reg.ReadString('ImportToProject._developer');
        If Reg.ValueExists('ImportToProject._comment') Then
        frmImportToProject._comment.text := Reg.ReadString('ImportToProject._comment');
        If Reg.ValueExists('ImportToProject._PageNo') Then
        frmImportToProject._PageNo.text := Reg.ReadString('ImportToProject._PageNo');
        If Reg.ValueExists('ImportToProject._count') Then
        frmImportToProject._count.text := Reg.ReadString('ImportToProject._count');
        If Reg.ValueExists('ImportToProject._kinddesc') Then
        frmImportToProject._kinddesc.text := Reg.ReadString('ImportToProject._kinddesc');
        If Reg.ValueExists('ImportToProject.ExcelFilenameEdit') Then
        frmImportToProject.ExcelFilenameEdit.filename := Reg.ReadString('ImportToProject.ExcelFilenameEdit');

        // frmImportFromXLS
        If Reg.ValueExists('ImportFromXLS._first') Then
        frmImportFromXLS._first.text := Reg.ReadString('ImportFromXLS._first');
        If Reg.ValueExists('ImportFromXLS._last') Then
        frmImportFromXLS._last.text := Reg.ReadString('ImportFromXLS._last');
        If Reg.ValueExists('ImportFromXLS._article') Then
        frmImportFromXLS._article.text := Reg.ReadString('ImportFromXLS._article');
        If Reg.ValueExists('ImportFromXLS._name') Then
        frmImportFromXLS._name.text := Reg.ReadString('ImportFromXLS._name');
        If Reg.ValueExists('ImportFromXLS._price') Then
        frmImportFromXLS._price.text := Reg.ReadString('ImportFromXLS._price');
        If Reg.ValueExists('ImportFromXLS._developer') Then
        frmImportFromXLS._developer.text := Reg.ReadString('ImportFromXLS._developer');
        If Reg.ValueExists('ImportFromXLS._comment') Then
        frmImportFromXLS._comment.text := Reg.ReadString('ImportFromXLS._comment');
        If Reg.ValueExists('ImportFromXLS._PageNo') Then
        frmImportFromXLS._PageNo.text := Reg.ReadString('frmImportFromXLS._PageNo');
        If Reg.ValueExists('ImportFromXLS.ExcelFilenameEdit') Then
        frmImportFromXLS.ExcelFilenameEdit.filename := Reg.ReadString('ImportFromXLS.ExcelFilenameEdit');
      }

      If Reg.ValueExists('InstrumentPanel.Width') Then
        InstrumentPanel.Width := Reg.ReadInteger('InstrumentPanel.Width');
      if InstrumentPanel.Width < 50 then
        InstrumentPanel.Width := 50;

      //
    End;

    If Reg.OpenKey('\Software\mysoftware\orderbase2\ext', false) Then
    begin
      tmp := TstringList.Create;
      Reg.GetValueNames(tmp);
      for i := 0 to tmp.Count - 1 do
      begin
        extensions.Values[tmp[i]] := Reg.ReadString(tmp[i]);
      end;
      tmp.Free;
    end;

    If Reg.OpenKey('\Software\mysoftware\orderbase2\recent', false) Then
    begin
      recent_projects.Clear;
      Reg.GetValueNames(recent_projects);
      RecentRecreate;
    end;

  Finally
  End;

  frmLangColor.show_always := miLangAlways.Checked;
  frmLangColor.show_mixedonly := miLangMixed.Checked;

End;

Procedure TfrmMain.SaveSettings;
var
  i: Integer;
Begin
  Try
    Reg.RootKey := HKEY_CURRENT_USER;
    If Reg.OpenKey('\Software\mysoftware\orderbase2', true) Then
    Begin
      { Reg.WriteString('ImportToProject._first', frmImportToProject._first.text);
        Reg.WriteString('ImportToProject._last', frmImportToProject._last.text);
        Reg.WriteString('ImportToProject._article', frmImportToProject._article.text);
        Reg.WriteString('ImportToProject._name', frmImportToProject._name.text);
        Reg.WriteString('ImportToProject._price', frmImportToProject._price.text);
        Reg.WriteString('ImportToProject._developer', frmImportToProject._developer.text);
        Reg.WriteString('ImportToProject._comment', frmImportToProject._comment.text);
        Reg.WriteString('ImportToProject._PageNo', frmImportToProject._PageNo.text);
        Reg.WriteString('ImportToProject._count', frmImportToProject._count.text);
        Reg.WriteString('ImportToProject._kinddesc', frmImportToProject._kinddesc.text);
        Reg.WriteString('ImportToProject.ExcelFilenameEdit', frmImportToProject.ExcelFilenameEdit.filename);
        //
        Reg.WriteString('ImportFromXLS._first', frmImportFromXLS._first.text);
        Reg.WriteString('ImportFromXLS._last', frmImportFromXLS._last.text);
        Reg.WriteString('ImportFromXLS._article', frmImportFromXLS._article.text);
        Reg.WriteString('ImportFromXLS._name', frmImportFromXLS._name.text);
        Reg.WriteString('ImportFromXLS._price', frmImportFromXLS._price.text);
        Reg.WriteString('ImportFromXLS._developer', frmImportFromXLS._developer.text);
        Reg.WriteString('ImportFromXLS._comment', frmImportFromXLS._comment.text);
        Reg.WriteString('ImportFromXLS._PageNo', frmImportFromXLS._PageNo.text);
        Reg.WriteString('ImportFromXLS.ExcelFilenameEdit', frmImportFromXLS.ExcelFilenameEdit.filename);
      }

      Reg.WriteBool('actWindowsAntiClose', actWindowsAntiClose.Checked);
      Reg.WriteBool('actWindowsMax', actWindowsMax.Checked);
      Reg.WriteBool('actInstumentsAlign', actInstumentsAlign.Checked);
      Reg.WriteBool('miLangAlways', miLangAlways.Checked);
      Reg.WriteBool('miLangMixed', miLangMixed.Checked);
      Reg.WriteBool('miLangNever', miLangNever.Checked);
      Reg.WriteBool('miInternalPDF', miInternalPDF.Checked);

      Reg.WriteBool('miShowCert', miShowCert.Checked);

      Reg.WriteInteger('InstrumentPanel.Width', InstrumentPanel.Width);

    End;

    If Reg.OpenKey('\Software\mysoftware\orderbase2\ext', true) Then
      for i := 0 to extensions.Count - 1 do
      begin
        Reg.WriteString(extensions.Names[i], extensions.ValueFromIndex[i]);
      end;

    Reg.DeleteKey('\Software\mysoftware\orderbase2\recent');
    If Reg.OpenKey('\Software\mysoftware\orderbase2\recent', true) Then
    begin
      for i := 0 to recent_projects.Count - 1 do
      begin
        Reg.WriteString(recent_projects[i], recent_projects[i]);
      end;
    end;

  Finally
  End;
End;

Procedure TfrmMain.actAboutExecute(Sender: TObject);
Begin
  frmAbout.ShowModal;
End;

procedure TfrmMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := true;
  SaveSettings;

  if (Tag = 0) and actWindowsAntiClose.Checked then
    CanClose := false;

  if frmUniversal.TotalQuery.Count > 0 then
  begin
    CanClose := false;
    ShowMessage('  ');
  end;
end;

Procedure TfrmMain.LoadMenuSettings;
var
  fn: string;
begin
  fn := ExtractFilePath(Application.ExeName) + 'menu.ini';
  if FileExists(fn) then
    try
      Actions.LoadFromFile(fn);
      // Actions.filename := ''; //     
    except
    end;
  Actions.filename := fn;
end;

Procedure TfrmMain.FormCreate(Sender: TObject);
Begin
  LoadMenuSettings;

  frmHardware := nil;
  frmSystems := nil;
  frmTracker := nil;
  InstrumentPanel.Width := Width div 3;
  InstrumentPanel.TabIndex := 0;

  current_hardwareno := -1;
  current_systemno := -1;

  current_projectname := '';
  current_projectno := -1;
  current_projectsystemno := -1;

  // RegisterClasses([TfrmTest, TfrmHardware, TfrmSystems]);

  ws := TWindowState.wsMaximized;
  IconAttachment := TBitmap.Create;
  Images.GetBitmap(0, IconAttachment);
  FirstActivate := true;
  debug := false;
  Reg := TRegistry.Create;
  {
    eng := 'qwertyuiopasdfghjklzxcvbnm' +
    AnsiUpperCase('qwertyuiopasdfghjklzxcvbnm');
    rus := '' +
    AnsiUpperCase('');
  }

  eng := 'etyopahkxcbm' + AnsiUpperCase('etyopahkxcbm');
  rus := '' + AnsiUpperCase('');

  extensions := TstringList.Create;
  extensions.AddPair('.xls', '');
  recent_projects := TstringList.Create;
End;

Procedure TfrmMain.FormDestroy(Sender: TObject);
Begin
  IconAttachment.Free;
  Reg.Free;
  extensions.Free;
  recent_projects.Free;
End;

Procedure TfrmMain.FormShow(Sender: TObject);
Begin
  ReadSettings;
  SetInstrumentPanel;
  WindowState := wsMaximized;
  // try autologon
  if FirstActivate then
  begin
    FirstActivate := false;
    AutoLogon;
    if frmUniversal.DBConnected then
    begin
      if miShowCert.Checked then
        actCertificates.Execute;
      CategoryTrackerExpand;
    end;
  end;
  TimerCheckAll.Enabled := true;
End;

Procedure TfrmMain.actProjectSelectUpdate(Sender: TObject);
Begin
  actProjectSelect.Enabled := frmUniversal.DBConnected and (useractive > 0);
End;

procedure TfrmMain.actProjectSystemsAddExecute(Sender: TObject);
Var
  newName: String;
  tnod: TTreeNode;
  flds, SQL: String;
  // Source_system_no, DST_system_no: Integer;
Begin
  if (ActiveMDIChild = nil) then
    exit;
  if not(ActiveMDIChild is TfrmProject) then
    exit;

  frmSystemsAdd.Project_no := current_projectno;
  frmSystemsAdd.SRC_tablename := '';
  frmSystemsAdd.SRC_systemno := -1;
  frmSystemsAdd.DST_tablename := 'uni_projectsystems';
  frmSystemsAdd.DST_systemno := -1;

  if frmSystemsAdd.ShowModal = mrOk then
  begin
    frmMain.Log(1, 'uni_projectsystems', current_projectname, '', trim(frmSystemsAdd.editName.text));
    TfrmProject(ActiveMDIChild).TPrSystems.Refresh;
    TfrmProject(ActiveMDIChild).TPrSystems.Last;
  end;

  // DST_system_no := QuerySRC.FieldByName('rec_no').AsInteger;
  {
    If Source_system_no > 0 Then
    If frmDoCopyHardware.ShowModal = mrOk Then
    try
    flds := 'name,kinddesc,article,comment,developer,file,price,valuta,count,modules';
    SQL := 'INSERT INTO uni_projecthardware (project_no,system_no,' + flds + ') ' + 'SELECT ' +
    IntToStr(current_projectno) + ',' + IntToStr(DST_system_no) + ',' + flds +
    ' FROM `uni_projecthardware` WHERE `system_no`=' + IntToStr(Source_system_no) + ' ORDER BY `orderby`';
    QueryDST.SQL.Text := SQL;
    QueryDST.Execute;
    SQL := 'UPDATE uni_projecthardware SET `orderby`=`rec_no` WHERE `project_no`=' + IntToStr(current_projectno) +
    ' AND `system_no`=' + IntToStr(DST_system_no);
    QueryDST.SQL.Text := SQL;
    QueryDST.Execute;
    except
    End;
  }
end;

procedure TfrmMain.actProjectSystemsAddUpdate(Sender: TObject);
begin
  actProjectSystemsAdd.Enabled := frmUniversal.DBConnected;
end;

procedure TfrmMain.actProjectSystemsDeleteExecute(Sender: TObject);
Var
  system_no: Integer;
  FilterSQL: String;
Begin
  If (current_projectno > 0) AND (current_projectsystemno > 0) Then
  begin
    frmSystemsDelete.Labelinfo.Caption := '  ' + current_projectsystemname + '?';
    if current_projectsystemtag <> '' then
      frmSystemsDelete.Labelinfo.Caption := '  ' + current_projectsystemname + '/' +
        current_projectsystemtag + '?';

    if frmSystemsDelete.ShowModal <> mrOk then
      exit;

    Try
      QueryDST.SQL.text := 'DELETE FROM `uni_projectsystems` WHERE `project_no`=:project_no AND `rec_no`=:system_no';
      QueryDST.ParamByName('project_no').AsInteger := current_projectno;
      QueryDST.ParamByName('system_no').AsInteger := current_projectsystemno;
      QueryDST.ExecSQL;

      QueryDST.SQL.text :=
        'DELETE FROM `uni_projecthardware` WHERE `project_no`=:project_no AND `system_no`=:system_no';
      QueryDST.ParamByName('project_no').AsInteger := current_projectno;
      QueryDST.ParamByName('system_no').AsInteger := current_projectsystemno;
      QueryDST.ExecSQL;
      QueryDST.Close;

      frmMain.Log(3, 'uni_projectsystems', current_projectname, current_projectsystemname, current_projectsystemname);

      if (ActiveMDIChild <> nil) and (ActiveMDIChild is TfrmProject) then
      begin
        TfrmProject(ActiveMDIChild).TPrSystems.Refresh;
      end;
    Except
    End;
  end;
end;

procedure TfrmMain.actProjectSystemsDeleteUpdate(Sender: TObject);
begin
  actProjectSystemsDelete.Enabled := frmUniversal.DBConnected and (current_projectno > 0) AND
    (current_projectsystemno > 0);
end;

procedure TfrmMain.actProjectSystemsEditExecute(Sender: TObject);
begin
  if current_projectsystemno < 0 then
    exit;

  frmSystemsAdd.Project_no := current_projectno;
  frmSystemsAdd.SRC_tablename := 'uni_projectsystems';
  frmSystemsAdd.SRC_systemno := current_projectsystemno;
  frmSystemsAdd.DST_tablename := 'uni_projectsystems';
  frmSystemsAdd.DST_systemno := current_projectsystemno;

  if frmSystemsAdd.ShowModal = mrOk then
  begin
    frmMain.Log(2, 'uni_projectsystems', current_projectname, current_projectsystemname,
      trim(frmSystemsAdd.editName.text));
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TfrmProject) then
      TfrmProject(ActiveMDIChild).TPrSystems.Refresh;
  end;
end;

procedure TfrmMain.actProjectSystemsEditUpdate(Sender: TObject);
begin
  actProjectSystemsEdit.Enabled := frmUniversal.DBConnected and (current_projectsystemno > -1);
end;

procedure TfrmMain.actProjectSystemsExportExecute(Sender: TObject);
begin
  //      
  if not(current_projectno > -1) then
    exit;

  frmSystemsAdd.Project_no := current_projectno;
  frmSystemsAdd.SRC_tablename := 'uni_projectsystems';
  frmSystemsAdd.SRC_systemno := current_projectsystemno;
  frmSystemsAdd.DST_tablename := 'uni_systems';
  frmSystemsAdd.DST_systemno := -1;

  if frmSystemsAdd.ShowModal = mrOk then
  begin
    //   
    if frmSystems <> nil then
      frmSystems.TSystems.Refresh;
  end;
end;

procedure TfrmMain.actProjectSystemsExportUpdate(Sender: TObject);
begin
  actProjectSystemsExport.Enabled := frmUniversal.DBConnected and (current_projectsystemno > -1);
end;

procedure TfrmMain.CustomizeDlgClose(Sender: TObject);
begin
  SaveMenuSettings;
end;

procedure TfrmMain.SaveMenuSettings;
var
  fn: string;
begin
  // fn := ExtractFilePath(Application.ExeName) + 'menu.ini';
  try
    // Actions.SaveToFile(fn);
    Actions.SaveToFile(Actions.filename);
    // ShowMessage('    ' + fn);
  except
  end;
end;

procedure TfrmMain.actProjectSystemsImportUpdate(Sender: TObject);
begin
  actProjectSystemsImport.Enabled := frmUniversal.DBConnected and
    ((current_systemno > -1) and (current_projectno > -1));
end;

procedure TfrmMain.actCertificatesExecute(Sender: TObject);
begin
  NewCaption := '';
  If Not MDIExists(NewCaption) Then
    With TfrmCertificates.Create(Application) Do
      Caption := NewCaption;
end;

procedure TfrmMain.actCertificatesUpdate(Sender: TObject);
begin
  actCertificates.Enabled := frmUniversal.DBConnected;
end;

procedure TfrmMain.actChangeUserExecute(Sender: TObject);
begin
  If frmUserLogin.ShowModal = mrOk Then
  Begin
    username := frmUserLogin._UserName.text;
    userpass := frmUserLogin._UserPass.text;
    SetUserRights;
  End;
end;

procedure TfrmMain.actChangeUserUpdate(Sender: TObject);
begin
  actChangeUser.Enabled := MDIChildCount < 1;
end;

procedure TfrmMain.actClearFileStoreExecute(Sender: TObject);
begin
  if (MessageDlg
    ('       .      ?',
    mtCustom, [mbYes, mbCancel], 0) = mrYes) then
  begin
    CheckAllFiles;
  end;
end;

procedure TfrmMain.actCopyToClipboardExecute(Sender: TObject);
var
  selectedGrid: TJvDBGrid;
  txt: string;
  i: Integer;
Begin
  if not(Screen.ActiveControl is TJvDBGrid) then
    exit;
  selectedGrid := TJvDBGrid(Screen.ActiveControl);
  txt := '';
  //
  if dgRowSelect in selectedGrid.Options then
  begin
    //  
    for i := 0 to selectedGrid.Columns.Count - 1 do
    begin
      txt := txt + selectedGrid.Columns[i].Field.AsString + ';';
    end;
  end
  else
  begin
    //  
    txt := selectedGrid.Columns[selectedGrid.SelectedIndex].Field.AsString;
  end;
  //
  Clipboard.SetTextBuf(Pchar(txt));
end;

procedure TfrmMain.actCopyToClipboardUpdate(Sender: TObject);
begin
  actCopyToClipboard.Enabled := (Screen.ActiveControl is TJvDBGrid);
end;

Procedure TfrmMain.AutoLogon;
var
  myAutoLogon: Boolean;
  myDatabase, myServer, myPort, myUserlogin, myUserpass, myUserGroup: string;
Begin
  //      
  myAutoLogon := false;
  Try
    Reg.RootKey := HKEY_CURRENT_USER;
    If Reg.OpenKey('\Software\mysoftware\orderbase2', true) Then
    Begin
      myPort := '3306';
      If Reg.ValueExists('autologon') Then
        myAutoLogon := Reg.ReadBool('autologon');
      If Reg.ValueExists('userlogin') Then
        myUserlogin := Reg.ReadString('userlogin');
      If Reg.ValueExists('userpass') Then
        myUserpass := Reg.ReadString('userpass');
      If Reg.ValueExists('server') Then
        myServer := Reg.ReadString('server');
      If Reg.ValueExists('port') Then
        myPort := Reg.ReadString('port');
      If Reg.ValueExists('database') Then
        myDatabase := Reg.ReadString('database');
    End;
  except
  End;

  if not myAutoLogon then
    exit;

  StatusBar.Panels.Items[3].text := '   ' + myServer + ':' + myPort;;
  Application.ProcessMessages;

  username := myUserlogin;
  userpass := myUserpass;
  frmUniversal.DatabaseConnection.Params.Values['Server'] := myServer;
  frmUniversal.DatabaseConnection.Params.Values['port'] := myPort;
  frmUniversal.DatabaseConnection.Params.username := frmUniversal.Translit(myUserlogin);
  frmUniversal.DatabaseConnection.Params.Database := myDatabase;
  frmUniversal.DatabaseConnection.Params.password := myUserpass;
  // frmUniversal.DatabaseConnection.Params.Values['LoginTimeout'] := '5';

  if not frmUniversal.DatabaseConnection.Connected then
    Try
      frmUniversal.DatabaseConnection.Connected := true;
    Except
    End;

  // 
  if frmUniversal.DBConnected then
  begin
    SetUserRights;
  end
  else
  begin
    //    ,   
    actChangeUser.Execute;
  end;

  StatusBar.Panels.Items[3].text := '';

End;

Procedure TfrmMain.SetUserRights;
begin
  //    
  // ShowMessage('    ' + group);
  StatusBar.Panels.Items[0].text := '  ';
  if frmUniversal.DatabaseConnection.Connected then
    try
      usergroup := username;
      frmUniversal.DatabaseQuery1.SQL.text := 'SELECT `usergroup`,`active` FROM `uni_users` WHERE `username`=:username';
      frmUniversal.DatabaseQuery1.ParamByName('username').AsString := username;
      frmUniversal.DatabaseQuery1.Active := true;
      if frmUniversal.DatabaseQuery1.RecordCount > 0 then
      begin
        usergroup := frmUniversal.DatabaseQuery1.FieldByName('usergroup').AsString;
        useractive := frmUniversal.DatabaseQuery1.FieldByName('active').AsInteger;
      end
      else
      begin
        usergroup := ' ';
        useractive := 2;
      end;
      // show status
      StatusBar.Panels.Items[0].text := username + ' (' + usergroup + ' [' + useractive.ToString + '])';
      StatusBar.Panels.Items[0].text := username + ' (' + usergroup + ')';
    except
    end;
end;

procedure TfrmMain.InstrumentSplitterCanResize(Sender: TObject; var NewSize: Integer; var Accept: Boolean);
begin
  Accept := true; // NewSize < 600;
end;

Procedure TfrmMain.actCustomersExecute(Sender: TObject);
Begin
  NewCaption := '';
  If Not MDIExists(NewCaption) Then
    With TfrmCustomers.Create(Application) Do
      Caption := NewCaption;
End;

procedure TfrmMain.actCustomersUpdate(Sender: TObject);
begin
  actCustomers.Enabled := frmUniversal.DBConnected and (useractive > 0);
end;

Procedure TfrmMain.actDevelopersExecute(Sender: TObject);
Begin
  NewCaption := '';
  If Not MDIExists(NewCaption) Then
    With TfrmDevelopers.Create(Application) Do
      Caption := NewCaption;
End;

procedure TfrmMain.actDevelopersUpdate(Sender: TObject);
begin
  actDevelopers.Enabled := frmUniversal.DBConnected and (useractive > 0);
end;

Procedure TfrmMain.actExitExecute(Sender: TObject);
Begin
  Tag := 1;
  Close;
End;

Function TfrmMain.Translit(s: String): String;
Const
  rus: String = 'Ũ';
  skip: String = ' ~!@#$%^&*()_+`-=/?\|/[]{}<>,.''";:';
  eng = ['A' .. 'Z', 'a' .. 'z'];
  num = ['0' .. '9'];
  lat: Array [1 .. 66] Of String = ('a', 'b', 'v', 'g', 'd', 'e', 'yo', 'zh', 'z', 'i', 'y', 'k', 'l', 'm', 'n', 'o',
    'p', 'r', 's', 't', 'u', 'f', 'kh', 'ts', 'ch', 'sh', 'shch', '', 'y', '', 'e', 'yu', 'ya', 'A', 'B', 'V', 'G', 'D',
    'E', 'Yo', 'Zh', 'Z', 'I', 'Y', 'K', 'L', 'M', 'N', 'O', 'P', 'R', 'S', 'T', 'U', 'F', 'Kh', 'Ts', 'Ch', 'Sh',
    'Shch', '', 'Y', '', 'E', 'Yu', 'Ya');
Var
  p, i, l: Integer;
Begin
  s := String(AnsiString(s));
  result := '';
  l := length(s);
  For i := 1 To l Do
  Begin
    p := Pos(s[i], rus);
    If p > 0 Then
      result := result + lat[p]
    Else If CharInSet(s[i], eng) Then
      result := result + s[i]
    Else If CharInSet(s[i], num) Then
      result := result + s[i]
    Else
      result := result + '_';
  End;

  While Pos('__', result) > 0 Do
  Begin
    Delete(result, Pos('__', result), 1);
  End;

  While length(result) > 100 Do
  Begin
    Delete(result, length(result), 1);
  End;

  If Copy(result, length(result), 1) = '_' Then
  Begin
    Delete(result, length(result), 1);
  End;

  result := lowercase(result);
End;

Function TfrmMain.DateTimeForSQL(Const DateTime: TDateTime): String;
Begin
  result := FormatDateTime('yyyy-mm-dd', DateTime);
End;

Function TfrmMain.TransformToEN(s: String): String;
Var
  p, i, l: Integer;
Begin
  s := String(AnsiString(s));
  result := '';
  l := length(s);
  For i := 1 To l Do
  Begin
    p := Pos(s[i], rus);
    If p > 0 Then
      result := result + eng[p]
    Else
      result := result + s[i]
  End;
End;

Function TfrmMain.TransformToRU(s: String): String;
Var
  p, i, l: Integer;
Begin
  s := String(AnsiString(s));
  result := '';
  l := length(s);
  For i := 1 To l Do
  Begin
    p := Pos(s[i], eng);
    If p > 0 Then
      result := result + rus[p]
    Else
      result := result + s[i]
  End;
End;

function TfrmMain.GetNextValue(old: string): string;
var
  o_left, o_right: string;
  n_left: string;
  i: Integer;
  flag: Boolean;
Const
  num = '0123456789';
begin
  o_left := '';
  flag := false;
  For i := 1 To length(old) Do
  Begin
    If (Pos(old[i], num) > 0) and not flag then
    begin
      o_left := o_left + old[i];
    end
    else
    begin
      o_right := o_right + old[i];
      flag := true;
    end;
  End;
  n_left := IntToStr(StrToInt(o_left) + 1);
  while length(n_left) < length(o_left) do
  begin
    n_left := '0' + n_left;
  end;

  result := n_left + o_right;
end;

Function TfrmMain.FloatToMySQL(f: Extended): String;
var
  str: string;
Begin
  str := FloatToStr(f);
  result := StringReplace(str, ',', '.', []);
End;

procedure TfrmMain.ss1Click(Sender: TObject);
begin
  ToolsCreate('TfrmTest', true);
end;

Function TfrmMain.MDIExists(FormCaption: String): Boolean;
Var
  i, fnd: Integer;
Begin
  fnd := 0;
  For i := 0 To MDIChildCount - 1 Do
  Begin
    If MDIChildren[i].Caption = FormCaption Then
    Begin
      MDIChildren[i].BringToFront;
      fnd := 1;
    End;
  End;
  result := (fnd = 1);
End;

procedure TfrmMain.ToolsCreate(FormClass: string; tools: Boolean);
var
  aFormClass: TFormClass;
  aForm: TForm;
  i, fnd: Integer;
begin
  if not tools then
  begin
    If Not MDIExists(NewCaption) Then
      with TfrmHardware.Create(Application) do
      begin
        formStyle := fsMDIChild;
        WindowState := wsNormal;
      end;
    exit;
  end;

  //  
  { if DockLeft.DockClientCount > 0 then
    if DockLeft.DockClients[0] is TForm then
    begin
    (DockLeft.DockClients[0] as TForm).Close;
    end; }

  //  
  aFormClass := TFormClass(FindClass(FormClass));
  aForm := aFormClass.Create(Application.MainForm);
  aForm.formStyle := fsNormal;

  //   
  // aForm.ManualDock(Panel1);
  aForm.WindowState := wsMaximized;
end;

procedure TfrmMain.DockLeftResize(Sender: TObject);
begin
  { if (DockLeft.Width > 200) and (DockLeft.Width <> dockleft_width) then
    begin
    dockleft_width := DockLeft.Width;
    end; }
end;

procedure TfrmMain.DockLeftUnDock(Sender: TObject; Client: TControl; NewTarget: TWinControl; var Allow: Boolean);
begin
  { if DockLeft.DockClientCount = 0 then
    begin
    DockLeft.Width := 1;
    SplitterLeft.Visible := false;
    end
    else
    begin
    DockLeft.Width := dockleft_width;
    SplitterLeft.Visible := false;
    end; }
end;

procedure TfrmMain.CategoryHardwareExpand;
begin
  if ToolsHardware.ControlCount <> 0 then
    exit;
  //     
  frmHardware := TfrmHardware.Create(Application);
  with frmHardware do
  begin
    Parent := ToolsHardware;
    formStyle := fsNormal;
    BorderStyle := bsNone;
    WindowState := wsNormal;
    Visible := true;
    Align := alClient;
  end;
  ToolsHardware.Repaint;
end;

procedure TfrmMain.CategorySystemsExpand;
begin
  if ToolsSystems.ControlCount <> 0 then
    exit;
  //     
  frmSystems := TfrmSystems.Create(Application);
  with frmSystems do
  begin
    Parent := ToolsSystems;
    formStyle := fsNormal;
    BorderStyle := bsNone;
    WindowState := wsNormal;
    Visible := true;
    Align := alClient;
  end;
  ToolsSystems.Repaint;
end;

procedure TfrmMain.CategoryTrackerExpand;
begin
  if ToolsTracker.ControlCount <> 0 then
    exit;
  //     
  frmTracker := TfrmTracker.Create(Application);
  with frmTracker do
  begin
    Parent := ToolsTracker;
    formStyle := fsNormal;
    BorderStyle := bsNone;
    WindowState := wsNormal;
    Visible := true;
    Align := alClient;
  end;
  ToolsTracker.Repaint;
end;

procedure TfrmMain.TimerCheckAllTimer(Sender: TObject);
var
  newtext: string;
  dt: TDateTime;
  rec_no: Integer;
begin
  //  
  if miLangNever.Checked then
    exit;

  frmLangColor.ShowText(Screen.ActiveControl);
end;

procedure TfrmMain.InformAboutUpdate(rec_no: Integer);
begin
  ExecSQL('REPLACE `uni_settings` (`rec_no`,`dt`) VALUES (' + rec_no.ToString + ',now());');
end;

procedure TfrmMain.InstrumentPanelChange(Sender: TObject);
begin
  //
  if InstrumentPanel.ActivePage = ToolsHardware then
    CategoryHardwareExpand;
  if InstrumentPanel.ActivePage = ToolsSystems then
    CategorySystemsExpand;
  if InstrumentPanel.ActivePage = ToolsTracker then
    CategoryTrackerExpand;
end;

Procedure TfrmMain.OpenProject(Project_no: Integer);
var
  myProject: TfrmProject;
begin
  // LastProjectsAdd(Project_no);
  myProject := TfrmProject.Create(Application);
  myProject.Project_no := Project_no;
  myProject.FormActivate(self);
  RecentRecreate;
end;

Procedure TfrmMain.RecentRecreate;
var
  i: Integer;
  nitem: TMenuItem;
begin
  while recent_projects.Count > 10 do
    recent_projects.Delete(recent_projects.Count - 1);
  //      recent_projects
  miRecent.Clear;
  for i := 0 to recent_projects.Count - 1 do
  begin
    nitem := TMenuItem.Create(miRecent);
    miRecent.add(nitem);
    nitem.Caption := recent_projects[i];
    nitem.OnClick := OpenRecent;
  end;
  // add ro recent
end;

procedure TfrmMain.OpenRecent(Sender: TObject);
var
  name: string;
begin
  name := TMenuItem(Sender).Caption;
  name := Copy(name, 0, Pos('(', name) - 2);
  name := Copy(name, 7, length(name));

  QuerySRC.SQL.text := 'SELECT `rec_no` FROM `uni_projects` WHERE `name`=:name;';
  QuerySRC.ParamByName('name').AsString := name;
  QuerySRC.Active := true;
  if QuerySRC.RecordCount > 0 then
    OpenProject(QuerySRC.FieldByName('rec_no').AsInteger)
  else
  begin
    TMenuItem(Sender).Visible := false;
    if recent_projects.IndexOf(name) > -1 then
      recent_projects.Delete(recent_projects.IndexOf(name));
  end;
end;

function TfrmMain.OpenFile(filename: string): Boolean;
var
  ext, runwithapp: string;
begin
  Application.ProcessMessages;

  if not FileExists(filename) then
  begin
    ShowMessage('   "' + filename + '"');
    exit;
  end;
  ext := ExtractFileExt(filename);

  // internal viewers
  if miInternalPDF.Checked and (uppercase(ext) = '.PDF') then
  begin
    NewCaption := ExtractFileName(filename);
    If Not MDIExists(NewCaption) Then
      With TfrmPDFViewer.Create(Application) Do
      begin
        Caption := NewCaption;
        loadfile(filename);
      end;
    exit;
  end;

  // external viewers
  runwithapp := trim(frmMain.extensions.Values[ext]);

  if length(runwithapp) = 0 then
  begin
    //   
    ShellExecute(Handle, 'Open', Pchar('"' + filename + '"'), Nil, Nil, SW_SHOWNORMAL);
  end
  else
  begin
    //   c 
    ShellExecute(Handle, 'Open', Pchar(runwithapp), Pchar('"' + filename + '"'), Nil, SW_SHOWNORMAL);
  end;
end;

procedure TfrmMain.Log(operation: Integer; table, project, System, text: string);
begin
  if length(text) > 40 then
    text := Copy(text, 1, 37) + '...';
  if length(project) > 20 then
    project := Copy(project, 1, 17) + '...';
  if length(System) > 20 then
    System := Copy(text, 1, 17) + '...';

  try
    QueryLog.SQL.text := 'INSERT INTO `uni_log` SET username=:username,operation=:operation,text=:text,' +
      'table_name=:table_name,project_name=:project_name,system_name=:system_name;';
    QueryLog.ParamByName('username').AsString := username;
    QueryLog.ParamByName('operation').AsInteger := operation;
    QueryLog.ParamByName('text').AsString := text;
    QueryLog.ParamByName('table_name').AsString := table;
    QueryLog.ParamByName('project_name').AsString := project;
    QueryLog.ParamByName('system_name').AsString := System;
    QueryLog.ExecSQL;
    QueryLog.Close;
  except
  end;

  if frmTracker <> nil then
  begin
    frmTracker.TimerGetLogs.Enabled := false;
    frmTracker.TimerGetLogs.Enabled := true;
  end;
end;

procedure TfrmMain.actProjectSystemsCopyExecute(Sender: TObject);
begin
  //    
  if not((current_projectsystemno > -1) and (current_projectno > -1)) then
    exit;

  frmSystemsAdd.Project_no := current_projectno;
  frmSystemsAdd.SRC_tablename := 'uni_projectsystems';
  frmSystemsAdd.SRC_systemno := current_projectsystemno;
  frmSystemsAdd.DST_tablename := 'uni_projectsystems';
  frmSystemsAdd.DST_systemno := -1;

  frmSystemsAdd.ShowModal;

  try
    //   
    if (ActiveMDIChild <> nil) and (ActiveMDIChild is TfrmProject) then
    begin
      TfrmProject(ActiveMDIChild).TPrSystems.Refresh;
      TfrmProject(ActiveMDIChild).TPrSystems.Locate('rec_no', current_projectsystemno);
    end;
  except

  end;
end;

procedure TfrmMain.actProjectSystemsCopyUpdate(Sender: TObject);
begin
  actProjectSystemsCopy.Enabled := frmUniversal.DBConnected and (current_projectsystemno > -1);
end;

procedure TfrmMain.actProjectSystemsImportExecute(Sender: TObject);
begin
  //      
  if not(current_projectno > -1) then
    exit;

  frmSystemsAdd.Project_no := current_projectno;
  frmSystemsAdd.SRC_tablename := 'uni_systems';
  frmSystemsAdd.SRC_systemno := current_systemno;
  frmSystemsAdd.DST_tablename := 'uni_projectsystems';
  frmSystemsAdd.DST_systemno := current_projectsystemno;

  if frmSystemsAdd.ShowModal = mrOk then
    try
      //   
      if (ActiveMDIChild <> nil) and (ActiveMDIChild is TfrmProject) then
      begin
        TfrmProject(ActiveMDIChild).TPrSystems.Refresh;
        TfrmProject(ActiveMDIChild).TPrSystems.Locate('rec_no', current_projectsystemno);
      end;
    except

    end;
end;

procedure TfrmMain.miSetExtension(Sender: TObject);
var
  ext: string;
begin
  ext := '.xls';
  if Sender is TMenuItem then
  begin
    ext := TMenuItem(Sender).Hint;
  end;
  //    
  frmDescEdit.description.text := extensions.Values[ext];
  frmDescEdit.btnFileSelect.Visible := true;
  frmDescEdit.btnClear.Visible := true;
  if frmDescEdit.ShowModal = mrOk then
  begin
    extensions.Values[ext] := trim(frmDescEdit.description.text);
  end;
  SaveSettings;
end;

End.
