unit Mail;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, JvExStdCtrls, JvButton, IdText, idAttachmentFile,
  JvCtrls, JvFooter, Vcl.ExtCtrls, JvExExtCtrls, JvExtComponent, IdBaseComponent, IdMessage,
  IdComponent, IdTCPConnection, IdTCPClient, IdExplicitTLSClientServerBase, Registry,
  IdMessageClient, IdSMTPBase, IdSMTP, Vcl.AppEvnts, IdIOHandler,
  IdIOHandlerSocket, IdIOHandlerStack, IdSSL, IdSSLOpenSSL;

type
  TfrmMail = class(TForm)
    JvFooter1: TJvFooter;
    btnOk: TJvFooterBtn;
    JvFooterBtn1: TJvFooterBtn;
    GroupBox1: TGroupBox;
    SMTPHost: TLabeledEdit;
    SMTPPort: TLabeledEdit;
    SMTPUsername: TLabeledEdit;
    SMTPPassword: TLabeledEdit;
    SMTPSenderEmail: TLabeledEdit;
    SMTPSenderName: TLabeledEdit;
    Panel1: TPanel;
    MemoBody: TMemo;
    Label3: TLabel;
    EditSubject: TEdit;
    Label2: TLabel;
    EditRecipient: TEdit;
    SMTP: TIdSMTP;
    PanelLeft: TPanel;
    FileList: TListBox;
    Label1: TLabel;
    Label4: TLabel;
    procedure btnOkClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure JvFooterBtn2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    function SendEMail: boolean;
    procedure ReadSettings;
    procedure SaveSettings;
    function IdSSLIOHandlerSocketOpenSSL1VerifyPeer(Certificate: TIdX509; AOk: boolean;
      ADepth, AError: Integer): boolean;
    { Private declarations }
  public
    Reg: TRegistry;
    { Public declarations }
  end;

var
  frmMail: TfrmMail;

implementation

{$R *.dfm}

procedure TfrmMail.btnOkClick(Sender: TObject);
begin
  btnOk.Enabled := false;
  if SendEMail then
  begin
    ShowMessage(' ');
    modalResult := mrOk;
  end;
  btnOk.Enabled := true;
end;

procedure TfrmMail.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SaveSettings;
end;

procedure TfrmMail.FormCreate(Sender: TObject);
begin
  Reg := TRegistry.Create;
end;

procedure TfrmMail.FormDestroy(Sender: TObject);
begin
  Reg.Free;
end;

procedure TfrmMail.FormShow(Sender: TObject);
begin
  btnOk.Enabled := true;
  ReadSettings;
end;

function TfrmMail.IdSSLIOHandlerSocketOpenSSL1VerifyPeer(Certificate: TIdX509; AOk: boolean;
  ADepth, AError: Integer): boolean;
begin
  result := AOk;
end;

procedure TfrmMail.JvFooterBtn2Click(Sender: TObject);
begin
  SaveSettings;
end;

function TfrmMail.SendEMail: boolean;
var
  IdMessage: TIdMessage;
  fn: string;
  i, port: Integer;
  IdSSL: TIdSSLIOHandlerSocketOpenSSL;
  zip: TIdAttachmentFile;
begin
  result := false;
  //
  IdMessage := TIdMessage.Create;
  IdMessage.MsgId := inttostr(random(9999999));
  IdMessage.IsEncoded := true;
  IdMessage.CharSet := 'UTF-8';
  IdMessage.From.Address := SMTPSenderEmail.Text;
  IdMessage.From.Name := SMTPSenderName.Text;
  IdMessage.Subject := EditSubject.Text;
  IdMessage.Recipients.EMailAddresses := EditRecipient.Text;
  IdMessage.ContentType := 'multipart/mixed';

  SMTP.AuthType := TIdSMTPAuthenticationType.satDefault;
  SMTP.Host := trim(SMTPHost.Text);
  if TryStrToInt(SMTPPort.Text, port) then
    SMTP.port := port
  else
    SMTP.port := 25;

  SMTP.Username := trim(SMTPUsername.Text);
  SMTP.Password := trim(SMTPPassword.Text);
  if SMTP.port > 25 then
  begin
    IdSSL := TIdSSLIOHandlerSocketOpenSSL.Create;
    IdSSL.Host := SMTP.Host;
    IdSSL.port := SMTP.port;
    IdSSL.Destination := IdSSL.Host + ':' + inttostr(IdSSL.port);
    SMTP.IOHandler := IdSSL;
    SMTP.UseTLS := utUseImplicitTLS;
    IdSSL.OnVerifyPeer := IdSSLIOHandlerSocketOpenSSL1VerifyPeer;
  end;

  with TIdText.Create(IdMessage.MessageParts, nil) do
  begin
    ContentType := 'text/html';
    CharSet := 'UTF-8';
    Body.Text := MemoBody.Lines.Text;
  end;

  for i := 0 to FileList.items.Count - 1 do
  begin
    fn := FileList.items[i];
    if fileexists(fn) then
    begin
      zip := TIdAttachmentFile.Create(IdMessage.MessageParts, fn);
    end;
  end;

  if not SMTP.Connected then
    try
      SMTP.Connect;
    except
      on E: Exception do
      begin
        MessageDlg('.     .' + #13#10 + E.Message, mtError, [mbOK], 0);
        Exit;
      end;
    end;

  if SMTP.Connected then
  begin
    SMTP.Send(IdMessage);
    result := true;
  end;

  if SMTP.Connected then
    SMTP.Disconnect;

  IdMessage.Free;
end;

Procedure TfrmMail.ReadSettings;
Begin
  Try
    Reg.RootKey := HKEY_CURRENT_USER;
    If Reg.OpenKey('\Software\mysoftware\orderbase2', true) Then
    Begin
      If Reg.ValueExists('Mail.SMTPHost') Then
        SMTPHost.Text := Reg.ReadString('Mail.SMTPHost');
      If Reg.ValueExists('Mail.SMTPPort') Then
        SMTPPort.Text := Reg.ReadString('Mail.SMTPPort');
      If Reg.ValueExists('Mail.SMTPUsername') Then
        SMTPUsername.Text := Reg.ReadString('Mail.SMTPUsername');
      If Reg.ValueExists('Mail.SMTPPassword') Then
        SMTPPassword.Text := Reg.ReadString('Mail.SMTPPassword');
      If Reg.ValueExists('Mail.SMTPSenderName') Then
        SMTPSenderName.Text := Reg.ReadString('Mail.SMTPSenderName');
      If Reg.ValueExists('Mail.SMTPSenderEmail') Then
        SMTPSenderEmail.Text := Reg.ReadString('Mail.SMTPSenderEmail');
      If Reg.ValueExists('Mail.EditRecipient') Then
        EditRecipient.Text := Reg.ReadString('Mail.EditRecipient');
      If Reg.ValueExists('Mail.EditSubject') Then
        EditSubject.Text := Reg.ReadString('Mail.EditSubject');
      If Reg.ValueExists('Mail.MemoBody') Then
        MemoBody.Lines.Text := Reg.ReadString('Mail.MemoBody');
    End;
  Finally
  End;
End;

Procedure TfrmMail.SaveSettings;
Begin
  Try
    Reg.RootKey := HKEY_CURRENT_USER;
    If Reg.OpenKey('\Software\mysoftware\orderbase2', true) Then
    Begin
      Reg.WriteString('Mail.SMTPHost', trim(SMTPHost.Text));
      Reg.WriteString('Mail.SMTPPort', trim(SMTPPort.Text));
      Reg.WriteString('Mail.SMTPUsername', trim(SMTPUsername.Text));
      Reg.WriteString('Mail.SMTPPassword', trim(SMTPPassword.Text));
      Reg.WriteString('Mail.SMTPSenderName', trim(SMTPSenderName.Text));
      Reg.WriteString('Mail.SMTPSenderEmail', SMTPSenderEmail.Text);

      Reg.WriteString('Mail.EditRecipient', EditRecipient.Text);
      Reg.WriteString('Mail.EditSubject', EditSubject.Text);
      Reg.WriteString('Mail.MemoBody', MemoBody.Lines.Text);
    End;
  Finally
  End;
End;

end.
