unit LangColor;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ComCtrls, Vcl.ExtCtrls, JvCombobox;

type
  TfrmLangColor = class(TForm)
    TimerOff: TTimer;
    procedure PaintBoxPaint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TimerOffTimer(Sender: TObject);
  private
    all: string;
    en, ru: boolean;
    { Private declarations }
  public
    show_mixedonly: boolean;
    show_always: boolean;
    fs: integer;
    procedure ShowText(ctrl: TWinControl);
    { Public declarations }
  end;

var
  frmLangColor: TfrmLangColor;

implementation

{$R *.dfm}

uses Main;

procedure TfrmLangColor.ShowText(ctrl: TWinControl);
var
  lPoint: TPoint;
  newtext: string;
begin
  newtext := '';
  if Screen.ActiveControl <> nil then
  begin
    if Screen.ActiveControl is TEdit then
      newtext := TEdit(Screen.ActiveControl).text;
    if Screen.ActiveControl is TJvComboBox then
      newtext := TJvComboBox(Screen.ActiveControl).text;
    if Screen.ActiveControl is TComboBox then
      newtext := TComboBox(Screen.ActiveControl).text;

    TimerOff.Enabled := false;
    TimerOff.Enabled := true;
  end
  else
    exit;

  try
    lPoint := Screen.ActiveControl.ClientToScreen(Point(0, 0));
    if Screen.ActiveControl is TEdit then
      fs := TEdit(Screen.ActiveControl).Font.Size;
    frmLangColor.Left := lPoint.X;
    if Screen.ActiveControl is TWinControl then
    begin
      frmLangColor.Width := TWinControl(Screen.ActiveControl).Width - 4;
      frmLangColor.Height := TWinControl(Screen.ActiveControl).ClientHeight;
    end;
    frmLangColor.Top := lPoint.Y - frmLangColor.Height - 2;
//    repaint;
  except
  end;

  if newtext = '' then
  begin
    all := newtext;
    hide;
  end;

  if newtext <> '' then
    try
      // if all <> newtext then
      begin
        all := newtext;
        PaintBoxPaint(self);

        if show_mixedonly then
        begin
          if en and ru then
          begin
            if not visible then
            begin
              ShowWindow(frmLangColor.Handle, SW_SHOWNOACTIVATE);
              SetWindowPos(frmLangColor.Handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOACTIVATE + SWP_NOMOVE + SWP_NOSIZE);
              visible := true;
            end;
          end
          else
          begin
            visible := false;
          end;
        end
        else if not visible then
        begin
          ShowWindow(frmLangColor.Handle, SW_SHOWNOACTIVATE);
          SetWindowPos(frmLangColor.Handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOACTIVATE + SWP_NOMOVE + SWP_NOSIZE);
          visible := true;
        end;
      end;
    except
    end;

  // if visible then
end;

procedure TfrmLangColor.TimerOffTimer(Sender: TObject);
begin
  hide;
  TimerOff.Enabled := false;
end;

procedure TfrmLangColor.FormCreate(Sender: TObject);
begin
  fs := 8;
  show_mixedonly := true;
end;

procedure TfrmLangColor.PaintBoxPaint(Sender: TObject);
var
  i, ww, hh: integer;
  cp: integer;
begin
  cp := 1;
  with canvas do
  begin
    // Font.Size := round(PaintBox.Height * 0.7);
    Brush.Color := clCream;
    FillRect(ClientRect);
    Brush.Color := clGray;
    FrameRect(ClientRect);

    Font.Size := fs;
    Brush.Color := clWhite;
    Brush.Style := bsClear;
    Font.Style := [];

    en := false;
    ru := false;

    for i := 1 to Length(all) do
    begin
      ww := TextWidth(all[i]); // + 1;
      hh := TextHeight(all[i]);
      Font.Color := clBlack;
      if (all[i] >= 'A') and (all[i] <= 'Z') then
      begin
        Font.Color := $FF6D6D;
        en := true;
      end;
      if (all[i] >= 'a') and (all[i] <= 'z') then
      begin
        Font.Color := $FF6D6D;
        en := true;
      end;
      if (all[i] >= '') and (all[i] <= '') then
      begin
        Font.Color := $81D41A;
        ru := true;
      end;
      //
      // TextOut(cp, -round(PaintBox.Height * 0.1), all[i]);
      TextOut(cp + 1, 2, all[i]);
      cp := cp + ww;
    end;

  end;
end;

end.
