unit KindSystems;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, AdvUtil, Vcl.Grids,
  AdvObj, BaseGrid, AdvGrid, DBAdvGrid, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf,
  FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt, Data.DB,
  FireDAC.Comp.DataSet, FireDAC.Comp.Client, JvExStdCtrls, JvButton, JvCtrls,
  JvFooter, Vcl.ExtCtrls, JvExExtCtrls, JvExtComponent, Vcl.Menus,
  System.Actions, Vcl.ActnList, JvDialogs;

type
  TfrmKindSystems = class(TForm)
    TableGrid: TDBAdvGrid;
    TSystemsTemplates: TFDQuery;
    DSSystemsTemplates: TDataSource;
    JvFooter1: TJvFooter;
    btnClose: TJvFooterBtn;
    MyQuery1: TFDQuery;
    btnLoadCert: TJvFooterBtn;
    pmMenu: TPopupMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    PanelHeader: TPanel;
    Label2: TLabel;
    Actions: TActionList;
    actAdd: TAction;
    actDelete: TAction;
    actAttAdd: TAction;
    N3: TMenuItem;
    N4: TMenuItem;
    dlgOpen: TJvOpenDialog;
    actAttSave: TAction;
    dlgSave: TSaveDialog;
    actAttSave1: TMenuItem;
    actAttExpire: TAction;
    actAttExpire1: TMenuItem;
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure actAddExecute(Sender: TObject);
    procedure actDeleteExecute(Sender: TObject);
    procedure TSystemsTemplatesAfterOpen(DataSet: TDataSet);
    procedure actAttAddExecute(Sender: TObject);
    procedure actAttSaveExecute(Sender: TObject);
    procedure actAttSaveUpdate(Sender: TObject);
    procedure actDeleteUpdate(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure actAttExpireExecute(Sender: TObject);
  private
    procedure SetDefaults;
    { Private declarations }
  public
    procedure FillList(var kinds: tstrings);
    { Public declarations }
  end;

var
  frmKindSystems: TfrmKindSystems;

implementation

{$R *.dfm}

uses Universal, CertificateExpireDate;

procedure TfrmKindSystems.actAddExecute(Sender: TObject);
begin
  try
    TSystemsTemplates.Append;
    TSystemsTemplates.Post;
    TSystemsTemplates.Edit;
  except
  end;
end;

procedure TfrmKindSystems.actAttAddExecute(Sender: TObject);
Var
  fn, newfilename: String;
  i: Integer;
  bm: TBookmark;
  d: String;
Begin
  //  

  dlgOpen.Title := ' ';

  //  
  If dlgOpen.Execute Then
  Begin
    fn := dlgOpen.FileName;
    If FileExists(fn) Then
    Begin
      newfilename := frmUniversal.FileSaveToFB(fn);
    End;
  End;

  //   
  If pos(' ', newfilename) < 1 Then
  Begin
    TSystemsTemplates.DisableControls;
    Try
      TSystemsTemplates.Edit;
      TSystemsTemplates.FieldByName('file').AsString := newfilename;
      TSystemsTemplates.Post;
    Except
    End;
    TSystemsTemplates.EnableControls;
  End;
end;

procedure TfrmKindSystems.actAttExpireExecute(Sender: TObject);
var
  certdate: TDateTime;
  SQL: string;
begin
  frmCertificateExpireDate.UseExpire.Checked := not TSystemsTemplates.FieldByName('expire').IsNull;
  if not TSystemsTemplates.FieldByName('expire').IsNull then
    frmCertificateExpireDate.EditExpireDate.Date := TSystemsTemplates.FieldByName('expire').AsDateTime
  else
    frmCertificateExpireDate.EditExpireDate.Date := now();

  if frmCertificateExpireDate.ShowModal = mrOk then
    try
      certdate := frmCertificateExpireDate.EditExpireDate.Date;
      //  
      if frmCertificateExpireDate.UseExpire.Checked then
      begin
        TSystemsTemplates.Edit;
        TSystemsTemplates.FieldByName('expire').AsDateTime := certdate;
        TSystemsTemplates.Post;
      end
      else
      begin
        //   
        TSystemsTemplates.Edit;
        TSystemsTemplates.FieldByName('expire').Clear;
        TSystemsTemplates.Post;
      end;
    except
    end;
  TSystemsTemplates.Refresh;
end;

procedure TfrmKindSystems.actAttSaveExecute(Sender: TObject);
Var
  fn, d: String;
Begin
  //  
  If (TSystemsTemplates.RecNo > 0) Then
  Begin
    //  
    fn := TSystemsTemplates.FieldByName('file').AsString;
    dlgSave.FileName := fn;
    dlgSave.DefaultExt := ExtractFileExt(fn);
    If (fn <> '') And dlgSave.Execute Then
    Begin
      frmUniversal.FileGetByNameToFile(fn, dlgSave.FileName);
    End;
  End;
end;

procedure TfrmKindSystems.actAttSaveUpdate(Sender: TObject);
begin
  actAttSave.Enabled := TSystemsTemplates.RecNo > 0;
end;

procedure TfrmKindSystems.actDeleteExecute(Sender: TObject);
var
  fv: string;
begin
  if TSystemsTemplates.RecordCount < 1 then
    exit;
  fv := TSystemsTemplates.FieldByName('kind').AsString;
  if (MessageDlg(' "' + fv + '"?', mtCustom, [mbYes, mbCancel], 0) = mrYes) then
    try
      TSystemsTemplates.Delete;
    except

    end;
end;

procedure TfrmKindSystems.actDeleteUpdate(Sender: TObject);
begin
  actDelete.Enabled := (TSystemsTemplates.RecNo > 0);
end;

procedure TfrmKindSystems.FillList(var kinds: tstrings);
begin
  kinds.Clear;
  try
    MyQuery1.SQL.Text := 'SELECT `kind` FROM `uni_systemstemplates` GROUP BY `kind`';
    MyQuery1.Active := true;
    while not MyQuery1.eof do
    begin
      kinds.add(MyQuery1.Fields[0].AsString);
      MyQuery1.next;
    end;
  except
  end;
end;

procedure TfrmKindSystems.FormActivate(Sender: TObject);
begin
  try
    TSystemsTemplates.Active := true;
    //
    if TSystemsTemplates.Active and (TSystemsTemplates.RecordCount = 0) then
      SetDefaults;
  except
    close;
  end;
  //
end;

procedure TfrmKindSystems.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TfrmKindSystems.btnCloseClick(Sender: TObject);
begin
  close;
end;

procedure TfrmKindSystems.SetDefaults;
const
  _kind: array [0 .. 6] of string = ('', '', '', '', '', '', '');
  _construction: array [0 .. 6] of string = ('', '', '', '', '',
    '', '');
  _voltage: array [0 .. 6] of string = ('380', '380', '380', '380', '220', '380', '380');
  _current: array [0 .. 6] of string = ('1000', '630', '63', '63', '63', '63', '250');
  _protection: array [0 .. 6] of string = ('20/00', '31', '31', '31', '41', '54', '54');
  _entries: array [0 .. 6] of string = ('2', '2', '1', '1', '1', '1', '1');
  _voltage_secondary: array [0 .. 6] of string = ('220', '220', '', '', '', '220', '220');
  _strength: array [0 .. 6] of string = ('16', '16', '4,5', '4,5', '4,5', '4,5', '16');
var
  i: Integer;
begin
  //   
  for i := 0 to 6 do
  begin
    TSystemsTemplates.Append;
    TSystemsTemplates.FieldByName('kind').AsString := _kind[i];
    TSystemsTemplates.FieldByName('construction').AsString := _construction[i];
    TSystemsTemplates.FieldByName('voltage').AsString := _voltage[i];
    TSystemsTemplates.FieldByName('current').AsString := _current[i];
    TSystemsTemplates.FieldByName('protection').AsString := _protection[i];
    TSystemsTemplates.FieldByName('entries').AsString := _entries[i];
    TSystemsTemplates.FieldByName('voltage_secondary').AsString := _voltage_secondary[i];
    TSystemsTemplates.FieldByName('strength').AsString := _strength[i];
    TSystemsTemplates.Post;
  end;
end;

procedure TfrmKindSystems.TSystemsTemplatesAfterOpen(DataSet: TDataSet);
begin
  TableGrid.ColumnByFieldName['rec_no'].Width := 0;

  TableGrid.ColumnByFieldName['kind'].Header := '';
  TableGrid.ColumnByFieldName['construction'].Header := '';
  TableGrid.ColumnByFieldName['voltage'].Header := ' (U1), ';
  TableGrid.ColumnByFieldName['current'].Header := '  (I), ';
  TableGrid.ColumnByFieldName['protection'].Header := '  (IP)';
  TableGrid.ColumnByFieldName['entries'].Header := ' , ';
  TableGrid.ColumnByFieldName['voltage_secondary'].Header := '   (U2), ';
  TableGrid.ColumnByFieldName['strength'].Header := '   (I), ';
  TableGrid.ColumnByFieldName['file'].Header := '';
  TableGrid.ColumnByFieldName['expire'].Header := 'C   ';

  try
    TableGrid.SelectRange(1, 1, 1, 1);
  except

  end;
end;

end.
