unit HardwareReplace;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, JvExStdCtrls, JvButton,
  JvCtrls, JvFooter, Vcl.ExtCtrls, JvExExtCtrls, JvExtComponent, JvCombobox,
  JvCheckBox, Vcl.Grids, Vcl.DBGrids, JvExDBGrids, JvDBGrid, Data.DB, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client,
  Clipbrd, Vcl.ActnList, System.Actions;

type
  TfrmHardwareReplace = class(TForm)
    Footer: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    btnOk: TJvFooterBtn;
    PanelTop: TPanel;
    PanelRight: TPanel;
    GridTemplate: TJvDBGrid;
    Panel3: TPanel;
    Label3: TLabel;
    SearchCatalog: TLabel;
    Label4: TLabel;
    OnlyCategory: TJvCheckBox;
    _Search: TEdit;
    _SearchDeveloper: TJvComboBox;
    Label1: TLabel;
    WhatByName: TEdit;
    MyQuery1: TFDQuery;
    DSHardware: TDataSource;
    TimerUpdateList: TTimer;
    WhatByArticle: TEdit;
    ActionList1: TActionList;
    actOk: TAction;
    WithName: TRadioButton;
    WithArticle: TRadioButton;
    Panel1: TPanel;
    WhereChange2: TRadioButton;
    Label2: TLabel;
    WhereChange1: TRadioButton;
    THardware: TFDQuery;
    TimerOk: TTimer;
    procedure WhatByNameChange(Sender: TObject);
    procedure TimerUpdateListTimer(Sender: TObject);
    procedure SearchCatalogClick(Sender: TObject);
    procedure OnlyCategoryClick(Sender: TObject);
    procedure _SearchChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure GridTemplateTitleBtnClick(Sender: TObject; ACol: Integer; Field: TField);
    procedure FormCreate(Sender: TObject);
    procedure THardwareAfterOpen(DataSet: TDataSet);
    procedure _SearchDeveloperChange(Sender: TObject);
    procedure WithNameClick(Sender: TObject);
    procedure actOkExecute(Sender: TObject);
    procedure actOkUpdate(Sender: TObject);
    procedure WhatByNameDblClick(Sender: TObject);
    procedure WhatByArticleDblClick(Sender: TObject);
    procedure GridTemplateDblClick(Sender: TObject);
    procedure WithArticleClick(Sender: TObject);
    procedure TimerOkTimer(Sender: TObject);
  private
    procedure UpdateHardwareList;
    procedure UpdateCheckBoxs;
    procedure ReplaceExec;
    { Private declarations }
  public
    WhatId: Integer;
    Project_no: Integer;
    System_no: Integer;
    template_list: String;
    template_no: Integer;

    { Public declarations }
  end;

var
  frmHardwareReplace: TfrmHardwareReplace;

implementation

{$R *.dfm}

uses Main, SelectKindHardware, Universal;

procedure TfrmHardwareReplace.actOkUpdate(Sender: TObject);
begin
  actOk.Enabled := (THardware.Active and (THardware.RecNo > 0) and (WithName.Checked OR WithArticle.Checked))
end;

procedure TfrmHardwareReplace.FormCreate(Sender: TObject);
begin
  template_no := -1;
  // WhereChange.ItemIndex := 0;
end;

procedure TfrmHardwareReplace.FormShow(Sender: TObject);
var
  tmp: string;
begin

  if not frmUniversal.DBConnected then
    close;

  SearchCatalog.Caption := '';
  OnlyCategory.Checked := false;
  if _SearchDeveloper.Items.Count = 0 then
    Try
      //  
      _SearchDeveloper.Clear;
      MyQuery1.SQL.Text := 'SELECT `developer` FROM `uni_hardware` GROUP BY `developer`;';
      MyQuery1.Active := true;
      While Not MyQuery1.eof Do
      Begin
        tmp := Trim(MyQuery1.Fields[0].AsString);
        If tmp <> '' Then
          _SearchDeveloper.Items.Add(MyQuery1.Fields[0].AsString);
        MyQuery1.Next;
      End;
    Except
    End;
  UpdateCheckBoxs;
  _Search.SetFocus;
end;

procedure TfrmHardwareReplace.GridTemplateDblClick(Sender: TObject);
begin
  TimerOk.Enabled := true;
end;

procedure TfrmHardwareReplace.GridTemplateTitleBtnClick(Sender: TObject; ACol: Integer; Field: TField);
begin
  TimerUpdateList.Enabled := true;
end;

procedure TfrmHardwareReplace.OnlyCategoryClick(Sender: TObject);
begin
  If OnlyCategory.Checked Then
  Begin
    If template_no < 0 Then
      SearchCatalogClick(self)
  End;
  TimerUpdateList.Enabled := true;
end;

procedure TfrmHardwareReplace.SearchCatalogClick(Sender: TObject);
begin
  If frmSelectKindHardware.ShowModal = mrOk Then
  Begin
    SearchCatalog.Caption := frmSelectKindHardware.template_name;
    template_no := frmSelectKindHardware.template_no;
    template_list := frmSelectKindHardware.template_list;
  End;
  If (template_no < 0) Then
    OnlyCategory.Checked := false;
  TimerUpdateList.Enabled := true;
end;

procedure TfrmHardwareReplace.THardwareAfterOpen(DataSet: TDataSet);
begin
  (THardware.FieldByName('price') As TFloatField).DisplayFormat := ',0.00';
  ShowScrollBar(GridTemplate.Handle, SB_VERT, false);
  ShowScrollBar(GridTemplate.Handle, SB_VERT, true);
end;

procedure TfrmHardwareReplace.TimerOkTimer(Sender: TObject);
begin
  TimerOk.Enabled := false;
  actOk.Execute;
end;

procedure TfrmHardwareReplace.TimerUpdateListTimer(Sender: TObject);
begin
  TimerUpdateList.Enabled := false;
  UpdateHardwareList;
end;

procedure TfrmHardwareReplace.WhatByArticleDblClick(Sender: TObject);
begin
  _Search.Text := WhatByArticle.Text;
end;

procedure TfrmHardwareReplace.WhatByNameChange(Sender: TObject);
begin
  TimerUpdateList.Enabled := true;
end;

procedure TfrmHardwareReplace.WhatByNameDblClick(Sender: TObject);
begin
  _Search.Text := WhatByName.Text;
end;

procedure TfrmHardwareReplace.WithArticleClick(Sender: TObject);
begin
  UpdateCheckBoxs;
end;

procedure TfrmHardwareReplace.WithNameClick(Sender: TObject);
begin
  UpdateCheckBoxs;
end;

procedure TfrmHardwareReplace._SearchChange(Sender: TObject);
begin
  TimerUpdateList.Enabled := true;
end;

procedure TfrmHardwareReplace._SearchDeveloperChange(Sender: TObject);
begin
  TimerUpdateList.Enabled := true;
end;

Procedure TfrmHardwareReplace.UpdateHardwareList;
Var
  filter: String;
  searchkey: String;
  RU, EN: string;
Begin
  THardware.Active := false;

  searchkey := Trim(_Search.Text);
  If searchkey <> '' Then
  Begin
    EN := frmMain.TransformToEN(searchkey);
    RU := frmMain.TransformToRU(searchkey);
    filter := '(`article` LIKE ' + QuotedStr('%' + searchkey + '%');
    filter := filter + ' OR `name` LIKE ' + QuotedStr('%' + searchkey + '%');
    filter := filter + ' OR `name` LIKE ' + QuotedStr('%' + EN + '%');
    filter := filter + ' OR `name` LIKE ' + QuotedStr('%' + RU + '%');
    filter := filter + ' OR `comment` LIKE ' + QuotedStr('%' + searchkey + '%');
    filter := filter + ')';
  End;
  If OnlyCategory.Checked Then
  Begin
    If filter <> '' Then
      filter := filter + ' AND ';
    filter := filter + '`kind` IN (' + template_list + ')';
  End;
  If (_SearchDeveloper.Text <> '') Then
  Begin
    If filter <> '' Then
      filter := filter + ' AND ';
    filter := filter + '`developer`=' + QuotedStr(_SearchDeveloper.Text);
  End;

  THardware.SQL.Text := 'SELECT * FROM uni_hardware WHERE ' + filter;
  if GridTemplate.SortedField <> '' then
    THardware.SQL.Text := THardware.SQL.Text + ' ORDER BY ' + GridTemplate.SortedField;
  If GridTemplate.SortMarker = smDown Then
    THardware.SQL.Text := THardware.SQL.Text + ' DESC';

  try
    THardware.Active := true;
  except
  end;

  // (THardware.FieldByName('price') As TFloatField).DisplayFormat := ',0.00';
End;

procedure TfrmHardwareReplace.UpdateCheckBoxs;
begin
  //
  WhatByName.Enabled := WithName.Checked;
  if WithName.Checked then
  begin
    WhatByName.Color := clInfoBk;
  end
  else
  begin
    WhatByName.Color := clBtnFace;
  end;
  WhatByArticle.Enabled := WithArticle.Checked;
  if WithArticle.Checked then
  begin
    WhatByArticle.Color := clInfoBk;
  end
  else
  begin
    WhatByArticle.Color := clBtnFace;
  end;
end;

procedure TfrmHardwareReplace.actOkExecute(Sender: TObject);
var
  buttonSelected: Integer;
begin
  if WhereChange1.Checked then
  begin
    buttonSelected := MessageDlg('    ?', mtCustom, [mbYes, mbCancel], 0);
    if (buttonSelected = mrYes) then
      ReplaceExec;
  end;

  if WhereChange2.Checked then
    ReplaceExec;
end;

procedure TfrmHardwareReplace.ReplaceExec;
var
  SQL, WHAT, WHERE, newname: string;
begin
  if THardware.Active and (THardware.RecNo > 0) and (WithName.Checked OR WithArticle.Checked) then
  begin
    formatSETTINGS.DecimalSeparator := '.';
    WHAT := '`name`=:name,`article`=:article,`kinddesc`=:kinddesc,`comment`=:comment,`price`=:price,`valuta`=:valuta,' +
      '`file`=:file,`expire`=:expire,developer=:developer,modules=:modules,modules2=:modules2';

    // where
    WHERE := '`project_no`=' + IntToStr(Project_no) + ' AND (';
    if WithName.Checked then
    begin
      WHERE := WHERE + '`name`=' + QuotedStr(WhatByName.Text);
    end;
    if WithName.Checked and WithArticle.Checked then
      WHERE := WHERE + ' OR ';

    if WithArticle.Checked then
    begin
      WHERE := WHERE + '`article`=' + QuotedStr(WhatByArticle.Text);
    end;
    WHERE := WHERE + ')';

    //   
    if WhereChange1.Checked then
      WHERE := WHERE + ' AND `system_no` IN (SELECT `rec_no` FROM `uni_projectsystems` WHERE `project_no`=' +
        IntToStr(Project_no) + ' AND `active`=true)';

    //   
    if WhereChange2.Checked then
      WHERE := WHERE + ' AND `system_no`=' + IntToStr(System_no);

    SQL := 'UPDATE `uni_projecthardware` SET ' + WHAT + ' WHERE ' + WHERE;

    MyQuery1.SQL.Text := SQL;
    MyQuery1.ParamByName('name').AsString := THardware.FieldByName('name').AsString;
    MyQuery1.ParamByName('article').AsString := THardware.FieldByName('article').AsString;
    MyQuery1.ParamByName('kinddesc').AsString := THardware.FieldByName('kinddesc').AsString;
    MyQuery1.ParamByName('comment').AsString := THardware.FieldByName('comment').AsString;
    MyQuery1.ParamByName('valuta').AsString := THardware.FieldByName('valuta').AsString;
    MyQuery1.ParamByName('file').AsString := THardware.FieldByName('file').AsString;
    MyQuery1.ParamByName('price').AsFloat := THardware.FieldByName('price').AsFloat;
    MyQuery1.ParamByName('expire').AsDateTime := THardware.FieldByName('expire').AsDateTime;
    MyQuery1.ParamByName('developer').AsString := THardware.FieldByName('developer').AsString;
    MyQuery1.ParamByName('modules').AsFloat := THardware.FieldByName('modules').AsFloat;
    MyQuery1.ParamByName('modules2').AsFloat := THardware.FieldByName('modules2').AsFloat;
    try
      MyQuery1.Execute;
    except
      Clipboard.SetTextBuf(pchar(SQL));
      ShowMessage('.     ');
    end;
    ModalResult := mrOk;
  end;
end;

end.
