Unit HardwareAdd;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, JvExStdCtrls, JvButton, JvCtrls, JvFooter, ExtCtrls,
  JvExExtCtrls, JvExtComponent, Grids, DBGrids, JvExDBGrids, JvDBGrid, DB,
  Mask, DBCtrls, JvExControls, JvDBLookupTreeView, JvExMask,
  JvToolEdit, JvBaseEdits, JvDBControls, JvEdit, JvMemoryDataset,
  JvDataSource, JvCombobox, JvAutoComplete, JvSpin, ActnList, StdActns,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client, System.RegularExpressions,
  Vcl.Samples.Spin, JvValidateEdit, AdvSpin, AdvEdit;

Type
  TfrmHardwareAdd = Class(TForm)
    JvFooter1: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    btnOk: TJvFooterBtn;
    GroupBox1: TGroupBox;
    LabelArticle: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    GroupBox2: TGroupBox;
    TemplateGrid: TJvDBGrid;
    DSDefTable: TDataSource;
    lblPrice: TLabel;
    _price: TJvCalcEdit;
    DefTable: TJvMemoryData;
    TQuery: TFDQuery;
    Label5: TLabel;
    btnAutoname: TJvImgBtn;
    Label6: TLabel;
    Label7: TLabel;
    _modules2: TJvValidateEdit;
    _modules: TJvValidateEdit;
    Label1: TLabel;
    rb_din: TRadioButton;
    rb_nedin: TRadioButton;
    rb_other: TRadioButton;
    TAtt: TFDQuery;
    TDefFields: TFDQuery;
    _name: TEdit;
    ac_name: TJvLookupAutoComplete;
    _kinddesc: TEdit;
    _article: TEdit;
    _developer: TEdit;
    _comment: TEdit;
    ac_article: TJvLookupAutoComplete;
    ac_developer: TJvLookupAutoComplete;
    ac_kinddesc: TJvLookupAutoComplete;
    Procedure btnOkClick(Sender: TObject);
    Procedure FormShow(Sender: TObject);
    Procedure _articleChange(Sender: TObject);
    Procedure _priceChange(Sender: TObject);
    Procedure btnAutonameClick(Sender: TObject);
    Procedure FormCreate(Sender: TObject);
    Procedure FormActivate(Sender: TObject);
    procedure DefTableBeforePost(DataSet: TDataSet);
    procedure _modulesChange(Sender: TObject);
    procedure _modules2Change(Sender: TObject);
  Private
    function ArticleExists(article: string): boolean;
    procedure AutoFillPrepary;
    procedure AttFill;
    procedure FillFromSrc;
    { Private declarations }
  Public
    CategoryNo: integer;
    HardwareNo: integer; // -1  
    HardwareSrc: integer; // -1    
    tableSRC, tableDST: string;
    din: integer;
    Procedure Clear;
    { Public declarations }
  End;

Var
  frmHardwareAdd: TfrmHardwareAdd;

Implementation

Uses Main, Universal, Generator;

{$R *.dfm}

Procedure TfrmHardwareAdd.btnOkClick(Sender: TObject);
var
  s1, s2: String;
Begin
  If (length(_article.Text) = 0) Then
  Begin
    btnAutoname.Click;
    Application.ProcessMessages;
  End;

  if (_article.hint <> _article.Text) and ArticleExists(_article.Text) then
  begin
    LabelArticle.Font.Color := clRed;
    ShowMessage('.  ');
    exit;
  end;

  If (length(_article.Text) = 0) Then
    exit;

  If ac_article.Strings.IndexOf(_article.Text) = -1 Then
    ac_article.Strings.Add(_article.Text);
  If ac_name.Strings.IndexOf(_name.Text) = -1 Then
    ac_name.Strings.Add(_name.Text);
  If ac_developer.Strings.IndexOf(_developer.Text) = -1 Then
    ac_developer.Strings.Add(_developer.Text);

  TQuery.SQL.Text := 'SELECT * FROM ' + tableSRC + ' WHERE rec_no=:rec_no';
  TQuery.ParamByName('rec_no').AsInteger := HardwareNo;
  TQuery.Active := true;

  if HardwareNo = -1 then
  begin
    TQuery.Append;
  end;

  if HardwareNo > -1 then
  begin
    TQuery.Edit;
  end;

  TQuery.FieldByName('kind').AsInteger := frmHardwareAdd.CategoryNo;
  TQuery.FieldByName('article').AsString := Trim(frmHardwareAdd._article.Text);
  TQuery.FieldByName('kinddesc').AsString := Trim(frmHardwareAdd._kinddesc.Text);
  TQuery.FieldByName('name').AsString := Trim(frmHardwareAdd._name.Text);
  TQuery.FieldByName('comment').AsString := Trim(frmHardwareAdd._comment.Text);
  TQuery.FieldByName('developer').AsString := Trim(frmHardwareAdd._developer.Text);
  TQuery.FieldByName('price').AsFloat := frmHardwareAdd._price.Value;
  TQuery.FieldByName('valuta').AsString := 'RUB';
  TQuery.FieldByName('modules').AsFloat := StrToFloat(frmHardwareAdd._modules.Text);
  TQuery.FieldByName('modules2').AsFloat := StrToFloat(frmHardwareAdd._modules2.Text);
  TQuery.FieldByName('lastupdate').AsDateTime := now();
  TQuery.FieldByName('username').AsString := frmMain.username;

  if rb_din.Checked then
    TQuery.FieldByName('din').AsInteger := 1;
  if rb_nedin.Checked then
    TQuery.FieldByName('din').AsInteger := 2;
  if rb_other.Checked then
    TQuery.FieldByName('din').AsInteger := 0;

  TQuery.Post;
  if HardwareNo = -1 then
  begin
    TQuery.SQL.Text := 'SELECT LAST_INSERT_ID() as ID';
    TQuery.Active := true;
    HardwareNo := TQuery.FieldByName('ID').AsInteger;
  end;
  TQuery.Close;

  // TAtt fill
  TAtt.SQL.Text := 'SELECT * FROM `uni_attachment` WHERE parent=:parent;';
  TAtt.ParamByName('parent').AsInteger := HardwareNo;
  TAtt.Active := true;

  DefTable.First;
  While Not DefTable.eof Do
  Begin
    s1 := DefTable.FieldByName('attname').AsString;
    s2 := DefTable.FieldByName('attvalue').AsString;
    If TAtt.Locate('name', s1, []) Then
    Begin
      TAtt.Edit;
      TAtt.FieldByName('content').AsString := s2;
      TAtt.Post;
    End
    Else If s1 <> '' Then
    Begin
      TAtt.Append;
      TAtt.FieldByName('parent').AsInteger := HardwareNo;
      TAtt.FieldByName('name').AsString := s1;
      TAtt.FieldByName('content').AsString := s2;
      TAtt.Post;
    End;
    DefTable.Next;
  End;
  //

  ModalResult := mrOk;
End;

Procedure TfrmHardwareAdd.Clear;
Begin
  _article.Text := '';
  _name.Text := '';
  _developer.Text := '';
  _price.Text := '';
  _comment.Text := '';
  _kinddesc.Text := '';
  _modules.Text := '0';
  _modules2.Text := '0';
  DefTable.Active := true;
  DefTable.EmptyTable;
  rb_other.Checked := true;

End;

procedure TfrmHardwareAdd.DefTableBeforePost(DataSet: TDataSet);
var
  input: string;
begin
  input := DefTable.FieldByName('attvalue').AsString;
  If pos(#$D, input) > 0 Then
  Begin
    input := copy(input, 0, pos(#$D, input) - 1);
    DefTable.FieldByName('attvalue').AsString := input;
  End;
end;

Procedure TfrmHardwareAdd.FormActivate(Sender: TObject);
Begin
  _article.SetFocus;
End;

Procedure TfrmHardwareAdd.FormCreate(Sender: TObject);
Begin
  tableSRC := 'uni_hardware';
  tableDST := 'uni_hardware';
End;

Procedure TfrmHardwareAdd.AutoFillPrepary;
begin
  //
  Try
    If (ac_article.Strings.Count = 0) Then
    Begin
      TQuery.SQL.Text := 'SELECT `article` FROM `uni_hardware` GROUP BY `article`;';
      TQuery.Active := true;
      While Not TQuery.eof Do
      Begin
        ac_article.Strings.Add(TQuery.Fields[0].AsString);
        TQuery.Next;
      End;
    End;
    If (ac_name.Strings.Count = 0) Then
    Begin
      TQuery.SQL.Text := 'SELECT `name` FROM `uni_hardware` GROUP BY `name`;';
      TQuery.Active := true;
      While Not TQuery.eof Do
      Begin
        ac_name.Strings.Add(TQuery.Fields[0].AsString);
        TQuery.Next;
      End;
    End;
    If (ac_developer.Strings.Count = 0) Then
    Begin
      TQuery.SQL.Text := 'SELECT `developer` FROM `uni_hardware` GROUP BY `developer`;';
      TQuery.Active := true;
      While Not TQuery.eof Do
      Begin
        ac_developer.Strings.Add(TQuery.Fields[0].AsString);
        TQuery.Next;
      End;
    End;
    { If (_comment.Strings.Count = 0) Then
      Begin
      TQuery.SQL.Text :=
      'SELECT `comment` FROM `uni_hardware` GROUP BY `comment`;';
      TQuery.Active := true;
      While Not TQuery.Eof Do
      Begin
      _comment.Strings.Add(TQuery.Fields[0].AsString);
      TQuery.Next;
      End;
      End; }
    If (ac_kinddesc.Strings.Count = 0) Then
    Begin
      TQuery.SQL.Text := 'SELECT `kinddesc` FROM `uni_hardware` GROUP BY `kinddesc`;';
      TQuery.Active := true;
      While Not TQuery.eof Do
      Begin
        ac_kinddesc.Strings.Add(TQuery.Fields[0].AsString);
        TQuery.Next;
      End;
    End;
  Except
  End;
end;

Procedure TfrmHardwareAdd.FillFromSrc;
Var
  s1, s2: String;
Begin
  //    
  TQuery.SQL.Text := 'SELECT * FROM ' + tableSRC + ' WHERE rec_no=:rec_no';
  TQuery.ParamByName('rec_no').AsInteger := HardwareSrc;
  TQuery.Active := true;

  if TQuery.RecordCount < 1 then
    exit;

  _article.Text := TQuery.FieldByName('article').AsString;
  _kinddesc.Text := TQuery.FieldByName('kinddesc').AsString;
  _name.Text := TQuery.FieldByName('name').AsString;
  _comment.Text := TQuery.FieldByName('comment').AsString;
  _developer.Text := TQuery.FieldByName('developer').AsString;
  _price.Value := TQuery.FieldByName('price').AsFloat;
  _modules.Text := FormatFloat('0.##', TQuery.FieldByName('modules').AsFloat);
  _modules2.Text := FormatFloat('0.##', TQuery.FieldByName('modules2').AsFloat);

  // TAtt fill
  TAtt.SQL.Text := 'SELECT * FROM `uni_attachment` WHERE parent=' + IntToStr(HardwareSrc) + ';';
  TAtt.Active := true;
  While Not TAtt.eof Do
  Begin
    DefTable.Append;
    DefTable.FieldByName('attname').AsString := TAtt.FieldByName('name').AsString;
    DefTable.FieldByName('attvalue').AsString := TAtt.FieldByName('content').AsString;
    DefTable.Post;
    TAtt.Next;
  End;
  // deffields fill
  //     
  TDefFields.SQL.Text := 'SELECT * FROM `uni_templatesfields` WHERE parent=' + IntToStr(CategoryNo) + ';';
  TDefFields.Active := true;
  While Not TDefFields.eof Do
  Begin
    s1 := TDefFields.FieldByName('name').AsString;
    s2 := TDefFields.FieldByName('defaultvalue').AsString;
    If Not DefTable.Locate('attname', s1, []) Then
    Begin
      DefTable.Append;
      DefTable.FieldByName('attname').AsString := s1;
      DefTable.FieldByName('attvalue').AsString := s2;
      DefTable.Post;
    End;
    TDefFields.Next;
  End;
  DefTable.First;

end;

Procedure TfrmHardwareAdd.FormShow(Sender: TObject);
Begin
  _article.Color := clWindow;
  if not frmUniversal.DBConnected then
    Close;
  AutoFillPrepary;
  frmHardwareAdd.Clear;

  din := 0;

  if HardwareNo = -1 then
  begin
    if HardwareSrc = -1 then
    begin
      frmHardwareAdd.Caption := ' ';
    end
    else
    begin
      frmHardwareAdd.Caption := '   ';
      FillFromSrc;
      _article.hint := '';
    end;
  end
  else
  begin
    frmHardwareAdd.Caption := ' ';
    TQuery.SQL.Text := 'SELECT * FROM ' + tableSRC + ' WHERE rec_no=:rec_no';
    TQuery.ParamByName('rec_no').AsInteger := HardwareNo;
    TQuery.Active := true;
    _article.Text := TQuery.FieldByName('article').AsString;
    _kinddesc.Text := TQuery.FieldByName('kinddesc').AsString;
    _name.Text := TQuery.FieldByName('name').AsString;
    _comment.Text := TQuery.FieldByName('comment').AsString;
    _developer.Text := TQuery.FieldByName('developer').AsString;
    _price.Value := TQuery.FieldByName('price').AsFloat;
    _modules.Text := FormatFloat('0.##', TQuery.FieldByName('modules').AsFloat);
    _modules2.Text := FormatFloat('0.##', TQuery.FieldByName('modules2').AsFloat);
    din := TQuery.FieldByName('din').AsInteger;
    AttFill;
    _article.hint := _article.Text;
  end;

  rb_other.Checked := (din = 0);
  rb_din.Checked := (din = 1);
  rb_nedin.Checked := (din = 2);
End;

procedure TfrmHardwareAdd.AttFill;
var
  s1, s2: String;
begin
  // TAtt fill
  TAtt.SQL.Text := 'SELECT * FROM `uni_attachment` WHERE parent=' + IntToStr(HardwareNo) + ';';
  TAtt.Active := true;
  While Not TAtt.eof Do
  Begin
    frmHardwareAdd.DefTable.Append;
    frmHardwareAdd.DefTable.FieldByName('attname').AsString := TAtt.FieldByName('name').AsString;
    frmHardwareAdd.DefTable.FieldByName('attvalue').AsString := TAtt.FieldByName('content').AsString;
    frmHardwareAdd.DefTable.Post;
    TAtt.Next;
  End;
  // deffields fill
  //     
  TDefFields.SQL.Text := 'SELECT * FROM `uni_templatesfields` WHERE parent=' + IntToStr(CategoryNo) + ';';
  TDefFields.Active := true;
  While Not TDefFields.eof Do
  Begin
    s1 := TDefFields.FieldByName('name').AsString;
    s2 := TDefFields.FieldByName('defaultvalue').AsString;
    If Not DefTable.Locate('attname', s1, []) Then
    Begin
      DefTable.Append;
      DefTable.FieldByName('attname').AsString := s1;
      DefTable.FieldByName('attvalue').AsString := s2;
      DefTable.Post;
    End;
    TDefFields.Next;
  End;
  frmHardwareAdd.DefTable.First;
end;

Procedure TfrmHardwareAdd._articleChange(Sender: TObject);
Var
  input: String;
Begin
  If (Sender Is TJvComboEdit) Then
  Begin
    input := (Sender As TJvComboEdit).Text;
    If pos(#$D, input) > 0 Then
    Begin
      input := copy(input, 0, pos(#$D, input) - 1);
      (Sender As TJvComboEdit).Text := input;
    End;
  End;
  LabelArticle.Font.Color := clWindowText;
  btnAutoname.Enabled := (_article.Text = '');
End;

procedure TfrmHardwareAdd._modules2Change(Sender: TObject);
var
  txt: string;
  val: double;
begin
  if not Visible then
    exit;
  if not _modules2.Enabled then
    exit;
  txt := _modules2.Text;

  txt := StringReplace(txt, '.', FormatSettings.DecimalSeparator, [rfReplaceAll, rfIgnoreCase]);
  txt := StringReplace(txt, ',', FormatSettings.DecimalSeparator, [rfReplaceAll, rfIgnoreCase]);

  if _modules2.Text <> txt then
  begin
    _modules2.Text := txt;
    _modules2.Selstart := length(_modules2.Text);
  end;

  _modules.Enabled := false;
  if TryStrToFloat(txt, val) then
  begin
    _modules.Text := FormatFloat('0.##', val / 18);
  end
  else
    _modules.Text := '';
  _modules.Enabled := true;

end;

procedure TfrmHardwareAdd._modulesChange(Sender: TObject);
var
  txt: string;
  val: double;
begin
  if not Visible then
    exit;
  if not _modules.Enabled then
    exit;
  txt := _modules.Text;

  txt := StringReplace(txt, '.', FormatSettings.DecimalSeparator, [rfReplaceAll, rfIgnoreCase]);
  txt := StringReplace(txt, ',', FormatSettings.DecimalSeparator, [rfReplaceAll, rfIgnoreCase]);

  if _modules.Text <> txt then
  begin
    _modules.Text := txt;
    _modules.Selstart := length(_modules.Text);
  end;

  _modules2.Enabled := false;
  if TryStrToFloat(txt, val) then
  begin
    _modules2.Text := FormatFloat('0.##', val * 18);
  end
  else
    _modules2.Text := '';
  _modules2.Enabled := true;

end;

Procedure TfrmHardwareAdd._priceChange(Sender: TObject);
Var
  input: String;
Begin
  If (Sender Is TJvCalcEdit) Then
  Begin
    input := (Sender As TJvCalcEdit).Text;
    If pos(#$D, input) > 0 Then
    Begin
      input := copy(input, 0, pos(#$D, input) - 1);
      (Sender As TJvCalcEdit).Text := input;
    End;
  End;
End;

Procedure TfrmHardwareAdd.btnAutonameClick(Sender: TObject);
Var
  article: String;
  // len: integer;
  FMAX: integer;
  SC: boolean;
Begin
  // autofill
  If _article.Text = '' Then
  Begin
    article := frmGenerator.GetCurrentValue;

    SC := true;
    //      

    while SC do
    begin
      TQuery.SQL.Text := 'SELECT `article` FROM `uni_hardware` WHERE `article`=:article LIMIT 1;';
      TQuery.ParamByName('article').AsString := article;
      TQuery.Active := true;
      if TQuery.RecordCount > 0 then
      Begin
        //  ,  
        article := frmGenerator.GetNextCode(article);
        frmGenerator.SaveValue(article);
      End
      else
        SC := false;
    end;
    _article.Text := article;
  End;
  TQuery.Active := false;
End;

function TfrmHardwareAdd.ArticleExists(article: string): boolean;
Var
  rc: integer;
Begin
  // autofill
  TQuery.SQL.Text := 'SELECT `article` FROM `uni_hardware` WHERE `article`=' + QuotedStr(article) + ' AND `rec_no`<>' +
    IntToStr(HardwareNo) + ' LIMIT 1';
  TQuery.Active := true;
  rc := TQuery.RecordCount;
  result := rc > 0;
  TQuery.Active := false;
End;

End.
