unit Generator;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, JvExStdCtrls, JvButton,
  JvCtrls, JvFooter, Vcl.ExtCtrls, JvExExtCtrls, JvExtComponent;

type
  TfrmGenerator = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    NewCode: TEdit;
    Results: TListBox;
    JvFooter1: TJvFooter;
    btnOk: TJvFooterBtn;
    JvFooterBtn1: TJvFooterBtn;
    procedure NewCodeChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
  private
    procedure ShowResults;
    { Private declarations }
  public
    function GetNextCode(start: string): string;
    function GetCurrentValue: string;
    procedure SaveValue(value: string);
    { Public declarations }
  end;

var
  frmGenerator: TfrmGenerator;

implementation

{$R *.dfm}

uses Universal;

procedure TfrmGenerator.NewCodeChange(Sender: TObject);
begin
  ShowResults;
end;

procedure TfrmGenerator.ShowResults;
var
  i: integer;
  c: string;
begin
  //
  c := NewCode.Text;
  Results.Clear;
  for i := 0 to 50 do
  begin
    c := GetNextCode(c);
    Results.Items.Add(c);
  end;
  Results.ItemIndex := 0;
end;

procedure TfrmGenerator.SaveValue(value: string);
begin
  frmUniversal.MyQuery1.SQL.Text := 'SELECT * FROM `uni_settings` WHERE `name`=:name;';
  frmUniversal.MyQuery1.ParamByName('name').AsString := '';
  frmUniversal.MyQuery1.Active := true;
  if frmUniversal.MyQuery1.RecordCount = 0 then
  begin
    frmUniversal.MyQuery1.SQL.Text := 'INSERT INTO `uni_settings` (`name`,`value`) VALUES (:name,:value);';
    frmUniversal.MyQuery1.ParamByName('name').AsString := '';
    frmUniversal.MyQuery1.ParamByName('value').AsString := value.Trim;
    frmUniversal.MyQuery1.ExecSQL;
  end
  else
  begin
    frmUniversal.MyQuery1.SQL.Text := 'UPDATE `uni_settings` SET `value`=:value WHERE name=:name;';
    frmUniversal.MyQuery1.ParamByName('name').AsString := '';
    frmUniversal.MyQuery1.ParamByName('value').AsString := value.Trim;
    frmUniversal.MyQuery1.ExecSQL;
  end;
end;

procedure TfrmGenerator.btnOkClick(Sender: TObject);
begin
  SaveValue(NewCode.Text);
  ModalResult := mrOk;
end;

function TfrmGenerator.GetCurrentValue: string;
begin
  result := '';
  try
    frmUniversal.MyQuery1.SQL.Text := 'SELECT `value` FROM `uni_settings` WHERE `name`=:name;';
    frmUniversal.MyQuery1.ParamByName('name').AsString := '';
    frmUniversal.MyQuery1.Active := true;
    if frmUniversal.MyQuery1.RecordCount > 0 then
      result := frmUniversal.MyQuery1.FieldByName('value').AsString;
  except
  end;
end;

procedure TfrmGenerator.FormActivate(Sender: TObject);
begin
  NewCode.Text := GetCurrentValue;
  ShowResults;
end;

function TfrmGenerator.GetNextCode(start: string): string;
var
  i, p: integer;
  nextdo: boolean;
begin
  result := start;
  if length(start) < 1 then
    exit;

  nextdo := true;
  for i := length(start) downto 0 do
  begin
    if nextdo and (start[i] in ['0' .. '9']) then
    begin
      nextdo := false;
      case start[i] of
        '0':
          start[i] := '1';
        '1':
          start[i] := '2';
        '2':
          start[i] := '3';
        '3':
          start[i] := '4';
        '4':
          start[i] := '5';
        '5':
          start[i] := '6';
        '6':
          start[i] := '7';
        '7':
          start[i] := '8';
        '8':
          start[i] := '9';
        '9':
          start[i] := '0';
      end;
      if start[i] = '0' then
      begin
        nextdo := true;
        p := i;
      end;
    end;
  end;
  if nextdo then
  begin
    insert('1',start,p);
  end;

  result := start;
end;

end.
