unit DataModule;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics, frxDesgn, frxRich,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Data.DB, frxClass,
  frxDBSet, JvMemoryDataset, frxExportRTF,
  frxExportPDF, FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, frxExportBaseDialog, FireDAC.Comp.DataSet,
  FireDAC.Comp.Client, frxExportImage, frxExportXLS, frxExportXLSX, frxExportODF,
  frxExportHTML, frxExportDOCX, JvDataEmbedded, JvDialogs, frxCrypt, frxGZip,
  frxDCtrl, frxGradient, frxChBox, frxCellularTextObject, frxZipCode, frxMap,
  frxTableObject, frxOLE, frxBarcode;

type
  TData = class(TForm)
    TPrHardware: TFDQuery;
    TPrSystems: TFDQuery;
    TProjects: TFDQuery;
    PrHardware: TfrxDBDataset;
    PrSystems: TfrxDBDataset;
    Projects: TfrxDBDataset;
    frxReport: TfrxReport;
    TTemplate: TFDQuery;
    frxRTFExport1: TfrxRTFExport;
    frxPDFExport1: TfrxPDFExport;
    TTasks: TFDQuery;
    Tasks: TfrxDBDataset;
    frxPNGExport1: TfrxPNGExport;
    frxXLSExport1: TfrxXLSExport;
    frxXLSXExport1: TfrxXLSXExport;
    frxODSExport1: TfrxODSExport;
    frxODTExport1: TfrxODTExport;
    frxHTMLExport1: TfrxHTMLExport;
    frxDOCXExport1: TfrxDOCXExport;
    frxTIFFExport1: TfrxTIFFExport;
    EmptyTemplate: TJvDataEmbedded;
    frxDesigner: TfrxDesigner;
    dlgSave: TSaveDialog;
    dlgOpen: TJvOpenDialog;
    TCustomers: TFDQuery;
    Customers: TfrxDBDataset;
    function frxDesignerSaveReport(Report: TfrxReport; SaveAs: Boolean): Boolean;
    procedure frxReportGetValue(const VarName: string; var Value: Variant);
  private
    { Private declarations }
  public
    reportkind, reportname: string;
    reportext, reportfile: string;
    report_recno: integer;
    Project_no: integer;
    System_no: integer;
    procedure DBConnect;
    procedure DoReport;
    procedure DoReportSave;
    procedure DoReportSaveFormat(resultstream: TMemoryStream; reportext: string); Overload;
    procedure DoReportPreset;
    procedure DesignReport;
    { Public declarations }
  end;

var
  Data: TData;

implementation

{$R *.dfm}

uses Main, Universal;

procedure TData.DBConnect;
begin
  if not frmUniversal.DBConnected then
    close;
  try
    // TTemplate.Active := true;
  except
  end;
end;

procedure TData.DoReport;
var
  BlobField2: TField;
  edit_stream: TStream;
begin
  if not frmUniversal.DBConnected then
    close;

  try
    Projects.DataSet := TProjects;
    PrSystems.DataSet := TPrSystems;
    PrHardware.DataSet := TPrHardware;
    Tasks.DataSet := TTasks;
    Customers.DataSet := TCustomers;

    //  
    TProjects.SQL.Text := 'SELECT * FROM `uni_projects` WHERE `rec_no`=' + IntToStr(Project_no) + ' LIMIT 1;';
    TProjects.Active := true;

    TPrSystems.SQL.Text := 'SELECT * FROM `uni_projectsystems` WHERE `project_no`=' + IntToStr(Project_no) +
      ' ORDER BY `orderby`;';
    TPrSystems.Active := true;

    TPrHardware.SQL.Text := 'SELECT *, `price`*`count` as `total` FROM uni_projecthardware WHERE `project_no`=' +
      IntToStr(Project_no) + ' AND `system_no`=' + IntToStr(System_no) + ' ORDER BY `orderby`;';
    TPrHardware.Active := true;

    TCustomers.SQL.Text := 'SELECT * FROM `uni_customers`;';
    TCustomers.Active := true;

    // ShowMessage(IntToStr(TPrHardware.RecordCount));

    //   
    TTemplate.SQL.Text := 'SELECT * FROM `uni_docparts` WHERE `project_no`=0 AND `kind`=' + QuotedStr(reportkind) +
      ' AND `name`=' + QuotedStr(reportname) + ';';
    TTemplate.Active := true;
    //
    if TTemplate.RecordCount > 0 then
    begin
      BlobField2 := TTemplate.FieldByName('store');
      edit_stream := TTemplate.CreateBlobStream(BlobField2, bmRead);
      frxReport.FileName := 'template.fr3';
      frxReport.LoadFromStream(edit_stream);
      frxReport.ShowReport;
    end
    else
    begin
      ShowMessage('.      ');
    end;
  except
    ShowMessage('.');
  end;
end;

procedure TData.DoReportSave;
var
  BlobField2: TField;
  edit_stream: TStream;
begin
  if not frmUniversal.DBConnected then
    close;

  try
    DoReportPreset;

    //
    if TTemplate.RecordCount > 0 then
    begin
      BlobField2 := TTemplate.FieldByName('store');
      edit_stream := TTemplate.CreateBlobStream(BlobField2, bmRead);
      frxReport.FileName := 'template.fr3';
      frxReport.LoadFromStream(edit_stream);

      frxReport.PrepareReport();

      edit_stream.Free;
    end
    else
    begin
      ShowMessage('.      ');
    end;
  except
  end;
end;

procedure TData.DoReportPreset;
begin
  //
  Projects.DataSet := TProjects;
  PrSystems.DataSet := TPrSystems;
  PrHardware.DataSet := TPrHardware;
  Tasks.DataSet := TTasks;

  //  
  TProjects.SQL.Text := 'SELECT * FROM `uni_projects` WHERE `rec_no`=:project_no;';
  TProjects.ParamByName('project_no').AsInteger := Project_no;
  TProjects.Active := true;

  TPrSystems.SQL.Text := 'SELECT * FROM `uni_projectsystems` WHERE `project_no`=:project_no ORDER BY `orderby`;';
  TPrSystems.ParamByName('project_no').AsInteger := Project_no;
  TPrSystems.Active := true;

  TPrHardware.SQL.Text :=
    'SELECT *, `price`*`count` as `total` FROM `uni_projecthardware` WHERE `project_no`=:project_no ORDER BY `orderby`;';
  TPrHardware.ParamByName('project_no').AsInteger := Project_no;
  TPrHardware.Active := true;

  TTasks.SQL.Text := 'SELECT * FROM `uni_messages` WHERE `project_no`=:project_no ORDER BY `kind`,`orderby`;';
  TTasks.ParamByName('project_no').AsInteger := Project_no;
  TTasks.Active := true;

  TCustomers.SQL.Text := 'SELECT * FROM `uni_customers`;';
  TCustomers.Active := true;

  //   
  TTemplate.SQL.Text := 'SELECT * FROM `uni_docparts` WHERE `project_no`=0 AND `kind`=:kind AND `name`=:name;';
  TTemplate.ParamByName('kind').AsString := reportkind;
  TTemplate.ParamByName('name').AsString := reportname;
  TTemplate.Active := true;
end;

procedure TData.DoReportSaveFormat(resultstream: TMemoryStream; reportext: string);
begin

  if reportext = '.PDF' then
  begin
    frxPDFExport1.Stream := resultstream;
    frxReport.Export(frxPDFExport1);
  end
  else if reportext = '.RTF' then
  begin
    frxRTFExport1.Stream := resultstream;
    frxReport.Export(frxRTFExport1);
  end
  else if reportext = '.PNG' then
  begin
    frxPNGExport1.Stream := resultstream;
    frxReport.Export(frxPNGExport1);
  end
  else if reportext = '.XLS' then
  begin
    frxXLSExport1.Stream := resultstream;
    frxReport.Export(frxXLSExport1);
  end
  else if reportext = '.XLSX' then
  begin
    frxXLSXExport1.Stream := resultstream;
    frxReport.Export(frxXLSXExport1);
  end
  else if reportext = '.ODS' then
  begin
    frxODSExport1.Stream := resultstream;
    frxReport.Export(frxODSExport1);
  end
  else if reportext = '.ODT' then
  begin
    frxODTExport1.Stream := resultstream;
    frxReport.Export(frxODTExport1);
  end
  else if reportext = '.HTML' then
  begin
    frxHTMLExport1.Stream := resultstream;
    frxReport.Export(frxHTMLExport1);
  end
  else if reportext = '.DOCX' then
  begin
    frxDOCXExport1.Stream := resultstream;
    frxReport.Export(frxDOCXExport1);
  end
  else if reportext = '.TIFF' then
  begin
    frxTIFFExport1.Stream := resultstream;
    frxReport.Export(frxTIFFExport1);
  end;
end;

function TData.frxDesignerSaveReport(Report: TfrxReport; SaveAs: Boolean): Boolean;
var
  FS: TMemoryStream;
begin
  FS := TMemoryStream.Create;
  try
    Data.frxReport.SaveToStream(FS);
    FS.Seek(0, soFromBeginning);

    if SaveAs then
    begin
      if dlgSave.Execute then
        FS.SaveToFile(dlgSave.FileName);
    end
    else
    begin
      frmUniversal.FilebaseQuery1.SQL.Text := 'UPDATE `uni_docparts` SET `store`=:store WHERE rec_no=:rec_no;';
      frmUniversal.FilebaseQuery1.ParamByName('store').LoadFromStream(FS, ftBlob);
      frmUniversal.FilebaseQuery1.ParamByName('rec_no').AsInteger := report_recno;
      frmUniversal.FilebaseQuery1.ExecSQL;
      frmUniversal.FilebaseQuery1.close;
    end;
  finally
    FS.Free;
  end;
end;

procedure TData.frxReportGetValue(const VarName: string; var Value: Variant);
var
  s: tstrings;
  v: string;
begin
  //
  if pos('<', VarName) > 0 then
    exit;

  s := tstringlist.Create;
  s.Text := TPrSystems.FieldByName('opts').AsString;
  v := s.Values[trim(VarName)];
  if length(v) > 0 then
    Value := v;
  s.Free;

end;

procedure TData.DesignReport;
begin
     frxReport.DesignReport;
end;

end.
