unit Certificates;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, Vcl.Tabs,
  Vcl.Grids, FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, Data.DB, FireDAC.Comp.DataSet,
  FireDAC.Comp.Client, Vcl.DBGrids, JvExDBGrids, JvDBGrid, Vcl.WinXPickers, ShellAPI,
  Vcl.ComCtrls, Vcl.Menus, System.Actions, Vcl.ActnList, JvDialogs;

type
  TfrmCertificates = class(TForm)
    PanelHeader: TPanel;
    Label2: TLabel;
    Sheets: TTabSet;
    THardware: TFDQuery;
    DSHardware: TDataSource;
    HardwareGrid: TJvDBGrid;
    Panel1: TPanel;
    btnLoad: TButton;
    btnSave: TButton;
    Button1: TButton;
    pmCertificates: TPopupMenu;
    Actions: TActionList;
    actOpen: TAction;
    actReplace: TAction;
    actSetDate: TAction;
    FDQuery1: TFDQuery;
    dlgOpen: TJvOpenDialog;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    Panel2: TPanel;
    editFilter: TLabeledEdit;
    TimerUpdate: TTimer;
    actRemoveCert: TAction;
    N4: TMenuItem;
    N5: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure SheetsChange(Sender: TObject; NewTab: Integer; var AllowChange: Boolean);
    procedure actOpenExecute(Sender: TObject);
    procedure actReplaceExecute(Sender: TObject);
    procedure actSetDateExecute(Sender: TObject);
    procedure actOpenUpdate(Sender: TObject);
    procedure actReplaceUpdate(Sender: TObject);
    procedure actSetDateUpdate(Sender: TObject);
    procedure HardwareGridTitleBtnClick(Sender: TObject; ACol: Integer; Field: TField);
    procedure editFilterChange(Sender: TObject);
    procedure TimerUpdateTimer(Sender: TObject);
    procedure actRemoveCertUpdate(Sender: TObject);
    procedure actRemoveCertExecute(Sender: TObject);
  private
    procedure ShowGrid(filter: Integer);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmCertificates: TfrmCertificates;

implementation

{$R *.dfm}

uses Main, Universal, CertificateExpireDate;

procedure TfrmCertificates.actOpenExecute(Sender: TObject);
Var
  fn, fp, d: String;
Begin
  // 
  fp := frmMain.ComputerInfo.Folders.Temp + '\';
  //     
  If (THardware.RecNo > 0) Then
  Begin
    //  
    fn := THardware.FieldByName('file').AsString;
    If (fn <> '') Then
    Begin
      frmUniversal.FileGetByNameToFile(fn, fp + fn);
    End;
  End;

  frmMain.OpenFile(fp + fn);
end;

procedure TfrmCertificates.actOpenUpdate(Sender: TObject);
begin
  actOpen.Enabled := (HardwareGrid.SelCount = 1);
end;

procedure TfrmCertificates.actRemoveCertExecute(Sender: TObject);
Var
  fn, newfilename: String;
  cnt, i: Integer;
  bm: TBookmark;
  d: String;
Begin
  cnt := HardwareGrid.SelectedRows.Count;
  If cnt > 1 Then
    dlgOpen.Title := '   ' + IntToStr(cnt) + ' '
  Else
    dlgOpen.Title := ' ';

  //  
  if MessageDlg(dlgOpen.Title, mtCustom, [mbYes, mbCancel], 0) = mrYes then
  Begin
    //   
    THardware.DisableControls;
    Try
      bm := THardware.GetBookmark;
      If cnt > 0 Then
        For i := 0 To cnt - 1 Do
        Begin
          THardware.GotoBookmark(HardwareGrid.SelectedRows[i]);
          THardware.Edit;
          THardware.FieldByName('file').AsString := '';
          THardware.Post;
        End
      Else
      Begin
        THardware.Edit;
        THardware.FieldByName('file').AsString := '';
        THardware.Post;
      End;
      THardware.GotoBookmark(bm);
      THardware.FreeBookmark(bm);
    Except
      showmessage('  7266');
    End;
    THardware.EnableControls;
  End;
end;

procedure TfrmCertificates.actRemoveCertUpdate(Sender: TObject);
begin
  actRemoveCert.Enabled := (HardwareGrid.SelCount > 0);
end;

procedure TfrmCertificates.actReplaceExecute(Sender: TObject);
Var
  fn, newfilename: String;
  cnt, i: Integer;
  bm: TBookmark;
  d: String;
Begin
  cnt := HardwareGrid.SelectedRows.Count;
  If cnt > 1 Then
    dlgOpen.Title := '   ' + IntToStr(cnt) + ' '
  Else
    dlgOpen.Title := ' ';

  //  
  If dlgOpen.Execute Then
  Begin
    fn := dlgOpen.FileName;
    If FileExists(fn) Then
    Begin
      newfilename := frmUniversal.FileSaveToFB(fn);
    End;

    //   
    If pos(' ', newfilename) < 1 Then
    Begin
      THardware.DisableControls;
      Try
        bm := THardware.GetBookmark;
        If cnt > 0 Then
          For i := 0 To cnt - 1 Do
          Begin
            THardware.GotoBookmark(HardwareGrid.SelectedRows[i]);
            THardware.Edit;
            THardware.FieldByName('file').AsString := newfilename;
            THardware.Post;
          End
        Else
        Begin
          THardware.Edit;
          THardware.FieldByName('file').AsString := newfilename;
          THardware.Post;
        End;
        THardware.GotoBookmark(bm);
        THardware.FreeBookmark(bm);
      Except
        showmessage('  7264');
      End;
      THardware.EnableControls;
    End; // 

  End;
end;

procedure TfrmCertificates.actReplaceUpdate(Sender: TObject);
begin
  actReplace.Enabled := (HardwareGrid.SelCount > 0);
end;

procedure TfrmCertificates.actSetDateExecute(Sender: TObject);
var
  certfile: string;
  certdate: TDateTime;
  SQL: string;
  bm: TBookmark;
  i: Integer;
begin
  frmCertificateExpireDate.UseExpire.Checked := not THardware.FieldByName('expire').IsNull;
  if not THardware.FieldByName('expire').IsNull then
    frmCertificateExpireDate.EditExpireDate.Date := THardware.FieldByName('expire').AsDateTime
  else
    frmCertificateExpireDate.EditExpireDate.Date := now();

  if frmCertificateExpireDate.ShowModal = mrOk then
  begin
    certdate := frmCertificateExpireDate.EditExpireDate.Date;
    //  

    //   
    THardware.DisableControls;
    Try
      bm := THardware.GetBookmark;
      If HardwareGrid.SelCount > 0 Then
        For i := 0 To HardwareGrid.SelCount - 1 Do
        Begin
          THardware.GotoBookmark(HardwareGrid.SelectedRows[i]);
          THardware.Edit;
          THardware.FieldByName('expire').AsDateTime := certdate;
          if not frmCertificateExpireDate.UseExpire.Checked then
            THardware.FieldByName('expire').Clear;
          THardware.Post;
        End
      Else
      Begin
        THardware.Edit;
        THardware.FieldByName('expire').AsDateTime := certdate;
        if not frmCertificateExpireDate.UseExpire.Checked then
          THardware.FieldByName('expire').Clear;
        THardware.Post;
      End;
      THardware.GotoBookmark(bm);
      THardware.FreeBookmark(bm);
    Except
    End;
    THardware.EnableControls;
    // 
    THardware.Refresh;

  end; //  
end;

procedure TfrmCertificates.actSetDateUpdate(Sender: TObject);
begin
  actSetDate.Enabled := (HardwareGrid.SelCount > 0);
end;

procedure TfrmCertificates.btnSaveClick(Sender: TObject);
Var
  fn, fp, d: String;
Begin
  // 
  fp := frmMain.ComputerInfo.Folders.Temp + '\';
  //     
  If (THardware.RecNo > 0) And (HardwareGrid.SelectedRows.Count < 2) Then
  Begin
    //  
    fn := THardware.FieldByName('file').AsString;
    If (fn <> '') Then
    Begin
      frmUniversal.FileGetByNameToFile(fn, fp + fn);
    End;
  End;

  if FileExists(fp + fn) then
  begin
    ShellExecute(Handle, 'Open', Pchar(frmMain.extensions.Values[ExtractFileExt(fn)] + ' ' + fp + fn), Nil, Nil, 1);
  end;
end;

procedure TfrmCertificates.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TfrmCertificates.FormCreate(Sender: TObject);
begin
  WindowState := frmMain.ws;
end;

procedure TfrmCertificates.FormShow(Sender: TObject);
begin
  Sheets.TabIndex := 1;
  ShowGrid(Sheets.TabIndex);
end;

procedure TfrmCertificates.HardwareGridTitleBtnClick(Sender: TObject; ACol: Integer; Field: TField);
begin
  ShowGrid(Sheets.TabIndex);
end;

procedure TfrmCertificates.editFilterChange(Sender: TObject);
begin
  TimerUpdate.Enabled := false;
  TimerUpdate.Enabled := true;
end;

procedure TfrmCertificates.SheetsChange(Sender: TObject; NewTab: Integer; var AllowChange: Boolean);
begin
  ShowGrid(NewTab);
end;

procedure TfrmCertificates.ShowGrid(filter: Integer);
begin
  if not frmUniversal.DBConnected then
    exit;
  THardware.Active := false;
  case filter of
    0:
      begin
        THardware.SQL.Text := 'SELECT * FROM uni_hardware WHERE (length(file)>0)';
      end;
    1:
      begin
        THardware.SQL.Text :=
          'SELECT * FROM uni_hardware WHERE (length(file)>0 AND expire>=CURRENT_DATE AND expire<CURRENT_DATE + INTERVAL 7 DAY)';
      end;
    2:
      begin
        THardware.SQL.Text := 'SELECT * FROM uni_hardware WHERE (length(file)>0 AND expire<CURRENT_DATE)';
      end;
    3:
      begin
        THardware.SQL.Text := 'SELECT * FROM uni_hardware WHERE (length(file)=0 OR file IS NULL)';
      end;
  end;

  if editFilter.Text <> '' then
  begin
    THardware.SQL.Add(' AND (`article` LIKE :f OR `name` LIKE :f)');
    THardware.ParamByName('f').AsString := '%' + editFilter.Text + '%';
  end;

  if HardwareGrid.SortedField <> '' then
    THardware.SQL.Add(' ORDER BY ' + HardwareGrid.SortedField);

  If HardwareGrid.SortMarker = smDown Then
    THardware.SQL.Add(' DESC');

  THardware.Active := true;
end;

procedure TfrmCertificates.TimerUpdateTimer(Sender: TObject);
begin
  TimerUpdate.Enabled := false;
  ShowGrid(Sheets.TabIndex);
end;

end.
