unit AutoPassport;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, JvExStdCtrls, JvButton,
  JvCtrls, JvFooter, Vcl.ExtCtrls, JvExExtCtrls, JvExtComponent,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param, math,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, Data.DB, FireDAC.Comp.DataSet,
  FireDAC.Comp.Client;

type
  TfrmAutoPassport = class(TForm)
    JvFooter1: TJvFooter;
    lblInfo: TLabel;
    btnStart: TJvFooterBtn;
    btnClose: TJvFooterBtn;
    FindArea: TGroupBox;
    UpdateAnyway: TRadioButton;
    UpdateSkip: TRadioButton;
    GroupNumbers: TGroupBox;
    zav_pre: TEdit;
    zav_post: TEdit;
    zav: TEdit;
    Logs: TListBox;
    JvFooterBtn1: TJvFooterBtn;
    JvFooterBtn2: TJvFooterBtn;
    procedure FormShow(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure JvFooterBtn2Click(Sender: TObject);
    procedure JvFooterBtn1Click(Sender: TObject);
  private
    project_no, system_no: integer;
    project_name: string;
    systemslist: TStrings;
    procedure DetectExists(showlogs: boolean);
    function PoolStart(start, count: integer): integer;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmAutoPassport: TfrmAutoPassport;

implementation

{$R *.dfm}

uses Main, Universal;

procedure TfrmAutoPassport.btnStartClick(Sender: TObject);
var
  MyQuery: TFDQuery;
  // r: integer;
  _zav_pre, _zav, _zav_post: integer;
  full, full2, sysname: string;
  count, newcnt: integer;
begin
  systemslist.Clear;
  if UpdateSkip.Checked then
    DetectExists(false);

  btnStart.Enabled := true;
  lblInfo.Caption := '';
  Logs.Items.Clear;

  project_no := frmMain.current_projectno;
  system_no := frmMain.current_projectsystemno;

  if not trystrtoint(zav_pre.Text, newcnt) then
    newcnt := 1;

  try
    MyQuery := TFDQuery.Create(self);
    MyQuery.Connection := frmUniversal.DatabaseConnection;

    MyQuery.SQL.Text :=
      'SELECT `rec_no`,`name`,`tag`,`zav_pre`,`zav`,`zav_post`,`count`,`active`,`zav_date` FROM uni_projectsystems WHERE project_no=:project_no ORDER BY `orderby`';
    MyQuery.ParamByName('project_no').AsInteger := project_no;
    MyQuery.active := true;
    while not MyQuery.Eof do
    begin
      // r := MyQuery.FieldByName('rec_no').AsInteger;
      count := MyQuery.FieldByName('count').AsInteger;
      _zav_pre := MyQuery.FieldByName('zav_pre').AsInteger;
      _zav := MyQuery.FieldByName('zav').AsInteger;
      _zav_post := MyQuery.FieldByName('zav_post').AsInteger;
      sysname := MyQuery.FieldByName('name').AsString + ' / ' + MyQuery.FieldByName('tag').AsString;
      if trim(MyQuery.FieldByName('tag').AsString) = '' then
        sysname := MyQuery.FieldByName('name').AsString;

      if (_zav_pre = 0) or (_zav = 0) or (_zav_post = 0) or UpdateAnyway.Checked then
      begin
        //  
        trystrtoint(zav_pre.Text, _zav_pre);
        trystrtoint(zav.Text, _zav);
        trystrtoint(zav_post.Text, _zav_post);

        _zav_pre := PoolStart(_zav_pre, count);
        full := _zav_pre.ToString + '-' + _zav.ToString + '-' + _zav_post.ToString;
        full2 := (_zav_pre + count - 1).ToString + '-' + _zav.ToString + '-' + _zav_post.ToString;

        if full = full2 then
          Logs.Items.Add('"' + sysname + '" x' + count.ToString + ' < ' + full)
        else
          Logs.Items.Add('"' + sysname + '" x' + count.ToString + ' < ' + full + ' ... ' + full2);
        // set
        try
          MyQuery.Edit;
          MyQuery.FieldByName('zav_pre').AsInteger := _zav_pre;
          MyQuery.FieldByName('zav').AsInteger := _zav;
          MyQuery.FieldByName('zav_post').AsInteger := _zav_post;
          MyQuery.FieldByName('zav_date').AsDateTime := now;
          MyQuery.Post;
        except
          Logs.Items.Add('ERROR ' + MyQuery.FieldByName('name').AsString);
        end;
        //  
        _zav_pre := _zav_pre + count;
        zav_pre.Text := _zav_pre.ToString;
      end
      else
      begin
        //   
        full := _zav_pre.ToString + '-' + _zav.ToString + '-' + _zav_post.ToString;
        full2 := (_zav_pre + count - 1).ToString + '-' + _zav.ToString + '-' + _zav_post.ToString;
        if full = full2 then
          Logs.Items.Add('"' + sysname + '" x' + count.ToString + ' = ' + full)
        else
          Logs.Items.Add('"' + sysname + '" x' + count.ToString + ' = ' + full + ' ... ' + full2);
      end;

      Application.ProcessMessages;
      Logs.ItemIndex := Logs.Items.count - 1;

      MyQuery.Next;
    end;
    //
    MyQuery.free;

  except
    btnStart.Enabled := false;
  end;

  Application.ProcessMessages;
  Logs.ItemIndex := Logs.Items.count - 1;

end;

function TfrmAutoPassport.PoolStart(start, count: integer): integer;
var
  i: integer;
  full: string;
  cur: integer;
begin
  cur := start;
  i := 1;
  while i < count do
  begin
    full := (cur + count - 1).ToString + '-' + zav.Text + '-' + zav_post.Text;
    if systemslist.IndexOf(full) > -1 then
    begin
      i := 1;
      cur := (cur + count - 1);
    end;
    inc(i);
  end;
  result := cur;
end;

procedure TfrmAutoPassport.FormCreate(Sender: TObject);
begin
  systemslist := TStringList.Create;
end;

procedure TfrmAutoPassport.FormDestroy(Sender: TObject);
begin
  systemslist.free;
end;

procedure TfrmAutoPassport.FormShow(Sender: TObject);
var
  myarr: array of integer;
  strbuf, s: string;
  i: integer;
begin
  UpdateSkip.Checked := true;
  Logs.Items.Clear;

  btnStart.Enabled := true;
  lblInfo.Caption := '';

  //     
  project_no := frmMain.current_projectno;
  system_no := frmMain.current_projectsystemno;
  project_name := frmMain.current_projectname;

  if project_no < 0 then
    close;

  s := project_name + '!';
  for i := 1 to Length(s) do
  begin
    if s[i] in ['0' .. '9'] then
      strbuf := strbuf + s[i]
    else
    begin
      SetLength(myarr, Length(myarr) + 1);
      myarr[High(myarr)] := strtoint(strbuf);
      strbuf := '';
    end;
  end;

  i := Length(myarr);
  if i > 0 then
    zav.Text := myarr[0].ToString;
  if i > 1 then
    zav_post.Text := myarr[High(myarr)].ToString;
  zav_pre.Text := '1';

  Application.ProcessMessages;
  DetectExists(true);
end;

procedure TfrmAutoPassport.JvFooterBtn1Click(Sender: TObject);
begin
  Logs.Items.Clear;
  DetectExists(false);
  Logs.Items.AddStrings(systemslist);
end;

procedure TfrmAutoPassport.JvFooterBtn2Click(Sender: TObject);
begin
  Logs.Items.Clear;
  DetectExists(true);
end;

procedure TfrmAutoPassport.DetectExists(showlogs: boolean);
var
  MyQuery: TFDQuery;
  i, count, newcnt: integer;
  full, full2, sysname: string;
  name: string;
  _zav_pre, _zav, _zav_post: integer;
begin
  if not trystrtoint(zav_pre.Text, newcnt) then
    newcnt := 1;
  systemslist.Clear;

  try
    MyQuery := TFDQuery.Create(self);
    MyQuery.Connection := frmUniversal.DatabaseConnection;

    MyQuery.SQL.Text :=
      'SELECT `rec_no`,`name`,`tag`,`zav_pre`,`zav`,`zav_post`,`count` FROM uni_projectsystems WHERE project_no=:project_no ORDER BY `orderby`';
    MyQuery.ParamByName('project_no').AsInteger := project_no;
    MyQuery.active := true;
    while not MyQuery.Eof do
    begin
      // r := MyQuery.FieldByName('rec_no').AsInteger;
      count := MyQuery.FieldByName('count').AsInteger;
      name := MyQuery.FieldByName('name').AsString;
      _zav_pre := MyQuery.FieldByName('zav_pre').AsInteger;
      _zav := MyQuery.FieldByName('zav').AsInteger;
      _zav_post := MyQuery.FieldByName('zav_post').AsInteger;
      sysname := MyQuery.FieldByName('name').AsString + ' / ' + MyQuery.FieldByName('tag').AsString;
      if trim(MyQuery.FieldByName('tag').AsString) = '' then
        sysname := MyQuery.FieldByName('name').AsString;

      full := '';
      if (_zav_pre > 0) and (_zav > 0) and (_zav_post > 0) then
        for i := 0 to count - 1 do
        begin
          full := _zav_pre.ToString + '-' + _zav.ToString + '-' + _zav_post.ToString;
          systemslist.Add(full);
          // Logs.Items.Add('... ' + full);
          _zav_pre := _zav_pre + 1;
          newcnt := max(newcnt, _zav_pre);
        end;

      _zav_pre := MyQuery.FieldByName('zav_pre').AsInteger;
      _zav := MyQuery.FieldByName('zav').AsInteger;
      _zav_post := MyQuery.FieldByName('zav_post').AsInteger;
      full := _zav_pre.ToString + '-' + _zav.ToString + '-' + _zav_post.ToString;
      full2 := (_zav_pre + count - 1).ToString + '-' + _zav.ToString + '-' + _zav_post.ToString;

      if showlogs then
      begin
        if full = full2 then
          Logs.Items.Add('"' + sysname + '" x' + count.ToString + ' = ' + full)
        else
          Logs.Items.Add('"' + sysname + '" x' + count.ToString + ' = ' + full + ' ... ' + full2);
      end;

      Application.ProcessMessages;
      Logs.ItemIndex := Logs.Items.count - 1;

      MyQuery.Next;
    end;
    //
    MyQuery.free;

    zav_pre.Text := newcnt.ToString;
  except
  end;

  Application.ProcessMessages;
  if showlogs then
  begin
    Logs.ItemIndex := Logs.Items.count - 1;
  end;
end;

end.
